/**
 * @type {string}
 */
const CONTROLLER_BASE_URL = 'admin_controller.php';

/**
 * @type {HTMLInputElement}
 */
const osSelect = document.getElementById("os_version");
/**
 * @type {HTMLInputElement}
 */
const osVersionHidden = document.getElementById("os_version_hidden");
/**
 * @type {HTMLSelectElement}
 */
const poSelect = document.getElementById("poNumberSelect");
/**
 * @type {HTMLInputElement}
 */
const poInput = document.getElementById("poNumberInput");
/**
 * @type {HTMLInputElement}
 */
const poHidden = document.getElementById("poNumber_hidden");
/**
 * @type {HTMLImageElement}
 */
const editOS = document.getElementById("edit_os");
/**
 * @type {HTMLImageElement}
 */
const editPO = document.getElementById("edit_po");
/**
 * @type {HTMLInputElement}
 */
const serialField = document.getElementById('serialNumber');

osSelect.addEventListener('change', (_event) => {
	osVersionHidden.value = osSelect.value;
});
poSelect.addEventListener('change', (_event) => {
	poInput.value = poSelect.value;
	poHidden.value = poSelect.value;
});
poInput.addEventListener('change', (_event) => {
	poSelect.value = poInput.value;
	poHidden.value = poInput.value;
})
editOS.addEventListener('click', (_event) => {
	osSelect.disabled = !osSelect.disabled;
});
editPO.addEventListener('click', (_event) => {
	poSelect.disabled = !poSelect.disabled;
	poInput.disabled = !poInput.disabled;
});


document.onkeypress = stopRKey;
setLoadingModalVisible(false);
document.rcvForm.serialNumber.focus();

var is_ipad = false;
var is_imac = false;
var is_macbook = false;
var model = "";

function speakerTest(){

	document.getElementById("audio").play();

	setTimeout(function(){
		document.getElementById("speaker").innerHTML="Right";
	},1500);
	setTimeout(function(){
		document.getElementById("speaker").innerHTML="Center";
	},3000);
	setTimeout(function(){
		document.getElementById("speaker").innerHTML="Left";
	},4500);
}

function Validate(){

	var i;
	var optical = false;
	var lcd = false;
	var glass = false;
	var enet = false;
	var ports = false;
	var wifi = false;
	var speakers = false;
	var battery = false;
	var isight = false;
	var home_button = false;
	var volume = false;
	var sleep_wake = false;
	var silent_rot = false;
	var headphone = false;
	var front_camera = false;
	var rear_camera = false;
	var speaker = false;
	var mic = false;
	var charge = false;
	var err = "";
	/**
	 * @type {HTMLInputElement}
	 */
	const nonstandardSerialCheckbox = document.getElementById('nonstandard_serial');
	const nonstandardSerial = nonstandardSerialCheckbox.checked;

	if(document.rcvForm.serialNumber.value == ""){
		err+= "Please enter a Serial #\n";
	}

	if(!nonstandardSerial && document.rcvForm.serialNumber.value.length != 11 && document.rcvForm.serialNumber.value.length != 12 && document.rcvForm.serialNumber.value.length != 13 && document.rcvForm.serialNumber.value.length != 8){
		err+= "Invalid Serial #/Order #\n";
	}

	if(document.rcvForm.grade.value == ""){
		err += "Please select a Grade\n";
	}

	if (!is_ipad && !document.rcvForm.boot_failure_osx.checked){

		for (i=0;i<=2;i++){
			if(document.rcvForm.optical[i].checked){
				optical = true;
			}
		}

		if (!optical){
			err += "Please select an option for Optical\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.lcd[i].checked){
				lcd = true;
			}
		}

		if (!lcd){
			err += "Please select an option for LCD\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.glass[i].checked){
				glass = true;
			}
		}

		if (!glass){
			err += "Please select an option for Glass\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.enet[i].checked){
				enet = true;
			}
		}

		if (!enet){
			err += "Please select an option for Enet\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.wifi[i].checked){
				wifi = true;
			}
		}

		if (!wifi){
			err += "Please select an option for Wifi\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.speakers[i].checked){
				speakers = true;
			}
		}

		if (!speakers){
			err += "Please select an option for Speakers\n";
		}

		for (i=0;i<=2;i++){
			if(!is_imac && document.rcvForm.battery[i].checked){
				battery = true;
			}
		}

		if (!battery && !is_imac){
			err += "Please select an option for Battery\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.isight[i].checked){
				isight = true;
			}
		}

		if (!isight){
			err += "Please select an option for iSight\n";
		}
	}

	/*if (is_imac && !document.rcvForm.boot_failure_imac.checked){

		for (i=0;i<=2;i++){
			if(document.rcvForm.optical_imac[i].checked){
				optical = true;
			}
		}

		if (!optical){
			err += "Please select an option for Optical\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.lcd_imac[i].checked){
				lcd = true;
			}
		}

		if (!lcd){
			err += "Please select an option for LCD\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.glass_imac[i].checked){
				glass = true;
			}
		}

		if (!glass){
			err += "Please select an option for Glass\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.enet_imac[i].checked){
				enet = true;
			}
		}

		if (!enet){
			err += "Please select an option for Enet\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.ports_imac[i].checked){
				ports = true;
			}
		}

		if (!ports){
			err += "Please select an option for Ports\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.wifi_imac[i].checked){
				wifi = true;
			}
		}

		if (!wifi){
			err += "Please select an option for Wifi\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.speakers_imac[i].checked){
				speakers = true;
			}
		}

		if (!speakers){
			err += "Please select an option for Speakers\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.isight_imac[i].checked){
				isight = true;
			}
		}

		if (!isight){
			err += "Please select an option for iSight\n";
		}
	}*/

	if (is_ipad && !document.rcvForm.boot_failure_ipad.checked){
		for (i=0;i<=2;i++){
			if(document.rcvForm.home_button[i].checked){
				home_button = true;
			}
		}

		if (!home_button){
			err += "Please select an option for Home Button\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.volume[i].checked){
				volume = true;
			}
		}

		if (!volume){
			err += "Please select an option for Volume up/down\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.sleep_wake[i].checked){
				sleep_wake = true;
			}
		}

		if (!sleep_wake){
			err += "Please select an option for Sleep/wake\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.silent_rot[i].checked){
				silent_rot = true;
			}
		}

		if (!silent_rot){
			err += "Please select an option for Silent/Rot lock\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.headphone[i].checked){
				headphone = true;
			}
		}

		if (!headphone){
			err += "Please select an option for Headphone jack\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.front_camera[i].checked){
				front_camera = true;
			}
		}

		if (!front_camera){
			err += "Please select an option for Front camera\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.rear_camera[i].checked){
				rear_camera = true;
			}
		}

		if (!rear_camera){
			err += "Please select an option for Rear camera\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.speaker[i].checked){
				speaker = true;
			}
		}

		if (!speaker){
			err += "Please select an option for Speaker\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.mic[i].checked){
				mic = true;
			}
		}

		if (!mic){
			err += "Please select an option for Mic\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.charge[i].checked){
				charge = true;
			}
		}

		if (!charge){
			err += "Please select an option for Charge\n";
		}

		for (i=0;i<=2;i++){
			if(document.rcvForm.wifi_ipad[i].checked){
				wifi = true;
			}
		}

		if (!wifi){
			err += "Please select an option for Wifi\n";
		}
	}


	if (document.rcvForm.os_version_hidden.value == ""){
		err += "Please select the OS\n";
	}

	if (document.rcvForm.poNumber_hidden.value == ""){
		err += "Please select the School/PO#";
	}

	if (err != ""){
		err = "Please correct the following errors:\n\n"+err;
		alert(err);
		return false;
	}else{

		/*document.getElementById("submit").disabled = true;
		document.getElementById("spinner").style.display = "block";*/
		setLoadingModalVisible(true);
		var theForm = document.rcvForm;
		var poststr = "";
		var inputs = document.getElementsByTagName("input");
		poststr = "is_ipad=" + is_ipad;
		poststr += "&is_imac=" + is_imac;
		for (var i = 0; i < inputs.length; i++) {
			if (inputs[i].type === "radio" && inputs[i].checked) {
				poststr += "&" + inputs[i].id + "=" + inputs[i].value;
			}
			if (inputs[i].type === "text" && inputs[i].value != "") {
				poststr += "&" + inputs[i].id + "=" + inputs[i].value;
			}
			if (inputs[i].type === "checkbox" && inputs[i].checked && inputs[i].id != 'nonstandard_serial') {
				poststr += "&" + inputs[i].id + "=" + "1";
			}
		}
		var selects = document.getElementsByTagName("select");
		for (var i = 0; i < selects.length; i++){
			const elementId = selects[i].id;
			const elementValue = selects[i].value;
			if (elementId != 'poNumberSelect') {
				poststr += `&${elementId}=${elementValue}`;
			}
		}
		poststr += "&audit_log_id=" + document.getElementById("audit_log_id").value;
		poststr += `&poNumber=${poHidden.value}`;

		poststr += "&order_number=" + document.getElementById("order_number").value;
		poststr += "&oNum=" + document.getElementById("oNum").value;
		poststr += "&hdnSerialNumber=" + document.getElementById("hdnSerialNumber").value;
		poststr += `&grade_at_audit=${document.getElementById('grade').value}`;
		var url = CONTROLLER_BASE_URL + "?m=submit_audit"
		makeAjaxRequest(url, poststr, "POST",returnAudit);
	}

}

function returnAudit(){
	if (http_request.readyState == 4) {
		switch (http_request.status) {
			case 200:
				resetAuditForm();
			break;
			default:
				setLoadingModalVisible(false);
				alert("Error with AJAX request.");
		}
	}

}

function resetAuditForm() {
	document.getElementById("model").innerHTML = "";
	document.getElementById("oNum").value = "";
	document.getElementById("hdnSerialNumber").value = "";
	document.querySelector('#formHolder').innerHTML = '';
	document.getElementById('grade_os_po_table').hidden = true;
	/**
	 * @type {HTMLCollectionOf<HTMLInputElement>}
	 */
	const inputs = document.getElementsByTagName("input");
	for (const input of inputs) {
		if (input.type == "text" && input.value != "") {
			input.value = "";
		} else if ((input.type == "checkbox" || input.type == "radio") && input.checked) {
			input.checked = false;
		}
	}
	setLoadingModalVisible(false);
	document.getElementById("oNum").focus();
}


async function returnGrades() {
	if (http_request.readyState == 4) {
		switch (http_request.status) {
			case 200:
				setLoadingModalVisible(false);
				if (http_request.responseText == "Serial number not recognized."){
					alert(http_request.responseText);
					document.getElementById("submit").disabled = false;
					return false;
				}
				const hd_ram_pattern = /^\d/;

				var response = http_request.responseText;
				var JSONobject = JSON.parse(response);
				var items = JSONobject.oss;
				var arrayLength = items.length;
				is_ipad = JSONobject.is_ipad;
				is_imac = JSONobject.is_imac;
				is_macbook = !(is_imac || is_ipad);
				const deviceType = (is_ipad) ? 'ipad' : (is_imac) ? 'imac' : (is_macbook) ? 'macbook' : 'error';
				const resp = await getForm(deviceType);
				console.log(JSONobject);
				console.log(resp);
				document.getElementById("model").innerHTML = JSONobject.model_number;
				model = JSONobject.model_number;
				checkoutStopgap();
				document.getElementById("order_number").value = JSONobject.order_number;
				document.getElementById("system_txt").innerHTML = JSONobject.system_txt;
				console.log(JSONobject);

				if (JSONobject.ram_1 && hd_ram_pattern.test(JSONobject.ram_1)){
					document.getElementById("ram_1").value = JSONobject.ram_1;
				}
				if (JSONobject.ram_2 && hd_ram_pattern.test(JSONobject.ram_2)){
					document.getElementById("ram_2").value = JSONobject.ram_2;
				}
				if (JSONobject.ram_3 && hd_ram_pattern.test(JSONobject.ram_3)){
					document.getElementById("ram_3").value = JSONobject.ram_3;
				}
				if (JSONobject.ram_4 && hd_ram_pattern.test(JSONobject.ram_4)){
					document.getElementById("ram_4").value = JSONobject.ram_4;
				}
				if (JSONobject.ram){
					document.getElementById("ram").innerHTML = JSONobject.ram;
				} else if (!JSONobject.ram && document.getElementById('ram') != null) {
					document.getElementById('ram_1').readOnly = false;
					document.getElementById('ram_2').readOnly = false;
					document.getElementById('ram_3').readOnly = false;
					document.getElementById('ram_4').readOnly = false;
				}
				if (JSONobject.hd_1 && hd_ram_pattern.test(JSONobject.hd_1)){
					document.getElementById("hd_1").value = JSONobject.hd_1;
				}
				if (JSONobject.hd_2 && hd_ram_pattern.test(JSONobject.hd_1)){
					document.getElementById("hd_1").value = JSONobject.hd_1;
				}
				if (JSONobject.hd){
					document.getElementById("hd").innerHTML = JSONobject.hd;
				} else if (!JSONobject.hd && document.getElementById('hd') != null) {
					document.getElementById('hd_1').readOnly = false;
					document.getElementById('hd_2').readOnly = false;
				}
				if (JSONobject.battery_mah){
					document.getElementById("battery_mah").value = JSONobject.battery_mah;
				}
				if (JSONobject.battery_cycles){
					document.getElementById("battery_cycles").value = JSONobject.battery_cycles;
				}
				if (JSONobject.os_version){
					const osVersion = getOSVersion(JSONobject.os_version);
					document.getElementById("os_version").value = osVersion;
					osVersionHidden.value = osVersion;
					osSelect.disabled = true;
				} else if (!JSONobject.os_version) {
					osSelect.disabled = false;
				}
				if (JSONobject.capacity){
					document.getElementById("capacity").value = JSONobject.capacity;
				} else if (!JSONobject.capacity && document.getElementById('capacity') != null) {
					document.getElementById('capacity').readOnly = false;
				}
				if (JSONobject.oNum){
					document.getElementById("oNum").value = JSONobject.oNum;
				}
				if (JSONobject.hdnSerialNumber){
					// console.log(JSONobject.hdnSerialNumber);
					/**
					 * @type {HTMLInputElement}
					 */
					const nonstandardSerialCheckbox = document.getElementById('nonstandard_serial');
					document.getElementById("hdnSerialNumber").value = JSONobject.hdnSerialNumber;
					if (!nonstandardSerialCheckbox.checked) {
						let ident = JSONobject.hdnSerialNumber.substr(Math.max(8, JSONobject.hdnSerialNumber.length - 4));
						document.getElementById('identifier').value = ident;
					}
				}
				if (JSONobject.activation_lock){
					if (JSONobject.activation_lock == "true"){
						document.getElementById("activation_lock").checked = true;
					}
				}
				if (JSONobject.mdm_lock){
					if (JSONobject.mdm_lock == "true"){
						document.getElementById("mdm_lock").checked = true;
					}
				}
				if (JSONobject.poNumber){
					const poNumber = JSONobject.poNumber;
					poInput.value = poNumber;
					poSelect.value = poNumber;
					poHidden.value = poNumber;
					poSelect.disabled = true;
					poSelect.hidden = true;
					poInput.disabled = true;
					poInput.hidden = false;
				} else if (!JSONobject.poNum) {
					poInput.value = "";
					poSelect.value = "";
					poHidden.value = "";
					poInput.hidden = true;
					poSelect.disabled = false;
					poSelect.hidden = false;
				}

				// if (JSONobject.is_ipad){
				// 	document.getElementById("osx_form").style.display = "none";
				// 	document.getElementById("imac_form").style.display = "none";
				// 	document.getElementById("ipad_form").style.display = "block";
				// 	//document.getElementById("grade").value = "A"
				// }else if (JSONobject.is_imac){
				// 	document.getElementById("osx_form").style.display = "block";
				// 	document.getElementById("imac_form").style.display = "none";
				// 	document.getElementById("ipad_form").style.display = "none";
				// 	document.getElementById("td_missing_keys").style.visibility = "hidden";
				// 	document.getElementById("td_loose_hinge").style.visibility = "hidden";
				// 	document.getElementById("tr_keyboard_marks").style.visibility = "hidden";
				// 	document.getElementById("tr_macbook").style.visibility = "hidden";
				// 	document.getElementById("tr_keyboard").style.visibility = "hidden";
				// 	document.getElementById("tr_trackpad").style.visibility = "hidden";
				// 	document.getElementById("tr_battery").style.visibility = "hidden";
				// }else{
				// 	document.getElementById("osx_form").style.display = "block";
				// 	document.getElementById("imac_form").style.display = "none";
				// 	document.getElementById("ipad_form").style.display = "none";
				// 	document.getElementById("td_missing_keys").style.visibility = "visible";
				// 	document.getElementById("td_loose_hinge").style.visibility = "visible";
				// 	document.getElementById("tr_keyboard_marks").style.visibility = "visible";
				// 	document.getElementById("tr_macbook").style.visibility = "visible";
				// 	document.getElementById("tr_keyboard").style.visibility = "visible";
				// 	document.getElementById("tr_trackpad").style.visibility = "visible";
				// 	document.getElementById("tr_battery").style.visibility = "visible";
				// }

				document.getElementById("audit_log_id").value = JSONobject.audit_log_id;

				if (JSONobject.serial_exists){
					alert("Serial number previously checked in.")
				}

				if (!JSONobject.order_number_exists){
					var order_number = prompt("Please enter the order number for this product","");
					if (order_number != null) {
						document.getElementById("order_number").value = order_number;
					}
				}
				if (JSONobject.oNum) {
					serialField.value = JSONobject.oNum;
				}

				if (JSONobject.already_audited) {
					if (!window.confirm(`This SP number has already been checked in at ${JSONobject.previous_audit.time}. ${JSONobject.previous_audit.details}. Are you sure you want to audit it again? All previous data will be overwritten if a new audit is submitted.`)) {
						resetAuditForm();
					}
				}

			break;
			default:
				setLoadingModalVisible(false);
				alert("Error with AJAX request.");
		}
	}
}

function triggerGetGrades() {
	getGrades(document.getElementById('serialNumber'));
}

function getGrades(obj){
	/**
	 * @type {HTMLInputElement}
	 */
	const nonstandardSerialCheckbox = document.getElementById('nonstandard_serial');
	const nonstandardSerial = nonstandardSerialCheckbox.checked;
	/**
	 * @type {HTMLInputElement}
	 */
	const identifierField = document.getElementById('identifier');
	const errorField = document.getElementById('serialErrorMessage');
	if (!nonstandardSerial && obj.value.length != 11 && obj.value.length != 12 && obj.value.length != 13 && obj.value.length != 8){
		// alert("Invalid serial/order number entered.");
		const serialField = document.getElementById('serialNumber');
		const errorField = document.getElementById('serialErrorMessage');
		errorField.classList.add('serialError');
		serialField.classList.add('serialError');
		return false;
	}
	errorField.classList.remove('serialError');
	serialField.classList.remove('serialError');
	if (!nonstandardSerial) {
		identifierField.value = (serialField.value.length > 12) ? serialField.value.substring(9) : serialField.value.substring(8);
	}
	obj.value = obj.value.toUpperCase();
	identifierField.value = identifierField.value.toUpperCase();
	var poststr = "serialNumber="+obj.value;
	poststr += `&identifier=${identifierField.value}`;
	var url = CONTROLLER_BASE_URL + "?m=get_grades";
	setLoadingModalVisible(true);
	makeAjaxRequest(url, poststr, "POST", returnGrades);
}

function returnUpdateGrade() {
	if (http_request.readyState == 4) {
		switch (http_request.status) {
			case 200:
				document.getElementById("grade").value = http_request.responseText.trim();
				break;
			default:
				alert("Error with AJAX request.");
		}
	}
}

function updateGrade(){

	var poststr = "";
	var inputs = document.getElementsByTagName("input");
	for (var i = 0; i < inputs.length; i++) {
		if (inputs[i].type === "radio" && inputs[i].checked) {
			poststr += "&" + inputs[i].id + "=" + inputs[i].value;
		}
		if (inputs[i].type === "text" && inputs[i].value != "") {
			poststr += "&" + inputs[i].id + "=" + inputs[i].value;
		}
		if (inputs[i].type === "checkbox" && inputs[i].checked) {
			poststr += "&" + inputs[i].id + "=" + "1";
		}
	}
	var selects = document.getElementsByTagName("select");
	for (var i = 0; i < selects.length; i++){
		if (selects[i].value != ""){
			poststr += "&" + selects[i].id + "=" + selects[i].value;
		}
	}
	if (is_ipad){
		poststr += "&device=ipad";
	}else if (is_imac){
		poststr += "&device=imac";
	}else{
		poststr += "&device=macbook";
	}
	var url = CONTROLLER_BASE_URL + "?m=audit_grade_update";
	makeAjaxRequest(url, poststr, "POST", returnUpdateGrade);
}

/**
 *
 * @param {string} str OS version to parse
 */
function getOSVersion(str) {
	if (str.startsWith('(')) { // If starts with (, means system profiler pulled darwin version. OS version is 10.(darwin version minus 4).
		const darwinVersion = parseInt(str.substr(1, 2));
		const versionNum = darwinVersion - 4;
		return `10.${versionNum.toString()}`;
	} else if (str.startsWith('10')) {
		const endIndex = (str.indexOf('.', 3) == -1) ? str.length : str.indexOf('.', 3);
		return str.substr(0, endIndex);
	} else {
		return str;
	}
}

function getForm(formtype) {
	document.querySelector('#formHolder').innerHTML = '';
	return fetch(`templates/audit/${formtype}.html`, {cache: "no-store"})
		.then((formRes) => {
			return formRes.text();
		})
		.then((formBody) => {
			document.getElementById('grade_os_po_table').hidden = true;
			document.getElementById('grade').value = '';
			document.getElementById('os_version').value = '';
			document.getElementById('os_version_hidden').value = '';
			document.getElementById('poNumberSelect').value = '';
			document.getElementById('poNumberInput').value = '';
			document.getElementById('poNumber_hidden').value = '';
			document.querySelector('#formHolder').innerHTML = formBody;
			document.getElementById('grade_os_po_table').hidden = false;
			return true;
		})
		.catch(() => {
			return false;
		});
}

function checkoutStopgap() {
	if (is_ipad) {
		ipadCheckoutStopgap();
	}
	if (is_macbook) {
		macbookCheckoutStopgap();
	}
	if (is_imac) {
		imacCheckoutStopgap();
	}
}

function imacCheckoutStopgap() {
	const optical = 'optical';
	const noOpticalArray = [
		'A1418',
		'A1419',
		'A2116',
		'A2115'
	];
	if (noOpticalArray.includes(model)) {
		setRadioValue(optical, 'na');
	}
}

function macbookCheckoutStopgap() {
	const optical = 'optical';
	const enet = 'enet';
	const glass = 'glass';
	const airArray = [
		'A1237',
		'A1304',
		'A1369',
		'A1465',
		'A1466',
		'A1370',
		'MD231LL/A',
		'A1932',
		'3120',
		'11',
		'Aspire ONE',
		'647',
		'D255E',
		'E431',
		'CB30',
		'AC700-1099',


	];
	if (airArray.includes(model)) {
		setRadioValue(optical, 'na');
		setRadioValue(enet, 'na');
		setRadioValue(glass, 'na');
	}
}

function ipadCheckoutStopgap() {
	const frontCamera = 'front_camera';
	const rearCamera = 'rear_camera';
	const sideSwitch = 'silent_rot';
	const earlyModelArray = [
		'A1219',
		'A1337',
		'MB292LL/A',
	];
	const middleModelArray = [
		'A1395',
		'A1396',
		'A1397',
		'A1432',
		'A1454',
		'A1416',
		'MC706LL/A',
		'A1403',
		'A1430',
		'A1458',
		'A1459',
		'A1460',
		'A1474',
		'A1489',
		'A1475',
		'A1599',
		'A1600',
		'A1490',
	];
	const lateModelArray = [
		'A1566',
		'A1538',
		'A1567',
		'A1550',
		'A1673',
		'A1674',
		'A1822',
		'A1584',
		'A1823',
		'A1893',
		'A1701',
		'A1670',
		'A1954',
	];

	if (earlyModelArray.includes(model)) {
		setRadioValue(frontCamera, 'na');
		setRadioValue(rearCamera, 'na');
	}
	if (lateModelArray.includes(model)) {
		setRadioValue(sideSwitch, 'na');
	}
}

/**
 *
 * @param {string} inputname
 * @param {string} value
 */
function setRadioValue(inputname, value) {
	/**
	 * @type {HTMLInputElement[]}
	 */
	const radios = document.getElementsByName(inputname);
	for (const radio of radios) {
		if (radio.value == value) {
			radio.checked = true;
		} else {
			radio.checked = false;
			radio.disabled = true;
		}
	}
}
function toggleNonstandardSerial() {
	/**
	 * @type {HTMLInputElement}
	 */
	const identifierField = document.getElementById('identifier');
	/**
	 * @type {HTMLParagraphElement}
	 */
	const identifierRow = document.getElementById('identifier_row');
	/**
	 * @type {HTMLInputElement}
	 */
	const nonstandardSerialCheckbox = document.getElementById('nonstandard_serial');
	const nonstandardSerial = nonstandardSerialCheckbox.checked;
	identifierRow.hidden = identifierField.hidden = !nonstandardSerial;
	if (!nonstandardSerial) {
		identifierField.value = (serialField.value.length > 12) ? serialField.value.substring(9) : serialField.value.substring(8);
		triggerGetGrades();
	}
}
