
var US_COUNTRY_CODE = "US";
var CANADA_COUNTRY_CODE = "CA";
var BLOCK_DISPLAY_STYLE = "";
var NO_DISPLAY = "none";
var EMPTY_VALUE = "";

function getProvinceField(form) {
    return form.caProvince ? form.caProvince : null;
}


function getStateValue(form) {
    return form.usState ? form.usState.value : null;
}


function getOtherValue(form) {
    return form.otherState ? form.otherState.value : null;
}


function showCounty(countyId) {
    try {
        var elem = document.getElementById(countyId);
        elem.style.display = BLOCK_DISPLAY_STYLE;
    } catch (e) {
        // yes, we know it's undefined.
    }

}


function hideCounty(countyFieldToSet, countyId) {
    try {
        var elem = document.getElementById(countyId);
        elem.style.display = NO_DISPLAY;

        if (countyFieldToSet) {
            setSubentityValue(EMPTY_VALUE, countyFieldToSet);
        }
    } catch (e) {
        // yes, we know it's undefined.
    }
}


function hideProvince(provinceFieldToSet, countyId, provinceId) {
    if (elem = document.getElementById(provinceId)) {
        elem.style.display = NO_DISPLAY;
    }

    try {
        // why isn't this working?
        //setStateValue(EMPTY_VALUE, false, provinceFieldToSet, countyId);
    } catch (e) {
        // yes, we know it's undefined.
    }
}


function hideOther(otherId) {
    if (elem = document.getElementById(otherId)) {
        elem.style.display = NO_DISPLAY;
    }
}


function hideState(stateFieldToSet, stateId, countyId) {
    try {
        var elem = document.getElementById(stateId);
        elem.style.display = NO_DISPLAY;

        setStateValue(EMPTY_VALUE, false, stateFieldToSet, countyId);
    } catch (e) {
        // yes, we know it's undefined.
    }
}


function showState(stateFieldToSet, countyFieldToSet, stateValue, stateId, countyId) {
    setStateValue(stateValue, true, stateFieldToSet, countyFieldToSet, countyId);

    var elem = document.getElementById(stateId);
    elem.style.display = BLOCK_DISPLAY_STYLE;
}


function showOther(stateFieldToSet, otherValue, countyId, otherId) {
    setStateValue(otherValue, false, stateFieldToSet, countyId);

    var elem = document.getElementById(otherId);
    elem.style.display = BLOCK_DISPLAY_STYLE;
}


function showProvince(stateFieldToSet, provinceFieldToSet, countyId, provinceId) {
    setStateValue(provinceFieldToSet.value, false, stateFieldToSet, countyId);

    var elem = document.getElementById(provinceId);
    elem.style.display = BLOCK_DISPLAY_STYLE;
}


function setPrevSubentityValue(value) {
    document.address.prevSubentity.value = value;
}


function checkStates(country, stateFieldToSet, countyFieldToSet, provinceFieldToSet, stateValue, stateId, provinceId, countyId, otherId, otherValue) {
    switch(country.value) {
        case US_COUNTRY_CODE:
            hideProvince(provinceFieldToSet, countyId, provinceId);
            hideOther(otherId);
            showState(stateFieldToSet, countyFieldToSet, stateValue, stateId, countyId);
            showCounty(countyId);
            displaySubentity(countyFieldToSet, stateValue, countyId);
            break;
        case CANADA_COUNTRY_CODE:
            hideState(stateFieldToSet, stateId, countyId);
            hideOther(otherId);
            hideCounty(countyFieldToSet, countyId)
            showProvince(stateFieldToSet, provinceFieldToSet, countyId, provinceId);
            break;
        default:
            hideState(stateFieldToSet, stateId, countyId);
            hideProvince(stateFieldToSet, countyId, provinceId);
            hideCounty(countyFieldToSet, countyId);
            showOther(stateFieldToSet, otherValue, countyId, otherId);
            //setStateValue(EMPTY_VALUE, false, stateFieldToSet, countyId);
    }
}


/*
 * Displays or hides the states county if it exists.
 */
function displaySubentity(countyFieldToSet, stateValue, countyId) {
    var prevSubentity = document.address.prevSubentity.value;
    var selectedEntity = stateValue;

    setPrevSubentityValue(selectedEntity);

    if (EMPTY_VALUE != prevSubentity) {
        try {
            showCounty(countyId);
            var elem = document.getElementById(prevSubentity);
            elem.style.display = NO_DISPLAY;
        } catch (e) {
            // yes, we know it's undefined.
        }
    }

    try {
        var elem = document.getElementById(selectedEntity);
        elem.style.display = BLOCK_DISPLAY_STYLE;

        if (countyFieldToSet) {
            eval('var tempValue = document.address.thisSubentity' + selectedEntity + '.value');
            setSubentityValue(tempValue, countyFieldToSet);
        }
    } catch(e) {
        hideCounty(countyFieldToSet, countyId);
    }
}

function setStateValue(stateValue, doSubentity, stateFieldToSet, countyFieldToSet, countyId) {
    //alert('state='+stateValue+'stateFieldToSet='+stateFieldToSet.name);
    stateFieldToSet.value = stateValue;

    // pretty much a hack.
    if (doSubentity && countyFieldToSet) {
        displaySubentity(countyFieldToSet, stateValue, countyId);
    } else {
        try {
            var elem = document.getElementById(countyId);
            elem.style.display = NO_DISPLAY;
        } catch (e) {
            // yes, we know it's undefined.
        }
    }
}


function setSubentityValue(subentityValue, countyFieldToSubmit) {
    countyFieldToSubmit.value = subentityValue;
}


function initializeDisplay(thisState, thisProvince, stateFieldToSet, customerCounty, countyFieldToSet, provinceFieldToSet, stateValue, countyId, thisOther, otherValue) {
    if (BLOCK_DISPLAY_STYLE == thisState) {
        setStateValue(stateValue, false, stateFieldToSet, countyFieldToSet, countyId);
        setPrevSubentityValue(stateValue);

        try {
            var elem = document.getElementById(stateValue);
            elem.style.display = BLOCK_DISPLAY_STYLE;

            showCounty(countyId);
            try {
                if (0 < customerCounty.length) {
                    countyFieldToSet.value = customerCounty;

                    displaySubentity(countyFieldToSet, stateValue, countyId);
                }
            } catch (e) {
                // yes, we know it's undefined.
            }
        } catch(e) { }
    } else if (BLOCK_DISPLAY_STYLE == thisProvince) {
        if (provinceFieldToSet) {
            setStateValue(provinceFieldToSet.value, false, stateFieldToSet, countyFieldToSet, countyId);
        }

    } else if (BLOCK_DISPLAY_STYLE == thisOther) {
        setStateValue(otherValue, false, stateFieldToSet, countyFieldToSet, countyId);

    } else {
        //setStateValue(EMPTY_VALUE, false, stateFieldToSet, countyFieldToSet, countyId);

    }
}