class Salesperson {
	constructor(data) {
		/**
		 * @type {string}
		 */
		this.id = '';
		/**
		 * @type {string}
		 */
		this.name = '';
		/**
		 * @type {string}
		 */
		this.zohoId = '';
		if (data.id) {
			this.id = data.id;
			this.name = data.name;
			this.zohoId = data.zohoId;
		}
		if (data.dbId) {
			this.id = data.dbId;
			this.name = data.name;
			this.zohoId = data.zohoId;
		}
		else if (data.salesRepId) {
			this.id = data.salesRepId;
			this.name = data.salesRepName;
			this.zohoId = data.salesRepZohoId;
		}
	}

	getId() {
		return this.id;
	}

	/**
	 * @returns {string}
	 */
	getName() {
		return this.name;
	}

	getZohoId() {
		return this.zohoId;
	}


	/**
	 * Fetches salesperson first name
	 * @returns First name of salesperson
	 */
	getFirstName() {
		return this.getName().substring(0, this.getName().indexOf(' '));
	}

	getSalespersonLink() {
		const link = document.createElement('a');
		link.href = `https://crm.zoho.com/crm/org26161413/settings/users/${this.getZohoId()}`
		link.innerText = this.getFirstName();
		link.target = "_blank";
		return link;
	}

	/**
	 *
	 * @param {boolean} selected Whether this option should be selected.
	 * @returns {HTMLOptionElement}
	 */
	getSalespersonOption(selected) {
		const option = document.createElement('option');
		option.value = this.getId();
		option.innerText = this.getFirstName();
		option.selected = selected;
		return option;
	}

	/**
	 *
	 * @param {Salesperson} otherSalesperson
	 */
	checkSameId(otherSalesperson) {
		return (this.getId() == otherSalesperson.getId());
	}
}
