const CONTROLLER_BASE_URL = 'admin_controller.php';
const redirect = getRedirectUrl();


/**
 * @type {HTMLInputElement}
 */
const VALIDATION_INPUT = document.getElementById('verification_code');

/**
 *
 * @param {Event} event
 * @returns
 */
async function validate(event) {
	event.preventDefault();

	const verificationCode = VALIDATION_INPUT.value;

	const responseText = await fetch(`${CONTROLLER_BASE_URL}?m=auth_verify&code=${verificationCode}`)
		.then(response => response.text());


	const isValid = JSON.parse(responseText);
	if (isValid) {
		if (redirect.length > 0) {
			window.location.href = `${CONTROLLER_BASE_URL}?m=${redirect}`;
		}
		else {
			alert("Key valid.");
		}
	}
	else {
		alert('Key not recognized');
	}
	return isValid;
}

function getRedirectUrl() {
	const propertyName = 'redirect=';
	const href = window.location.href;
	const index = href.indexOf(propertyName);
	const length = propertyName.length;
	if (index != -1) {
		return href.substring(index + length);
	}
	else {
		return '';
	}
}
