const orderInputs = document.getElementsByClassName('order_number_input');
const spInputs = document.getElementsByClassName('sp_number_input');
const trackingNumberInputs = document.getElementsByClassName('tracking_number_input');
const shippingDateInputs = document.getElementsByClassName('tracking_number_input');
const checkoutForm = document.getElementById('checkoutForm');
console.log('ecomcheckout.js loaded');
initListeners();

function initListeners() {
	if (checkoutForm.addEventListener) {
		checkoutForm.addEventListener("submit", function(evt) {
			if (document.activeElement.classList.contains('order_number_input') || !validate()) {
				evt.preventDefault();
			}
		}, true);
	}
	else {
		checkoutForm.attachEvent('onsubmit', function(evt){
			if (document.activeElement.classList.contains('order_number_input') || !validate()) {
				evt.preventDefault();
			}
		});
	}


	for (const orderInput of orderInputs) {
		orderInput.addEventListener('keyup', (event) => {
			if (event['key'] === 'Enter') {
				const row = getCurrentRow(orderInput.id);
				document.getElementById('sp_numbers_' + row).focus();
			}
		});
	}
	initMultiInputListeners(spInputs, 'sp');
	initMultiInputListeners(trackingNumberInputs, 'tracking');

	orderInputs[0].focus();
}

/**
 *
 * @param {HTMLTextAreaElement[]} inputs Collection of text area inputs
 * @param {string} inputType String of type of inputs
 */
function initMultiInputListeners(inputs, inputType) {
	const otherType = (inputType == 'sp') ? 'tracking' : 'sp';
	for (const input of inputs) {
		input.addEventListener('keyup', (event) => {
			if (event.key === 'Enter') {
				const entries = input.value.split('\n');
				const lastEntry = getLastEntry(entries);
				const lastEntryType = evaluateEntryType(lastEntry);
				if (lastEntryType != inputType) {
					const row = parseInt(getCurrentRow(input.id));
					input.value = entries.slice(0, entries.length - 2, entries.length).join('\n');
					if (lastEntryType == 'order') {
						const nextRow = row + 1;
						const nextOrder = document.getElementById('order_number_' + nextRow.toString());
						const nextSp = document.getElementById('sp_numbers_' + nextRow);
						nextOrder.value = lastEntry;
						nextSp.focus();
					} else if (lastEntryType == otherType) {
						const otherField = document.getElementById(otherType + '_numbers_' + row);
						otherField.value += (otherField.value.length > 0) ? '\n' + lastEntry + '\n' : lastEntry + '\n';
						addRow(otherField);
						otherField.focus();
					}
				} else {
					addRow(input);
				}
			}
		})
	}
}

orderInputs[0].focus();


/**
 *
 * @param {string} str Last entry to be parsed
 * @returns {string} Type of entry - tracking, sp, or order
 */
function evaluateEntryType(str) {
	const upsPattern = /^(1Z.{16})$/;
	const fedexPattern = /^(.{12}|.{15})$/;
	const uspsPattern = /^(.{22})$/;
	const spPattern = /^(SP\d{6})$/;
	if (upsPattern.test(str) || fedexPattern.test(str) || uspsPattern.test(str)) {
		return 'tracking';
	} else if (spPattern.test(str)) {
		return 'sp';
	} else {
		return 'order';
	}
}

/**
 *
 * @param {string} str The element ID to check
 * @returns {string} The current row, as a string
 */
function getCurrentRow(str) {
	return str.substring(str.lastIndexOf('_') + 1);
}

/**
 *
 * @param {string[]} arr Array of strings to get the last entry from
 * @returns {string} Last entry element
 */
function getLastEntry(arr) {
	return arr[arr.length - 2];
}

/**
 *
 * @param {HTMLTextAreaElement} element
 */
function addRow(element) {
	element.rows += 1;
}

/**
 *
 * @param {string} str The SP number to test
 * @returns {boolean} true if a valid SP number, else false
 */
function isValidSPNumber(str) {
	const spPattern = /^(SP\d{6})$/;
	return (spPattern.test(str) || str == '');
}


function validate() {
	let errorMessage = '';
	for (const orderInput of orderInputs) {
		const currentRow = getCurrentRow(orderInput.id);
		const currentSpInput = document.getElementById('sp_numbers_' + currentRow);
		const spEntries = (currentSpInput.value) ? currentSpInput.value.split('\n') : [];
		if (orderInput.value && orderInput.value.length > 0 && (!currentSpInput.value || currentSpInput.value.length < 1)) {
			errorMessage += 'No SP numbers entered for order ' + orderInput.value + ' on row ' + currentRow + '\n';
		}
		for (const spEntry of spEntries) {
			if (!isValidSPNumber(spEntry)) {
				errorMessage += 'Invalid SP number found for order ' + orderInput.value + ' on row ' + currentRow + '\n';
			}
		}
	}
	if (errorMessage.length > 0) {
		alert(errorMessage);
		return false;
	} else {
		return true;
	}
}
