<?php

class PackingSlipPDF extends FPDF {

	var $leftFooter ='';
	var $rightFooter = '';
	var $imgHeader = '';
	var $centerHeader = 'Packing Slip';
	var $rightHeader = '';
	var $orderNumber = '';
	var $date = '';
	var $R = '';
	var $G = '';
	var $B = '';

	function Header(){
		// Logo
		$this->Image($this->imgHeader, 10, 6, 0, 20);
		// $this->Image($this->imgHeader, 0, null, 0, 20);
		// Move to the right
		//$this->Cell(80);
		// Arial bold 15
		$this->SetFont('Arial','B',20);
		$this->SetXY(10, 20);
		// $this->Cell(194.8, 8, $this->centerHeader, 0, 0, 'C');
		$this->Cell(194.8, 8, '', 0, 0, 'C');
		$this->SetXY(10, 30);
		$this->SetDrawColor($this->R, $this->G, $this->B);
		$this->Rect(10, $this->GetY()+1,195, 1.2,'F');
		// $this->Line(10,$this->GetY()+5,252,$this->GetY()+5);
		$this->Ln(10);
	}

	function Footer(){
		$this->SetY(-15);
		$this->SetFont('Times','',5);
		$this->Cell(120,10, $this->leftFooter);
		$this->Cell(120,10, $this->rightFooter,0,0,'R');

	}
	function Code39($xpos, $ypos, $code, $baseline=0.5, $height=5, $writeReadable=false, $alignReadable='L'){

		$wide = $baseline;
		$narrow = $baseline / 3 ;
		$gap = $narrow;

		$barChar = $this->GetBarChars();

		$this->SetFont('Arial','',10);
		$this->SetFillColor(0);

		$startXPos = $xpos;

		$barcode = '*'.strtoupper($code).'*';
		for($i=0; $i<strlen($barcode); $i++){
			$char = $barcode[$i];
			if(!isset($barChar[$char])){
				$this->Error('Invalid character in barcode: '.$char);
			}
			$seq = $barChar[$char];
			for($bar=0; $bar<9; $bar++){
				if($seq[$bar] == 'n'){
					$lineWidth = $narrow;
				}else{
					$lineWidth = $wide;
				}
				if($bar % 2 == 0){
					$this->Rect($xpos, $ypos, $lineWidth, $height, 'F');
				}
				$xpos += $lineWidth;
			}
			$xpos += $gap;
		}
		$barCodeWidth = $xpos - $startXPos;
		if ($writeReadable) {
			// $readableXPos = $startXPos;
			if ($alignReadable == 'L') {
				$readableXPos = $startXPos;
			}
			elseif ($alignReadable == 'C') {
				$readableXPos = $xpos - ($this->GetStringWidth($code) / 2) - ($barCodeWidth / 2);
			}
			elseif ($alignReadable == 'R') {
				$readableXPos = $xpos - $this->GetStringWidth($code);
			}
			$this->Text($readableXPos, $ypos + $height + 6, $code);
		}
	}

	function GetCode39Width($code, $baseline=0.5, $height=5) {

		$wide = $baseline;
		$narrow = $baseline / 3 ;
		$gap = $narrow;

		$barChar = $this->GetBarChars();

		$this->SetFont('Arial','',10);
		$this->SetFillColor(0);

		$startXPos = $xpos;

		$barcode = '*'.strtoupper($code).'*';
		for($i=0; $i<strlen($barcode); $i++){
			$char = $barcode[$i];
			if(!isset($barChar[$char])){
				$this->Error('Invalid character in barcode: '.$char);
			}
			$seq = $barChar[$char];
			for($bar=0; $bar<9; $bar++){
				if($seq[$bar] == 'n'){
					$lineWidth = $narrow;
				}else{
					$lineWidth = $wide;
				}
				if($bar % 2 == 0){
					// $this->Rect($xpos, $ypos, $lineWidth, $height, 'F');
				}
				$xpos += $lineWidth;
			}
			$xpos += $gap;
		}
		$barCodeWidth = $xpos - $startXPos;
		return $barCodeWidth;
	}

	private function GetBarChars() {
		$barChar['0'] = 'nnnwwnwnn';
		$barChar['1'] = 'wnnwnnnnw';
		$barChar['2'] = 'nnwwnnnnw';
		$barChar['3'] = 'wnwwnnnnn';
		$barChar['4'] = 'nnnwwnnnw';
		$barChar['5'] = 'wnnwwnnnn';
		$barChar['6'] = 'nnwwwnnnn';
		$barChar['7'] = 'nnnwnnwnw';
		$barChar['8'] = 'wnnwnnwnn';
		$barChar['9'] = 'nnwwnnwnn';
		$barChar['A'] = 'wnnnnwnnw';
		$barChar['B'] = 'nnwnnwnnw';
		$barChar['C'] = 'wnwnnwnnn';
		$barChar['D'] = 'nnnnwwnnw';
		$barChar['E'] = 'wnnnwwnnn';
		$barChar['F'] = 'nnwnwwnnn';
		$barChar['G'] = 'nnnnnwwnw';
		$barChar['H'] = 'wnnnnwwnn';
		$barChar['I'] = 'nnwnnwwnn';
		$barChar['J'] = 'nnnnwwwnn';
		$barChar['K'] = 'wnnnnnnww';
		$barChar['L'] = 'nnwnnnnww';
		$barChar['M'] = 'wnwnnnnwn';
		$barChar['N'] = 'nnnnwnnww';
		$barChar['O'] = 'wnnnwnnwn';
		$barChar['P'] = 'nnwnwnnwn';
		$barChar['Q'] = 'nnnnnnwww';
		$barChar['R'] = 'wnnnnnwwn';
		$barChar['S'] = 'nnwnnnwwn';
		$barChar['T'] = 'nnnnwnwwn';
		$barChar['U'] = 'wwnnnnnnw';
		$barChar['V'] = 'nwwnnnnnw';
		$barChar['W'] = 'wwwnnnnnn';
		$barChar['X'] = 'nwnnwnnnw';
		$barChar['Y'] = 'wwnnwnnnn';
		$barChar['Z'] = 'nwwnwnnnn';
		$barChar['-'] = 'nwnnnnwnw';
		$barChar['.'] = 'wwnnnnwnn';
		$barChar[' '] = 'nwwnnnwnn';
		$barChar['*'] = 'nwnnwnwnn';
		$barChar['$'] = 'nwnwnwnnn';
		$barChar['/'] = 'nwnwnnnwn';
		$barChar['+'] = 'nwnnnwnwn';
		$barChar['%'] = 'nnnwnwnwn';

		return $barChar;

	}
}

?>
