<?php

class Worldship extends Database {
	private $verboseLogging = false;

	public function worldshipNew() {
		global $ups_ship_from, $executiveObj;

		$ups_service = $this->db_select_multiple('ups_service', 'ups_service_code,internal_description',array(),'order by ups_service_code');

		$sql = "SELECT * FROM ups_service_types WHERE `description` = '{$_GET['shipper']}';";
		$serviceCodeData = $this->db_query($sql, 'select-single', true);
		$serviceCode = $serviceCodeData['service_code'] ? $serviceCodeData['service_code'] : '03';
		$service = $this->arrayToHtmlSelectOptions($ups_service, false, $serviceCode);

		$ups_package_type =  $this->db_select_multiple('ups_package_type', 'ups_package_type_id,ups_packaging_type_code,internal_description,length,width,height',array(),'order by sequence');

		$boxId = 0;
		if ($_GET['listing_id'] && $_GET['channel']) {
			$boxId = $this->getSelectedBoxId($_GET['listing_id'], $_GET['channel']);
			$deviceWeight = $this->getSelectedDeviceWeight($_GET['listing_id'], $_GET['channel']);
		}

		$package = '';

		$shipping_boxes = $executiveObj->getShippingBoxes();

		$dimensions['length'] = $shipping_boxes[0]['length'];
		$dimensions['width'] = $shipping_boxes[0]['width'];
		$dimensions['height'] = $shipping_boxes[0]['height'];

		$weight = '';
		foreach ($shipping_boxes as $shipping_box){
			if ($shipping_box['id'] == $boxId) {
				$dimensions['length'] = $shipping_box['length'];
				$dimensions['width'] = $shipping_box['width'];
				$dimensions['height'] = $shipping_box['height'];
				if ($shipping_box['weight'] && $deviceWeight) {
					$weight = strval(round((float)$shipping_boxes[$boxId]['weight'] + (float)$deviceWeight));
				}
				$package .= '<option selected value="new_'.$shipping_box['id'].'" ups_packaging_type_code="'.$shipping_box['type_code'].'" length="'.$shipping_box['length'].'" width="'.$shipping_box['width'].'" height="'.$shipping_box['height'].'">'.$shipping_box['name'].'</option>';
			} else {
				$package .= '<option value="new_'.$shipping_box['id'].'" ups_packaging_type_code="'.$shipping_box['type_code'].'" length="'.$shipping_box['length'].'" width="'.$shipping_box['width'].'" height="'.$shipping_box['height'].'">'.$shipping_box['name'].'</option>';
			}
		}
		$package .= '<option disabled>=====Old Box Types=====</option>';
		foreach ($ups_package_type as $package_type){
			$package .= '<option value="old_'.$package_type['ups_package_type_id'].'" ups_packaging_type_code="'.$package_type['ups_packaging_type_code'].'" length="'.$package_type['length'].'" width="'.$package_type['width'].'" height="'.$package_type['height'].'">'.$package_type['internal_description'].'</option>';
		}
		if ($_GET['echoweight'] == 'yes') {
			echo "<p>$deviceWeight</p>";
			echo "<p>{$shipping_boxes[$boxId]['weight']}</p>";
			echo "<p></p>";
			echo print_r($shipping_boxes[$boxId]);
			echo "<p></p>";
			echo "<p>$weight</p>";
		}

		$ups_return_service = $this->db_select_multiple('ups_return_service', 'ups_return_service_code,internal_description',array(),'order by ups_return_service_code');

		$return_service = $this->arrayToHtmlSelectOptions($ups_return_service,true,false,array(),'None');

		$ups_shipments = $this->db_select_multiple('ups_shipments', 'distinct ship_to, attention, address1, address2, address3, city, state, zip, phone, email', '', 'order by ship_to');

		$i = 0;
		foreach ($ups_shipments as $row){

			$ups_ship_to[] = array($i,$row['ship_to']);
			$ups_shipments[$i]['ship_id'] = $i;

			$i++;
		}
		$ship_to_json = json_encode($ups_shipments);

		$var_json = 'var shiptoJSONObj = {"shipaddresses":'.$ship_to_json.'};';

		$ship_from = $this->arrayToHtmlSelectOptions(array_keys($ups_ship_from));

		$ship_to = $this->arrayToHtmlSelectOptions($ups_ship_to,true);


		if ($_GET['oNum']){
			$ds_orders = $this->db_select_single('ds_orders', '*', array('oNum' => $_GET['oNum']));

			if ($ds_orders['cShipCompany'] == ''){

				$company = $ds_orders['cShipFname'].' '.$ds_orders['cShipLname'];
				$name = '';

			}else{

				$company = $ds_orders['cShipCompany'];
				$name = $ds_orders['cShipFname'].' '.$ds_orders['cShipLname'];

			}

			$address1 = $ds_orders['cShipAddress1'];
			$address2 = $ds_orders['cShipAddress2'];
			$city = $ds_orders['cShipCity'];
			$state = $ds_orders['cShipState'];
			$zip = $ds_orders['cShipZip'];
			$phone = $ds_orders['cPhone'];
			$email = $ds_orders['cShipEmail'];
			$ref1 = $ds_orders['oNum'];

		}else{

			$company = $_GET['company'] ? $this->decodeSanitizedString($_GET['company']) : '';
			$name = $_GET['name'] ? $this->decodeSanitizedString($_GET['name']) : '';
			$address1 = $_GET['address1'] ? $this->decodeSanitizedString($_GET['address1']) : '';
			$address2 = $_GET['address2'] ? $this->decodeSanitizedString($_GET['address2']) : '';
			$city = $_GET['city'] ? $this->decodeSanitizedString($_GET['city']) : '';
			$state = $_GET['state'] ? $this->decodeSanitizedString($_GET['state']) : '';
			$zip = $_GET['zip'] ? $this->decodeSanitizedString($_GET['zip']) : '';
			$phone = $_GET['phone'] ? $this->decodeSanitizedString($_GET['phone']) : '';
			$email = $_GET['email'] ? $this->decodeSanitizedString($_GET['email']) : '';
			$ref1 = $_GET['ref1'] ? $this->decodeSanitizedString($_GET['ref1']) : '';
			$ref2 = $_GET['ref2'] ? $this->decodeSanitizedString($_GET['ref2']) : '';
			$saleChannel = $_GET['channel'] ? $this->decodeSanitizedString($_GET['channel']) : '';

			if (!($saleChannel && $ref2)) {
				$ecommButtonHidden = 'hidden disabled';
			}
			if ($_GET['from']) {
				$ship_from = $this->arrayToHtmlSelectOptions(array_keys($ups_ship_from), false, $_GET['from']);
			}
		}

		$large_printers = $this->db_select_multiple('large_printers', 'large_printer_id, large_printer_name',array(),'order by large_printer_name');
		$dd_large_printers = '';
		foreach ($large_printers as $large_printer){
			if ($_GET['origin'] == 'open_orders' && $large_printer['large_printer_id'] == '12') {
				$dd_large_printers .= '<option selected value="'.$large_printer['large_printer_id'].'">'.$large_printer['large_printer_name'].'</option>';
			}
			else {
				$dd_large_printers .= '<option value="'.$large_printer['large_printer_id'].'">'.$large_printer['large_printer_name'].'</option>';
			}
		}

		$parse = array(
			'SERVICE'   => $service,
			'PACKAGE'   => $package,
			'RETURN_SERVICE'    =>  $return_service,
			'SHIP_FROM' => $ship_from,
			'SHIP_TO'   => $ship_to,
			'COMPANY'   => $company,
			'NAME'      => $name,
			'ADDRESS1'  => $address1,
			'ADDRESS2'  => $address2,
			'CITY'      => $city,
			'STATE'     => $state,
			'ZIP'       => $zip,
			'PHONE'     => $phone,
			'EMAIL'     => $email,
			'REF1'      => $ref1,
			'REF2'      => $ref2,
			'VAR_JSON'  => $var_json,
			'LENGTH'    => $dimensions['length'],
			'WIDTH'    => $dimensions['width'],
			'HEIGHT'    => $dimensions['height'],
			'LARGE_PRINTERS'    => $dd_large_printers,
			'WEIGHT' => $weight,
			'SALE_CHANNEL' => $saleChannel,
			'ECOMM_BUTTON_HIDDEN' => $ecommButtonHidden
		);

		echo $this->parse(TEMPLATE,  array('BODY' => $this->parse(WORLDSHIP_NEW,$parse)));
	}

	public function shipBackMarketOrders($orderIds, $verboseLogging=false) {
		if ($verboseLogging || $_POST['verboselogging'] == 'yes' || $_GET['verboselogging'] == 'yes') {
			echo "<pre>";
			echo "Verbose logging enabled.\n";
			echo "Shipping the following orders:\n";
			print_r($orderIds);
			$this->verboseLogging = true;
		}

		// Set variables for later use
		$channel = 'backmarket';
		$printer = '12';
		if (count($orderIds) < 1) {
			echo "ERR: No Order IDs\n";
			return false;
		}

		// Instantiate array to hold error logging data
		$returnData = array();
		foreach ($orderIds as $orderId) {

			$this->shipOrder($orderId, $channel, $returnData);
		}
		return $returnData;
	}

	public function shipNeweggOrders($orderIds, $verboseLogging=false) {
		if ($verboseLogging || $_POST['verboselogging'] == 'yes' || $_GET['verboselogging'] == 'yes') {
			echo "<pre>";
			echo "Verbose logging enabled.\n";
			echo "Shipping the following orders:\n";
			print_r($orderIds);
			$this->verboseLogging = true;
		}

		// Set variables for later use
		$channel = 'newegg';
		$printer = '12';
		if (count($orderIds) < 1) {
			echo "ERR: No Order IDs\n";
			return false;
		}

		// Instantiate array to hold error logging data
		$returnData = array();
		foreach ($orderIds as $orderId) {

			$this->shipOrder($orderId, $channel, $returnData);
		}
		return $returnData;
	}

	public function shipEbayOrders($orderIds, $verboseLogging=false) {
		if ($verboseLogging || $_POST['verboselogging'] == 'yes' || $_GET['verboselogging'] == 'yes') {
			echo "<pre>";
			echo "Verbose logging enabled.\n";
			echo "Shipping the following orders:\n";
			print_r($orderIds);
			$this->verboseLogging = true;
		}

		// Set variables for later use
		$channel = 'ebay';
		$printer = '12';
		if (count($orderIds) < 1) {
			echo "ERR: No Order IDs\n";
			return false;
		}

		// Instantiate array to hold error logging data
		$returnData = array();
		foreach ($orderIds as $orderId) {

			$this->shipOrder($orderId, $channel, $returnData);
		}
		return $returnData;
	}

	private function shipOrder($orderId, $channel, &$returnData){
		global $adminObj;
		$printer = '12';
		if ($this->verboseLogging) {
			echo "Preparing to ship $orderId\n";
		}
		$order = $this->getOrder($orderId, $channel);
		if ($this->verboseLogging) {
			echo "Fetched order $orderId\n";
			// print_r($order);
		}
		if ($order) {
			$returnData[$orderId] = array();

			// Get local data as exists already
			$localOrderData = $this->getLocalOrderData($orderId);
			if ($this->verboseLogging) {
				echo "Order $orderId: Fetched local order data\n";
			}

			$itemCounts = $this->getItemCounts($order, $channel);
			if ($this->verboseLogging) {
				echo "Order $orderId: Fetched item counts:\n\tLine items:$itemCounts->lineItems\n\tQuantity:$itemCounts->quantity\n";
			}

			if ($itemCounts->lineItems > 1 || $itemCounts->quantity != 1) {
				if ($this->verboseLogging) {
					echo "Too many items to auto-process.\n";
				}
				$sql = "UPDATE `ecomm_open_orders` SET `error` = 'More than one device. Needs manual processing.' WHERE `order_id` = '$orderId';";
				$this->db_query($sql, 'update');
				$returnData[$orderId]['error'] = 'More than one device. Needs manual processing.';
				return false; // TODO - Need to build in support for multiple-device shipment. For now, only one allowed.
			}

			// Get the listing id for device being shipped.
			$listingId = $this->getListingId($order, $channel);
			if ($this->verboseLogging) {
				echo "Order $orderId: Fetched listing ID: $listingId\n";
			}

			// Get data for the device's associated box.
			$boxData = $this->getBoxData($listingId, $channel);
			$boxWeight = $boxData['weight'];
			$boxId = $boxData['id'];

			if (!$boxId || trim($boxId) == '') {
				if ($this->verboseLogging) {
					echo "ERR: No box found for $orderId\n";
				}
				$sql = "UPDATE `ecomm_open_orders` SET `error` = 'No box definition found.' WHERE `order_id` = '$orderId';";
				$this->db_query($sql, 'update');
				$returnData[$orderId]['error'] = 'No box definition found.';
				return false;
			}

			// Get device weight.
			$deviceWeight = $adminObj->getSelectedDeviceWeight($listingId, $channel);

			if (!$deviceWeight) {
				if ($this->verboseLogging) {
					echo "ERR: No device weight found for $orderId\n";
				}
				$sql = "UPDATE `ecomm_open_orders` SET `error` = 'No device weight defined.' WHERE `order_id` = '$orderId';";
				$this->db_query($sql, 'update');
				$returnData[$orderId]['error'] = 'No device weight defined.';
				return false;
			}

			// Calculate total scale weight.
			$weight = strval(round((float)$boxWeight + (float)$deviceWeight));
			if ($this->verboseLogging) {
				echo "Total Weight: $weight\n";
			}

			$shipData = $this->getShipDataFromOrderObject($channel, $order, $boxData, $weight);
			$shipData['ref2'] = $orderId;
			$shipData['printer'] = $printer;

			$url = '';
			// if ($channel == 'backmarket') {
			// 	$url = $order->delivery_note;
			// }
			if ($this->verboseLogging) {
				echo print_r($shipData);
			}
			$result = $this->handleEcommWorldship($shipData, $localOrderData, $orderId, $this->verboseLogging);
			if ($this->verboseLogging) {
				echo "Result: $result\n";
			}

			if ($result == "1" || $result == 1) {
				$this->handlePrintingPackingSlip($orderId, $channel, $returnData, $url, $this->verboseLogging);
			}
			if ($this->verboseLogging) {
				echo "</pre>\n";
			}
		}
	}

	/************************************
	 *
	 * Order Shipment Helper Functions
	 * Begin
	 *
	 ************************************/


	private function getOrder($orderId, $channel) {
		if ($this->verboseLogging) {
			echo "Getting $channel: $orderId\n";
		}
		global $backmarketObj, $ebayApiObj, $neweggApiObj;
		$order = false;
		if ($channel == 'backmarket') {
			$orderData = $backmarketObj->getOrder($orderId);
			if ($this->verboseLogging) {
				echo "$channel: $orderId fetched\n";
			}
			if ($orderData) {
				$order = json_decode($orderData);
			}
		}
		elseif ($channel == 'newegg') {
			$orderData = $neweggApiObj->getOrder(trim($orderId));
			if ($this->verboseLogging) {
				echo "$channel: $orderId fetched\n";
			}
			if ($orderData) {
				$decodedData = json_decode($orderData);
				$order = $decodedData->ResponseBody->OrderInfoList[0];
			}
		}
		elseif ($channel == 'ebay') {
			$orderData = $ebayApiObj->getOrder($orderId);
			if ($this->verboseLogging) {
				echo "$channel: $orderId fetched\n";
			}
			if ($orderData) {
				$order = json_decode($orderData);
			}
		}
		return $order;
	}

	private function getLocalOrderData($orderId) {
		$sql = "SELECT `id`, `order_id`, `channel_id`, `labels_printed`, `shipping_label_generated` FROM `ecomm_open_orders` WHERE `order_id`='$orderId';";
		return $this->db_query($sql, 'select-single', true);
	}

	private function getItemCounts(&$order, $channel) {
		$counts = new stdClass;
		$counts->lineItems = 0;
		$counts->quantity = 0;
		if ($channel == 'backmarket') {
			$counts->lineItems = count($order->orderlines);
			$counts->quantity = (int)$order->orderlines[0]->quantity;
		}
		elseif($channel == 'newegg') {
			$counts->lineItems = count($order->ItemInfoList);
			$counts->quantity = (int)$order->ItemInfoList[0]->OrderedQty;
		}
		elseif ($channel == 'ebay') {
			$counts->lineItems = count($order->lineItems);
			$counts->quantity = (int)$order->lineItems[0]->quantity;
		}
		return $counts;
	}

	private function getListingId(&$order, $channel) {
		if ($channel == 'backmarket') {
			return $order->orderlines[0]->listing_id;
		}
		elseif ($channel == 'newegg') {
			return $order->ItemInfoList[0]->NeweggItemNumber;
		}
		elseif ($channel == 'ebay') {
			return $order->lineItems[0]->legacyItemId;
		}
		return false;
	}

	private function handleEcommWorldshipResults($localOrderData, $result, $orderId, $verboseLogging = false) {
		if ($result != 1 && $result != "1") {
			if ($verboseLogging) {
				echo "Shipping label failed to print.\n";
			}
			$errorMsgLength = (int)substr($result, 2, strpos($result, ':', 2) - 2);
			$errorMsg = substr($result, strpos($result, '"') + 1, $errorMsgLength);
			$returnData[$orderId]['error'] = $errorMsg;
			$returnData[$orderId]['error'] = "Packing slip failed to print.";
			$sql = "UPDATE `ecomm_open_orders` SET `error` = '$errorMsg' WHERE `order_id` = '$orderId';";
			$this->db_query($sql, 'update');
		}
		elseif ($localOrderData['shipping_label_generated'] == "0" && ($result == "1" || $result == 1)) {
			if ($verboseLogging) {
				echo "Shipping label successfully printed.\n";
			}
			$sql = "UPDATE `ecomm_open_orders` SET `shipping_label_generated`='1' WHERE `order_id`='$orderId';";
			$this->db_query($sql, 'update', true);
		}
	}

	private function handleEcommWorldship($shipData, $localOrderData, $orderId, $verboseLogging=false) {
		$result = '0';
		if ($localOrderData['shipping_label_generated'] != '1') {
			if ($verboseLogging) {
				echo "Generating new shipping label.\n";
			}
			$result = $this->ecommWorldship($shipData);
		}
		else {
			if ($verboseLogging) {
				echo "Shipping label already exists, bypassing.\n";
			}
			$result = $localOrderData['shipping_label_generated'];
		}
		$this->handleEcommWorldshipResults($localOrderData, $result, $orderId, $verboseLogging);
		return $result;
	}

	private function handlePrintingPackingSlip($orderId, $channel, &$returnData, $url='', $verboseLogging = false) {
		if ($verboseLogging) {
			echo "Preparing to print packing slip.\n";
		}
		$packingSlipResult = $this->printPackingSlip($orderId, $channel, $url);
		if ($verboseLogging) {
			echo "Packing slip print result:\n";
			print_r($packingSlipResult);
		}
		if ($packingSlipResult['success']) {
			if ($verboseLogging) {
				echo "Packing slip printed.\n";
			}
			$returnData[$orderId]['labels_printed'] = 1;
			$sql = "UPDATE `ecomm_open_orders` SET `error` = NULL, `labels_printed` = '1' WHERE `order_id` = '$orderId';";
			if ($verboseLogging) {
				echo "$sql\n";
			}
			$this->db_query($sql, 'update');
		}
		else {
			if ($verboseLogging) {
				echo "Packing slip failed to print.\n";
			}
			$returnData[$orderId]['error'] = "Packing slip failed to print.";
			$sql = "UPDATE `ecomm_open_orders` SET `error` = 'Packing slip failed to print.' WHERE `order_id` = '$orderId';";
			$this->db_query($sql, 'update');
		}
	}

	/************************************
	 *
	 * Order Shipment Helper Functions
	 * End
	 *
	 ************************************/

	private function getShipDataFromOrderObject($channel, $order, $boxData, $weight) {
		$verboseLogging = false;
		if ($_POST['verboselogging'] == 'yes' || $_GET['verboselogging'] == 'yes') {
			$verboseLogging = true;
		}
		$length = $boxData['length'];
		$width = $boxData['width'];
		$height = $boxData['height'];
		$boxWeight = $boxData['weight'];
		$boxId = $boxData['id'];

		if ($verboseLogging) {
			echo "Length: $length\nWidth: $width\nHeight: $height\nWeight: $boxWeight\nBox ID: $boxId\n";
		}
		if ($channel == 'backmarket') {
			// Parse ship name and get service code.
			$shipName = substr($order->shipper, 4);

			// Put data from decoded order into variables
			$name = $order->shipping_address->first_name . " " . $order->shipping_address->last_name;
			$address1 = $order->shipping_address->street;
			$address2 = $order->shipping_address->street2;
			$city = $order->shipping_address->city;
			$state = $order->shipping_address->state_or_province;
			$zip = $order->shipping_address->postal_code;
			$phone = $order->shipping_address->phone;
			$email = $order->shipping_address->email;
			$ref1 = "Back Market";
		}
		elseif($channel == 'newegg') {
			// Normalize shipping type name
			$shipNames = array(
				'Standard Shipping (5-7 business days)' => 'Ground',
				'One-Day Shipping(Next day)' => 'Next Day Air Saver',
				'Two-Day Shipping(2 business days)' => '2nd Day Air'
			);
			if ($shipNames[$order->ShipService]) {
				$shipName = $shipNames[$order->ShipService];
			}
			else {
				$shipName = 'Ground';
			}

			// Put data from decoded order into variables
			$name = $order->ShipToFirstName . " " . $order->ShipToLastName;
			$address1 = $order->ShipToAddress1;
			$address2 = $order->ShipToAddress2;
			$city = $order->ShipToCityName;
			$state = $order->ShipToStateCode;
			$zip = $order->ShipToZipCode;
			$phone = $order->CustomerPhoneNumber;
			$email = $order->CustomerEmailAddress;
			$ref1 = "Newegg";
		}
		elseif ($this->startsWith($channel, 'ebay')) {
			$shipNames = array(
				'UPSNextDayAir' => 'Next Day Air',
				'UPS2ndDayAir' => '2nd Day Air',
				'UPSGround' => 'Ground'
			);
			if ($shipNames[$order->ShipService]) {
				$shipName = $shipNames[$order->ShipService];
			}
			else {
				$shipName = 'Ground';
			}
			// Put data from decoded order into variables
			$name = $order->fulfillmentStartInstructions[0]->shippingStep->shipTo->fullName;
			$address1 = $order->fulfillmentStartInstructions[0]->shippingStep->shipTo->contactAddress->addressLine1;
			$address2 = $order->fulfillmentStartInstructions[0]->shippingStep->shipTo->contactAddress->addressLine2;
			$city = $order->fulfillmentStartInstructions[0]->shippingStep->shipTo->contactAddress->city;
			$state = $order->fulfillmentStartInstructions[0]->shippingStep->shipTo->contactAddress->stateOrProvince;
			$zip = $order->fulfillmentStartInstructions[0]->shippingStep->shipTo->contactAddress->postalCode;
			$phone = $order->fulfillmentStartInstructions[0]->shippingStep->shipTo->primaryPhone->phoneNumber;
			$email = $order->fulfillmentStartInstructions[0]->shippingStep->shipTo->email;
			$ref1 = $order->lineItems[0]->soldFormat == "AUCTION" ? "eBay Auction" : "eBay";
		}
		$service = $this->getServiceCode($shipName);
		$shipData = array(
			'ship_from'		=> 'SourcePlus'
			,'company'		=> $name
			,'address1'		=> $address1
			,'address2'		=> $address2
			,'city'			=> $city
			,'state'		=> $state
			,'zip'			=> $zip
			,'phone'		=> $phone
			,'email'		=> $email
			,'service'		=> $service
			,'package'		=> $boxId
			,'length'		=> $length
			,'width'		=> $width
			,'height'		=> $height
			,'weight'		=> $weight
			,'ref1'			=> $ref1
			// ,'ref2'			=> $orderId
			// ,'printer'		=> $printer
			,'channel'		=> $channel
		);
		return $shipData;
	}

	private function getServiceCode($shipName) {
		$sql = "SELECT * FROM ups_service_types WHERE `description` = '$shipName';";
		$serviceCodeData = $this->db_query($sql, 'select-single', true);
		return $serviceCodeData['service_code'];
	}

	private function printPackingSlip($orderId, $channel, $url='', $path='') {
		if ($path == '') {
			$path = HTML_FOLDER.'tmp';
		}
		$sql = "SELECT tracking_number FROM ups_pending_tracking_numbers WHERE order_number_id = (SELECT id FROM ups_pending_orders WHERE order_number = '$orderId');";
		$trackingNumbers = $this->db_query($sql, 'select-multiple', true);
		require_once(HTML_FOLDER . 'classes/class_packingslips.php');
		$packingslipObj = new PackingSlips;
		$result = $packingslipObj->printPackingSlips($orderId, $channel, $trackingNumbers);
		return $result;
	}

	private function ecommWorldship($data) {
		global $upsObj, $ups_ship_from, $adminObj;

		$verboseLogging = false;
		if ($_POST['verboselogging'] == 'yes') {
			echo "<pre>";
			$verboseLogging = true;
		}
		if ($verboseLogging) {
			echo "All required data found, now in worldship\n";
		}

		$calcWeight = $this->getCalcWeight($data['length'],$data['width'],$data['height']);

		$scale_weight = $data['weight'];

		if (round($calcWeight) > $data['weight']){
			$data['weight'] = round($calcWeight);
		}

		$from = $ups_ship_from[$data['ship_from']];
		$ups_package_type = '';
		$sql = "SELECT uptc.type_code AS ups_packaging_type_code, uptc.`description` AS ups_description FROM shipping_boxes AS sb LEFT JOIN ups_package_type_codes AS uptc ON sb.ups_type_code_id = uptc.`id` WHERE sb.id = {$data['package']};";
		$ups_package_type = $this->db_query($sql, 'select-single', true);

		$package_type = $ups_package_type['ups_packaging_type_code'];
		$package_description = $ups_package_type['ups_description'];

		$data['country'] = 'US';
		$temp_large_printer = $_SESSION['large_printer_id'];

		$_SESSION['large_printer_id'] = $data['printer'];

		//create shipment
		$response = $upsObj->ship_worldship('Worldship',$from,$data,$data['service'],$data['weight'],$data['return_service'],$data['delivery_confirmation'],false,$saturday,$data['declared_value'],$data['add_boxes'],$data['ref1'],$data['ref2'], false,0,$package_type,$package_description);

		$boxes = count($response);

		$i = 1;

		$channel = $data['channel'];
		$channel = str_replace('_', '', $channel);
		$orderNumber = trim($data['ref2']);
		$trackingNumbers = array();

		$errorMsg = '';

		foreach($response as $row){

			//write record to ship log
			if ($row['status'] == 'Success'){
				array_push($trackingNumbers, $row['tracking']);

				$ship_data = array(
					'tracking_no'               =>  $row['tracking']
					,'ship_from'                =>  $data['ship_from']
					,'ship_to'                  =>  $data['company']
					,'attention'                =>  $data['name']
					,'address1'                 =>  $data['address1']
					,'address2'                 =>  $data['address2']
					,'address3'                 =>  $data['address3']
					,'city'                     =>  $data['city']
					,'state'                    =>  $data['state']
					,'zip'                      =>  $data['zip']
					,'phone'                    =>  $data['phone']
					,'email'                    =>  $data['email']
					,'service'                  =>  $data['service']
					,'bill_to'                  =>  $data['bill_to']
					,'weight'                   =>  $scale_weight
					,'ref1'                     =>  $data['ref1']
					,'ref2'                     =>  $data['ref2']
					,'delivery_confirmation'    =>  $data['delivery_confirmation']
					,'return_service'           =>  $data['return_service']
					,'declared_value'           =>  $data['declared_value']
					,'saturday_delivery'        =>  $saturday
					,'number_boxes'             =>  $i.' of '.$boxes
					,'total_charge'             =>  (float)$row['total_charge']/$boxes
					,'length'                   => $data['length']
					,'width'                    => $data['width']
					,'height'                   => $data['height']
					,'dimensional_weight'       => round($calcWeight)
					,'service_type_id'			=> "(SELECT id FROM ups_service_types WHERE service_code = '{$data['service']}' LIMIT 1)"
				);

				$ship_data['package_type_id'] = $data['package'];

				$this->db_insert('ups_shipments', $ship_data);
				$trackingNumber = $row['tracking'];
				try {
					$sql = "INSERT IGNORE INTO `ecomm_open_order_tracking_numbers`(`open_order_id`, `tracking_number`) VALUES ((SELECT `id` FROM `ecomm_open_orders` WHERE `order_id`='$orderNumber'),'$trackingNumber');";
					$this->db_query($sql, 'insert');
				} catch (Exception $e) {
					echo $e->getMessage();
				}
			}else{
				if ($verboseLogging) {
					echo "\nUPS ship error.\n";
				}

				//return error
				$errorMsg .= serialize($row);
				if ($verboseLogging) {
					print_r($row);
					echo "Error message: $errorMsg\n";
				}

				$this->db_insert('ups_errors', array('request_data' => serialize($data), 'error_text' => serialize($row)), false);

			}

			$i++;

		}
		if ($channel && $orderNumber && count($trackingNumbers) > 0) {
			$adminObj->insertPendingOrderData($channel, $orderNumber, $trackingNumbers);
		}

		$_SESSION['large_printer_id'] = $temp_large_printer;

		if (!$errorMsg) {
			$return = "1";
		} else {
			$errorMsgLength = (int)substr($errorMsg, 2, strpos($errorMsg, ':', 2) - 2);
			$trimmedErrorMsg = substr($errorMsg, strpos($errorMsg, '"') + 1, $errorMsgLength);
			// $sql = "UPDATE `ecomm_open_orders` SET `error` = '$errorMsg' WHERE `order_id` = '$orderId';";
			// $this->db_query($sql, 'update');
			$return = $errorMsg;
			if ($verboseLogging) {
				echo "Error Message Length: $errorMsgLength\n";
				echo "Trimmed Error Message: $trimmedErrorMsg\n";
			}
		}
		if ($verboseLogging) {
			echo "Return: $return\n";
			echo "</pre>\n";
		}


		return $return;
	}

	private function getBoxData($listingId, $channel) {
		$sql = "SELECT sb.* FROM machine_order_number AS mon LEFT JOIN machine_ecomm_ids AS mei ON mon.order_number_id = mei.order_number_id LEFT JOIN machine_order_shipping_boxes AS mosb ON mon.order_number_id = mosb.machine_order_id LEFT JOIN shipping_boxes AS sb ON sb.id = mosb.shipping_box_id WHERE mei.listing_id = '$listingId' AND mei.channel_identifier = '$channel';";
		$data = $this->db_query($sql, 'select-single');
		return $data;
	}

	private function getCalcWeight($length, $width, $height) {
		$upsWeightDiv = 139;
		return ($length * $width * $height)/$upsWeightDiv;
	}

	function getAddresses($str) {
		$pattern = '/^[A-Za-z0-9 \.\-\/\']+$/';
		if (!preg_match($pattern, $str)) {
			echo 'bad entry';
			exit;
		}
		$str = mysql_real_escape_string($str);
		$query =
			"SELECT DISTINCT
				REPLACE(LTRIM(RTRIM(REPLACE(ship_to, CHAR(9), '    '))),'    ', CHAR(9)) AS shipto
				-- ,attention
				-- ,address1
				-- ,address2
				-- ,address3
				-- ,city
				-- ,state
				-- ,zip
				-- ,phone
				-- ,email
			FROM
				ups_shipments
			WHERE
				ship_to LIKE '%$str%'
			ORDER BY
				shipto;";

		// echo ($query);
		$data = $this->db_query($query, 'select-multiple', true);
		$data = array_slice($data, 0, 100);
		$json = $this->safe_json_encode($data);
		if ($json) {
			echo $json;
		}
		else {
			echo json_last_error();
		}
	}

	function getAddressVariants($str) {
		$pattern = '/^[A-Za-z0-9 \.\-\/\']+$/';
		if (!preg_match($pattern, $str)) {
			echo 'bad entry';
			exit;
		}
		$str = mysql_real_escape_string($str);
		$query =
			"SELECT DISTINCT
				REPLACE(LTRIM(RTRIM(REPLACE(ship_to, CHAR(9), '    '))),'    ', CHAR(9)) AS shipto
				-- ,`attention`
				,`address1`
				,`address2`
				,`address3`
				,`city`
				,`state`
				,`zip`
				-- ,`phone`
				-- ,`email`
			FROM
				ups_shipments
			WHERE
				ship_to = '$str'
			ORDER BY
				shipto;";

		// echo ($query);
		$data = $this->db_query($query, 'select-multiple', true);
		$data = array_slice($data, 0, 100);
		$json = $this->safe_json_encode($data);
		if ($json) {
			echo $json;
		}
		else {
			echo json_last_error();
		}
	}

	private function getSelectedBoxId($listingId, $channel) {
		if ($channel == "back_market") {
			$channel = "backmarket";
		}
		elseif (substr($channel, 0, 4) === 'ebay') {
			$channel = "ebay";
		}
		$sql = "SELECT sb.id FROM machine_order_number AS mon LEFT JOIN machine_ecomm_ids AS mei ON mon.order_number_id = mei.order_number_id LEFT JOIN machine_order_shipping_boxes AS mosb ON mon.order_number_id = mosb.machine_order_id LEFT JOIN shipping_boxes AS sb ON sb.id = mosb.shipping_box_id WHERE mei.listing_id = '$listingId' AND mei.channel_identifier = '$channel';";
		// echo "<p>$sql</p>";
		$data = $this->db_query($sql, 'select-single');
		return $data['id'];
	}

	private function getSelectedDeviceWeight($listingId, $channel) {
		if ($channel == "back_market") {
			$channel = "backmarket";
		}
		elseif (substr($channel, 0, 4) === "ebay") {
			$channel = "ebay";
		}
		$sql = "SELECT mon.device_weight FROM machine_order_number AS mon LEFT JOIN machine_ecomm_ids AS mei ON mon.order_number_id = mei.order_number_id WHERE mei.listing_id = '$listingId' AND mei.channel_identifier = '$channel';";
		// echo "<p>$sql</p>";
		$data = $this->db_query($sql, 'select-single');
		return $data['device_weight'];
	}
}

?>
