<?php

class ShipLog extends Database {
	function shipLogPage($page) {
		$title = "Shipped Orders";
		$templateElements = array(
			'LOADING_MODAL' => LOADING_MODAL,
			'SCRIPTS' => 	'<script src="__CDN_JAVASCRIPT__javascript/column_definition/column_definition.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/shiplog/records/shipLogRecord.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/shiplog/ship_log.js" type="text/javascript"></script>' . IMPORT_JQUERY . IMPORT_JQUERY_UI,
			'IMPORTEXPORT' => 	'<div style="display: inline-block;">
									<label style="display: block;" for="mtsNumberImport">Import from Zoho</label>
									<input id="mtsNumberImport" type="text" placeholder="Enter MTS#" maxlength="8" onkeyup="processMtsImportInput(event, this)" />
									<button id="mtsImportSubmit" type="button" onclick="fetchMtsData()">Fetch</button>
								</div>
								<div style="display: inline-block">
									<button onclick="generateCsv()">Export Current Selection</button>
								</div>
								<div style="display: inline-block">
									<button onclick="toggleUpdateElementsVisible()">Toggle Update Column</button>
								</div>'
		);
		if ($page == 'ecomm') {
			$templateElements['SCRIPTS'] = '<script src="__CDN_JAVASCRIPT__javascript/column_definition/column_definition.js" type="text/javascript"></script>
											<script src="__CDN_JAVASCRIPT__javascript/shiplog/ecommerce/records/ecommerce_ship_log_record.js" type="text/javascript"></script>
											<script src="__CDN_JAVASCRIPT__javascript/shiplog/ecommerce/records/ReturnedOrder.js" type="text/javascript"></script>
											<script src="__CDN_JAVASCRIPT__javascript/shiplog/ecommerce/records/EbayShippedOrder.js" type="text/javascript"></script>
											<script src="__CDN_JAVASCRIPT__javascript/shiplog/ecommerce/records/NeweggShippedOrder.js" type="text/javascript"></script>
											<script src="__CDN_JAVASCRIPT__javascript/shiplog/ecommerce/records/BackMarketShippedOrder.js" type="text/javascript"></script>
											<script src="__CDN_JAVASCRIPT__javascript/shiplog/ecommerce/records/AmazonShippedOrder.js" type="text/javascript"></script>
											<script src="__CDN_JAVASCRIPT__javascript/shiplog/ecommerce/ecommerce_ship_log.js" type="text/javascript"></script>'  . IMPORT_JQUERY . IMPORT_JQUERY_UI;
			$templateElements['IMPORTEXPORT'] =	'<div style="display: inline-block">
													<button onclick="generateCsv()">Export Current Selection</button>
												</div>';
			$title = "Ecommerce Shipped Orders";
		}
		echo $this->parse(TEMPLATE, array('BODY' => $this->parse(SHIP_LOG_PAGE, $templateElements), "TITLE" => $title));
	}


	function getTtsShipLog($salespersons=array(), $startDate='', $endDate='') {
		// 2785157225bc65ce47da9f36f83d1be8 - m.kemper
		$adminString = $_SESSION['xdigiSHOPadmin'];
		$showSales = true;
		// Amber
		if ($adminString == '644dd752df0aaebd0bcc893f6d7a49ba') {
			$salespersons = array('835703000000061001');
			$showSales = false;
		}
		// Kym
		// elseif ($adminString == '7822815c2cee70c449686d84082e277b') {
		// 	$salespersons = array('835703000007379001');
		// 	$showSales = false;
		// }
		// Bonny
		elseif ($adminString == 'b893d841e5bf852c76f9ae30b2d7be63') {
			$salespersons = array('835703000010136075');
			$showSales = false;
		}
		$idSearchClause = "os.zoho_id IN (";
		$nameSearchClause = "os.`name` IN (";
		$i = 0;
		$j = 0;
		foreach ($salespersons as $salesperson) {
			$idPattern = "/(\d{18})/";
			if (preg_match($idPattern, $salesperson)) {
				if ($i) {
					$idSearchClause .= ', ';
				}
				$idSearchClause .= "'$salesperson'";
				$i++;
			} else {
				if ($j) {
					$nameSearchClause .= ', ';
				}
				$nameSearchClause .= "'$salesperson'";
				$j++;
			}
		}
		$idSearchClause .= ") ";
		$nameSearchClause .= ") ";

		$salesSearchClause = "";
		if ($i) {
			$salesSearchClause .= $idSearchClause;
			if ($j) {
				$salesSearchClause .= "OR ";
			}
		}
		if ($j) {
			$salesSearchClause .= $nameSearchClause;
		}
		if ($i && $j) {
			$salesSearchClause = "($salesSearchClause)";
		}

		$whereClause = "";
		if ($i || $j || ($startDate && $startDate != '') || ($endDate && $endDate != '')) {
			$whereClause = "WHERE ";
			$whereClause .= "$salesSearchClause";
			if (($startDate && $startDate != '') || ($endDate && $endDate != '')) {
				if ($i || $j) {
					$whereClause .= " AND ";
				}
				$whereClause .= "osd.ship_date ";
				if ($startDate && $startDate != '' && $endDate && $endDate != '') {
					$whereClause .= "BETWEEN '$startDate' AND '$endDate'";
				} else if ($startDate && $startDate != '') {
					$whereClause .= ">= '$startDate'";
				} else if ($endDate && $endDate != '') {
					$whereClause .= "<= '$endDate'";
				}
			}
		}
		$dataQuery =
			"SELECT
				osl.zoho_id AS order_id,
				osl.mts_number,
				oa.zoho_id AS account_id,
				oa.`name` AS account_name,
				os.zoho_id AS sales_id,
				os.`name` AS
				salesperson,
				osl.invoice_date,
				osd.ship_date,
				CONCAT(osd.tracking_number_1, ' ', osd.tracking_number_2, ' ', osd.tracking_number_3, ' ', osd.tracking_number_4, ' ', osd.tracking_number_5) AS tracking_numbers,
				osl.notes,
				osl.total,
				IFNULL(osl.deductions, 0) AS deductions,
				oli.zoho_id AS product_id,
				oli.`name` AS product_name,
				oli.`code` AS product_code,
				oli.`deducted_on_ship_log` AS deducted,
				osli.`description` AS product_description,
				osli.`total` AS product_total,
				osli.quantity,
				IFNULL(`states`.`abbreviation`, 'UK') AS stateAbbreviation,
				IFNULL(`states`.`name`, 'Unknown') AS stateName
			FROM
				order_ship_log AS osl
			LEFT JOIN
				order_accounts AS oa
				ON osl.account_id = oa.id
			LEFT JOIN
				order_salespersons AS os
				ON osl.salesperson_id = os.id
			LEFT JOIN
				order_shipped_line_items AS osli
				ON osli.ship_log_id = osl.id
			LEFT JOIN order_line_items AS oli
				ON osli.line_item_id = oli.id
			LEFT JOIN order_shipping_details AS osd
				ON osd.order_id = osl.id
			LEFT JOIN `states`
				ON osl.`state_id` = `states`.`id`
			$whereClause
			ORDER BY ship_date, mts_number DESC;";

		$data = array();
		$results = $this->db_query($dataQuery, 'select-multiple', true);

		$whereClause2 = "";
		if ($i || $j || ($startDate && $startDate != '') || ($endDate && $endDate != '')) {
			$whereClause2 = "WHERE ";
			$whereClause2 .= "$salesSearchClause";
			if ($i || $j) {
				$whereClause2 .= " AND ";
			}
			$whereClause2 .= "osl.invoice_date > '2019-07-01' AND osd.ship_date = '0000-00-00'";
		}
		$dataQuery2 =
			"SELECT
				osl.zoho_id AS order_id,
				osl.mts_number,
				oa.zoho_id AS account_id,
				oa.`name` AS account_name,
				os.zoho_id AS sales_id,
				os.`name` AS
				salesperson,
				osl.invoice_date,
				osd.ship_date,
				CONCAT(osd.tracking_number_1, ' ', osd.tracking_number_2, ' ', osd.tracking_number_3, ' ', osd.tracking_number_4, ' ', osd.tracking_number_5) AS tracking_numbers,
				osl.notes,
				osl.total,
				IFNULL(osl.deductions, 0) AS deductions,
				oli.zoho_id AS product_id,
				oli.`name` AS product_name,
				oli.`code` AS product_code,
				osli.`description` AS product_description,
				osli.`total` AS product_total,
				osli.quantity,
				IFNULL(`states`.`abbreviation`, 'UK') AS stateAbbreviation,
				IFNULL(`states`.`name`, 'Unknown') AS stateName
			FROM
				order_ship_log AS osl
			LEFT JOIN
				order_accounts AS oa
				ON osl.account_id = oa.id
			LEFT JOIN
				order_salespersons AS os
				ON osl.salesperson_id = os.id
			LEFT JOIN
				order_shipped_line_items AS osli
				ON osli.ship_log_id = osl.id
			LEFT JOIN order_line_items AS oli
				ON osli.line_item_id = oli.id
			LEFT JOIN order_shipping_details AS osd
				ON osd.order_id = osl.id
			LEFT JOIN `states`
				ON osl.`state_id` = `states`.`id`
			WHERE osl.invoice_date >= '2019-07-01' AND osd.ship_date = '0000-00-00' OR osd.ship_date IS NULL
			ORDER BY invoice_date DESC
			LIMIT 50;";

		$unknownShipDate = $this->db_query($dataQuery2, 'select-multiple');
		$data['query'] = $dataQuery;
		$data['results'] = $results;
		$data['unknownShipDate'] = $unknownShipDate;
		$data['showSales'] = $showSales;

		return json_encode($data);
	}

	function getEcommShipLog($startDate='', $endDate='', $debug=false) {
		$data = array(
			'queries' => array(),
			'ecommIds' => array()
		);

		// Generate date clause
		if ($debug) {
			echo "<p>In Get Ecomm Shiplog</p>";
		}
		$backmarketResults = $this->getBackMarketShippedOrders($startDate, $endDate, $debug, $data);
		//print_r($backmarketResults);
		if ($debug) {
			echo "<pre>";;
			print_r($backmarketResults);
			echo "</pre>";
		}
		$ebayAuctionResults = $this->getEbayShippedOrders($startDate, $endDate, 'ebay_auctions', $debug, $data);
		if ($debug) {
			echo "<h3>Ebay auction results:</h3>";
			echo "<pre>";
			print_r($ebayAuctionResults);
			echo "</pre>";
		}
		$ebayOthersResults = $this->getEbayShippedOrders($startDate, $endDate, 'ebay_others', $debug, $data);
		if ($debug) {
			echo "<h3>Ebay other results:</h3>";
			echo "<pre>";
			print_r($ebayOthersResults);
			echo "</pre>";
		}
		$ebayResults = array();
		if ($ebayAuctionResults && $ebayOthersResults) {
			$ebayResults = array_merge($ebayAuctionResults, $ebayOthersResults);
		}
		else if ($ebayAuctionResults) {
			$ebayResults = $ebayAuctionResults;
		}
		else if ($ebayOthersResults) {
			$ebayResults = $ebayOthersResults;
		}
		if ($debug) {
			echo "<h3>Ebay merged results:</h3>";
			echo "<pre>";
			print_r($ebayResults);
			echo "</pre>";
		}
		if ($backmarketResults && $ebayResults) {
			$results = array_merge($backmarketResults, $ebayResults);
		}
		else if ($backmarketResults) {
			$results = $backmarketResults;
		}
		else if ($ebayResults) {
			$results = $ebayResults;
		}
		else {
			$results = array();
		}
		$neweggResults = $this->getNeweggShippedOrders($startDate, $endDate, $debug, $data);
		if ($neweggResults) {
			$results = array_merge($results, $neweggResults);
		}
		if ($debug) {
			echo "<pre>";
			print_r($neweggResults);
			echo "</pre>";
		}
		if ($debug) {
			echo "<pre>";
			print_r($results);
			echo "</pre>";
		}
		$amazonResults = $this->getAmazonShippedOrders($startDate, $endDate, $debug, $data);
		if ($amazonResults) {
			$results = array_merge($results, $amazonResults);
		}
		if ($debug) {
			echo "<pre>";
			print_r($amazonResults);
			echo "</pre>";
		}
		if ($debug) {
			echo "<pre>";
			print_r($results);
			echo "</pre>";
		}
		$otherResults = $this->getOthersShippedOrders($startDate, $endDate, $debug, $data);
		if ($otherResults) {
			$results = array_merge($results, $otherResults);
		}
		
		/*$amazonSPResults = $this->getAmazonSPShippedOrders($startDate, $endDate, $debug, $data);
		if ($amazonSPResults) {
			$results = array_merge($results, $amazonSPResults);
		}
		if ($debug) {
			echo "<pre>";
			print_r($amazonSPResults);
			echo "</pre>";
		}
		if ($debug) {
			echo "<pre>";
			print_r($results);
			echo "</pre>";
		}*/
		
		$returns = $this->getReturnedOrders($startDate, $endDate);
		$data['returns'] = $returns;
		$data['results'] = $results;
		if ($debug) {
			echo "<p>Finished, returning:</p>";
			echo "<pre>";
			echo json_encode($data);
			echo "</pre>";
		}
		return json_encode($data);
	}

	private function getReturnedOrders($startDate='', $endDate='') {
		$whereClause = "";
		if (($startDate && $startDate != '') || ($endDate && $endDate != '')) {
			$whereClause = "WHERE ";
			if (($startDate && $startDate != '') || ($endDate && $endDate != '')) {
				$whereClause .= "erl.`return_date` ";
				if ($startDate && $startDate != '' && $endDate && $endDate != '') {
					$whereClause .= "BETWEEN '$startDate' AND '$endDate 23:59:59'";
				} else if ($startDate && $startDate != '') {
					$whereClause .= ">= '$startDate'";
				} else if ($endDate && $endDate != '') {
					$whereClause .= "<= '$endDate'";
				}
			}
		}
		$sql = "SELECT esl.`order_id`, erl.`return_date`, erl.`return_amount`, esc.`identifier` AS sales_channel_identifier, esc.`name` AS sales_channel_name FROM `ecomm_return_log` AS erl LEFT JOIN `ecomm_ship_log` AS esl ON erl.`ecomm_id` = esl.`id` LEFT JOIN ecomm_sales_channels AS esc ON esl.channel_id = esc.id $whereClause;"; // erl.`ecomm_id` IN ('$idString');";
		$result = $this->db_query($sql, 'select-multiple', true);
		if ($result) {
			return $result;
		}
		else {
			return array();
		}
	}

	private function getBackMarketShippedOrders($startDate='', $endDate='', $debug=false, &$resultsArray) {
		$whereClause = $this->buildWhereClause($startDate, $endDate, 'back_market');
		$sql = "SELECT DISTINCT
					esl.id,
					esl.order_id,
					esl.channel_id,
					esl.subtotal,
					esl.notes,
					esd.ship_date,
					esd.ship_method,
					(SELECT GROUP_CONCAT(tracking_number)
					FROM ecomm_tracking_numbers etn
					WHERE etn.ecomm_id = esl.id) AS tracking_numbers,
					esc.`identifier` AS sales_channel_identifier,
					esc.`name` AS sales_channel_name,
					lt.sku,
					jt.`quantity`
				FROM ecomm_ship_log AS esl
				LEFT JOIN ecomm_shipping_details AS esd ON esd.ecomm_id = esl.id
				LEFT JOIN ecomm_tracking_numbers AS etn ON etn.ecomm_id = esl.id
				LEFT JOIN ecomm_sales_channels AS esc ON esl.channel_id = esc.id
				LEFT JOIN ecomm_back_market_listings_shipped AS jt ON jt.ecomm_id = esl.id
				LEFT JOIN ecomm_back_market_listings AS lt ON lt.id = jt.item_id
				$whereClause
				ORDER BY ship_date DESC;";
		if ($debug) {
			echo "<pre>$sql</pre>";
		}
		$resultsArray['queries']['backmarket'] = $sql;
		$backmarketResults = $this->db_query($sql, 'select-multiple', true);
		foreach ($backmarketResults as $result) {
			$ecommId = $result['id'];
			array_push($resultsArray['ecommIds'], $ecommId);
		}
		return $backmarketResults;
	}

	private function getEbayShippedOrders($startDate='', $endDate='', $channel='ebay_auctions', $debug=false, &$resultsArray) {
		$whereClause = $this->buildWhereClause($startDate, $endDate, $channel);
		$sql = "SELECT DISTINCT
					esl.id,
					esl.order_id,
					esl.channel_id,
					esl.subtotal,
					esl.notes,
					esd.ship_date,
					esd.ship_method,
					(SELECT GROUP_CONCAT(tracking_number)
					FROM ecomm_tracking_numbers etn
					WHERE etn.ecomm_id = esl.id) AS tracking_numbers,
					esc.`identifier` AS sales_channel_identifier,
					esc.`name` AS sales_channel_name,
					eblt.sku,
					eblt.legacy_item_id,
					-- eblt.title,
					ebjt.`quantity`
				FROM ecomm_ship_log AS esl
				LEFT JOIN ecomm_shipping_details AS esd ON esd.ecomm_id = esl.id
				LEFT JOIN ecomm_tracking_numbers AS etn ON etn.ecomm_id = esl.id
				LEFT JOIN ecomm_sales_channels AS esc ON esl.channel_id = esc.id
				LEFT JOIN ecomm_ebay_listings_shipped AS ebjt ON ebjt.ecomm_id = esl.id
				LEFT JOIN ecomm_ebay_listings AS eblt ON eblt.id = ebjt.item_id
				$whereClause
				ORDER BY ship_date DESC;";
		if ($debug) {
			echo "<pre>$sql</pre>";
		}
		$resultsArray['queries'][$channel] = $sql;
		$ebayResults = $this->db_query($sql, 'select-multiple', true);
		return $ebayResults;
	}

	private function getNeweggShippedOrders($startDate='', $endDate='', $debug=false, &$resultsArray) {
		$whereClause = $this->buildWhereClause($startDate, $endDate, 'newegg');
		$sql = "SELECT DISTINCT
					esl.id,
					esl.order_id,
					esl.channel_id,
					esl.subtotal,
					esl.notes,
					esd.ship_date,
					esd.ship_method,
					(SELECT GROUP_CONCAT(tracking_number)
					FROM ecomm_tracking_numbers etn
					WHERE etn.ecomm_id = esl.id) AS tracking_numbers,
					esc.`identifier` AS sales_channel_identifier,
					esc.`name` AS sales_channel_name,
					nlt.sku,
					nlt.newegg_item_number,
					-- nlt.title,
					njt.`quantity`
				FROM ecomm_ship_log AS esl
				LEFT JOIN ecomm_shipping_details AS esd ON esd.ecomm_id = esl.id
				LEFT JOIN ecomm_tracking_numbers AS etn ON etn.ecomm_id = esl.id
				LEFT JOIN ecomm_sales_channels AS esc ON esl.channel_id = esc.id
				LEFT JOIN ecomm_newegg_listings_shipped AS njt ON njt.ecomm_id = esl.id
				LEFT JOIN ecomm_newegg_listings AS nlt ON nlt.id = njt.item_id
				$whereClause
				ORDER BY ship_date DESC;";
		if ($debug) {
			echo "<pre>$sql</pre>";
		}
		$resultsArray['queries']['newegg'] = $sql;
		$results = $this->db_query($sql, 'select-multiple', true);
		return $results;
	}

	private function getOthersShippedOrders($startDate = '', $endDate='', $debug=false, &$resultsArray) {
		$whereClause = $this->buildWhereClause($startDate, $endDate);
		$sql = "SELECT DISTINCT
					esl.id,
					esl.order_id,
					esl.channel_id,
					esl.subtotal,
					esl.notes,
					esd.ship_date,
					esd.ship_method,
					(SELECT GROUP_CONCAT(tracking_number)
					FROM ecomm_tracking_numbers etn
					WHERE etn.ecomm_id = esl.id) AS tracking_numbers,
					esc.`identifier` AS sales_channel_identifier,
					esc.`name` AS sales_channel_name
				FROM ecomm_ship_log AS esl
				LEFT JOIN ecomm_shipping_details AS esd ON esd.ecomm_id = esl.id
				LEFT JOIN ecomm_tracking_numbers AS etn ON etn.ecomm_id = esl.id
				LEFT JOIN ecomm_sales_channels AS esc ON esl.channel_id = esc.id
				$whereClause
				AND esc.identifier IN ('chanx', 'facebook', 'weeklycloseouts')
				ORDER BY ship_date DESC;";
		$resultsArray['queries']['others'] = $sql;
		$results = $this->db_query($sql, 'select-multiple', true);
		$resultsArray['debug']['others'] = $results;
		if ($debug) {
			print_r($results);
		}
		return $results;
	}

	private function getAmazonShippedOrders($startDate='', $endDate='', $debug=false, &$resultsArray) {
		$whereClause = $this->buildWhereClause($startDate, $endDate, 'amazon');
		$sql = "SELECT DISTINCT
					esl.id,
					esl.order_id,
					esl.channel_id,
					esl.subtotal,
					esl.notes,
					esd.ship_date,
					esd.ship_method,
					(SELECT GROUP_CONCAT(tracking_number)
					FROM ecomm_tracking_numbers etn
					WHERE etn.ecomm_id = esl.id) AS tracking_numbers,
					esc.`identifier` AS sales_channel_identifier,
					esc.`name` AS sales_channel_name,
					lt.sku,
					lt.order_item_id,
					-- lt.title,
					jt.`quantity`
				FROM ecomm_ship_log AS esl
				LEFT JOIN ecomm_shipping_details AS esd ON esd.ecomm_id = esl.id
				LEFT JOIN ecomm_tracking_numbers AS etn ON etn.ecomm_id = esl.id
				LEFT JOIN ecomm_sales_channels AS esc ON esl.channel_id = esc.id
				LEFT JOIN ecomm_amazon_listings_shipped AS jt ON jt.ecomm_id = esl.id
				LEFT JOIN ecomm_amazon_listings AS lt ON lt.id = jt.item_id
				$whereClause
				ORDER BY ship_date DESC;";
		if ($debug) {
			echo "<pre>$sql</pre>";
		}
		$resultsArray['queries']['amazon'] = $sql;
		$results = $this->db_query($sql, 'select-multiple', true);
		return $results;
	}
	
	private function getAmazonSPShippedOrders($startDate='', $endDate='', $debug=false, &$resultsArray) {
		require_once(HTML_FOLDER . 'apis/amazon/class_amazon_api.php');
		$version = "v2";
		$sandbox = false;
		$debug = false;
		$amazonApi = new AmazonAPI($version, $sandbox, $debug);	
		$test_result = $amazonApi->ShippedOrderRequestSigner();
		$results = json_decode($test_result, true);
		$resultsArray['queries']['amazon'] = $results;
		return $results;
	}

	private function buildWhereClause($startDate='', $endDate='', $channel='') {
		$whereClause = "";
		if (($startDate && $startDate != '') || ($endDate && $endDate != '') || $channel != '') {
			$whereClause = "WHERE ";
			if (($startDate && $startDate != '') || ($endDate && $endDate != '')) {
				$whereClause .= "esd.ship_date ";
				if ($startDate && $startDate != '' && $endDate && $endDate != '') {
					$whereClause .= "BETWEEN '$startDate' AND '$endDate 23:59:59'";
				} else if ($startDate && $startDate != '') {
					$whereClause .= ">= '$startDate'";
				} else if ($endDate && $endDate != '') {
					$whereClause .= "<= '$endDate'";
				}
			}
			if ($channel) {
				if (($startDate && $startDate != '') || ($endDate && $endDate != '')) {
					$whereClause .= " AND ";
				}
				$whereClause .= " esl.channel_id = (SELECT id FROM ecomm_sales_channels WHERE identifier='$channel' LIMIT 1)";
			}
		}
		return $whereClause;
	}

	function populateShipLog($startPage=1, $numPages=10) {
		global $zohoObj;

		$data = $zohoObj->getAllShippedInvoices($startPage, $numPages);

		// echo "<pre>";
		// print_r($data);
		// echo "</pre>";
		// exit;
		// echo print_r($data['accounts']);

		$nextStartPage = $startPage + $numPages;
		if ($startPage == 0) {
			echo "<a href='".CONTROLLER."?m=populate_ship_log&startPage=1&numPages=$numPages' target='_blank'>Next Pages</a>";
		}
		else {
			echo "<a href='".CONTROLLER."?m=populate_ship_log&startPage=$nextStartPage&numPages=$numPages' target='_blank'>Next Pages</a>";
		}
		$orderCount = count($data['invoices']);
		$accountCount = count($data['accounts']);
		$salespersonCount = count($data['salespersons']);
		$lineItemCount = count($data['lineItems']);
		echo "<h1>$orderCount total orders</h1>";
		echo "<h2>$accountCount total accounts</h2>";
		echo "<h2>$salespersonCount total salespersons</h2>";
		echo "<h2>$lineItemCount total lineitems</h2>";
		$accountInsertQuery = "INSERT IGNORE INTO order_accounts(`name`, `zoho_id`) VALUES ";
		$i = 0;
		// $this->resetAutoIncrement('order_accounts');
		foreach ($data['accounts'] as $account) {
			$escapedAccountName = mysql_escape_string($account['Account_Name']);
			$accountInsertQuery = "INSERT IGNORE INTO order_accounts(`name`, `zoho_id`) VALUES ('$escapedAccountName', '{$account['Account_Id']}');";
			echo "<p>$accountInsertQuery</p>";

			$this->db_query($accountInsertQuery, 'insert', true);
			$this->resetAutoIncrement('order_accounts');
			// if ($i) {
			// 	$accountInsertQuery .= ', ';
			// }
			// $escapedAccountName = mysql_escape_string($account['Account_Name']);
			// $accountInsertQuery .= "('$escapedAccountName', '{$account['Account_Id']}')";
			// $i++;
		}
		// $accountInsertQuery .= ';';
		// echo "<p>$accountInsertQuery</p>";

		// $this->db_query($accountInsertQuery, 'insert', true);

		$i = 0;
		$salespersonInsertQuery = "INSERT IGNORE INTO order_salespersons(`name`, `zoho_id`) VALUES ";
		// $this->resetAutoIncrement('order_salespersons');
		foreach ($data['salespersons'] as $salesperson) {
			$escapedSalespersonName = mysql_escape_string($salesperson['Owner']);
			$salespersonInsertQuery = "INSERT IGNORE INTO order_salespersons(`name`, `zoho_id`) VALUES ('$escapedSalespersonName', '{$salesperson['Owner_Id']}');";
			echo "<p>$salespersonInsertQuery</p>";

			$this->db_query($salespersonInsertQuery, 'insert', true);
			$this->resetAutoIncrement('order_salespersons');
			// if ($i) {
			// 	$salespersonInsertQuery .= ', ';
			// }
			// $escapedSalespersonName = mysql_escape_string($salesperson['Owner']);
			// $salespersonInsertQuery .= "('$escapedSalespersonName', '{$salesperson['Owner_Id']}')";
			// $i++;
		}
		// $salespersonInsertQuery .= ';';
		// echo "<p>$salespersonInsertQuery</p>";

		// $this->db_query($salespersonInsertQuery, 'insert', true);


		$i = 0;
		$lineItemInsertQuery = "INSERT IGNORE INTO order_line_items(`name`, `zoho_id`) VALUES ";
		// $this->resetAutoIncrement('order_line_items');
		foreach ($data['lineItems'] as $lineItem) {
			$escapedLineItemName = mysql_escape_string($lineItem['name']);
			$escapedLineItemCode = mysql_escape_string($lineItem['code']);
			$lineItemInsertQuery = "INSERT IGNORE INTO order_line_items(`name`, `zoho_id`, `code`) VALUES ('$escapedLineItemName', '{$lineItem['id']}', '$escapedLineItemCode') ON DUPLICATE KEY UPDATE `name`='$escapedLineItemName', `code`='$escapedLineItemCode';";
			echo "<p>$lineItemInsertQuery</p>";

			$this->db_query($lineItemInsertQuery, 'insert', true);
			$this->resetAutoIncrement('order_line_items');
			// if ($i) {
			// 	$lineItemInsertQuery .= ', ';
			// }
			// $escapedLineItemName = mysql_escape_string($lineItem['name']);
			// $lineItemInsertQuery .= "('$escapedLineItemName', '{$lineItem['id']}')";
			// $i++;
		}
		// $lineItemInsertQuery .= ';';
		// echo "<p>$lineItemInsertQuery</p>";

		// $this->db_query($lineItemInsertQuery, 'insert', true);

		$j = 0;
		$joinTableInsertQuery = "INSERT IGNORE INTO order_shipped_line_items(`ship_log_id`, `line_item_id`, `quantity`) VALUES ";
		$i = 0;
		$this->resetAutoIncrement('order_ship_log');
		foreach ($data['invoices'] as $invoice) {
			$zohoId = $invoice['Invoice_Id'];
			$accountId = $invoice['Account_Id'];
			$salespersonId = $invoice['Owner_Id'];
			$mtsNumber = $invoice['MTS_Quote_Number'];
			$invoiceDate = $invoice['Created_Time'];
			$state = $invoice['State'];
			$total = $invoice['Total'];
			$deductions = $invoice['Deduction'];
			$shipLogInsertQuery = "INSERT INTO order_ship_log (`zoho_id`, `account_id`, `salesperson_id`, mts_number, invoice_date, total, deductions, notes, `state_id`) VALUES ('$zohoId', (SELECT id FROM order_accounts WHERE zoho_id = '$accountId'), (SELECT id FROM order_salespersons WHERE zoho_id = '$salespersonId'), '$mtsNumber', '$invoiceDate', '$total', '$deductions', (SELECT open_orders.notes FROM open_orders WHERE open_orders.zoho_id='$zohoId'), (SELECT `id` FROM `states` WHERE `abbreviation`='$state' LIMIT 1)) ON DUPLICATE KEY UPDATE `state_id`=(SELECT `id` FROM `states` WHERE `abbreviation`='$state' LIMIT 1), `total`='$total', `deductions`='$deductions';";
			echo "<p>$shipLogInsertQuery</p>";
			$this->db_query($shipLogInsertQuery, 'insert', true);
			// $this->insertOrderState($state, $zohoId);
			$this->resetAutoIncrement('order_ship_log');
			foreach($invoice['Products'] as $product) {
				$productId = $product['id'];
				$quantity = $product['quantity'];
				$description = mysql_real_escape_string($product['description']);
				$total = $product['total'];

				$joinTableInsertQuery = "INSERT IGNORE INTO order_shipped_line_items(`ship_log_id`, `line_item_id`, `description`, `quantity`, `total`) VALUES ((SELECT id FROM order_ship_log WHERE zoho_id = '$zohoId'), (SELECT id FROM order_line_items WHERE zoho_id = '$productId'), '$description', '$quantity', '$total') ON DUPLICATE KEY UPDATE `description`='$description', `quantity`='$quantity', `total`='$total'";
				echo "<p>$joinTableInsertQuery</p>";
				$this->db_query($joinTableInsertQuery, 'insert', true);
				// if ($j) {
				// 	$joinTableInsertQuery .= ', ';
				// }
				// $joinTableInsertQuery .= "((SELECT id FROM order_ship_log WHERE zoho_id = '{$invoice['Invoice_Id']}'), (SELECT id FROM order_line_items WHERE zoho_id = '{$product['id']}'), {$product['quantity']})";
				// $j++;
			}
			// if ($i) {
			// 	$shipLogInsertQuery .= ', ';
			// }
			// $shipLogInsertQuery .= "('{$invoice['Invoice_Id']}', (SELECT id FROM order_accounts WHERE zoho_id = '{$invoice['Account_Id']}'), (SELECT id FROM order_salespersons WHERE zoho_id = '{$invoice['Owner_Id']}'), '{$invoice['MTS_Quote_Number']}', '{$invoice['Created_Time']}', {$invoice['Sub_Total']}, (SELECT open_orders.notes FROM open_orders WHERE open_orders.zoho_id='{$invoice['Invoice_Id']}'))";
			// $i++;
		}
		// $shipLogInsertQuery .= ';';
		// $joinTableInsertQuery .= ';';

		$i = 0;
		foreach ($data['shipping'] as $shippingDetail) {
			// if (!$shippingDetail['Ship_Date']) {
			// 	$shippingDetail['Ship_Date'] = substr($shippingDetail['Created_Time'], 0, 10);
			// }
			$shippingDetailsInsertQuery = "INSERT INTO order_shipping_details(`order_id`, `ship_date`, `ship_method`, `tracking_number_1`, `tracking_number_2`, `tracking_number_3`, `tracking_number_4`, `tracking_number_5`) VALUES ((SELECT id FROM order_ship_log WHERE zoho_id = '{$shippingDetail['Invoice_Id']}'), '{$shippingDetail['Ship_Date']}', '{$shippingDetail['Ship_Method']}', '{$shippingDetail['Tracking_Number_1']}', '{$shippingDetail['Tracking_Number_2']}', '{$shippingDetail['Tracking_Number_3']}', '{$shippingDetail['Tracking_Number_4']}', '{$shippingDetail['Tracking_Number_5']}') ON DUPLICATE KEY UPDATE `ship_date`='{$shippingDetail['Ship_Date']}';";
			echo "<p>$shippingDetailsInsertQuery</p>";
			$this->db_query($shippingDetailsInsertQuery, 'insert', true);
			// if ($i) {
			// 	$shippingDetailsInsertQuery .= ", ";
			// }
			// $shippingDetailsInsertQuery .= "((SELECT id FROM order_ship_log WHERE zoho_id = '{$shippingDetail['Invoice_Id']}'), '{$shippingDetail['Ship_Date']}', '{$shippingDetail['Ship_Method']}', '{$shippingDetail['Tracking_Number_1']}', '{$shippingDetail['Tracking_Number_2']}', '{$shippingDetail['Tracking_Number_3']}', '{$shippingDetail['Tracking_Number_4']}', '{$shippingDetail['Tracking_Number_5']}')";
			// $i++;
		}
		// $shippingDetailsInsertQuery .= ';';
		// echo "<p>$shippingDetailsInsertQuery</p>";
		// $this->db_query($shippingDetailsInsertQuery, 'insert', true);

		$dataQuery = "SELECT osl.zoho_id AS order_id, osl.mts_number, oa.zoho_id AS account_id, oa.`name` AS account_name, os.zoho_id AS sales_id, os.`name` AS salesperson, osd.ship_date, osl.notes, osl.total, oli.zoho_id AS product_id, oli.`name` AS product_name, osli.quantity FROM order_ship_log AS osl LEFT JOIN order_accounts AS oa ON osl.account_id = oa.id LEFT JOIN order_salespersons AS os ON osl.salesperson_id = os.id LEFT JOIN order_shipped_line_items AS osli ON osli.ship_log_id = osl.id LEFT JOIN order_line_items AS oli ON osli.line_item_id = oli.id LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id ORDER BY ship_date DESC;";

		echo "<h1>Done!</h1>";



		// echo print_r($data);


		// echo "<p>$accountInsertQuery</p>";
		// echo "<p>$salespersonInsertQuery</p>";
		// echo "<p>$lineItemInsertQuery</p>";
		// echo "<p>$shipLogInsertQuery</p>";
		// echo "<p>$joinTableInsertQuery</p>";
		// echo "<p>$shippingDetailsInsertQuery</p>";

		// $this->db_query($accountInsertQuery, 'insert', true);
		// $this->db_query($salespersonInsertQuery, 'insert', true);
		// $this->db_query($lineItemInsertQuery, 'insert', true);
		// $this->db_query($shipLogInsertQuery, 'insert', true);
		// $this->db_query($joinTableInsertQuery, 'insert', true);
		// $this->db_query($shippingDetailsInsertQuery, 'insert', true);

		// $data = $this->db_query($dataQuery, 'select-multiple', true);

		// echo json_encode($data);
	}

	function populateEbayShipLog() {
		global $ebayApiObj;

		$results = $ebayApiObj->getOrders(1000);
		$orders = json_decode($results);
	}

	public function getNewZohoInfo($mtsNumber) {
		global $zohoObj;
		return $this->getUpdatedZohoInfo($zohoObj->getRecordIdByMtsNumber($mtsNumber));
	}

	public function getUpdatedZohoInfo($zohoId) {
		global $zohoObj;
		$updatedRecord = $zohoObj->getShippedRecordData($zohoId);
		$debug = false;
		if ($_GET['debug'] == '1' || $_GET['debug'] == 'yes') {
			$debug = true;
			echo "<pre>";
			print_r($updatedRecord);
			echo "</pre>";
		}
		$sql = "DELETE FROM `order_shipped_line_items` WHERE `ship_log_id`=(SELECT `id` FROM `order_ship_log` WHERE `zoho_id`='$zohoId');";
		$this->db_query($sql, 'delete', true);
		$sql = "DELETE FROM `order_shipping_details` WHERE `order_id`=(SELECT `id` FROM `order_ship_log` WHERE `zoho_id`='$zohoId');";
		$this->db_query($sql, 'delete', true);

		$account = $updatedRecord['account'];
		$escapedAccountName = mysql_escape_string($account['Account_Name']);
		$accountInsertQuery = "INSERT INTO order_accounts(`name`, `zoho_id`) VALUES ('$escapedAccountName', '{$account['Account_Id']}') ON DUPLICATE KEY UPDATE `name`='$escapedAccountName';";
		$this->db_query($accountInsertQuery, 'insert', true);

		$salesperson = $updatedRecord['salesperson'];
		$escapedSalespersonName = mysql_escape_string($salesperson['Owner']);
		$salespersonInsertQuery = "INSERT INTO order_salespersons(`name`, `zoho_id`) VALUES ('$escapedSalespersonName', '{$salesperson['Owner_Id']}') ON DUPLICATE KEY UPDATE `name`='$escapedSalespersonName';";
		$this->db_query($salespersonInsertQuery, 'insert', true);

		foreach ($updatedRecord['lineItems'] as $lineItem) {
			$escapedLineItemName = mysql_escape_string($lineItem['name']);
			$escapedLineItemCode = mysql_escape_string($lineItem['code']);
			$lineItemInsertQuery = "INSERT IGNORE INTO order_line_items(`name`, `zoho_id`, `code`) VALUES ('$escapedLineItemName', '{$lineItem['id']}', '$escapedLineItemCode') ON DUPLICATE KEY UPDATE `name`='$escapedLineItemName', `code`='$escapedLineItemCode';";

			$this->db_query($lineItemInsertQuery, 'insert', true);
			$this->resetAutoIncrement('order_line_items');
		}


		$invoice = $updatedRecord['invoice'];
		$state = $invoice['State'];
		$status = $invoice['Status'];
		$zohoId = $invoice['Invoice_Id'];
		if ($status == 'Canceled') {
			$shipLogDeleteQuery = "DELETE FROM order_ship_log WHERE zoho_id = '$zohoId';";
			if ($debug) {
				echo "<pre>$shipLogDeleteQuery</pre>";
			}
			$this->db_query($shipLogDeleteQuery, 'delete', true);
		}
		elseif ($status == 'Shipped') {
			$shipLogInsertQuery =
				"INSERT INTO order_ship_log (`zoho_id`, `account_id`, `salesperson_id`, mts_number, invoice_date, total, deductions, notes, `state_id`)
				VALUES
					('{$invoice['Invoice_Id']}',
					(SELECT id FROM order_accounts WHERE zoho_id = '{$invoice['Account_Id']}'),
					(SELECT id FROM order_salespersons WHERE zoho_id = '{$invoice['Owner_Id']}'),
					'{$invoice['MTS_Quote_Number']}',
					'{$invoice['Created_Time']}',
					{$invoice['Total']},
					{$invoice['Deduction']},
					(SELECT open_orders.notes FROM open_orders WHERE open_orders.zoho_id='{$invoice['Invoice_Id']}'),
					(SELECT `id` FROM `states` WHERE `abbreviation`='$state' LIMIT 1))
				ON DUPLICATE KEY UPDATE
					`account_id`=(SELECT id FROM order_accounts WHERE zoho_id = '{$invoice['Account_Id']}'),
					`salesperson_id`=(SELECT id FROM order_salespersons WHERE zoho_id = '{$invoice['Owner_Id']}'),
					mts_number='{$invoice['MTS_Quote_Number']}',
					invoice_date='{$invoice['Created_Time']}',
					total='{$invoice['Total']}',
					deductions='{$invoice['Deduction']}';";
			if ($debug) {
				echo "<pre>$shipLogInsertQuery</pre>";
			}
			$this->db_query($shipLogInsertQuery, 'insert', true);

			// $state = $invoice['State'];
			// $this->insertOrderState($state, $zohoId);

			foreach($invoice['Products'] as $product) {
				$invoiceId = $invoice['Invoice_Id'];
				$productId = $product['id'];
				$productQuantity = $product['quantity'];
				$productDescription = mysql_real_escape_string($product['description']);
				$productTotal = $product['total'];

				$joinTableInsertQuery = "INSERT IGNORE INTO order_shipped_line_items(`ship_log_id`, `line_item_id`, `quantity`, `description`, `total`) VALUES ((SELECT id FROM order_ship_log WHERE zoho_id = '$invoiceId'), (SELECT id FROM order_line_items WHERE zoho_id = '$productId'), '$productQuantity', '$productDescription', '$productTotal') ON DUPLICATE KEY UPDATE `quantity`='$productQuantity', `description`='$productDescription', `total`='$productTotal';";
				$this->db_query($joinTableInsertQuery, 'insert', true);
			}

			$shipping = $updatedRecord['shipping'];
			$shippingInsertQuery = "INSERT IGNORE INTO order_shipping_details VALUES ((SELECT id FROM order_ship_log WHERE zoho_id = '{$shipping['Invoice_Id']}'), '{$shipping['Ship_Date']}', '{$shipping['Ship_Method']}', '{$shipping['Tracking_Number_1']}', '{$shipping['Tracking_Number_2']}', '{$shipping['Tracking_Number_3']}', '{$shipping['Tracking_Number_4']}', '{$shipping['Tracking_Number_5']}') ON DUPLICATE KEY UPDATE `ship_date`={$shipping['Ship_Date']};";

			$this->db_query($shippingInsertQuery, 'insert', true);
		}
		$this->resetAutoIncrement('order_accounts');
		$this->resetAutoIncrement('order_salespersons');
		$this->resetAutoIncrement('order_line_items');
		$this->resetAutoIncrement('order_ship_log');
		return true;
	}

	function getUpdatedZohoShipDate($zohoId) {
		global $zohoObj;
		$record = $zohoObj->getShippedRecordData($zohoId);
		$shipDate = $record['shipping']['Ship_Date'] ? $record['shipping']['Ship_Date'] : '0000-00-00';
		$shipMethod = $record['shipping']['Ship_Method'] ? $record['shipping']['Ship_Method'] : '';
		$trackingNo1 = $record['shipping']['Tracking_Number_1'] ? $record['shipping']['Tracking_Number_1'] : '';
		$trackingNo2 = $record['shipping']['Tracking_Number_2'] ? $record['shipping']['Tracking_Number_2'] : '';
		$trackingNo3 = $record['shipping']['Tracking_Number_3'] ? $record['shipping']['Tracking_Number_3'] : '';
		$trackingNo4 = $record['shipping']['Tracking_Number_4'] ? $record['shipping']['Tracking_Number_4'] : '';
		$trackingNo5 = $record['shipping']['Tracking_Number_5'] ? $record['shipping']['Tracking_Number_5'] : '';
		$sql = "UPDATE order_shipping_details SET ship_date = '$shipDate', ship_method = '$shipMethod', tracking_number_1 = '$trackingNo1', tracking_number_2 = '$trackingNo2', tracking_number_3 = '$trackingNo3', tracking_number_4 = '$trackingNo4', tracking_number_5 = '$trackingNo5' WHERE order_id = (SELECT id FROM order_ship_log AS osl WHERE osl.zoho_id = '$zohoId');";
		$updated = $this->db_query($sql, 'update', true);
		$data = array(
			'query' => $sql,
			'shipData' => $record['shipping'],
			'updated' => $updated
		);
		return json_encode($data);
	}

	function updateShipDate($zohoId, $shipDate) {
		$sql = "UPDATE `order_shipping_details` SET `ship_date` = '$shipDate' WHERE `order_id` = (SELECT `id` FROM `order_ship_log` WHERE `zoho_id` = '$zohoId');";
		return $this->db_query($sql, 'update', true);
	}

	private function insertOrderState($state, $zohoId='', $orderId='') {
		$this->deleteOrderState($zohoId, $orderId);
		if ($orderId && $orderId != '') {
			$insertQuery = "INSERT IGNORE INTO `orders_states`(`order_id`, `state_id`) VALUES ('$orderId', (SELECT `id` FROM `states` WHERE `name`='$state' OR `abbreviation`='$state' LIMIT 1));";
		}
		elseif ($zohoId && $zohoId != '') {
			$insertQuery = "INSERT IGNORE INTO `orders_states`(`order_id`, `state_id`) VALUES ((SELECT `id` FROM `order_ship_log` WHERE `zoho_id`='$zohoId' LIMIT 1), (SELECT `id` FROM `states` WHERE `name`='$state' OR `abbreviation`='$state' LIMIT 1));";
		}
		return $this->db_query($insertQuery, 'insert', true);
	}

	private function deleteOrderState($zohoId='', $orderId='') {
		if ($orderId && $orderId != '') {
			$deleteQuery = "DELETE FROM `orders_states` WHERE `order_id`='$orderId';";
		}
		elseif ($zohoId && $zohoId != '') {
			$deleteQuery = "DELETE FROM `orders_states` WHERE `order_id`=(SELECT `id` FROM `order_ship_log` WHERE `zoho_id`='$zohoId' LIMIT 1);";
		}
		return $this->db_query($deleteQuery, 'delete', true);
	}
}


?>
