<?php

$displayErrors = true;
// $displayErrors = false;
if ($displayErrors) {
	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ERROR);
}

class OpenOrders extends Database {
	function ttsOpenOrdersPage() {
		$templateElements = array(
			'LOADING_MODAL' => LOADING_MODAL
		);
		echo $this->parse(TEMPLATE, array('BODY' => $this->parse(OPEN_ORDERS_PAGE, $templateElements), "TITLE" => "Open Orders"));
	}

	function ecommerceOpenOrdersPage() {
		$templateElements = array(
			'LOADING_MODAL' => LOADING_MODAL
		);
		echo $this->parse(TEMPLATE, array('BODY' => $this->parse(ECOMMERCE_OPEN_ORDERS_PAGE, $templateElements), "TITLE" => "Ecommerce Open Orders"));
	}

	function getStatuses() {
		$query = "SELECT `id`, `status`, `display_order` FROM `open_order_statuses` ORDER BY `display_order` ASC;";
		$data = $this->db_query($query, 'select-multiple', true);
		return json_encode($data);
	}

	function updateOpenOrders() {
		global $zohoObj;
		$debug = false;
		if ($_GET['debug'] == 'yes' || $_GET['debug'] == '1') {
			$debug = true;
		}
		$records = $zohoObj->getSearchRecordsProducts();
		$lineItems = array();
		$openOrders = array();

		$returnRecords = array();
		foreach ($records as $record) {
			$accountData = array(
				'zohoId' => $record['Account_Id'],
				'name' => $record['Account_Name']
			);
			$account = new Account($accountData);
			$account->save();

			$account->populateDbId();
			$account->populateIsNewCustomer();

			$accountId = $account->getDbId();
			$isNewCustomer = $account->getIsNewCustomer() ? '1' : '0';

			$notes = '';
			if ($isNewCustomer == '1') {
				$notes = '***NEW CUSTOMER - VERIFY CUSTOMER/AP BEFORE SHIPMENT***';
			}

			$salespersonData = array(
				'zohoId' => $record['Owner_Id'],
				'name' => $record['Owner']
			);
			$salesperson = new Salesperson($salespersonData);
			$salesperson->save();

			$openOrderData = array(
				'apDataPresent' => $record['AP_Data_Present'],
				'zohoId' => $record['Invoice_Id'],
				'mtsNumber' => $record['MTS_Quote_Number'],
				'subject' => $record['Subject'],
				'account' => $account,
				'salesperson' => $salesperson,
				'invoiceDate' => $record['Created_Time'],
				'total' => $record['Total'],
				'notes' => $notes,
				'newCustomerOrder' => $isNewCustomer
			);

			$openOrder = new OpenOrder($openOrderData);
			$openOrder->setDebug($debug);


			$recordData = array(
				'AP_Data_Present' => $record['AP_Data_Present'],
				'Invoice_Id' => $record['Invoice_Id'],
				'MTS_Quote_Number' => $record['MTS_Quote_Number'],
				'Account_Id' => $record['Account_Id'],
				'Account_Name' => $record['Account_Name'],
				'Subject' => $record['Subject'],
				'Owner' => $record['Owner'],
				'Owner_Id' => $record['Owner_Id'],
				'Created_Time' => $record['Created_Time'],
				'Total' => $record['Total'],
				'Deduction' => $record['Deduction'],
				'Products' => array(),
			);

			foreach ($record['Products'] as $product) {
				$productData = array(
					'zohoId' => $product['id'],
					'code' => $product['code'],
					'name' => $product['name'],
					'quantity' => $product['quantity'],
					'total' => $product['total'],
					'deducted' => $this->getIsDeductedFromTtsOpenOrders($product['id']),
				);
				array_push($recordData['Products'], $productData);

				$openOrderLineItem = new OpenOrderLineItem($productData);
				$openOrder->addLineItem($openOrderLineItem);

				$lineItemData = array(
					'zohoId' => $product['id'],
					'name' => $product['name'],
					'code' => $product['code']
				);
				$lineItems[$zohoId] = new LineItem($lineItemData); // array('zohoId' => $zohoId, 'name' => $name, 'code' => $code);
			}
			$openOrder->save();
			if ($debug) {
				echo "<pre>";
				// print_r($openOrder);
				echo json_encode($openOrder, JSON_PRETTY_PRINT);
				echo "</pre>";
			}
			$total = (float)$record['Total'];
			$deduction = (float)$record['Deduction'];
			$subtotal = $total - $deduction;
			$zohoId = $record['Invoice_Id'];
			$mtsNumber = $record['MTS_Quote_Number'];
			$notes = mysql_real_escape_string($notes);
			$sql = "INSERT IGNORE INTO `open_orders`(`zoho_id`, `subtotal`, `account_id`, `new_customer_order`, `notes`) VALUES ('$zohoId', '$subtotal', '$accountId', '$isNewCustomer', '$notes') ON DUPLICATE KEY UPDATE `subtotal`='$subtotal';";
			// $this->db_query($sql, 'insert', true);
			array_push($returnRecords, $recordData);
		}
		foreach ($lineItems as $lineItem) {
			$lineItem->save();

			// $name = mysql_real_escape_string($lineItem['name']);
			// $code = mysql_real_escape_string($lineItem['code']);
			// $zohoId = mysql_real_escape_string($lineItem['zohoId']);
			// $sql = "INSERT INTO `order_line_items`(`name`, `zoho_id`, `code`) VALUES ('$name', '$zohoId', '$code') ON DUPLICATE KEY UPDATE `name`='$name', `code`='$code';";
			// $this->db_query($sql, 'insert', true);
		}
		foreach ($records as $record) {
			$recordZohoId = $record['Invoice_Id'];
			$sql = "DELETE FROM `open_order_line_items` WHERE `open_order_id`=(SELECT `id` FROM `open_orders` WHERE `zoho_id`='$recordZohoId' LIMIT 1);";
			// $this->db_query($sql, 'delete', true);
			foreach ($record['Products'] as $product) {
				$productZohoId = $product['id'];
				$quantity = $product['quantity'];
				$sql = "INSERT IGNORE INTO `open_order_line_items`(`line_item_id`, `open_order_id`, `quantity`) VALUES ((SELECT `id` FROM `order_line_items` WHERE `zoho_id`='$productZohoId'), (SELECT `id` FROM `open_orders` WHERE `zoho_id`='$recordZohoId'), '$quantity');";
				// $this->db_query($sql, 'insert', true);
			}
		}
		return $returnRecords;
	}

	function getIsDeductedFromTtsOpenOrders($zohoId) {
		$sql = "SELECT `deducted_on_open_orders` AS deducted FROM `order_line_items` WHERE `zoho_id`='$zohoId';";
		$result = $this->db_query($sql, 'select-single', true);
		$deducted = $result['deducted'] == '1' ? true : false;
		return $deducted;
	}

	function updateLocalRecordDataFromZoho($data) {
		$update = $data['update'];
		$orders = $data['orders'];
		$updateNew = $data['updateNew'];
		$records = json_decode($data['records'], true, 512);
		// print_r($data['records']);
		$newRecords = array();
		$lineItems = array();
		foreach ($records as $id => $record) {
			if ($record != '[]') {
				$products = json_decode($record, true);
				$newRecords[$id]['Products'] = $products;
				$newRecords[$id]['Invoice_Id'] = $id;
				foreach ($products as $product) {
					$lineItems[$product['id']] = $product;
				}
			}
		}
		// Add open orders
		// $query =
		// 	"INSERT IGNORE INTO
		// 		open_orders(`zoho_id`, `status_id`)
		// 	VALUES
		// 		$update
		// 	;";
		// $this->db_query($query, 'insert', true);
		// $this->addLineItems($lineItems); // Add line items to DB
		// $this->addOpenOrderLineItemsRelationships($newRecords); // Add line item-open order relationships

		// Reset table's auto-increment number. Prevents table auto-increment from spiraling out of control with every page refresh.
		$this->resetAutoIncrement('open_orders');

		// Get the data from the database after updates are made.
		$nextQuery = "SELECT `zoho_id`, `notes`, `status_id`, `asset_tags`, `new_customer_order` FROM `open_orders` WHERE `zoho_id` IN $orders;";
		$orders = $this->db_query($nextQuery, 'select-multiple', true);

		$updateArr = explode(',', $updateNew);
		$data = array(
			'orders' => $orders,
			'updateNew' => $updateArr,
			'records' => $records,
			// 'newRecords' => $newRecords,
			'lineItems' => $lineItems,
			// 'deleteQuery' => $this->deleteNoLongerOpenOrders($newRecords)
		);
		echo json_encode($data);
	}

	function saveSingle($data) {
		$query =
			"UPDATE `open_orders`
			SET `notes`='{$data['notes']}', `status_id`={$data['status_id']}, `asset_tags`='{$data['asset_tags']}'
			WHERE zoho_id='{$data['zoho_id']}'";
		echo $query;
		$numRows = $this->db_query($query, 'update', true);
		echo $numRows;
	}

	function saveMultiple($data) {
		$decoded = json_decode($data, true);
		$records = $decoded['records'];
		$notesClause = $this->buildNotesClause($records);
		$statusIdClause = $this->buildStatusIdClause($records);
		$assetTagsClause = $this->buildAssetTagsClause($records);
		$whereClause = "'".implode("','",array_keys($records))."'";
		$query =
			"UPDATE
				`open_orders`
			SET
				`notes`=$notesClause,
				`status_id`=$statusIdClause,
				`asset_tags`=$assetTagsClause
			WHERE `zoho_id` IN ($whereClause);
			";
		return $this->db_query($query, 'update', true);
	}

	function buildNotesClause($records, $idFieldName="zoho_id") {
		$notesClause = "(CASE ";
		foreach ($records as $record) {
			$notesClause .= "WHEN `$idFieldName`='{$record[$idFieldName]}' THEN '{$record['notes']}' ";
		}
		$notesClause .= "END)";
		return $notesClause;
	}

	function buildStatusIdClause($records) {
		$statusIdClause = "(CASE ";
		foreach($records as $record) {
			$statusIdClause .= "WHEN `zoho_id`='{$record['zoho_id']}' THEN {$record['status_id']} ";
		}
		$statusIdClause .= "END)";
		return $statusIdClause;
	}

	function buildAssetTagsClause($records) {
		$assetTagsClause = "(CASE ";
		foreach($records as $record) {
			$assetTagsClause .= "WHEN `zoho_id`='{$record['zoho_id']}' THEN {$record['asset_tags']} ";
		}
		$assetTagsClause .= "END)";
		return $assetTagsClause;
	}

	function addLineItems($lineItems) {
		$i = 0;
		$sql = "INSERT IGNORE INTO order_line_items(`name`, `zoho_id`) VALUES ";
		foreach ($lineItems as $lineItem) {
			if ($i) {
				$sql .= ', ';
			}
			$escapedLineItemName = mysql_escape_string($lineItem['name']);
			$sql .= "('$escapedLineItemName', '{$lineItem['id']}')";
			$i++;
		}
		$sql .= ';';
		$this->db_query($sql, 'insert', true);
		$this->resetAutoIncrement('order_line_items');
		return $sql;
	}

	function addOpenOrderLineItemsRelationships($records) {
		$sql = "INSERT IGNORE INTO open_order_line_items(`open_order_id`, `line_item_id`, `quantity`) VALUES ";
		$i = 0;
		foreach ($records as $record) {
			foreach($record['Products'] as $product) {
				if ($i) {
					$sql .= ', ';
				}
				$sql .= "((SELECT id FROM open_orders WHERE zoho_id = '{$record['Invoice_Id']}'), (SELECT id FROM order_line_items WHERE zoho_id = '{$product['id']}'), {$product['quantity']})";
				$i++;
			}
		}
		$sql .= ';';
		$this->db_query($sql, 'insert', true);
		return $sql;
	}

	function deleteNoLongerOpenOrders($records) {
		$sql = "DELETE FROM open_orders WHERE zoho_id NOT IN (";
		$i = 0;
		foreach ($records as $record) {
			if ($i) {
				$sql .= ', ';
			}
			$sql .= "'{$record['Invoice_Id']}'";
			$i++;
		}
		$sql .= ");";
		$this->db_query($sql, 'delete', true);
		return $sql;
	}


	// Ecomm open order functions below

	function getEcommOpenOrders($debug = false) {
		// global $backmarketObj;
		// $backmarketOrders = $backmarketObj->getOrders(3, 50); // Returns as JSON string.
		if ($debug) {
			echo "Getting ebay orders\n";
		}
		$ebayOrders = $this->getEbayOrders();
		if ($debug) {
			echo "Got ebay orders\nGetting newegg orders\n";
		}
		$neweggOrders = $this->getNeweggOrders($debug);
		if ($debug) {
			echo "Got newegg orders\nGetting backmarket orders\n";
		}
		$amazonOrders = $this->getAmazonOrders($debug);
		$amazonSPOrders = $this->getAmazonSPOrders($debug);
		$orders = array(
			'back_market' => $this->getBackMarketOrders(),
			'ebay_auction' => $ebayOrders['auction'],
			'ebay_other' => $ebayOrders['other'],
			'newegg' => $neweggOrders,
			'amazon' => $amazonOrders,
		);
		$this->resetAutoIncrement('ecomm_open_orders');
		if ($debug) {
			echo "Got all orders orders\nReturning json\n";
		}
		return json_encode($orders);
	}

	function getBackMarketOrders() {
		global $backmarketObj;
		$pendingPaymentOrders = json_decode($backmarketObj->getOrders(0, 50)); // Returns as JSON string.
		$pendingValidationOrders = json_decode($backmarketObj->getOrders(1, 50)); // Returns as JSON string.
		$readyToShipOrders = json_decode($backmarketObj->getOrders(3, 50)); // Returns as JSON string.
		$orderNums = array();
		foreach ($readyToShipOrders->results as $result) {
			array_push($orderNums, $result->order_id);
		}
		$orderNumsString = implode(', ', $orderNums);
		$returnArray = array(
			'order_type' => 'backmarket',
			'orders' => array()
		);
		$returnArray['orders'] = array();
		if ($orderNumsString && $orderNumsString != '') {
			$sql = "SELECT order_id, notes FROM ecomm_open_orders WHERE order_id IN ($orderNumsString) AND channel_id = (SELECT id FROM ecomm_sales_channels WHERE identifier='back_market' LIMIT 1) ORDER BY order_id ASC;";
			$ordersFromDb = $this->db_query($sql, 'select-multiple', true);
			$orderNotes = array();
			foreach ($ordersFromDb as $order) {
				if (array_search($order['order_id'], $orderNums) !== FALSE) {
					$idx = array_search($order['order_id'], $orderNums);
					unset($orderNums[$idx]);
				}
				$orderNotes[$order['order_id']] = $order['notes'];
			}
		}
		if (count($orderNums) > 0) {
			$orderNumsString = implode("', (SELECT id FROM ecomm_sales_channels WHERE identifier='back_market' LIMIT 1)), ('", $orderNums);
			$sql = "INSERT IGNORE INTO ecomm_open_orders(order_id, channel_id) VALUES ('$orderNumsString', (SELECT id FROM ecomm_sales_channels WHERE identifier='back_market' LIMIT 1));";
			$this->db_query($sql, 'insert', true);
			$returnArray['metadata']['insert-query'] = $sql;
		}
		foreach ($pendingPaymentOrders->results as $result) {
			if ($orderNotes[$result->order_id]) {
				$result->sp_notes = $orderNotes[$result->order_id];
			}
			$result->recipient_name = $result->shipping_address->first_name . " " . $result->shipping_address->last_name;
			$result->status_name = "Pending Payment Validation";
			array_push($returnArray['orders'], $result);
			$this->generatePackingSlip($result->order_id, 'backmarket', $debug);
		}
		foreach ($pendingValidationOrders->results as $result) {
			if ($orderNotes[$result->order_id]) {
				$result->sp_notes = $orderNotes[$result->order_id];
			}
			$result->recipient_name = $result->shipping_address->first_name . " " . $result->shipping_address->last_name;
			$result->status_name = "Pending Order Confirmation";
			array_push($returnArray['orders'], $result);
			$this->generatePackingSlip($result->order_id, 'backmarket', $debug);
		}
		foreach ($readyToShipOrders->results as $result) {
			$orderId = $result->order_id;
			if ($orderNotes[$result->order_id]) {
				$result->sp_notes = $orderNotes[$result->order_id];
			}
			$result->recipient_name = $result->shipping_address->first_name . " " . $result->shipping_address->last_name;
			$result->status_name = "Awaiting Shipment";
			// $sql = "SELECT `error`, `labels_printed` FROM `ecomm_open_orders` WHERE `order_id` = '$orderId' AND `channel_id` = (SELECT id FROM ecomm_sales_channels WHERE identifier='back_market' LIMIT 1);";
			// $errorData = $this->db_query($sql, 'select-single');
			$errorData = $this->getErrorData($orderId, 'back_market');
			$result->error_msg = $errorData['error'];
			$result->labels_printed = $errorData['labels_printed'];
			array_push($returnArray['orders'], $result);
			$this->generatePackingSlip($result->order_id, 'backmarket', $debug);
		}
		return $returnArray;
	}

	function getEbayOrders() {
		global $ebayApiObj;
		$orderData = $ebayApiObj->getUnfulfilledOrders(true);
		$auctionOrders = array();
		$otherOrders = array();
		$orders = $orderData->orders;
		foreach ($orders as $order) {
			$orderId = $order->orderId;
			$channel = $order->lineItems[0]->soldFormat == 'AUCTION' ? 'ebay_auctions' : 'ebay_others';
			$this->generatePackingSlip($order->orderId, 'ebay');
			$this->insertIntoEcommOpenOrders($orderId, $channel);
			$errorData = $this->getErrorData($orderId, $channel);
			$order->error_msg = $errorData['error'];
			$order->labels_printed = $errorData['labels_printed'];
			if ($order->lineItems[0]->soldFormat == 'AUCTION') {
				array_push($auctionOrders, $order);
			}
			else {
				array_push($otherOrders, $order);
			}
		}
		return array(
			"auction" => array(
				'order_type' => 'ebay',
				'orders' => $auctionOrders
			),
			"other" => array(
				'order_type' => 'ebay',
				'orders' => $otherOrders
			)
		);
	}

	function getNeweggOrders($debug=false) {
		if ($debug) {
			echo "\nIn get newegg orders:\n";
		}
		global $neweggApiObj;
		if ($debug) {
			echo "\tNewegg api obj global fetched\n";
		}

		$orderData = $neweggApiObj->getOrders();
		if ($debug) {
			echo "\tOrder data retrieved\n";
		}
		$decodedData = json_decode($orderData);
		if ($debug) {
			echo "\tOrder data decoded\n";
		}

		$returnArray = array(
			'order_type' => 'newegg',
			'orders' => array()
		);
		if ($debug) {
			echo "\tReturn array instantiated\n";
		}
		if ($decodedData->ResponseBody->PageInfo->TotalCount) {
			// $returnArray['orders'] = $decodedData->ResponseBody->OrderInfoList;
			foreach ($decodedData->ResponseBody->OrderInfoList as $order) {
				if ($debug) {
					echo "\tGenerating packing slip for $order->OrderNumber\n";
				}
				// echo $order->OrderNumber;
				$orderId = $order->OrderNumber;
				$this->generatePackingSlip($orderId, 'newegg', $debug);
				if ($debug) {
					echo "\tPacking slip generated for $order->OrderNumber\n";
				}
				$this->insertIntoEcommOpenOrders($orderId, 'newegg');
				$errorData = $this->getErrorData($orderId, $channel);
				// print_r($errorData);
				$order->error_msg = $errorData['error'];
				$order->labels_printed = $errorData['labels_printed'];
				// print_r($order);
				array_push($returnArray['orders'], $order);
			}
			if ($debug) {
				echo "\tReturn array orders added\n";
			}
		}
		else {
			$returnArray['orders'] = array();
			if ($debug) {
				echo "\tEmpty array sending\n";
			}
		}
		return $returnArray;
	}

	private function getAmazonOrders() {
		$returnArray = array(
			'orders' => array(),
			'order_type' => 'amazon',
			'metadata' => array()
		);
		$sql ="SELECT
				eoo.id AS `dbId`,
				eoo.order_id,
				eoo.error,
				eoo.labels_printed,
				eoo.shipping_label_generated,
				eoosd.*,
				eood.*
				FROM `ecomm_open_orders` AS eoo
				LEFT JOIN `ecomm_open_order_shipping_details` AS eoosd ON eoo.id = eoosd.open_order_id
				LEFT JOIN `ecomm_open_order_details` AS eood ON eoo.id = eood.open_order_id
				WHERE eoo.channel_id = (SELECT id FROM ecomm_sales_channels WHERE identifier='amazon')
				AND eoo.open = '1';";
		$orders = $this->db_query($sql, 'select-multiple', true);
		$returnArray['metadata']['query'] = $sql;
		$returnArray['metadata']['numOrders'] = count($orders);
		foreach ($orders as $order) {
			$dbId = $order['dbId'];
			$sql = "SELECT `sku`, `title`, `quantity`, `line_item_id` FROM ecomm_open_order_line_items WHERE open_order_id = '$dbId';";
			$orderItems = $this->db_query($sql, 'select-multiple', true);
			$order['orderItems'] = $orderItems;
			array_push($returnArray['orders'], $order);
		}
		return $returnArray;
	}
	
	private function getAmazonSPOrders() {
		$returnArray = array(
			'orders' => array(),
			'order_type' => 'amazon',
			'metadata' => array()
		);
		require_once(HTML_FOLDER . 'apis/amazon/class_amazon_api.php');
		$version = "v2";
		$sandbox = false;
		$debug = false;
		$amazonApi = new AmazonAPI($version, $sandbox, $debug);	
		$test_result = $amazonApi->OpenOrderRequestSigner();
		
		$results = json_decode($test_result, true);
		foreach ($results as $result) {
			$orderItems = array( 
				array(
					"0" => $result['orderItems']['0'],
					"1" => $result['orderItems']['1'],
					"2" => $result['orderItems']['2'],
					"3" => $result['orderItems']['3'],
					"line_item_id" => $result['orderItems']['line_item_id'],
					"quantity" => $result['orderItems']['quantity'],
					"sku" => $result['orderItems']['sku'],
					"title"=> $result['orderItems']['title'],
				),
			);
			$result['orderItems'] = $orderItems;
			array_push($returnArray['orders'], $result);
		}
		return $returnArray;
	}
	
	// private static function updateAmazonOpenOrders() {
	// 	$amazon = new AmazonMWS;
	// 	$openOrders = $amazon->getOpenOrders();
	// 	$orders = $openOrders->ListOrdersResult->Orders->Order;
	// }

	private function getErrorData($orderId, $channel) {
		$sql = "SELECT `error`, `labels_printed` FROM `ecomm_open_orders` WHERE `order_id` = '$orderId';"; // AND `channel_id` = (SELECT id FROM ecomm_sales_channels WHERE identifier='$channel' LIMIT 1);";
		$errorData = $this->db_query($sql, 'select-single');
		return $errorData;
	}

	private function insertIntoEcommOpenOrders($orderId, $channel) {
		if ($channel == 'amazon') {
			$sql = "INSERT IGNORE INTO ecomm_open_orders(`order_id`, `channel_id`) VALUES ('$orderId', (SELECT `id` FROM `ecomm_sales_channels` WHERE `identifier`='$channel' LIMIT 1));";
		}
		else {
			$sql = "INSERT IGNORE INTO ecomm_open_orders(`order_id`, `channel_id`) VALUES ('$orderId', (SELECT `id` FROM `ecomm_sales_channels` WHERE `identifier`='$channel' LIMIT 1)) ON DUPLICATE KEY UPDATE `open`='1';";
		}
		$this->db_query($sql, 'insert', true);
	}

	private function generatePackingSlip($orderId, $channel, $debug=false) {
		if ($debug) {
			echo "\tIn generatePackingSlip($orderId, $channel):\n";
		}
		require_once(HTML_FOLDER . 'classes/class_packingslips.php');
		if ($debug) {
			echo "\t\tRequired packing slip file\n";
		}
		$packingSlipObj = new PackingSlips;
		if ($debug) {
			echo "\t\tInstantiated packing slip object\n";
		}
		if (!$packingSlipObj->packingSlipIsGenerated($orderId, $channel)) {
			if ($debug) {
				echo "\t\tPacking slip does not exist\n";
			}
			if ($channel == 'newegg') {
				if ($debug) {
					echo "\t\tGenerating $channel packing slip\n";
				}
				$packingSlipObj->generateNeweggPackingSlip($orderId, 'F',$debug);
				if ($debug) {
					echo "\t\tNewegg packing slip generated\n";
				}
			}
			elseif ($channel == 'ebay') {
				if ($debug) {
					echo "\t\tGenerating $channel packing slip\n";
				}
				$packingSlipObj->generateEbayPackingSlip($orderId, 'F');
				if ($debug) {
					echo "\t\tEbay packing slip generated\n";
				}
			}
			elseif ($channel == 'backmarket') {
				$packingSlipObj->generateBackMarketPackingSlip($orderId, 'F');
			}
		}
	}

	function saveSingleEcomm($data) {
		$query =
			"UPDATE `ecomm_open_orders`
			SET `notes`='{$data['notes']}'
			WHERE order_id='{$data['order_id']}'";
		$numRows = $this->db_query($query, 'update', true);
		echo $numRows;
	}

	function saveMultipleEcomm($data) {
		$decoded = json_decode($data, true);
		$records = $decoded['records'];
		$notesClause = $this->buildNotesClause($records, 'order_id');
		$whereClause = "'".implode("','",array_keys($records))."'";
		$query =
			"UPDATE
				`ecomm_open_orders`
			SET
				`notes`=$notesClause
			WHERE `order_id` IN ($whereClause);
			";
		return $this->db_query($query, 'update', true);
	}

	function printPackingSlip($channel, $orderId, $path=HTML_FOLDER.'tmp') {
		global $backmarketObj;
		$printer = ECOMM_FULFILLMENT_INVENTORY_CAGE_PRINTER;

		if ($channel == 'back_market' || $channel == 'backmarket') {
			$orderData = $backmarketObj->getOrder($orderId);
			$decodedData = json_decode($orderData);
			$url = $decodedData->delivery_note;
			$filename = substr($url, strpos($url, 'Shipping_label'), 25);
		}

		$returnData = array();

		// https://backmarket-prd-us.s3.amazonaws.com/delivery_form/Shipping_label_652283.pdf?Signature=%2FtwZBdnRK1MIgi1GwKdUxGfhX9c%3D&Expires=1599766640&AWSAccessKeyId=AKIAJCL3CGZX5LRTF7WQ
		if ($url) {
			file_put_contents("$path/$filename", file_get_contents($url));

			$file = "$path/$filename";

			$this->send_printer($printer, $file);

			unlink($file);
			$returnData['printer'] = $printer;
			$returnData['path'] = $path;
			$returnData['filename'] = $filename;
			$returnData['file'] = $file;
			$returnData['url'] = $url;
			$returnData['success'] = true;
		}
		else {
			$returnData['success'] = false;
		}
		return json_encode($returnData);
	}
}


?>
