<?php



class MachineDatabase extends Database {
	function machine_database(){

		global $searchObj;

		echo $this->parse(TEMPLATE, array('BODY' => $header.$searchObj->display_machines(), "TITLE" => "Machine Database"));


	}
	function machine_detail($machine_id){

		global $searchObj;

		if ($_POST['back']){
			$this->goToURL(CONTROLLER.'?m=machine_database');
			exit;
		}

		if ($_POST['edit']){

			$this->machine_edit($_GET['machine_id']);
			exit;

		}

		if ($_POST['delete']){

			$this->db_update('machine_lookup', 'machine_id', $_GET['machine_id'], array('enabled'=>false));
			$this->goToURL(CONTROLLER.'?m=machine_database');
			exit;

		}

		$machine_info = $this->db_select_single('machine_lookup', '*', array('machine_id' => $machine_id));

		$join = array('machine_parts_map mpm on mpm.pID = dp.pID');

		$ds_products = $this->db_select_multiple('ds_products dp', 'distinct dp.*', array('mpm.machine_id' => $machine_id), 'order by dp.pNum', $join);

		$ds_vendors = $this->db_select_multiple('ds_vendors', 'venID, venCompany', array(), 'order by venCompany');

		foreach ($ds_vendors as $vendor){
			if ($vendor['venID'] == $machine_info['display_housing_venID']){
				$display_housing_vendor = $vendor['venCompany'];
			}
			if ($vendor['venID'] == $machine_info['display_bezel_venID']){
				$display_bezel_vendor = $vendor['venCompany'];
			}
			if ($vendor['venID'] == $machine_info['keyboard_venID']){
				$keyboard_vendor = $vendor['venCompany'];
			}
			if ($vendor['venID'] == $machine_info['top_case_venID']){
				$top_case_vendor = $vendor['venCompany'];
			}
			if ($vendor['venID'] == $machine_info['bottom_case_venID']){
				$bottom_case_vendor = $vendor['venCompany'];
			}
			if ($vendor['venID'] == $machine_info['battery_venID']){
				$battery_vendor = $vendor['venCompany'];
			}
			if ($vendor['venID'] == $machine_info['display_panel_venID']){
				$display_panel_vendor = $vendor['venCompany'];
			}
			if ($vendor['venID'] == $machine_info['upper_section_venID']){
				$upper_section_vendor = $vendor['venCompany'];
			}
		}

		$machine_grading_scale = $this->db_select_multiple('machine_grading_scale', 'symptoms', array('model_number' => $machine_info['model_number']),'order by grade');

		/*$product_model = $this->db_select_multiple('product_model', 'configCode',array('machine_id' => $machine_id),'order by configCode');

		$configArray = array();

		foreach ($product_model as $row){
			$configArray[] = $row['configCode'];
		}

		$configCodes = implode(',', $configArray);*/

		$parse = array(
			'MACHINE_ID'                 =>  $machine_id
			,'MACHINE_NAME'              =>  $machine_info['machine_description']
			,'MACHINE_IMAGE'            =>  ($machine_info['image_file'] == '' ? '' : '<img src="'.SITE_SURL.'images/machine_images/'.$machine_info['image_file'].'" />')
			,'PARTS_TABLE'              =>  $searchObj->display_parts_mini($ds_products,$machine_id)
			,'INTRODUCED'               =>  $machine_info['introduced']
			,'MODEL_IDENTIFIER'         =>  $machine_info['model_identifier']
			,'MODEL_NUMBER'             =>  $machine_info['model_number']
			,'PRODUCT_LINE'             =>  $machine_info['product_line']
			,'PROCESSOR'                =>  $machine_info['processor']
			,'PROCESSOR_SPEED'          =>  $machine_info['processor_speed']
			,'STORAGE'                  =>  $machine_info['storage']
			,'LATEST_OS'				=>	$machine_info['latest_os']
			,'UPGRADEABLE'				=>	$machine_info['upgradeable']
			,'DISPLAY_HOUSING'          =>  $machine_info['display_housing']
			,'DISPLAY_HOUSING_PRICE'    =>  ($machine_info['display_housing_price'] == '0.00' ? '' : $machine_info['display_housing_price'])
			,'DISPLAY_HOUSING_VENDOR'   =>  $display_housing_vendor
			,'DISPLAY_BEZEL'            =>  $machine_info['display_bezel']
			,'DISPLAY_BEZEL_PRICE'      =>  ($machine_info['display_bezel_price'] == '0.00' ? '' : $machine_info['display_bezel_price'])
			,'DISPLAY_BEZEL_VENDOR'     =>  $display_bezel_vendor
			,'KEYBOARD'                 =>  $machine_info['keyboard']
			,'KEYBOARD_PRICE'           =>  ($machine_info['keyboard_price'] == '0.00' ? '' : $machine_info['keyboard_price'])
			,'KEYBOARD_VENDOR'          =>  $keyboard_vendor
			,'TOP_CASE'                 =>  $machine_info['top_case']
			,'TOP_CASE_PRICE'           =>  ($machine_info['top_case_price'] == '0.00' ? '' : $machine_info['top_case_price'])
			,'TOP_CASE_VENDOR'          =>  $top_case_vendor
			,'BOTTOM_CASE'              =>  $machine_info['bottom_case']
			,'BOTTOM_CASE_PRICE'        =>  ($machine_info['bottom_case_price'] == '0.00' ? '' : $machine_info['bottom_case_price'])
			,'BOTTOM_CASE_VENDOR'       =>  $bottom_case_vendor
			,'BATTERY'                  =>  $machine_info['battery']
			,'BATTERY_PRICE'            =>  ($machine_info['battery_price'] == '0.00' ? '' : $machine_info['battery_price'])
			,'BATTERY_VENDOR'           =>  $battery_vendor
			,'DISPLAY_PANEL'            =>  $machine_info['display_panel']
			,'DISPLAY_PANEL_PRICE'      =>  ($machine_info['display_panel_price'] == '0.00' ? '' : $machine_info['display_panel_price'])
			,'DISPLAY_PANEL_VENDOR'     =>  $display_panel_vendor
			,'UPPER_SECTION'            =>  $machine_info['upper_section']
			,'UPPER_SECTION_PRICE'      =>  ($machine_info['upper_section_price'] == '0.00' ? '' : $machine_info['upper_section_price'])
			,'UPPER_SECTION_VENDOR'     =>  $upper_section_vendor
			,'TECH_NOTES'               =>  $machine_info['tech_notes']
			,'GRADE_A'                  =>  $machine_grading_scale[0]['symptoms']
			,'GRADE_B'                  =>  $machine_grading_scale[1]['symptoms']
			,'GRADE_C'                  =>  $machine_grading_scale[2]['symptoms']
			,'GRADE_D'                  =>  $machine_grading_scale[3]['symptoms']
		);


		echo $this->parse(TEMPLATE, array('BODY' => $this->parse(MACHINE_DETAIL, $parse)));
	}

	function machine_edit($machine_id){

		global $searchObj;

		if ($_POST['back']){
			if ($machine_id){
				$this->goToURL(CONTROLLER.'?m=machine_detail&machine_id='.$machine_id);
			}else{
				$this->goToURL(CONTROLLER.'?m=machine_database');
			}
			exit;
		}

		$machine_info = $this->db_select_single('machine_lookup', '*', array('machine_id' => $machine_id));

		if ($_POST['save']){

			$data = $_POST;

			if (!$machine_id){
				$data['enabled'] = '1';
				$data_new = $data;
				unset($data_new['save']);
				unset($data_new['configCodes']);
				unset($data_new['grade_a']);
				unset($data_new['grade_b']);
				unset($data_new['grade_c']);
				unset($data_new['grade_d']);
				$machine_id = $this->db_insert('machine_lookup', $data_new);
			}

			/*$configCodes = explode(',', $data['configCodes']);

			$this->db_delete('product_model', 'machine_id', $machine_id);

			foreach ($configCodes as $row){
				$this->db_insert('product_model', array('configCode' => trim($row), 'machine_id' => $machine_id));
			}*/

			unset($data['save']);
			//unset($data['configCodes']);
			if ($data['model_number'] != ''){

				$grading_scale_id = $this->db_select_single('machine_grading_scale', 'grading_scale_id', array('model_number' => $data['model_number']));

				if ($grading_scale_id['grading_scale_id']){

					$this->db_update('machine_grading_scale', model_number, $data['model_number'], array('symptoms' => $data['grade_a']), 'grade', 'A');
					$this->db_update('machine_grading_scale', model_number, $data['model_number'], array('symptoms' => $data['grade_b']), 'grade', 'B');
					$this->db_update('machine_grading_scale', model_number, $data['model_number'], array('symptoms' => $data['grade_c']), 'grade', 'C');
					$this->db_update('machine_grading_scale', model_number, $data['model_number'], array('symptoms' => $data['grade_d']), 'grade', 'D');

				}else{

					$gs_data = array(
						'model_number'  =>  $data['model_number']
						,'grade'        =>  'A'
						,'symptoms'    =>  $data['grade_a']
					);
					$this->db_insert('machine_grading_scale', $gs_data);

					$gs_data = array(
						'model_number'  =>  $data['model_number']
						,'grade'        =>  'B'
						,'symptoms'    =>  $data['grade_b']
					);
					$this->db_insert('machine_grading_scale', $gs_data);

					$gs_data = array(
						'model_number'  =>  $data['model_number']
						,'grade'        =>  'C'
						,'symptoms'    =>  $data['grade_c']
					);
					$this->db_insert('machine_grading_scale', $gs_data);

					$gs_data = array(
						'model_number'  =>  $data['model_number']
						,'grade'        =>  'D'
						,'symptoms'    =>  $data['grade_d']
					);
					$this->db_insert('machine_grading_scale', $gs_data);
				}

			}

			unset($data['grade_a']);
			unset($data['grade_b']);
			unset($data['grade_c']);
			unset($data['grade_d']);

			// $this->db_update('machine_lookup', 'machine_id', $machine_id, $data);

			$this->updateMachineLookup($machine_id, $data, $machine_info);


			if (!$this->db_select_single('product_line', '*', array('product_line' => $data['product_line']))){

				$max_sort = $this->db_select_single('product_line', 'max(sort_order)');

				$sort_order = $max_sort[0] + 10;

				$this->db_insert('product_line', array('product_line' => $data['product_line'],'sort_order' => $sort_order));

			}
			$this->goToURL(CONTROLLER.'?m=machine_detail&machine_id='.$machine_id);

		}


		$join = array('machine_parts_map mpm on mpm.pID = dp.pID');

		$ds_products = $this->db_select_multiple('ds_products dp', 'distinct dp.*', array('mpm.machine_id' => $machine_id), 'order by dp.pNum', $join);

		$dd_products = $this->db_select_multiple('ds_products dp', 'distinct dp.pNum, dp.pNum', array('mpm.machine_id' => $machine_id), 'order by dp.pNum', $join);

		$ds_vendors = $this->db_select_multiple('ds_vendors', 'venID, venCompany', array(), 'order by venCompany');

		$dd_display_housing_vendors = $this->arrayToHtmlSelectOptions($ds_vendors,true,$machine_info['display_housing_venID']);
		$dd_display_bezel_vendors = $this->arrayToHtmlSelectOptions($ds_vendors,true,$machine_info['display_bezel_venID']);
		$dd_keyboard_vendors = $this->arrayToHtmlSelectOptions($ds_vendors,true,$machine_info['keyboard_venID']);
		$dd_top_case_vendors = $this->arrayToHtmlSelectOptions($ds_vendors,true,$machine_info['top_case_venID']);
		$dd_bottom_case_vendors = $this->arrayToHtmlSelectOptions($ds_vendors,true,$machine_info['bottom_case_venID']);
		$dd_battery_vendors = $this->arrayToHtmlSelectOptions($ds_vendors,true,$machine_info['battery_venID']);
		$dd_display_panel_vendors = $this->arrayToHtmlSelectOptions($ds_vendors,true,$machine_info['display_panel_venID']);
		$dd_upper_section_vendors = $this->arrayToHtmlSelectOptions($ds_vendors,true,$machine_info['upper_section_venID']);

		$machine_grading_scale = $this->db_select_multiple('machine_grading_scale', 'symptoms', array('model_number' => $machine_info['model_number']),'order by grade');

		/*$product_model = $this->db_select_multiple('product_model', 'configCode',array('machine_id' => $machine_id),'order by configCode');

		$configArray = array();

		foreach ($product_model as $row){
			$configArray[] = $row['configCode'];
		}

		$configCodes = implode(',', $configArray);*/

		$parse = array(
			'MACHINE_ID'                =>  $machine_id
			,'MACHINE_NAME'             =>  htmlspecialchars($machine_info['machine_description'])
			,'PRODUCT_LINE'             =>  $machine_info['product_line']
			,'MACHINE_IMAGE'            =>  ($machine_info['image_file'] == '' ? 'admin_controller.php?m=machine_image&machine_id='.$machine_id : 'admin_controller.php?m=machine_image&image='.SITE_SURL.'images/machine_images/'.$machine_info['image_file'].'&machine_id='.$machine_id)
			,'PARTS_TABLE'              =>  $searchObj->display_parts_mini($ds_products,$machine_id)
			,'INTRODUCED'               =>  htmlspecialchars($machine_info['introduced'])
			,'MODEL_IDENTIFIER'         =>  htmlspecialchars($machine_info['model_identifier'])
			,'MODEL_NUMBER'             =>  htmlspecialchars($machine_info['model_number'])
			,'PROCESSOR'                =>  htmlspecialchars($machine_info['processor'])
			,'PROCESSOR_SPEED'          =>  htmlspecialchars($machine_info['processor_speed'])
			,'STORAGE'                  =>  htmlspecialchars($machine_info['storage'])
			,'LATEST_OS'				=>	htmlspecialchars($machine_info['latest_os'])
			,'UPGRADEABLE'				=>	htmlspecialchars($machine_info['upgradeable'])
			,'DISPLAY_HOUSING'          =>  $this->arrayToHtmlSelectOptions($dd_products,true,$machine_info['display_housing'])
			,'DISPLAY_HOUSING_PRICE'    =>  ($machine_info['display_housing_price'] == '0.00' ? '' : $machine_info['display_housing_price'])
			,'DISPLAY_HOUSING_VENDOR'   =>  $dd_display_housing_vendors
			,'DISPLAY_BEZEL'            =>  $this->arrayToHtmlSelectOptions($dd_products,true,$machine_info['display_bezel'])
			,'DISPLAY_BEZEL_PRICE'      =>  ($machine_info['display_bezel_price'] == '0.00' ? '' : $machine_info['display_bezel_price'])
			,'DISPLAY_BEZEL_VENDOR'     =>  $dd_display_bezel_vendors
			,'KEYBOARD'                 =>  $this->arrayToHtmlSelectOptions($dd_products,true,$machine_info['keyboard'])
			,'KEYBOARD_PRICE'           =>  ($machine_info['keyboard_price'] == '0.00' ? '' : $machine_info['keyboard_price'])
			,'KEYBOARD_VENDOR'          =>  $dd_keyboard_vendors
			,'TOP_CASE'                 =>  $this->arrayToHtmlSelectOptions($dd_products,true,$machine_info['top_case'])
			,'TOP_CASE_PRICE'           =>  ($machine_info['top_case_price'] == '0.00' ? '' : $machine_info['top_case_price'])
			,'TOP_CASE_VENDOR'          =>  $dd_top_case_vendors
			,'BOTTOM_CASE'              =>  $this->arrayToHtmlSelectOptions($dd_products,true,$machine_info['bottom_case'])
			,'BOTTOM_CASE_PRICE'        =>  ($machine_info['bottom_case_price'] == '0.00' ? '' : $machine_info['bottom_case_price'])
			,'BOTTOM_CASE_VENDOR'       =>  $dd_bottom_case_vendors
			,'BATTERY'                  =>  $this->arrayToHtmlSelectOptions($dd_products,true,$machine_info['battery'])
			,'BATTERY_PRICE'            =>  ($machine_info['battery_price'] == '0.00' ? '' : $machine_info['battery_price'])
			,'BATTERY_VENDOR'           =>  $dd_battery_vendors
			,'DISPLAY_PANEL'            =>  $this->arrayToHtmlSelectOptions($dd_products,true,$machine_info['display_panel'])
			,'DISPLAY_PANEL_PRICE'      =>  ($machine_info['display_panel_price'] == '0.00' ? '' : $machine_info['display_panel_price'])
			,'DISPLAY_PANEL_VENDOR'     =>  $dd_display_panel_vendors
			,'UPPER_SECTION'            =>  $this->arrayToHtmlSelectOptions($dd_products,true,$machine_info['upper_section'])
			,'UPPER_SECTION_PRICE'      =>  ($machine_info['upper_section_price'] == '0.00' ? '' : $machine_info['upper_section_price'])
			,'UPPER_SECTION_VENDOR'     =>  $dd_upper_section_vendors
			,'TECH_NOTES'               =>  $machine_info['tech_notes']
			,'GRADE_A'                  =>  $machine_grading_scale[0]['symptoms']
			,'GRADE_B'                  =>  $machine_grading_scale[1]['symptoms']
			,'GRADE_C'                  =>  $machine_grading_scale[2]['symptoms']
			,'GRADE_D'                  =>  $machine_grading_scale[3]['symptoms']
		);


		echo $this->parse(TEMPLATE, array('BODY' => $this->parse(MACHINE_EDIT, $parse)));
	}

	function updateMachineLookup($machineId, $data, $oldData) {
		$oldMachineDescription = $oldData['machine_description'];
		$newMachineDescription = $data['machine_description'];
		// echo "<pre>";
		if ($oldMachineDescription && $newMachineDescription && $newMachineDescription != $oldMachineDescription) {
			// echo "$newMachineDescription and $oldMachineDescription do not match, updating ds_orders\n";
			$this->updateDsOrderMachineType($oldMachineDescription, $newMachineDescription);
		}
		else {
			// echo "$newMachineDescription and $oldMachineDescription match\n";
		}
		// echo "</pre>";


		$sql = "UPDATE `machine_lookup` SET ";
		$i = 0;
		foreach($data as $aKey => $aVal) {
			if ($i) {
				$sql .= ', ';
			}
			$sql .= "`$aKey`=" . $this->qualify_value($aVal, $aKey);
			$i++;
		}
		$sql .= " WHERE `machine_id`='$machineId';";
		$this->db_query($sql, 'update', true);
	}

	function updateDsOrderMachineType($oldMachineType, $newMachineType) {
		$oldMachineType = mysql_real_escape_string($oldMachineType);
		$newMachineType = mysql_real_escape_string($newMachineType);
		$sql = "UPDATE `ds_orders` SET `machineType`='$newMachineType' WHERE `machineType` IS NOT NULL AND `machineType` != '' AND `machineType`='$oldMachineType';";
		$this->db_query($sql, 'update', true);
	}

	function find_machine($serialNumber){
		if ($_POST['addmachine']){
			$this->machine_edit();
			exit;
		}
		if ($_POST['addorder']){
			$this->order_number_edit();
			exit;
		}
		if (strlen($serialNumber) < 13){
			$configCode = substr($serialNumber,8);
		}else{
			$configCode = substr($serialNumber,9);
		}
		if ($machineInfo = $this->db_select_single('product_model', 'machine_id', array('configCode' => $configCode))){
			$this->goToURL(CONTROLLER.'?m=machine_detail&machine_id='.$machineInfo['machine_id']);
		}else{
			$this->goToURL(CONTROLLER.'?m=machine_database');
		}
	}

	function updateZohoIds($data) {
		$sql =
			"INSERT INTO machine_zoho_ids
			VALUES ({$data['machine_order_number_id']},
			{$data['first_stock_zoho_id_individual']},
			{$data['second_stock_zoho_id_individual']},
			{$data['first_stock_zoho_id_tenpack']},
			{$data['second_stock_zoho_id_tenpack']})
			ON DUPLICATE KEY UPDATE
			`first_stock_zoho_id_individual` = {$data['first_stock_zoho_id_individual']},
			`second_stock_zoho_id_individual` = {$data['second_stock_zoho_id_individual']},
			`first_stock_zoho_id_tenpack` = {$data['first_stock_zoho_id_tenpack']},
			`second_stock_zoho_id_tenpack` = {$data['second_stock_zoho_id_tenpack']};";
		$results = $this->db_query($sql, 'insert', true);
		return array($sql, $results);
	}

	function updateShopifyIds($data) {
		global $shopifyObj;
		$data['first_stock_inventory_item_id'] = 'NULL';
		$data['second_stock_inventory_item_id'] = 'NULL';
		if ($data['first_stock_shopify_variant_id'] && $data['first_stock_shopify_variant_id'] != '' && $data['first_stock_shopify_variant_id'] != 'NULL') {
			$vId = substr($data['first_stock_shopify_variant_id'], 1, strlen($data['first_stock_shopify_variant_id']) - 2);
			$vData = $shopifyObj->getVariant($vId);
			$invId = $vData['variant']['inventory_item_id'];
			echo "<p>InvID: $invId</p>";
			$data['first_stock_inventory_item_id'] = $invId != '' ? "'".$invId."'" : 'NULL';
		}
		if ($data['second_stock_shopify_variant_id'] && $data['second_stock_shopify_variant_id'] != '' && $data['second_stock_shopify_variant_id'] != 'NULL') {
			$vId = substr($data['second_stock_shopify_variant_id'], 1, strlen($data['second_stock_shopify_variant_id']) - 2);
			$vData = $shopifyObj->getVariant($vId);
			$invId = $vData['variant']['inventory_item_id'];
			$data['second_stock_inventory_item_id'] = $invId != '' ? "'".$invId."'" : 'NULL';
		}
		$sql =
			"INSERT INTO machine_shopify_ids
			VALUES ({$data['machine_order_number_id']},
			{$data['first_stock_shopify_product_id']},
			{$data['second_stock_shopify_product_id']},
			{$data['first_stock_shopify_variant_id']},
			{$data['second_stock_shopify_variant_id']},
			{$data['first_stock_inventory_item_id']},
			{$data['second_stock_inventory_item_id']})
			ON DUPLICATE KEY UPDATE
			`first_stock_shopify_product_id` = {$data['first_stock_shopify_product_id']},
			`second_stock_shopify_product_id` = {$data['second_stock_shopify_product_id']},
			`first_stock_shopify_variant_id` = {$data['first_stock_shopify_variant_id']},
			`second_stock_shopify_variant_id` = {$data['second_stock_shopify_variant_id']},
			`first_stock_inventory_item_id` = {$data['first_stock_inventory_item_id']},
			`second_stock_inventory_item_id` = {$data['second_stock_inventory_item_id']};";
		$results = $this->db_query($sql, 'insert', true);
		return array($sql, $results);
	}

	function order_number_edit($order_number_id){

		global $searchObj, $zohoObj;

		if ($_POST['save']){
			if ($_POST['order_number_id'] == ''){

				$order_number_id = $this->db_insert('machine_order_number',array('order_number' => mysql_real_escape_string($_POST['order_number']), 'machine_id' => $_POST['machine_id'], 'enabled' => true));

				if ($_POST['configCodes'] != ""){
					$configCodes = explode(',',$_POST['configCodes']);

					$this->db_delete('product_model', 'order_number_id', $_POST['order_number_id']);

					foreach ($configCodes as $row){
						$this->db_insert('product_model', array('configCode' => trim($row), 'machine_id' => $_POST['machine_id'], 'order_number_id' => $order_number_id));
					}


				}

				// echo $this->parse(TEMPLATE, array('BODY' => $header.$searchObj->display_machines()));
				header('Location: '. CONTROLLER . '?m=machine_database');
				exit;

			}
			$sql = "SELECT * FROM machine_order_number WHERE order_number_id = {$_POST['order_number_id']};";

			$existingData = $this->db_query($sql, 'select-single');

			$onid = $_POST['order_number_id'];
			$setClause = "";
			if ($_POST['storage'] != $existingData['storage']) {
				$storage = $_POST['storage'];
				if (strlen($setClause) > 0) {
					$setClause .= ", ";
				}
				$setClause .= "storage = '$storage'";
			}

			if ($_POST['ram'] != $existingData['ram']) {
				$ram = $_POST['ram'];
				if (strlen($setClause) > 0) {
					$setClause .= ", ";
				}
				$setClause .= "ram = '$ram'";
			}

			$first_stock_pricing = $_POST['first_stock_pricing'] != '' ? $_POST['first_stock_pricing'] : 'NULL';
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "first_stock_pricing = $first_stock_pricing";

			$second_stock_pricing = $_POST['second_stock_pricing'] != '' ? $_POST['second_stock_pricing'] : 'NULL';
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "second_stock_pricing = $second_stock_pricing";

			$first_stock_ten_pack_pricing = $_POST['first_stock_ten_pack_pricing'] != '' ? $_POST['first_stock_ten_pack_pricing'] : 'NULL';
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "first_stock_ten_pack_pricing = $first_stock_ten_pack_pricing";

			$second_stock_ten_pack_pricing = $_POST['second_stock_ten_pack_pricing'] != '' ? $_POST['second_stock_ten_pack_pricing'] : 'NULL';
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "second_stock_ten_pack_pricing = $second_stock_ten_pack_pricing";

			if ($_POST['color'] != $existingData['color']) {
				$color = $_POST['color'];
				if (strlen($setClause) > 0) {
					$setClause .= ", ";
				}
				$setClause .= "color = '$color'";
			}
			if ($_POST['processor'] != $existingData['processor']) {
				$processor = $_POST['processor'];
				if (strlen($setClause) > 0) {
					$setClause .= ", ";
				}
				$setClause .= "processor = '$processor'";
			}
			if ($_POST['processor_speed'] != $existingData['processor_speed']) {
				$processor_speed = $_POST['processor_speed'];
				if (strlen($setClause) > 0) {
					$setClause .= ", ";
				}
				$setClause .= "processor_speed = '$processor_speed'";
			}

			if ($_POST['limited_to_inventory'] != $existingData['limited_to_inventory']) {
				$limited_to_inventory = $_POST['limited_to_inventory'];
				if (strlen($setClause) > 0) {
					$setClause .= ", ";
				}
				$setClause .= "limited_to_inventory = $limited_to_inventory";
			}

			$first_stock_zoho_id_individual = $_POST['first_stock_zoho_id_individual'];
			$second_stock_zoho_id_individual = $_POST['second_stock_zoho_id_individual'];
			$first_stock_zoho_id_tenpack = $_POST['first_stock_zoho_id_tenpack'];
			$second_stock_zoho_id_tenpack = $_POST['second_stock_zoho_id_tenpack'];
			$first_stock_shopify_product_id = $_POST['first_stock_shopify_product_id'];
			$second_stock_shopify_product_id = $_POST['second_stock_shopify_product_id'];
			$first_stock_shopify_variant_id = $_POST['first_stock_shopify_variant_id'];
			$second_stock_shopify_variant_id = $_POST['second_stock_shopify_variant_id'];

			// Perform price changes - only on prod mode
			if (MODE != 'DEV') {
				// Zoho price changes
				if ($first_stock_zoho_id_individual && $first_stock_pricing && $first_stock_zoho_id_individual != 'NULL' && $first_stock_pricing != 'NULL') {
					$record = $zohoObj->updateProductPrice($first_stock_zoho_id_individual, $first_stock_pricing);
				}
				if ($second_stock_zoho_id_individual && $second_stock_pricing && $second_stock_zoho_id_individual != 'NULL' && $second_stock_pricing != 'NULL') {
					$record = $zohoObj->updateProductPrice($second_stock_zoho_id_individual, $second_stock_pricing);
				}
				if ($first_stock_zoho_id_tenpack && $first_stock_ten_pack_pricing && $first_stock_zoho_id_tenpack != 'NULL' && $first_stock_ten_pack_pricing != 'NULL') {
					$record = $zohoObj->updateProductPrice($first_stock_zoho_id_tenpack, $first_stock_ten_pack_pricing);
				}
				if ($second_stock_zoho_id_tenpack && $second_stock_ten_pack_pricing && $second_stock_zoho_id_tenpack != 'NULL' && $second_stock_ten_pack_pricing != 'NULL') {
					$record = $zohoObj->updateProductPrice($second_stock_zoho_id_tenpack, $second_stock_ten_pack_pricing);
				}

				// Perform Shopify price changes
				if ($first_stock_shopify_variant_id && $first_stock_pricing && $first_stock_shopify_variant_id != 'NULL' && $first_stock_pricing != 'NULL') {
					if (strpos($first_stock_pricing, '.') === false) {
						$first_stock_pricing = $first_stock_pricing.'.00';
					}
					$this->updateShopifyPrice(array('variantId' => $first_stock_shopify_variant_id, 'price' => $first_stock_pricing));
				}
				if ($second_stock_shopify_variant_id && $second_stock_pricing && $second_stock_shopify_variant_id != 'NULL' && $second_stock_pricing != 'NULL') {
					if (strpos($second_stock_pricing, '.') === false) {
						$second_stock_pricing = $second_stock_pricing.'.00';
					}
					$this->updateShopifyPrice(array('variantId' => $second_stock_shopify_variant_id, 'price' => $second_stock_pricing));
				}
			}

			if (strlen($setClause) > 0) {
				$sql = "UPDATE machine_order_number SET $setClause WHERE order_number_id = $onid;";
				$this->db_query($sql, 'update', true);
			}
			// Build ID update arrays
			$zohoIds = array(
				'machine_order_number_id' => $onid,
				'first_stock_zoho_id_individual' => $_POST['first_stock_zoho_id_individual'] != '' ? '\''.$_POST['first_stock_zoho_id_individual'].'\'' : 'NULL',
				'second_stock_zoho_id_individual' => $_POST['second_stock_zoho_id_individual'] != '' ? '\''.$_POST['second_stock_zoho_id_individual'].'\'' : 'NULL',
				'first_stock_zoho_id_tenpack' => $_POST['first_stock_zoho_id_tenpack'] != '' ? '\''.$_POST['first_stock_zoho_id_tenpack'].'\'' : 'NULL',
				'second_stock_zoho_id_tenpack' => $_POST['second_stock_zoho_id_tenpack'] != '' ? '\''.$_POST['second_stock_zoho_id_tenpack'].'\'' : 'NULL'
			);
			$shopifyIds = array(
				'machine_order_number_id' => $onid,
				'first_stock_shopify_product_id' => $_POST['first_stock_shopify_product_id'] != '' ? '\''.$_POST['first_stock_shopify_product_id'].'\'' : 'NULL',
				'second_stock_shopify_product_id' => $_POST['second_stock_shopify_product_id'] != '' ? '\''.$_POST['second_stock_shopify_product_id'].'\'' : 'NULL',
				'first_stock_shopify_variant_id' => $_POST['first_stock_shopify_variant_id'] != '' ? '\''.$_POST['first_stock_shopify_variant_id'].'\'' : 'NULL',
				'second_stock_shopify_variant_id' => $_POST['second_stock_shopify_variant_id'] != '' ? '\''.$_POST['second_stock_shopify_variant_id'].'\'' : 'NULL'
			);

			// Perform ID updates
			$this->updateZohoIds($zohoIds);
			$this->updateShopifyIds($shopifyIds);


			if ($_POST['configCodes'] != ""){
				$configCodes = explode(',',$_POST['configCodes']);

				$this->db_delete('product_model', 'order_number_id', $_POST['order_number_id']);

				foreach ($configCodes as $row){
					$this->db_insert('product_model', array('configCode' => trim($row), 'machine_id' => $_POST['machine_id'], 'order_number_id' => $_POST['order_number_id']));
				}
			}

			$this->db_update('machine_order_number','order_number_id',$_POST['order_number_id'],array('machine_id' => $_POST['machine_id'], 'order_number' => mysql_real_escape_string($_POST['order_number'])));

			if ($_POST['accessory']){
				$machine_accessories = $_POST['accessory'];

				$this->db_delete('machine_order_number_accessories', 'order_number_id', $_POST['order_number_id']);

				foreach ($machine_accessories as $k => $v){

					$this->db_insert('machine_order_number_accessories', array('order_number_id' => $_POST['order_number_id'],'deduction_id' => $k));

				}
			}

			header('Location: '. CONTROLLER . '?m=machine_database');
			exit;
		}

		if ($_POST['cancel']){
			header('Location: '. CONTROLLER . '?m=machine_database');
			exit;
		}

		if ($_POST['delete']){
			$this->db_update('machine_order_number', 'order_number_id', $_POST['order_number_id'], array('enabled' => false));
			header('Location: '. CONTROLLER . '?m=machine_database');
			exit;
		}
		if ($order_number_id) {
			$sql = "SELECT mon.*, mzi.*, msi.*
			FROM machine_order_number AS mon
			LEFT JOIN machine_zoho_ids AS mzi ON mon.order_number_id = mzi.machine_order_number_id
			LEFT JOIN machine_shopify_ids AS msi ON mon.order_number_id = msi.machine_order_number_id
			WHERE mon.order_number_id = $order_number_id;";
			$machine_order_number = $this->db_query($sql, 'select-single', true);
		} else {
			$machine_order_number = $this->db_select_single('machine_order_number', '*',array('order_number_id' => $order_number_id));
		}

		$machines = $this->db_select_multiple('machine_lookup', 'machine_id,machine_description',array('enabled'=>true),'order by machine_description');

		if ($machine_order_number != false){

			$product_model = $this->db_select_multiple('product_model', 'configCode',array('order_number_id' => $order_number_id),'order by configCode');

			foreach ($product_model as $row) {
				$product_model_array[] = $row['configCode'];
			}

			$product_model_list = implode(',', $product_model_array);

			$storage = $machine_order_number['storage'];

			$ram = $machine_order_number['ram'];

			$first_stock_pricing = $machine_order_number['first_stock_pricing'];
			$second_stock_pricing = $machine_order_number['second_stock_pricing'];
			$first_stock_ten_pack_pricing = $machine_order_number['first_stock_ten_pack_pricing'];
			$second_stock_ten_pack_pricing = $machine_order_number['second_stock_ten_pack_pricing'];
			$first_stock_zoho_id_individual = $machine_order_number['first_stock_zoho_id_individual'];
			$second_stock_zoho_id_individual = $machine_order_number['second_stock_zoho_id_individual'];
			$first_stock_zoho_id_tenpack = $machine_order_number['first_stock_zoho_id_tenpack'];
			$second_stock_zoho_id_tenpack = $machine_order_number['second_stock_zoho_id_tenpack'];
			$first_stock_shopify_product_id = $machine_order_number['first_stock_shopify_product_id'];
			$second_stock_shopify_product_id = $machine_order_number['second_stock_shopify_product_id'];
			$first_stock_shopify_variant_id = $machine_order_number['first_stock_shopify_variant_id'];
			$second_stock_shopify_variant_id = $machine_order_number['second_stock_shopify_variant_id'];
			$color = $machine_order_number['color'];
			$processor = $machine_order_number['processor'];
			$processor_speed = $machine_order_number['processor_speed'];
			$device_condition = $machine_order_number['device_condition'];
			$auto_update_expiration = $machine_order_number['auto_update_expiration'];
			$dropshipQuantity = $machine_order_number['dropship_quantity'];
			$dropshipCost = $machine_order_number['dropship_cost'];

			$isTouchscreen = $machine_order_number['touchscreen'];
			$touchscreen = "";
			if ($isTouchscreen == 0) {
				$touchscreen .= "<option value='0' selected>No</option>";
			} else {
				$touchscreen .= "<option value='0'>No</option>";
			}
			if ($isTouchscreen == 1) {
				$touchscreen .= "<option value='1' selected>Yes</option>";
			} else {
				$touchscreen .= "<option value='1'>Yes</option>";
			}

			$isDropship = $machine_order_number['dropship'];
			$dropship = "";
			if ($isDropship == 0) {
				$dropship .= "<option value='0' selected>No</option>";
			} else {
				$dropship .= "<option value='0'>No</option>";
			}
			if ($isDropship == 1) {
				$dropship .= "<option value='1' selected>Yes</option>";
			} else {
				$dropship .= "<option value='1'>Yes</option>";
			}

			$dropshipDescription = trim($machine_order_number['dropship_description']);
			$hideDropshipDesc = "";
			if (!$dropshipDescription) {
				$hideDropshipDesc = "hidden";
			}

			$limited = $machine_order_number['limited_to_inventory'];
			$limited_to_inventory = "";
			if ($limited == 0) {
				$limited_to_inventory .= "<option value='0' selected>No</option>";
			} else {
				$limited_to_inventory .= "<option value='0'>No</option>";
			}
			if ($limited == 1) {
				$limited_to_inventory .= "<option value='1' selected>Yes</option>";
			} else {
				$limited_to_inventory .= "<option value='1'>Yes</option>";
			}

			$active = $machine_order_number['active'];
			$activeOptions = '';
			if ($active == 0) {
				$activeOptions .= "<option value='0' selected>No</option>";
			} else {
				$activeOptions .= "<option value='0'>No</option>";
			}
			if ($active == 1) {
				$activeOptions .= "<option value='1' selected>Yes</option>";
			} else {
				$activeOptions .= "<option value='1'>Yes</option>";
			}

			$specialOrder = $machine_order_number['special_order'];
			$specialOrderOptions = '';
			if ($specialOrder == 0) {
				$specialOrderOptions .= "<option value='0' selected>No</option>";
			} else {
				$specialOrderOptions .= "<option value='0'>No</option>";
			}
			if ($specialOrder == 1) {
				$specialOrderOptions .= "<option value='1' selected>Yes</option>";
			} else {
				$specialOrderOptions .= "<option value='1'>Yes</option>";
			}

			$dd_machines = $this->arrayToHtmlSelectOptions($machines,true,$machine_order_number['machine_id']);

			$order_number = $machine_order_number['order_number'];
		}else{

			$order_number = '';
			if ($_GET['machine_id']){
				$dd_machines = $this->arrayToHtmlSelectOptions($machines,true,$_GET['machine_id']);
			}else{
				$dd_machines = $this->arrayToHtmlSelectOptions($machines,true);
			}
		}

		$accessories = $this->db_select_multiple('po_deductions_lookup', '*', array('active' => 1,'accessory' => 1),'ORDER BY sequence');


		$machine_order_number_accessories = $this->db_select_multiple('machine_order_number_accessories', 'deduction_id',array('order_number_id' => $order_number_id));

		foreach ($machine_order_number_accessories as $accessory){

			$accessory_array[] = $accessory['deduction_id'];
		}

		foreach ($accessories as $accessory){

			if (in_array($accessory['deduction_id'], $accessory_array)){

				$accessory_checks .= '<tr><td>'.$accessory['deduction_name'].'</td><td><input type="checkbox" id="accessory[]" name="accessory['.$accessory['deduction_id'].']" checked /></td></tr>';
			}else{
				$accessory_checks .= '<tr><td>'.$accessory['deduction_name'].'</td><td><input type="checkbox" id="accessory[]" name="accessory['.$accessory['deduction_id'].']" /></td></tr>';
			}

		}

		if ($machine_order_number['order_number_id']) {
			$sql = "SELECT mei.`sku`, mei.`listing_id`, mei.`active`, mei.`channel_identifier`, mei.`price`, mc.`identifier` AS `condition` FROM machine_ecomm_ids AS mei LEFT JOIN machine_conditions AS mc ON mei.`condition_id` = mc.`id` WHERE mei.`order_number_id` = {$machine_order_number['order_number_id']};";
			$sqldata = $this->db_query($sql, 'select-multiple', true);
			// print_r($sqldata[0]);
			$ecomm = array();
			foreach ($sqldata as $line) {
				$price = $line['price'];
				$sku = $line['sku'];
				$listing_id = $line['listing_id'];
				$ecommActive = $line['active'];
				$channel_identifier = $line['channel_identifier'];
				$condition = $line['condition'];
				if (!$ecomm[$condition]) {
					$ecomm[$condition] = array();
				}
				$ecomm[$condition][$channel_identifier] = array(
					'price' => $price,
					'sku' => $sku,
					'listing_id' => $listing_id,
					'active' => $ecommActive
				);
				// echo "<p>Channel: $channel_identifier</p><p>Condition: $condition</p><p>SKU: $sku</p><p>Listing ID: $listing_id</p>";
			}
			// print_r($ecomm);
		}

		$deviceWeightLbs = floor((float)$machine_order_number['device_weight']);
		$deviceWeightOz = floor(((float)$machine_order_number['device_weight'] - $deviceWeightLbs) * 16);
		$caseWeightLbs = floor((float)$machine_order_number['case_weight']);
		$caseWeightOz = floor(((float)$machine_order_number['case_weight'] - $caseWeightLbs) * 16);

		$data = array(
			'ORDER_NUMBER_ID'   =>  $machine_order_number['order_number_id']
			,'OLD_MACHINE_ID'   =>  $machine_order_number['machine_id']
			,'ORDER_NUMBER'     =>  $order_number
			,'DD_MACHINES'      =>  $dd_machines
			,'CONFIG_CODES'     =>  $product_model_list
			,'ACCESSORIES'      =>  $accessory_checks
			,'STORAGE'			=>	$storage
			,'RAM'				=>	$ram
			,'FIRST_STOCK_PRICING'	=>	$first_stock_pricing
			,'SECOND_STOCK_PRICING'	=>	$second_stock_pricing
			,'FIRST_STOCK_TEN_PACK_PRICING'	=>	$first_stock_ten_pack_pricing
			,'SECOND_STOCK_TEN_PACK_PRICING'	=>	$second_stock_ten_pack_pricing
			,'FIRST_STOCK_ZOHO_ID_INDIVIDUAL'	=>	$first_stock_zoho_id_individual
			,'SECOND_STOCK_ZOHO_ID_INDIVIDUAL'	=>	$second_stock_zoho_id_individual
			,'FIRST_STOCK_ZOHO_ID_TENPACK'	=>	$first_stock_zoho_id_tenpack
			,'SECOND_STOCK_ZOHO_ID_TENPACK'	=>	$second_stock_zoho_id_tenpack
			,'FIRST_STOCK_SHOPIFY_PROD_ID'	=>	$first_stock_shopify_product_id
			,'SECOND_STOCK_SHOPIFY_PROD_ID'	=>	$second_stock_shopify_product_id
			,'FIRST_STOCK_SHOPIFY_VAR_ID'	=>	$first_stock_shopify_variant_id
			,'SECOND_STOCK_SHOPIFY_VAR_ID'	=>	$second_stock_shopify_variant_id
			,'COLOR' => $color
			,'PROCESSOR' => $processor
			,'PROCESSOR_SPEED' => $processor_speed
			,'CONDITION' => $device_condition
			,'AUTO_UPDATE_EXPIRATION' => $auto_update_expiration
			,'DEVICE_LBS' => $deviceWeightLbs
			,'DEVICE_OZ' => $deviceWeightOz
			,'CASE_LBS' => $caseWeightLbs
			,'CASE_OZ' => $caseWeightOz
			,'TOUCHSCREEN' => $touchscreen
			,'DROPSHIP' => $dropship
			,'DROPSHIP_QUANTITY' => $dropshipQuantity
			,'DROPSHIP_COST' => $dropshipCost
			,'DROPSHIP_DESCRIPTION' => $dropshipDescription
			,'DROPSHIP_DESC_HIDE' => $hideDropshipDesc
			,'LIMITED_TO_INVENTORY'	=>	$limited_to_inventory
			,'ACTIVE' => $activeOptions
			,'SPECIAL_ORDER' => $specialOrderOptions
			,'AMAZON_RENEWED_PRICE' => $ecomm['renewed']['amazon']['price'] ? $ecomm['renewed']['amazon']['price'] : ''
			,'AMAZON_RENEWED_SKU' => $ecomm['renewed']['amazon']['sku'] ? $ecomm['renewed']['amazon']['sku'] : ''
			,'AMAZON_RENEWED_LISTING_ID' => $ecomm['renewed']['amazon']['listing_id'] ? $ecomm['renewed']['amazon']['listing_id'] : ''
			,'AMAZON_RENEWED_ACTIVE' => $ecomm['renewed']['amazon']['active'] ? 'checked' : ''
			,'BACKMARKET_RENEWED_PRICE' => $ecomm['renewed']['backmarket']['price'] ? $ecomm['renewed']['backmarket']['price'] : ''
			,'BACKMARKET_RENEWED_SKU' => $ecomm['renewed']['backmarket']['sku'] ? $ecomm['renewed']['backmarket']['sku'] : ''
			,'BACKMARKET_RENEWED_LISTING_ID' => $ecomm['renewed']['backmarket']['listing_id'] ? $ecomm['renewed']['backmarket']['listing_id'] : ''
			,'BACKMARKET_RENEWED_ACTIVE' => $ecomm['renewed']['backmarket']['active'] ? 'checked' : ''
			,'BACKMARKET_REFURBISHED_PRICE' => $ecomm['certifiedrefurbished']['backmarket']['price'] ? $ecomm['certifiedrefurbished']['backmarket']['price'] : ''
			,'BACKMARKET_REFURBISHED_SKU' => $ecomm['certifiedrefurbished']['backmarket']['sku'] ? $ecomm['certifiedrefurbished']['backmarket']['sku'] : ''
			,'BACKMARKET_REFURBISHED_LISTING_ID' => $ecomm['certifiedrefurbished']['backmarket']['listing_id'] ? $ecomm['certifiedrefurbished']['backmarket']['listing_id'] : ''
			,'BACKMARKET_REFURBISHED_ACTIVE' => $ecomm['certifiedrefurbished']['backmarket']['active'] ? 'checked' : ''
			,'EBAY_REFURBISHED_PRICE' => $ecomm['certifiedrefurbished']['ebay']['price'] ? $ecomm['certifiedrefurbished']['ebay']['price'] : ''
			,'EBAY_REFURBISHED_SKU' => $ecomm['certifiedrefurbished']['ebay']['sku'] ? $ecomm['certifiedrefurbished']['ebay']['sku'] : ''
			,'EBAY_REFURBISHED_LISTING_ID' => $ecomm['certifiedrefurbished']['ebay']['listing_id'] ? $ecomm['certifiedrefurbished']['ebay']['listing_id'] : ''
			,'EBAY_REFURBISHED_ACTIVE' => $ecomm['certifiedrefurbished']['ebay']['active'] ? 'checked' : ''
			,'NEWEGG_REFURBISHED_PRICE' => $ecomm['certifiedrefurbished']['newegg']['price'] ? $ecomm['certifiedrefurbished']['newegg']['price'] : ''
			,'NEWEGG_REFURBISHED_SKU' => $ecomm['certifiedrefurbished']['newegg']['sku'] ? $ecomm['certifiedrefurbished']['newegg']['sku'] : ''
			,'NEWEGG_REFURBISHED_LISTING_ID' => $ecomm['certifiedrefurbished']['newegg']['listing_id'] ? $ecomm['certifiedrefurbished']['newegg']['listing_id'] : ''
			,'NEWEGG_REFURBISHED_ACTIVE' => $ecomm['certifiedrefurbished']['newegg']['active'] ? 'checked' : ''
			,'BACKMARKET_SCRATCHDENT_PRICE' => $ecomm['scratchdent']['backmarket']['price'] ? $ecomm['scratchdent']['backmarket']['price'] : ''
			,'BACKMARKET_SCRATCHDENT_SKU' => $ecomm['scratchdent']['backmarket']['sku'] ? $ecomm['scratchdent']['backmarket']['sku'] : ''
			,'BACKMARKET_SCRATCHDENT_LISTING_ID' => $ecomm['scratchdent']['backmarket']['listing_id'] ? $ecomm['scratchdent']['backmarket']['listing_id'] : ''
			,'BACKMARKET_SCRATCHDENT_ACTIVE' => $ecomm['scratchdent']['backmarket']['active'] ? 'checked' : ''
			,'EBAY_SCRATCHDENT_PRICE' => $ecomm['scratchdent']['ebay']['price'] ? $ecomm['scratchdent']['ebay']['price'] : ''
			,'EBAY_SCRATCHDENT_SKU' => $ecomm['scratchdent']['ebay']['sku'] ? $ecomm['scratchdent']['ebay']['sku'] : ''
			,'EBAY_SCRATCHDENT_LISTING_ID' => $ecomm['scratchdent']['ebay']['listing_id'] ? $ecomm['scratchdent']['ebay']['listing_id'] : ''
			,'EBAY_SCRATCHDENT_ACTIVE' => $ecomm['scratchdent']['ebay']['active'] ? 'checked' : ''
			,'NEWEGG_SCRATCHDENT_PRICE' => $ecomm['scratchdent']['newegg']['price'] ? $ecomm['scratchdent']['newegg']['price'] : ''
			,'NEWEGG_SCRATCHDENT_SKU' => $ecomm['scratchdent']['newegg']['sku'] ? $ecomm['scratchdent']['newegg']['sku'] : ''
			,'NEWEGG_SCRATCHDENT_LISTING_ID' => $ecomm['scratchdent']['newegg']['listing_id'] ? $ecomm['scratchdent']['newegg']['listing_id'] : ''
			,'NEWEGG_SCRATCHDENT_ACTIVE' => $ecomm['scratchdent']['newegg']['active'] ? 'checked' : ''
		);
		// print_r($ecomm['renewed']['amazon']);

		// echo $this->parse(TEMPLATE, array('BODY' => $this->parse(ORDER_NUMBER_EDIT, $data), "TITLE" => "$order_number Details/Edit"));
		echo $this->parse(TEMPLATE, array('BODY' => $this->parse(ORDER_NUMBER_EDIT_NEW, $data), "TITLE" => "$order_number Details/Edit"));
	}

	function submitOrder($submittedData) {
		global $searchObj, $zohoObj;
		$decodedData = json_decode($submittedData['data'], true);
		$return = array(
			'original' => $submittedData,
			'decoded' => $decodedData
		);
		// echo print_r($return);
		// $submittedData = $decodedData;

		// echo "<pre>";
		// print_r($existingData);
		// echo "</pre>";
		// echo "<pre>";
		// print_r($_POST);
		// echo "</pre>";
		// exit;

		if ($decodedData['order_number_id'] == ''){

			$order_number_id = $this->db_insert('machine_order_number',array('order_number' => $decodedData['order_number'], 'machine_id' => $decodedData['machine_id'], 'enabled' => true));

			if ($decodedData['configCodes'] != ""){
				$configCodes = explode(',',$decodedData['configCodes']);

				$this->db_delete('product_model', 'order_number_id', $decodedData['order_number_id']);

				foreach ($configCodes as $row){
					$this->db_insert('product_model', array('configCode' => trim($row), 'machine_id' => $decodedData['machine_id'], 'order_number_id' => $order_number_id));
				}


			}

			// echo $this->parse(TEMPLATE, array('BODY' => $header.$searchObj->display_machines()));
			header('Location: '. CONTROLLER . '?m=machine_database');
			exit;

		}
		$return['pastNullOrderNumberId'] = true;
		// echo print_r($return);
		$sql = "SELECT * FROM machine_order_number WHERE order_number_id = {$decodedData['order_number_id']};";

		$existingData = $this->db_query($sql, 'select-single');

		$device_weight_lbs = $decodedData['device_weight_lbs'] ? (float)$decodedData['device_weight_lbs'] : 0;
		$device_weight_oz = $decodedData['device_weight_oz'] ? (float)$decodedData['device_weight_oz'] : 0;

		$case_weight_lbs = $decodedData['case_weight_lbs'] ? (float)$decodedData['case_weight_lbs'] : 0;
		$case_weight_oz = $decodedData['case_weight_oz'] ? (float)$decodedData['case_weight_oz'] : 0;

		$deviceWeight = $device_weight_lbs + ($device_weight_oz / 16);
		$caseWeight = $case_weight_lbs + ($case_weight_oz / 16);

		$decodedData['device_weight'] = $deviceWeight;
		$decodedData['case_weight'] = $caseWeight;


		$onid = $decodedData['order_number_id'];
		$setClause = "";
		if ($decodedData['storage'] != $existingData['storage']) {
			$storage = $decodedData['storage'];
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "storage = '$storage'";
		}

		if ($decodedData['ram'] != $existingData['ram']) {
			$ram = $decodedData['ram'];
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "ram = '$ram'";
		}

		if ($decodedData['device_weight'] != $existingData['device_weight']) {
			$device_weight = $decodedData['device_weight'];
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "device_weight = '$device_weight'";
		}

		if ($decodedData['case_weight'] != $existingData['case_weight']) {
			$case_weight = $decodedData['case_weight'];
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "case_weight = '$case_weight'";
		}

		$first_stock_pricing = $decodedData['first_stock_pricing'] != '' ? $decodedData['first_stock_pricing'] : 'NULL';
		if (strlen($setClause) > 0) {
			$setClause .= ", ";
		}
		$setClause .= "first_stock_pricing = $first_stock_pricing";

		$second_stock_pricing = $decodedData['second_stock_pricing'] != '' ? $decodedData['second_stock_pricing'] : 'NULL';
		if (strlen($setClause) > 0) {
			$setClause .= ", ";
		}
		$setClause .= "second_stock_pricing = $second_stock_pricing";

		$first_stock_ten_pack_pricing = $decodedData['first_stock_ten_pack_pricing'] != '' ? $decodedData['first_stock_ten_pack_pricing'] : 'NULL';
		if (strlen($setClause) > 0) {
			$setClause .= ", ";
		}
		$setClause .= "first_stock_ten_pack_pricing = $first_stock_ten_pack_pricing";

		$second_stock_ten_pack_pricing = $decodedData['second_stock_ten_pack_pricing'] != '' ? $decodedData['second_stock_ten_pack_pricing'] : 'NULL';
		if (strlen($setClause) > 0) {
			$setClause .= ", ";
		}
		$setClause .= "second_stock_ten_pack_pricing = $second_stock_ten_pack_pricing";

		$dropship_quantity = $decodedData['dropship_quantity'] != '' ? $decodedData['dropship_quantity'] : 'NULL';
		if (strlen($setClause) > 0) {
			$setClause .= ", ";
		}
		$setClause .= "dropship_quantity = $dropship_quantity";

		$dropship_cost = $decodedData['dropship_cost'] != '' ? $decodedData['dropship_cost'] : 'NULL';
		if (strlen($setClause) > 0) {
			$setClause .= ", ";
		}
		$setClause .= "dropship_cost = $dropship_cost";

		if ($decodedData['color'] != $existingData['color']) {
			$color = $decodedData['color'];
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "color = '$color'";
		}
		if ($decodedData['processor'] != $existingData['processor']) {
			$processor = $decodedData['processor'];
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "processor = '$processor'";
		}
		if ($decodedData['processor_speed'] != $existingData['processor_speed']) {
			$processor_speed = $decodedData['processor_speed'];
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "processor_speed = '$processor_speed'";
		}
		if ($decodedData['device_condition'] != $existingData['device_condition']) {
			$device_condition = $decodedData['device_condition'];
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "device_condition = '$device_condition'";
		}
		if ($decodedData['auto_update_expiration'] != $existingData['auto_update_expiration']) {
			$auto_update_expiration = $decodedData['auto_update_expiration'];
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "auto_update_expiration = '$auto_update_expiration'";
		}

		if ($decodedData['touchscreen'] != $existingData['touchscreen']) {
			$touchscreen = $decodedData['touchscreen'];
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "touchscreen = $touchscreen";
		}

		if ($decodedData['dropship'] != $existingData['dropship']) {
			$dropship = $decodedData['dropship'];
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "dropship = $dropship";
		}

		if ($decodedData['limited_to_inventory'] != $existingData['limited_to_inventory']) {
			$limited_to_inventory = $decodedData['limited_to_inventory'];
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "limited_to_inventory = $limited_to_inventory";
		}

		if ($decodedData['active'] != $existingData['active']) {
			$active = $decodedData['active'];
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "active = '$active'";
		}

		if ($decodedData['special_order'] != $existingData['special_order']) {
			$specialOrder = $decodedData['special_order'];
			if (strlen($setClause) > 0) {
				$setClause .= ", ";
			}
			$setClause .= "special_order = '$specialOrder'";
		}

		$first_stock_zoho_id_individual = $decodedData['first_stock_zoho_id_individual'];
		$second_stock_zoho_id_individual = $decodedData['second_stock_zoho_id_individual'];
		$first_stock_zoho_id_tenpack = $decodedData['first_stock_zoho_id_tenpack'];
		$second_stock_zoho_id_tenpack = $decodedData['second_stock_zoho_id_tenpack'];
		$first_stock_shopify_product_id = $decodedData['first_stock_shopify_product_id'];
		$second_stock_shopify_product_id = $decodedData['second_stock_shopify_product_id'];
		$first_stock_shopify_variant_id = $decodedData['first_stock_shopify_variant_id'];
		$second_stock_shopify_variant_id = $decodedData['second_stock_shopify_variant_id'];

		// Perform price changes - only on prod mode
		if (MODE != 'DEV') {
			// Zoho price changes
			if ($first_stock_zoho_id_individual && $first_stock_pricing && $first_stock_zoho_id_individual != 'NULL' && $first_stock_pricing != 'NULL') {
				$record = $zohoObj->updateProductPrice($first_stock_zoho_id_individual, $first_stock_pricing);
			}
			if ($second_stock_zoho_id_individual && $second_stock_pricing && $second_stock_zoho_id_individual != 'NULL' && $second_stock_pricing != 'NULL') {
				$record = $zohoObj->updateProductPrice($second_stock_zoho_id_individual, $second_stock_pricing);
			}
			if ($first_stock_zoho_id_tenpack && $first_stock_ten_pack_pricing && $first_stock_zoho_id_tenpack != 'NULL' && $first_stock_ten_pack_pricing != 'NULL') {
				$record = $zohoObj->updateProductPrice($first_stock_zoho_id_tenpack, $first_stock_ten_pack_pricing);
			}
			if ($second_stock_zoho_id_tenpack && $second_stock_ten_pack_pricing && $second_stock_zoho_id_tenpack != 'NULL' && $second_stock_ten_pack_pricing != 'NULL') {
				$record = $zohoObj->updateProductPrice($second_stock_zoho_id_tenpack, $second_stock_ten_pack_pricing);
			}

			// Perform Shopify price changes
			if ($first_stock_shopify_variant_id && $first_stock_pricing && $first_stock_shopify_variant_id != 'NULL' && $first_stock_pricing != 'NULL') {
				if (strpos($first_stock_pricing, '.') === false) {
					$first_stock_pricing = $first_stock_pricing.'.00';
				}
				$this->updateShopifyPrice(array('variantId' => $first_stock_shopify_variant_id, 'price' => $first_stock_pricing));
			}
			if ($second_stock_shopify_variant_id && $second_stock_pricing && $second_stock_shopify_variant_id != 'NULL' && $second_stock_pricing != 'NULL') {
				if (strpos($second_stock_pricing, '.') === false) {
					$second_stock_pricing = $second_stock_pricing.'.00';
				}
				$this->updateShopifyPrice(array('variantId' => $second_stock_shopify_variant_id, 'price' => $second_stock_pricing));
			}
		}

		if (strlen($setClause) > 0) {
			$sql = "UPDATE machine_order_number SET $setClause, `enabled`='1' WHERE order_number_id = $onid;";
			$this->db_query($sql, 'update', true);
		}
		// Build ID update arrays
		$zohoIds = array(
			'machine_order_number_id' => $onid,
			'first_stock_zoho_id_individual' => $decodedData['first_stock_zoho_id_individual'] != '' ? '\''.$decodedData['first_stock_zoho_id_individual'].'\'' : 'NULL',
			'second_stock_zoho_id_individual' => $decodedData['second_stock_zoho_id_individual'] != '' ? '\''.$decodedData['second_stock_zoho_id_individual'].'\'' : 'NULL',
			'first_stock_zoho_id_tenpack' => $decodedData['first_stock_zoho_id_tenpack'] != '' ? '\''.$decodedData['first_stock_zoho_id_tenpack'].'\'' : 'NULL',
			'second_stock_zoho_id_tenpack' => $decodedData['second_stock_zoho_id_tenpack'] != '' ? '\''.$decodedData['second_stock_zoho_id_tenpack'].'\'' : 'NULL'
		);
		$shopifyIds = array(
			'machine_order_number_id' => $onid,
			'first_stock_shopify_product_id' => $decodedData['first_stock_shopify_product_id'] != '' ? '\''.$decodedData['first_stock_shopify_product_id'].'\'' : 'NULL',
			'second_stock_shopify_product_id' => $decodedData['second_stock_shopify_product_id'] != '' ? '\''.$decodedData['second_stock_shopify_product_id'].'\'' : 'NULL',
			'first_stock_shopify_variant_id' => $decodedData['first_stock_shopify_variant_id'] != '' ? '\''.$decodedData['first_stock_shopify_variant_id'].'\'' : 'NULL',
			'second_stock_shopify_variant_id' => $decodedData['second_stock_shopify_variant_id'] != '' ? '\''.$decodedData['second_stock_shopify_variant_id'].'\'' : 'NULL'
		);
		$shipping_box_types = $decodedData['shipping_box_type'];
		$shipping_box_devices_with_case = $decodedData['ship_box_devices_with_case'];
		$shipping_box_devices_without_case = $decodedData['ship_box_devices_without_case'];

		// Perform ID updates
		$this->updateZohoIds($zohoIds);
		$this->updateShopifyIds($shopifyIds);
		$this->updateShippingBoxes($onid, $shipping_box_types, $shipping_box_devices_with_case, $shipping_box_devices_without_case);
		if ($decodedData['ecomm_integration']) {
			$this->updateEcommIntegrationData($onid, $decodedData['ecomm_integration']);
		}


		if ($decodedData['configCodes'] != ""){
			$configCodes = explode(',',$decodedData['configCodes']);

			$this->db_delete('product_model', 'order_number_id', $decodedData['order_number_id']);

			foreach ($configCodes as $row){
				$this->db_insert('product_model', array('configCode' => trim($row), 'machine_id' => $decodedData['machine_id'], 'order_number_id' => $decodedData['order_number_id']));
			}
		}


		$oldOrderNumber = $existingData['order_number'];
		$newOrderNumber = $decodedData['order_number'];
		$oldMachineId = $existingData['machine_id'];
		$newMachineId = $decodedData['machine_id'];
		if ($oldMachineId != $newMachineId) {
			$this->updateDsOrdersMachineTypeBySku($oldOrderNumber, $oldMachineId, $newMachineId);
		}
		if ($oldOrderNumber && $newOrderNumber && $oldOrderNumber != $newOrderNumber) {
			$this->updateDsOrdersAsset($oldOrderNumber, $newOrderNumber);
		}
		$this->db_update('machine_order_number','order_number_id',$decodedData['order_number_id'],array('machine_id' => $decodedData['machine_id'], 'order_number' => $decodedData['order_number']));

		if ($decodedData['accessory']){
			$machine_accessories = $decodedData['accessory'];

			$this->db_delete('machine_order_number_accessories', 'order_number_id', $decodedData['order_number_id']);

			foreach ($machine_accessories as $k => $v){

				$this->db_insert('machine_order_number_accessories', array('order_number_id' => $decodedData['order_number_id'],'deduction_id' => $k));

			}
		}

		// echo print_r($decodedData);

		// header('Location: '. CONTROLLER . '?m=machine_database');
		exit;

	}

	function updateDsOrdersMachineTypeBySku($asset, $oldMachineId, $newMachineId) {
		// $oldMachineType = mysql_real_escape_string($this->getMachineDescriptionByMachineId($oldMachineId));
		$newMachineType = mysql_real_escape_string($this->getMachineDescriptionByMachineId($newMachineId));
		$sql = "UPDATE `ds_orders` SET `machineType`='$newMachineType' WHERE `asset`='$asset';";
		// echo "$sql\n";
		$this->db_query($sql, 'update', true);
	}

	function updateDsOrdersAsset($oldAsset, $newAsset) {
		$oldAsset = mysql_real_escape_string($oldAsset);
		$newAsset = mysql_real_escape_string($newAsset);
		$sql = "UPDATE `ds_orders` SET `asset`='$newAsset' WHERE `asset` IS NOT NULL AND `asset` != '' AND `asset`='$oldAsset';";
		// echo "$sql\n";
		$this->db_query($sql, 'update', true);
	}

	function getMachineDescriptionByMachineId($machineId) {
		$sql = "SELECT `machine_description` FROM `machine_lookup` WHERE `machine_id`='$machineId';";
		$result = $this->db_query($sql, 'select-single', true);
		return $result['machine_description'];
	}

	function getShippingBoxData($order_number_id) {
		global $executiveObj;
		return array(
			'box_types' => $executiveObj->getShippingBoxes(),
			'active_boxes' => $executiveObj->getOrderShippingBoxes($order_number_id)
		);
	}

	function updateShopifyPrice($data) {
		global $shopifyObj;
		return $shopifyObj->updateVariant($data['variantId'], array('price' => $data['price']));
	}

	function updateShippingBoxes($orderNumberId, $shippingBoxTypes, $shippingBoxDevicesWithCase, $shippingBoxDevicesWithoutCase) {
		$sql = "DELETE FROM machine_order_shipping_boxes WHERE machine_order_id = $orderNumberId;";
		$this->db_query($sql, 'delete', true);
		foreach($shippingBoxTypes as $index => $id) {
			echo "<p>$index</p>";
			$withoutCase = $shippingBoxDevicesWithoutCase[$index] != '' ? $shippingBoxDevicesWithoutCase[$index] : '0';
			$withCase = $shippingBoxDevicesWithCase[$index] != '' ? $shippingBoxDevicesWithCase[$index] : '0';
			echo "<p></p>";
			$sql = "INSERT INTO machine_order_shipping_boxes VALUES ($orderNumberId, $id, $withoutCase, $withCase) ON DUPLICATE KEY UPDATE `devices_per_box_without_case`=$withoutCase, `devices_per_box_with_case`=$withCase;";
			echo $sql;
			echo $this->db_query($sql, 'insert', true);
		}
		return true;
	}

	private function updateEcommIntegrationData($orderNumberId, $ecommIntegration) {
		$sql = "DELETE FROM machine_ecomm_ids WHERE order_number_id = $orderNumberId;";
		echo "$sql\n";
		$this->db_query($sql, 'delete', true);
		foreach($ecommIntegration as $channelName => $channelData) {
			foreach ($channelData as $conditionName => $conditionData) {
				$active = $conditionData['active'] == 'on' ? 1 : 0;
				$price = $conditionData['price'] ? $conditionData['price'] : 'NULL';
				$sku = $conditionData['sku'] ? "'".$conditionData['sku']."'" : 'NULL';
				$listing_id = $conditionData['listing_id'] ? "'".$conditionData['listing_id']."'" : 'NULL';
				$sql = "INSERT INTO machine_ecomm_ids(`order_number_id`, `condition_id`, `price`, `sku`, `listing_id`, `active`, `channel_identifier`) VALUES ($orderNumberId, (SELECT id FROM machine_conditions WHERE identifier = '$conditionName' LIMIT 1), $price, $sku, $listing_id, $active, '$channelName');";
				echo "$sql\n";
				$this->db_query($sql, 'insert', true);
			}
		}
	}

	function deleteSkuShipBox($orderNumberId, $shipBoxId)  {
		$sql = "DELETE FROM machine_order_shipping_boxes WHERE `machine_order_id`=$orderNumberId AND `shipping_box_id`=$shipBoxId";
		return $this->db_query($sql, 'delete', true);
	}

	function validateConfigCodesUnique($orderNumberId, $configCodes, $debug=false) {
		if ($_GET['debug']=='1') {
			$debug = true;
		}
		$configCodes = explode(',', $configCodes);
		$duplicates = array();
		foreach ($configCodes as $configCode) {
			$sql = '';
			if ($orderNumberId) {
				$sql = "SELECT mon.`order_number` FROM `product_model` AS pm LEFT JOIN `machine_order_number` AS mon ON pm.`order_number_id`=mon.`order_number_id` WHERE pm.`configCode`='$configCode' AND pm.`order_number_id`!='$orderNumberId' LIMIT 1;";
			}
			else {
				$sql = "SELECT mon.`order_number` FROM `product_model` AS pm LEFT JOIN `machine_order_number` AS mon ON pm.`order_number_id`=mon.`order_number_id` WHERE pm.`configCode`='$configCode' LIMIT 1;";
			}
			if ($debug) {
				echo "$sql\n";
			}
			$result = $this->db_query($sql, 'select-single', true);
			$orderNumber = $result['order_number'];
			if ($orderNumber) {
				if ($debug) {
					echo "Order number found with $configCode: $orderNumber\n";
				}
				$duplicates[$configCode] = $orderNumber;
			}
			else {
				if ($debug) {
					echo "No order number found with $configCode.\n";
				}
			}
		}
		if ($debug) {
			print_r($configCodes);
		}
		if (count($duplicates) > 0) {
			return $duplicates;
		}
		else {
			return false;
		}
	}

	function validateSkuUnique($orderNumberId, $sku) {
		$sql = '';
		if ($orderNumberId) {
			$sql = "SELECT `order_number_id` FROM `machine_order_number` WHERE `order_number`='$sku' AND `order_number_id`!='$orderNumberId' LIMIT 1;";
		}
		else {
			$sql = "SELECT `order_number_id` FROM `machine_order_number` WHERE `order_number`='$sku' LIMIT 1;";
		}
		$result = $this->db_query($sql, 'select-single', true);
		$foundOrderNumberId = $result['order_number_id'];
		if ($foundOrderNumberId) {
			$duplicate = new stdClass;
			$duplicate->found = $foundOrderNumberId;
			return $duplicate;
		}
		else {
			return false;
		}
	}

	function deleteSku($orderNumberId) {
		$sql = "DELETE FROM `machine_order_number` WHERE `order_number_id`='$orderNumberId';";
		$this->db_query($sql, 'delete');
		$sql = "DELETE FROM `product_model` WHERE `order_number_id`='$orderNumberId';";
		$this->db_query($sql, 'delete');
		$sql = "DELETE FROM `machine_order_number_accessories` WHERE `order_number_id`='$orderNumberId';";
		$this->db_query($sql, 'delete');
	}
}

?>
