<?php

require_once(HTML_FOLDER . "classes/PurchaseOrders/PurchaseOrdersController.php");
class Inventory extends Database {
	function inventoryPage($page="inventory", $view="") {
		$title = "";
		$page_heading = "";
		$currentPage = "";
		$asset_modal = file_get_contents('templates/inventory/asset_modal.html');
		$template = INVENTORY_PAGE;
		if ($page == "inventory") {
			$title = "TTS Inventory";
			$page_heading = "Tech to School Inventory";
		}
		if ($page == "picked_ecomm") {
			$title = "Source+ Inventory";
			$page_heading = "Source+ Inventory";
		}
		if ($page == "picked_ebay_auction") {
			$title = "eBay Auction Inventory";
			$page_heading = "eBay Auction Inventory";
		}
		if ($page == "picked_wholesale") {
			$title = "Wholesale Inventory";
			$page_heading = "Wholesale Inventory";
			if ($view == 'local') {
				$title = "Local Wholesale Inventory";
				$page_heading = "Local Wholesale Inventory";
			}
		}
		elseif ($page == "repair_queue") {
			$title = "Repair Queue";
			$page_heading = "Repair Queue";
		}
		elseif ($page == "locked_inventory") {
			$title = "Locked Items";
			$page_heading = "Locked Items";
			$template = LOCKED_INVENTORY_PAGE;
			$asset_modal = file_get_contents('templates/locked_inventory/asset_modal.html');
		}
		$templateElements = array(
			'MODAL' => $asset_modal,
			'PAGE_HEADING' => $page_heading,
			'CURRENT_PAGE' => $page
		);
		echo $this->parse(TEMPLATE, array('BODY' => $this->parse($template, $templateElements), "TITLE" => $title));
	}

	function getOrdersWithLockedInventoryItems() {
		$sql =
			"SELECT
				poo.order_id,
				dso.`poNumber` AS po_number,
				COUNT(CASE WHEN dso.`activation_lock` = 1 THEN 1 END) AS activation_lock_count,
				COUNT(CASE WHEN dso.`mdm_lock` = 1 THEN 1 END) AS mdm_lock_count,
				-- (SELECT MIN(dateMachineReceived) FROM ds_orders WHERE poNumber = po_number AND dateMachineReceived > '2019-01-01') AS earliest_received,
				-- (SELECT MAX(dateMachineReceived) FROM ds_orders WHERE poNumber = po_number AND dateMachineReceived > '2019-01-01') AS latest_received,
				poa.account_id,
				poa.`account_name`,
				poo.`date_received`
			FROM ds_orders AS dso
			LEFT JOIN po_orders AS poo ON dso.`poNumber` = poo.`order_number`
			LEFT JOIN po_accounts AS poa ON poo.`account_id` = poa.`account_id`
			WHERE
				dso.`dateMachineReceived` > '2019-05-01'
			AND
				dso.poNumber IS NOT NULL
			AND
				dso.poNumber != ''
			GROUP BY dso.poNumber
			HAVING activation_lock_count > 0 OR mdm_lock_count > 0
			ORDER BY dso.poNumber ASC;";
		$orders = $this->db_query($sql, 'select-multiple', true);
		$data = array(
			'query' => $sql,
			'orders' => $orders
		);
		return $data;
	}
	private function getEcommOpenOrderDemand() {
		$sql = "SELECT `sku`, mc.`identifier` AS `condition`, `machine_order_id`, `condition_id`, COUNT(`quantity`) AS quantity FROM ecomm_open_order_line_items AS eooli LEFT JOIN machine_conditions AS mc ON eooli.`condition_id` = mc.`id` LEFT JOIN `ecomm_open_orders` AS eoo ON eoo.`id`=eooli.`open_order_id` WHERE `machine_order_id` IS NOT NULL AND eoo.`open`='1' GROUP BY `sku`, `condition_id`;";
		$results = $this->db_query($sql, 'select-multiple', true);
		$demand = array();
		foreach ($results as $result) {
			$sku = $result['sku'];
			$machineOrderId = $result['machine_order_id'];
			$conditionId = $result['condition_id'];
			$condition = $result['condition'];
			$quantity = $result['quantity'];
			if (!is_array($demand[$machineOrderId])) {
				$demand[$machineOrderId] = array();
			}
			$demand[$machineOrderId][$condition] = array('quantity' => $quantity);
		}
		return $demand;
	}

	function getInventoryItems($page='inventory', $view='') {
		$validPages = array(
			'inventory',
			'locked_inventory',
			'repair_queue',
			'picked_ecomm',
			'picked_ebay_auction',
			'picked_wholesale'
		);
		if (!in_array($page, $validPages)) {
			$page = 'inventory';
		}
		if ($page == 'locked_inventory') {
			$data = $this->getOrdersWithLockedInventoryItems();
			return json_encode($data);
		}
		$clauses = $this->buildInventoryPageClauses($page, $view);

		$sql = "SELECT
			dso.asset
			,COUNT(CASE WHEN dso.cStatus {$clauses['searchStatus']} {$clauses['allCountGrade']} {$clauses['activation']} THEN 1 END) AS item_count
			,COUNT(CASE WHEN dso.grade {$clauses['aGradeCount']} AND dso.cStatus {$clauses['searchStatus']} {$clauses['activation']} THEN 1 END) AS a_grade_count
			,COUNT(CASE WHEN dso.grade {$clauses['bGradeCount']} AND dso.cStatus {$clauses['searchStatus']} {$clauses['activation']} THEN 1 END) AS b_grade_count
			,COUNT(CASE WHEN dso.grade {$clauses['cGradeCount']} AND dso.cStatus {$clauses['searchStatus']} {$clauses['activation']} THEN 1 END) AS c_grade_count
			,COUNT(CASE WHEN dso.grade LIKE '%D%' AND dso.cStatus {$clauses['searchStatus']} {$clauses['activation']} THEN 1 END) AS d_grade_count
			,COUNT(CASE WHEN dso.grade = 'F' AND dso.cStatus {$clauses['searchStatus']} {$clauses['activation']} THEN 1 END) AS f_grade_count
			,COUNT(CASE WHEN dso.marking = 1 AND dso.cStatus {$clauses['searchStatus']} {$clauses['activation']} AND dso.grade IN ('A', 'B', 'C') THEN 1 END) AS engraved_count
			{$clauses['pickedEcommClause']}
			{$clauses['activationLockedCount']}
			,mon.order_number_id
			,mon.ram
			,mon.storage
			,mon.first_stock_pricing
			,mon.second_stock_pricing
			,mon.first_stock_ten_pack_pricing
			,mon.second_stock_ten_pack_pricing
			,mon.limited_to_inventory
			,mon.color
			,mon.active AS tts_active
			,ml.machine_id
			,ml.machine_description
			,ml.processor AS ml_processor
			,ml.processor_speed AS ml_processor_speed
			,mon.processor AS mon_processor
			,mon.processor_speed AS mon_processor_speed
			,mon.device_condition AS device_condition
			,mon.touchscreen AS touchscreen
			,mon.auto_update_expiration
			,ml.upgradeable
			,ml.latest_os
			,mzi.first_stock_zoho_id_individual
			,mzi.second_stock_zoho_id_individual
			,mzi.first_stock_zoho_id_tenpack
			,mzi.second_stock_zoho_id_tenpack
			,msi.first_stock_inventory_item_id
			,msi.second_stock_inventory_item_id
			,IFNULL((SELECT SUM(ooli.quantity) FROM open_order_line_items AS ooli WHERE line_item_id = (SELECT id FROM order_line_items WHERE zoho_id = mzi.first_stock_zoho_id_individual) GROUP BY ooli.line_item_id),0) + (IFNULL((SELECT SUM(ooli.quantity) FROM open_order_line_items AS ooli WHERE line_item_id = (SELECT id FROM order_line_items WHERE zoho_id = mzi.first_stock_zoho_id_tenpack) GROUP BY ooli.line_item_id), 0) * 10) AS first_stock_demand
			,IFNULL((SELECT SUM(ooli.quantity) FROM open_order_line_items AS ooli WHERE line_item_id = (SELECT id FROM order_line_items WHERE zoho_id = mzi.second_stock_zoho_id_individual) GROUP BY ooli.line_item_id),0) + (IFNULL((SELECT SUM(ooli.quantity) FROM open_order_line_items AS ooli WHERE line_item_id = (SELECT id FROM order_line_items WHERE zoho_id = mzi.second_stock_zoho_id_tenpack) GROUP BY ooli.line_item_id), 0) * 10) AS second_stock_demand
			FROM ds_orders AS dso
			LEFT JOIN machine_order_number AS mon ON dso.asset = mon.order_number
			LEFT JOIN machine_lookup AS ml ON ml.machine_id = mon.machine_id
			LEFT JOIN machine_zoho_ids AS mzi ON mzi.machine_order_number_id = mon.order_number_id
			LEFT JOIN machine_shopify_ids AS msi ON msi.machine_order_number_id = mon.order_number_id
			WHERE dso.dateMachineReceived > '2020-05-01'
				AND dso.asset IS NOT NULL
				AND dso.oNum LIKE 'SP%'
				{$clauses['activation']}
			GROUP BY dso.asset
			{$clauses['having']}
			ORDER BY item_count DESC;";


		$metadata = new stdClass;
		$metadata->query = $sql;
		$items = $this->db_query($sql, 'select-multiple', true);
		$inboundItems = self::getInboundLineItems();
		$realItems = array();

		foreach($items as $item) {
			$item['inbound'] = 0;
			foreach ($inboundItems as $inboundItem) {
				$zohoId = $inboundItem->getZohoId();
				$quantity = (int)$inboundItem->getQuantity();
				if ($zohoId == $item['first_stock_zoho_id_individual'] || $zohoId == $item['second_stock_zoho_id_individual']) {
					$item['inbound'] += $quantity;
				}
				elseif ($zohoId == $item['first_stock_zoho_id_tenpack'] || $zohoId == $item['second_stock_zoho_id_tenpack']) {
					$item['inbound'] += $quantity * 10;
				}
			}
			array_push($realItems, $item);
		}

		$data = array(
			'items' => $realItems,
			'statuses' => $this->getAllStatuses(),
			'metadata' => $metadata
		);
		if (/*$page == 'picked_ecomm' ||*/ $page == 'picked_wholesale' || $page == 'repair_queue' || $page == 'picked_ebay_auction') {
			if ($page == 'picked_ebay_auction') {
				$avgStatus = "= '".STATUS_PICKED_EBAY."'";
			}
			// $assets = array();
			// for ($i=0; $i < count($items); $i++) {
			// 	$assetNum = $this->getRealSku($items[$i]['asset']);
			// 	if (!in_array($assetNum, $assets)) {
			// 		array_push($assets, $assetNum);
			// 	}
			// }
			// if ($page == 'picked_ecomm') {
			// 	if ($view == '') {
			// 		$pickedEcommRenewed = STATUS_PICKED_ECOMM_RENEWED;
			// 		$pickedEcommCertified = STATUS_PICKED_ECOMM_CERTIFIED;
			// 		$pickedEcommScratchDent = STATUS_PICKED_ECOMM_SCRATCHDENT;
			// 		$avgStatus = "IN ('$pickedEcommRenewed', '$pickedEcommCertified', '$pickedEcommScratchDent')";
			// 	}
			// 	elseif($view == 'ebay') {
			// 		$avgStatus = "= '".STATUS_PICKED_EBAY."'";
			// 	}
			// }
			elseif ($page == 'picked_wholesale') {
				$avgStatus = "= '".STATUS_PICKED_WHOLESALE."'";
				if ($view == 'local') {
					$avgStatus = "= '".STATUS_PICKED_WHOLESALE_LOCAL."'";
				}
			}
			elseif ($page == 'repair_queue') {
				$avgStatus = "LIKE 'Refurb - Need Rep%'";
			}
			$data['average_costs'] = $this->getAverageCosts($avgStatus);
			$data['got_averages'] = true;
		}
		if ($page == 'picked_ecomm') {
			$data['average_ecomm_prices'] = $this->getAverageEcommPrices();
			$data['active_ecomm_channels'] = $this->getActiveEcommChannels();
			$data['demand'] = $this->getEcommOpenOrderDemand();
		}
		return json_encode($data);
	}

	function getShopifyVariantInventoryCounts($items) {
		$inventoryNums = array();
		foreach ($items as $item) {
			if ($item['first_stock_inventory_item_id'] || $item['second_stock_inventory_item_id']) {
				$first_stock_inventory_item_id = $item['first_stock_inventory_item_id'];
				$second_stock_inventory_item_id = $item['second_stock_inventory_item_id'];
				$first_stock_count = max((int)$item['first_stock_count'] - (int)$item['first_stock_demand'], 0);
				$second_stock_count = max((int)$item['second_stock_count'] - (int)$item['second_stock_demand'], 0);
				if ($first_stock_inventory_item_id && $first_stock_inventory_item_id != '') {
					array_push($inventoryNums, array('inventory_item_id' => (int)$first_stock_inventory_item_id, 'available' => (int)$first_stock_count));
				}
				if ($second_stock_inventory_item_id && $second_stock_inventory_item_id != '') {
					array_push($inventoryNums, array('inventory_item_id' => (int)$second_stock_inventory_item_id, 'available' => (int)$second_stock_count));
				}
			}
		}
		return $inventoryNums;
	}

	function updateShopifyInventory($timeDelay=0.4) {
		global $shopifyObj;
		$timeDelayMicroseconds = $timeDelay * 1000000;
		$sql =
			"SELECT
			COUNT(CASE WHEN dso.grade IN ('A', 'B') AND dso.cStatus = 'Refurb - In Process' AND (dso.activation_lock = 0 OR dso.activation_lock IS NULL) AND (dso.mdm_lock = 0 OR dso.mdm_lock IS NULL) THEN 1 END) AS first_stock_count
			,COUNT(CASE WHEN dso.grade = 'C' AND dso.cStatus = 'Refurb - In Process' AND (dso.activation_lock = 0 OR dso.activation_lock IS NULL) AND (dso.mdm_lock = 0 OR dso.mdm_lock IS NULL) THEN 1 END) AS second_stock_count
			,msi.first_stock_inventory_item_id
			,msi.second_stock_inventory_item_id
			,IFNULL((SELECT SUM(ooli.quantity) FROM open_order_line_items AS ooli WHERE line_item_id = (SELECT id FROM order_line_items WHERE zoho_id = mzi.first_stock_zoho_id_individual) GROUP BY ooli.line_item_id),0) + (IFNULL((SELECT SUM(ooli.quantity) FROM open_order_line_items AS ooli WHERE line_item_id = (SELECT id FROM order_line_items WHERE zoho_id = mzi.first_stock_zoho_id_tenpack) GROUP BY ooli.line_item_id), 0) * 10) AS first_stock_demand
			,IFNULL((SELECT SUM(ooli.quantity) FROM open_order_line_items AS ooli WHERE line_item_id = (SELECT id FROM order_line_items WHERE zoho_id = mzi.second_stock_zoho_id_individual) GROUP BY ooli.line_item_id),0) + (IFNULL((SELECT SUM(ooli.quantity) FROM open_order_line_items AS ooli WHERE line_item_id = (SELECT id FROM order_line_items WHERE zoho_id = mzi.second_stock_zoho_id_tenpack) GROUP BY ooli.line_item_id), 0) * 10) AS second_stock_demand
			FROM ds_orders AS dso
			LEFT JOIN machine_order_number AS mon ON dso.asset = mon.order_number
			LEFT JOIN machine_lookup AS ml ON ml.machine_id = mon.machine_id
			LEFT JOIN machine_zoho_ids AS mzi ON mzi.machine_order_number_id = mon.order_number_id
			LEFT JOIN machine_shopify_ids AS msi ON msi.machine_order_number_id = mon.order_number_id
			WHERE dso.dateMachineReceived > '2020-05-01'
				AND dso.asset IS NOT NULL
				AND dso.oNum LIKE 'SP%'
				AND (dso.activation_lock = 0 OR dso.activation_lock IS NULL) AND (dso.mdm_lock = 0 OR dso.mdm_lock IS NULL)
				AND (msi.first_stock_inventory_item_id IS NOT NULL OR msi.second_stock_inventory_item_id IS NOT NULL)
			GROUP BY dso.asset;";
		$items = $this->db_query($sql, 'select-multiple', true);
		$inventoryNums = $this->getShopifyVariantInventoryCounts($items);
		$inventoryUpdateResults = array();
		foreach ($inventoryNums as $inventory) {
			$result = $shopifyObj->updateInventoryLevel($inventory);
			array_push($inventoryUpdateResults, $result);
			usleep($timeDelayMicroseconds);
		}
		return $inventoryUpdateResults;
	}

	function buildInventoryPageClauses($page, $view) {
		if ($page == 'inventory') {
			$searchStatus = "= 'Refurb - In Process'";
			$activationClause = "AND (dso.activation_lock = 0 OR dso.activation_lock IS NULL) AND (dso.mdm_lock = 0 OR dso.mdm_lock IS NULL)";
			$allCountGradeClause = "AND dso.grade != 'F' AND dso.grade NOT LIKE '%D%'";
			$activationLockedCountClause = "";
			$havingClause = "";
			$aGradeCountClause = "= 'A'";
			$bGradeCountClause = "= 'B'";
			$cGradeCountClause = "= 'C'";
		}
		if ($page == 'picked_ecomm') {
			if ($view == '') {
				$searchStatus = "IN ('".STATUS_PICKED_ECOMM_RENEWED."', '".STATUS_PICKED_ECOMM_CERTIFIED."', '".STATUS_PICKED_ECOMM_SCRATCHDENT."')";
				$pickedEcommClause =  ",COUNT(CASE WHEN dso.cStatus = '".STATUS_PICKED_ECOMM_RENEWED."' THEN 1 END) AS renewed_count
				,COUNT(CASE WHEN dso.cStatus = '".STATUS_PICKED_ECOMM_CERTIFIED."' THEN 1 END) AS certified_count
				,COUNT(CASE WHEN dso.cStatus = '".STATUS_PICKED_ECOMM_SCRATCHDENT."' THEN 1 END) AS scratchdent_count";
			}
			elseif($view == 'ebay') {
				$searchStatus = "= '".STATUS_PICKED_EBAY."'";
			}
			$activationClause = "";
			$allCountGradeClause = "";
			$activationLockedCountClause = "";
			$havingClause = "HAVING item_count > 0";
			$aGradeCountClause = "LIKE 'A%'";
			$bGradeCountClause = "LIKE 'B%'";
			$cGradeCountClause = "LIKE 'C%'";
		}
		if ($page == 'picked_ebay_auction') {
			$searchStatus = "= '".STATUS_PICKED_EBAY."'";
			$activationClause = "";
			$allCountGradeClause = "";
			$activationLockedCountClause = "";
			$havingClause = "HAVING item_count > 0";
			$aGradeCountClause = "LIKE 'A%'";
			$bGradeCountClause = "LIKE 'B%'";
			$cGradeCountClause = "LIKE 'C%'";
		}
		if ($page == 'picked_wholesale') {
			$searchStatus = "= '".STATUS_PICKED_WHOLESALE."'";
			if ($view == 'local') {
				$searchStatus = "= '".STATUS_PICKED_WHOLESALE_LOCAL."'";
			}
			$activationClause = "";
			$allCountGradeClause = "";
			$activationLockedCountClause = "";
			$havingClause = "HAVING item_count > 0";
			$aGradeCountClause = "LIKE 'A%'";
			$bGradeCountClause = "LIKE 'B%'";
			$cGradeCountClause = "LIKE 'C%'";
		}
		elseif ($page == 'repair_queue') {
			$searchStatus = "LIKE 'Refurb - Need Rep%'";
			$activationClause = "";
			$allCountGradeClause = "";
			$activationLockedCountClause = ",COUNT(CASE WHEN dso.cStatus $searchStatus AND dso.activation_lock = 1 THEN 1 END) AS activation_lock_count, COUNT(CASE WHEN dso.cStatus $searchStatus AND dso.mdm_lock = 1 THEN 1 END) AS mdm_lock_count";
			$havingClause = "HAVING item_count > 0";
			$aGradeCountClause = "LIKE 'A%'";
			$bGradeCountClause = "LIKE 'B%'";
			$cGradeCountClause = "LIKE 'C%'";
		}
		elseif ($page == 'locked_inventory') {
			$searchStatus = "IN ('".STATUS_REFURB_PROCESS."', '".STATUS_REFURB_NEED_REPAIR."', '".STATUS_REFURB_NEED_REPAIR_IPAD."')";
			$activationClause = "AND (dso.activation_lock = 1 OR dso.mdm_lock = 1) AND (dso.activation_lock IS NOT NULL AND dso.mdm_lock IS NOT NULL)";
			$allCountGradeClause = "";
			$activationLockedCountClause = ",COUNT(CASE WHEN dso.cStatus $searchStatus AND dso.activation_lock = 1 THEN 1 END) AS activation_lock_count, COUNT(CASE WHEN dso.cStatus $searchStatus AND dso.mdm_lock = 1 THEN 1 END) AS mdm_lock_count";
			$havingClause = "HAVING item_count > 0";
			$aGradeCountClause = "LIKE 'A%'";
			$bGradeCountClause = "LIKE 'B%'";
			$cGradeCountClause = "LIKE 'C%'";
		}
		return array(
			'searchStatus' => $searchStatus,
			'activation' => $activationClause,
			'allCountGrade' => $allCountGradeClause,
			'activationLockedCount' => $activationLockedCountClause,
			'aGradeCount' => $aGradeCountClause,
			'bGradeCount' => $bGradeCountClause,
			'cGradeCount' => $cGradeCountClause,
			'having' => $havingClause,
			'pickedEcommClause' => $pickedEcommClause ? $pickedEcommClause : ''
		);
	}

	function getItemData($assetNumber, $grade="all", $page="inventory", $view='') {
		$clauses = $this->buildAssetModalClauses($grade, $page, $view);
		$sql = "SELECT
					dso.oNum, dso.dateMachineReceived, dso.grade, dso.cStatus, dso.marking
				FROM ds_orders AS dso
				WHERE dso.asset = '$assetNumber'
					{$clauses['grade']}
					AND dso.cStatus {$clauses['status']}
					AND dso.dateMachineReceived > '2020-05-01'
					{$clauses['activation']}
				ORDER BY dso.oNum ASC;";
		$items = $this->db_query($sql, 'select-multiple', true);
		$data = array(
			'items' => $items,
			'query' => $sql
		);
		echo json_encode($data);
	}

	function getLockedItemData($poNumber, $grade="all") {
		$lockClause = '';
		if ($grade == 'all') {
			$lockClause = "(dso.`mdm_lock` = 1 OR dso.`activation_lock` = 1)";
		}
		else if ($grade == 'activation') {
			$lockClause = "dso.`activation_lock` = 1";
		}
		else if ($grade == 'mdm') {
			$lockClause = "dso.`mdm_lock` = 1";
		}
		$sql =
			"SELECT
				dso.`serialNumber`,
				dso.`oNum`,
				dso.`grade`,
				dso.`dateMachineReceived`,
				dso.`mdm_lock`,
				dso.`activation_lock`,
				dso.`cStatus`
			FROM ds_orders AS dso
			WHERE dso.poNumber = '$poNumber'
			AND $lockClause";
		$data = $this->db_query($sql, 'select-multiple', true);
		return json_encode($data);
	}

	function buildAssetModalClauses($grade, $page, $view) {
		// Set status clause and activation clauses
		if ($page == 'inventory') {
			$statusClause = "= 'Refurb - In Process'";
			$activationClause = "AND (dso.activation_lock = 0 OR dso.activation_lock IS NULL) AND (dso.mdm_lock = 0 OR dso.mdm_lock IS NULL)";
		}
		elseif($page == 'repair_queue') {
			$statusClause = "LIKE 'Refurb - Need Rep%'";
			$activationClause = "";
		}
		elseif($page == 'locked_inventory') {
			$statusClause = "IN ('".STATUS_REFURB_PROCESS."', '".STATUS_REFURB_NEED_REPAIR."', '".STATUS_REFURB_NEED_REPAIR_IPAD."')";
			$activationClause = "AND (dso.activation_lock = 1 OR dso.mdm_lock = 1) AND (dso.activation_lock IS NOT NULL AND dso.mdm_lock IS NOT NULL)";
		}
		elseif ($page == 'picked_ecomm') {
			if ($grade == 'renewed') {
				$statusClause = "= '".STATUS_PICKED_ECOMM_RENEWED."'";
			}
			elseif ($grade == 'certified') {
				$statusClause = "= '".STATUS_PICKED_ECOMM_CERTIFIED."'";
			}
			elseif ($grade == 'scratchdent') {
				$statusClause = "= '".STATUS_PICKED_ECOMM_SCRATCHDENT."'";
			}
			$activationClause = "AND (dso.activation_lock = 0 OR dso.activation_lock IS NULL) AND (dso.mdm_lock = 0 OR dso.mdm_lock IS NULL)";
		}
		elseif ($page == 'picked_ebay_auction') {
			$statusClause = "= '".STATUS_PICKED_EBAY."'";
			$activationClause = "AND (dso.activation_lock = 0 OR dso.activation_lock IS NULL) AND (dso.mdm_lock = 0 OR dso.mdm_lock IS NULL)";
		}
		elseif ($page == 'picked_wholesale') {
			$statusClause = "= '".STATUS_PICKED_WHOLESALE."'";
			if($view == 'local') {
				$statusClause = "= '".STATUS_PICKED_WHOLESALE_LOCAL."'";
			}
			$activationClause = "AND (dso.activation_lock = 0 OR dso.activation_lock IS NULL) AND (dso.mdm_lock = 0 OR dso.mdm_lock IS NULL)";
		}

		// Set grade clause
		if ($grade == "all") {
			if ($page == 'inventory') {
				$gradeClause = "AND dso.grade IN ('A', 'B', 'C')";
			}
			elseif($page == 'repair_queue' || $page == 'locked_inventory' || 'picked_wholesale') {
				$gradeClause = "AND (dso.grade LIKE 'A%' OR dso.grade LIKE 'B%' OR dso.grade LIKE 'C%' OR dso.grade = 'F')";
			}
		} elseif ($grade == "first") {
			if ($page == 'inventory') {
				$gradeClause = "AND dso.grade IN ('A', 'B')";
			}
			elseif($page == 'repair_queue' || $page == 'locked_inventory' || 'picked_wholesale') {
				$gradeClause = "AND (dso.grade LIKE 'A%' OR dso.grade LIKE 'B%')";
			}
		} elseif ($grade == "second") {
			if ($page == 'inventory') {
				$gradeClause = "AND dso.grade = 'C'";
			}
			elseif($page == 'repair_queue' || $page == 'locked_inventory' || 'picked_wholesale') {
				$gradeClause = "AND dso.grade LIKE 'C%'";
			}
		} elseif ($grade == "engraved") {
			$gradeClause = "AND ('A', 'B', 'C') AND dso.marking = 1";
		}
		elseif ($grade == "activation" || $grade == "mdm") {
			$gradeClause = "AND (dso.grade LIKE 'A%' OR dso.grade LIKE 'B%' OR dso.grade LIKE 'C%' OR dso.grade = 'F')";
			if ($grade == "activation") {
				$activationClause = "AND dso.activation_lock AND dso.activation_lock IS NOT NULL";
			}
			elseif ($grade == "mdm") {
				$activationClause = "AND dso.mdm_lock AND dso.mdm_lock IS NOT NULL";
			}
		}

		return array(
			'grade' => $gradeClause,
			'status' => $statusClause,
			'activation' => $activationClause
		);
	}

	function getAllStatuses() {
		global $order_statii;
		return array_keys($order_statii);
	}

	function setNewStatuses($postData) {
		foreach ($postData as $key => $value) {
			$data[str_replace('_', ' ', $this->decodeSanitizedString($key))] = explode(',',$value);
		}
		$whereClause = "WHERE oNum IN (";
		$setClause = "(CASE";
		$i = 0;
		foreach ($data as $k => $v) {
			$vals = implode("', '", $v);
			if ($i) {
				// $setClause .= ' ';
				$whereClause .= ', ';
			}
			$setClause .= " WHEN oNum IN ('$vals') THEN '$k'";
			$whereClause .= "'$vals'";
			$i++;
		}
		$setClause .= " END)";
		$whereClause .= ")";

		$sql = "UPDATE ds_orders SET cStatus = $setClause $whereClause;";
		// echo $sql;
		$return = $this->db_query($sql, 'update', true);
		echo $return;
	}

	function generateAverageSelectClause($asset, $status) {
		return "ROUND(
			(
				(SELECT AVG(price_a) FROM po_items WHERE order_number = '$asset' GROUP BY order_number) * IFNULL((SELECT COUNT(dso.`oID`) FROM ds_orders AS dso WHERE dso.cStatus $status AND dso.`grade` = 'A' AND dso.`asset` LIKE '$asset%' GROUP BY CASE WHEN dso.asset LIKE '$asset%' THEN '$asset' ELSE NULL END), 0)
				+
				(SELECT AVG(price_b) FROM po_items WHERE order_number = '$asset' GROUP BY order_number) * IFNULL((SELECT COUNT(dso.`oID`) FROM ds_orders AS dso WHERE dso.cStatus $status AND dso.`grade` = 'B' AND dso.`asset` LIKE '$asset%' GROUP BY CASE WHEN dso.asset LIKE '$asset%' THEN '$asset' ELSE NULL END), 0)
				+
				(SELECT AVG(price_c) FROM po_items WHERE order_number = '$asset' GROUP BY order_number) * IFNULL((SELECT COUNT(dso.`oID`) FROM ds_orders AS dso WHERE dso.cStatus $status AND dso.`grade` = 'C' AND dso.`asset` LIKE '$asset%' GROUP BY CASE WHEN dso.asset LIKE '$asset%' THEN '$asset' ELSE NULL END), 0)
				+
				(SELECT AVG(price_d) FROM po_items WHERE order_number = '$asset' GROUP BY order_number) * IFNULL((SELECT COUNT(dso.`oID`) FROM ds_orders AS dso WHERE dso.cStatus $status AND dso.`grade` LIKE '_D' AND dso.`asset` LIKE '$asset%' GROUP BY CASE WHEN dso.asset LIKE '$asset%' THEN '$asset' ELSE NULL END), 0)
				+
				(SELECT AVG(price_f) FROM po_items WHERE order_number = '$asset' GROUP BY order_number) * IFNULL((SELECT COUNT(dso.`oID`) FROM ds_orders AS dso WHERE dso.cStatus $status AND dso.`grade` = 'F' AND dso.`asset` LIKE '$asset%' GROUP BY CASE WHEN dso.asset LIKE '$asset%' THEN '$asset' ELSE NULL END), 0)
			)
			/
			(
				IFNULL((SELECT COUNT(dso.`oID`) FROM ds_orders AS dso WHERE dso.cStatus $status AND dso.`grade` = 'A' AND dso.`asset` LIKE '$asset%' GROUP BY CASE WHEN dso.asset LIKE '$asset%' THEN '$asset' ELSE NULL END), 0)
				+
				IFNULL((SELECT COUNT(dso.`oID`) FROM ds_orders AS dso WHERE dso.cStatus $status AND dso.`grade` = 'B' AND dso.`asset` LIKE '$asset%' GROUP BY CASE WHEN dso.asset LIKE '$asset%' THEN '$asset' ELSE NULL END), 0)
				+
				IFNULL((SELECT COUNT(dso.`oID`) FROM ds_orders AS dso WHERE dso.cStatus $status AND dso.`grade` = 'C' AND dso.`asset` LIKE '$asset%' GROUP BY CASE WHEN dso.asset LIKE '$asset%' THEN '$asset' ELSE NULL END), 0)
				+
				IFNULL((SELECT COUNT(dso.`oID`) FROM ds_orders AS dso WHERE dso.cStatus $status AND dso.`grade` LIKE '_D' AND dso.`asset` LIKE '$asset%' GROUP BY CASE WHEN dso.asset LIKE '$asset%' THEN '$asset' ELSE NULL END), 0)
				+
				IFNULL((SELECT COUNT(dso.`oID`) FROM ds_orders AS dso WHERE dso.cStatus $status AND dso.`grade` = 'F' AND dso.`asset` LIKE '$asset%' GROUP BY CASE WHEN dso.asset LIKE '$asset%' THEN '$asset' ELSE NULL END), 0)
			)
		) AS '$asset'";
	}

	function getAverageEcommPrices() {
		$sql = "SELECT
				mon.order_number_id,
				mon.order_number,
				AVG(mei.price) AS renewed_avg
			FROM machine_order_number AS mon
			LEFT JOIN machine_ecomm_ids AS mei ON mon.order_number_id = mei.order_number_id
			WHERE mei.active = 1
			AND mei.`condition_id` = 1
			GROUP BY mon.order_number_id;";
		$renewed = $this->db_query($sql, 'select-multiple', true);
		$sql = "SELECT
				mon.order_number_id,
				mon.order_number,
				AVG(mei.price) AS certified_avg
			FROM machine_order_number AS mon
			LEFT JOIN machine_ecomm_ids AS mei ON mon.order_number_id = mei.order_number_id
			WHERE mei.active = 1
			AND mei.`condition_id` = 2
			GROUP BY mon.order_number_id;";
		$certified = $this->db_query($sql, 'select-multiple', true);
		$sql = "SELECT
				mon.order_number_id,
				mon.order_number,
				AVG(mei.price) AS scratchdent_avg
			FROM machine_order_number AS mon
			LEFT JOIN machine_ecomm_ids AS mei ON mon.order_number_id = mei.order_number_id
			WHERE mei.active = 1
			AND mei.`condition_id` = 3
			GROUP BY mon.order_number_id;";
		$scratchdent = $this->db_query($sql, 'select-multiple', true);
		$averages = array();
		foreach ($renewed as $item) {
			if (!$averages[$item['order_number_id']]) {
				$averages[$item['order_number_id']] = array();
			}
			$averages[$item['order_number_id']]['renewed_price'] = $item['renewed_avg'];
		}
		foreach ($certified as $item) {
			if (!$averages[$item['order_number_id']]) {
				$averages[$item['order_number_id']] = array();
			}
			$averages[$item['order_number_id']]['certified_price'] = $item['certified_avg'];
		}
		foreach ($scratchdent as $item) {
			if (!$averages[$item['order_number_id']]) {
				$averages[$item['order_number_id']] = array();
			}
			$averages[$item['order_number_id']]['scratchdent_price'] = $item['scratchdent_avg'];
		}
		// $averages = array(
		// 	'renewed' => $renewed,
		// 	'certified' => $certified,
		// 	'scratchdent' => $scratchdent,
		// 	'combined' => $combined
		// );
		return $averages;
	}

	function getActiveEcommChannels() {
		$sql = "SELECT mon.order_number_id,
					(SELECT `active` FROM machine_ecomm_ids WHERE `order_number_id` = mon.`order_number_id` AND `channel_identifier` = 'amazon' AND `condition_id` = 1) AS amazon_renewed_active,
					(SELECT `active` FROM machine_ecomm_ids WHERE `order_number_id` = mon.`order_number_id` AND `channel_identifier` = 'backmarket' AND `condition_id` = 1) AS backmarket_renewed_active,
					(SELECT `active` FROM machine_ecomm_ids WHERE `order_number_id` = mon.`order_number_id` AND `channel_identifier` = 'backmarket' AND `condition_id` = 2) AS backmarket_certified_active,
					(SELECT `active` FROM machine_ecomm_ids WHERE `order_number_id` = mon.`order_number_id` AND `channel_identifier` = 'ebay' AND `condition_id` = 2) AS ebay_certified_active,
					(SELECT `active` FROM machine_ecomm_ids WHERE `order_number_id` = mon.`order_number_id` AND `channel_identifier` = 'newegg' AND `condition_id` = 2) AS newegg_certified_active,
					(SELECT `active` FROM machine_ecomm_ids WHERE `order_number_id` = mon.`order_number_id` AND `channel_identifier` = 'backmarket' AND `condition_id` = 3) AS backmarket_scratchdent_active,
					(SELECT `active` FROM machine_ecomm_ids WHERE `order_number_id` = mon.`order_number_id` AND `channel_identifier` = 'ebay' AND `condition_id` = 3) AS ebay_scratchdent_active,
					(SELECT `active` FROM machine_ecomm_ids WHERE `order_number_id` = mon.`order_number_id` AND `channel_identifier` = 'newegg' AND `condition_id` = 3) AS newegg_scratchdent_active
				FROM `machine_order_number` AS mon
				LEFT JOIN `machine_ecomm_ids` AS mei ON mon.`order_number_id` = mei.`order_number_id`
				ORDER BY order_number_id ASC;";
		$data = $this->db_query($sql, 'select-multiple', true);
		$channels = array();
		foreach ($data as $datum) {
			if ($datum['amazon_renewed_active'] != NULL ||
				$datum['backmarket_renewed_active'] != NULL ||
				$datum['backmarket_certified_active'] != NULL ||
				$datum['ebay_certified_active'] != NULL ||
				$datum['newegg_certified_active'] != NULL ||
				$datum['backmarket_scratchdent_active'] != NULL ||
				$datum['ebay_scratchdent_active'] != NULL ||
				$datum['newegg_scratchdent_active'] != NULL
			) {
				$orderNumberId = $datum['order_number_id'];
				if (!$channels[$orderNumberId]) {
					$channels[$orderNumberId] = array();
				}
				if (!$channels[$orderNumberId]['renewed']) {
					$channels[$orderNumberId]['renewed'] = array();
				}
				if (!$channels[$orderNumberId]['certified']) {
					$channels[$orderNumberId]['certified'] = array();
				}
				if (!$channels[$orderNumberId]['scratchdent']) {
					$channels[$orderNumberId]['scratchdent'] = array();
				}
				$channels[$orderNumberId]['renewed']['amazon'] = $datum['amazon_renewed_active'];
				$channels[$orderNumberId]['renewed']['backmarket'] = $datum['backmarket_renewed_active'];
				$channels[$orderNumberId]['certified']['backmarket'] = $datum['backmarket_certified_active'];
				$channels[$orderNumberId]['certified']['ebay'] = $datum['ebay_certified_active'];
				$channels[$orderNumberId]['certified']['newegg'] = $datum['newegg_certified_active'];
				$channels[$orderNumberId]['scratchdent']['backmarket'] = $datum['backmarket_scratchdent_active'];
				$channels[$orderNumberId]['scratchdent']['ebay'] = $datum['ebay_scratchdent_active'];
				$channels[$orderNumberId]['scratchdent']['newegg'] = $datum['newegg_scratchdent_active'];
			}
		}
		return $channels;
	}

	public function getItemCountByBackMarketListingId($listingId) {
		$sku = $this->getSkuFromBackMarketListingId($listingId);
		$statusName = $this->getConditionStatusNameFromBackMarketListingId($listingId);
		if ($sku) {
			return $this->getItemCountBySku($sku, $statusName);
		}
		else {
			return 0;
		}
	}

	public function getSkuFromBackMarketListingId($listingId) {
		$sql = "SELECT mon.`order_number` FROM machine_order_number AS mon LEFT JOIN `machine_ecomm_ids` AS mei ON mon.`order_number_id` = mei.`order_number_id` WHERE mei.`listing_id` = '$listingId' AND mei.`channel_identifier` = 'backmarket' LIMIT 1;";
		$result = $this->db_query($sql, 'select-single', true);
		return $result['order_number'];
	}

	public function getConditionStatusNameFromBackMarketListingId($listingId) {
		$sql = "SELECT mc.`status_name` FROM machine_conditions AS mc LEFT JOIN `machine_ecomm_ids` AS mei ON mei.`condition_id` = mc.`id` WHERE mei.`listing_id` = '$listingId' AND mei.`channel_identifier` = 'backmarket' LIMIT 1;";
		$result = $this->db_query($sql, 'select-single', true);
		return $result['status_name'];

	}

	public function getItemCountBySku($sku, $statusName) {
		$sql = " SELECT
					dso.asset
					,COUNT(CASE WHEN dso.cStatus = '$statusName' AND (dso.activation_lock = 0 OR dso.activation_lock IS NULL) AND (dso.mdm_lock = 0 OR dso.mdm_lock IS NULL) THEN 1 END) AS item_count
					FROM ds_orders AS dso
					WHERE dso.dateMachineReceived > '2020-05-01'
						AND dso.asset = '$sku'
						AND dso.oNum LIKE 'SP%'
						AND dso.asset IS NOT NULL
					GROUP BY dso.asset
					ORDER BY item_count DESC;";
		$result = $this->db_query($sql, 'select-single', true);
		return (int)$result['item_count'];
	}

	function getAverageCosts($status) {
		$sql = "SELECT
			dso.asset,
			dso.poNumber,
			dso.grade_at_audit,
			COUNT(dso.oID) AS item_count,
			IFNULL(
				(SELECT
					CASE
						WHEN dso.grade_at_audit = 'A' THEN poi.price_a
						WHEN dso.grade_at_audit = 'B' THEN poi.price_b
						WHEN dso.grade_at_audit = 'C' THEN poi.price_c
						WHEN dso.grade_at_audit LIKE '%D%' THEN poi.price_d
						WHEN dso.grade_at_audit = 'F' THEN poi.price_f
						END
					FROM po_items AS poi
					WHERE poi.order_id =
						(SELECT por.order_id
						FROM po_orders AS por
						WHERE por.order_number = dso.poNumber LIMIT 1)
					AND poi.order_number = IF(dso.asset REGEXP '(-[0-9]{1,4}\/[0-9]{1,6})$', SUBSTRING_INDEX(dso.asset, '-', 1), dso.asset) LIMIT 1), 0) AS individual_cost
			FROM ds_orders AS dso
			WHERE dso.cStatus $status
			GROUP BY dso.asset, dso.grade_at_audit, dso.poNumber;";

		$items = $this->db_query($sql, 'select-multiple', true);
		$assets = array();
		$costs = array();
		$quantities = array();
		$averages = array();
		foreach ($items as $item) {
			$asset = $this->getRealSku($item['asset']);
			if (!$quantities[$asset]) {
				array_push($assets, $asset);
				$costs[$asset] = (int)$item['item_count'] * (int)$item['individual_cost'];
				$quantities[$asset] = (int)$item['item_count'];
			} else {
				$costs[$asset] += (int)$item['item_count'] * (int)$item['individual_cost'];
				$quantities[$asset] += (int)$item['item_count'];
			}
		}
		foreach ($assets as $asset) {
			$averages[$asset] = round($costs[$asset] / $quantities[$asset]);
		}
		$data = array(
			'averages' => $averages,
			'query' => $sql
		);
		return $data;
	}

	public function exportAllLockedItems($returnData=false) {
		$output = '';
		$sql = "SELECT DISTINCT dso.serialNumber, dso.asset, ml.machine_description, poNumber, IFNULL(dso.activation_lock, 0) AS activation_lock, IFNULL(dso.mdm_lock, 0) AS mdm_lock, IFNULL(dso.audit_activation_lock, 0) AS audit_activation_lock, IFNULL(dso.audit_mdm_lock, 0) AS audit_mdm_lock
					FROM ds_orders dso
					LEFT JOIN machine_order_number mon ON mon.order_number = dso.asset
					LEFT JOIN machine_lookup ml ON ml.machine_id = mon.machine_id
					WHERE (dso.mdm_lock = 1 OR dso.activation_lock = 1)  AND mon.enabled = '1'
					ORDER BY poNumber, asset, mdm_lock, activation_lock, serialNumber;";
		$rows = $this->db_query($sql, 'select-multiple', true);
		if ($rows) {
			foreach ($rows as $data) {

				$line = array(
				'PO Number' => $data['poNumber']
				, 'Serial Number' => $data['serialNumber']
				, 'Machine' => $data['machine_description']
				, 'SKU' => $data['asset']
				, 'Activation Lock' => $data['activation_lock']==1?'Yes':''
				, 'Activation Lock At Audit' => $data['audit_activation_lock']==1?'Yes':''
				, 'MDM Lock' => $data['mdm_lock']==1?'Yes':''
				, 'MDM Lock At Audit' => $data['audit_mdm_lock']==1?'Yes':''
				);
				$output .= '"' . implode('","', $line) . '"' . "\n";

			}
		}
		$date = date_format("YmdHis", new DateTime('now', new DateTimeZone('UTC')));
		// $this->send_file_to_browser(
		// 		implode(',', array_keys($line)) . "\n" . $output
		// 		, $date.'_all_locked_devices.csv'
		// );
        //if not returning data
        if (!$returnData) {
            # SEND TO BROWSER FOR DOWNLOAD
            if ($output) {
				$date = date_format("YmdHis", new DateTime('now', new DateTimeZone('UTC')));
				$this->send_file_to_browser(
						implode(',', array_keys($line)) . "\n" . $output
						, $date.'_all_locked_devices.csv'
				);
            }
            return false;
        } else {
            return implode(',', array_keys($line)) . "\n" . $output;
        }
	}

	public static function getInboundLineItems() {
		$lineItems = PurchaseOrdersController::getInboundLineItems();
		return $lineItems;
	}


	// $sql = "SELECT
	// CASE
	// 	WHEN dso.grade_at_audit = 'A' THEN poi.price_a
	// 	WHEN dso.grade_at_audit = 'B' THEN poi.price_b
	// 	WHEN dso.grade_at_audit = 'C' THEN poi.price_c
	// 	WHEN dso.grade_at_audit LIKE '_D' THEN poi.price_d
	// 	WHEN dso.grade_at_audit = 'F' THEN poi.price_f
	// END AS cost
	// FROM po_items poi
	// LEFT JOIN po_orders por ON por.order_id = poi.order_id
	// LEFT JOIN ds_orders dso ON dso.poNumber = por.order_number
	// WHERE dso.oNum = '{$data['oNum']}' AND poi.order_number = '{$data['asset']}'";
}

?>
