<?php

class Imaging extends Database {

	/**
	 * Generates the template for the imaging control page.
	 */
	function imaging_control(){

		/**
		 * Sets the number of rows to be displayed (not counting the All row).
		 */
		$numRowsPig = 8;
		$numRowsBeast = 4;
		$po_numbers = $this->db_select_multiple('po_numbers', 'po_number',array(),'ORDER BY po_number');

		$imaging_control = $this->db_select_multiple('imaging_control', '*',array(),'ORDER BY machine_id');
		$beast_imaging_control = $this->db_select_multiple('beast_imaging_control', '*', array(), 'ORDER BY rack_number');


		if ($_POST['submit']){
			echo print_r($_POST);
			for($x = 1; $x <= count($imaging_control); $x++) {
				if ($_POST['po_number_'.$x] != $_POST['hdn_po_number_'.$x]) {
					$this->db_update('imaging_control', 'machine_id', $x, array('po_number' => $_POST['po_number_'.$x]));
				}
			}
			for($x = 1; $x <= count($beast_imaging_control); $x++) {
				if ($_POST['po_number_beast_'.$x] != $_POST['hdn_po_number_beast_'.$x]) {
					$this->db_update('beast_imaging_control', 'rack_number', $x, array('po_number' => $_POST['po_number_beast_'.$x]));
				}
			}
		} elseif($_POST['set_all']) {
			$po = $_POST['select_all'];
			$query = 'UPDATE imaging_control SET po_number = "'.$po.'";';
			$this->db_query($query, 'update', true);
		} elseif($_POST['set_all_beast']) {
			$po = $_POST['select_all_beast'];
			$query = 'UPDATE beast_imaging_control SET po_number = "'.$po.'";';
			$this->db_query($query, 'update', true);
		}

		$imaging_control = $this->db_select_multiple('imaging_control', '*',array(),'ORDER BY machine_id');
		$beast_imaging_control = $this->db_select_multiple('beast_imaging_control', '*', array(), 'ORDER BY rack_number');

		$ipadDropDowns = '<h3>Pigs</h3>';
		$ipadDropDowns .= '<tr><td>All</td><td>';
		$ipadDropDowns .= '<select name="select_all"><option></option>';
		foreach ($po_numbers as $po) {
			$ipadDropDowns .= '<option>'.$po['po_number'].'</option>';
		}
		$ipadDropDowns .= '</td>';
		$ipadDropDowns .= '<td><input type="submit" id="set_all" name="set_all" value="Set All" /></td>';
		$ipadDropDowns .= '</tr>';

		for ($x = 0; $x < $numRowsPig; $x++) {
			$ipadDropDowns .= '<tr>';
			for ($y = $x; $y < sizeof($imaging_control); $y += $numRowsPig) {
				$ipadDropDowns .= '<td>Pig '.$imaging_control[$y]['machine_id'].'</td>';
				$ipadDropDowns .= '<td>';
				$ipadDropDowns .= '<select name="po_number_'.$imaging_control[$y]['machine_id'].'"><option></option>';
				foreach ($po_numbers as $po){
					if ($po['po_number'] == $imaging_control[$y]['po_number']){
						$ipadDropDowns .= '<option selected>'.$po['po_number'].'</option>';
					}else{
						$ipadDropDowns .= '<option>'.$po['po_number'].'</option>';
					}
				}
				$ipadDropDowns .= '<input type="hidden" name="hdn_po_number_'.$imaging_control[$y]['machine_id'].'" value="'.$imaging_control[$y]['po_number'].'"/>';
				$ipadDropDowns .= '</td>';
			}
			$ipadDropDowns .= '</tr>';
		}
		$beastDropDowns = '<h3>Beast</h3>';


		$beastDropDowns .= '<tr><td>All</td><td>';
		$beastDropDowns .= '<select name="select_all_beast"><option></option>';
		foreach ($po_numbers as $po) {
			$beastDropDowns .= '<option>'.$po['po_number'].'</option>';
		}
		$beastDropDowns .= '</td>';
		$beastDropDowns .= '<td><input type="submit" id="set_all_beast" name="set_all_beast" value="Set All (Beast)" /></td>';
		$beastDropDowns .= '</tr>';

		for ($x = 0; $x < $numRowsBeast; $x++) {
			$beastDropDowns .= '<tr>';
			for ($y = $x; $y < sizeof($beast_imaging_control); $y += $numRowsBeast) {
				$beastDropDowns .= '<td>Beast '.$beast_imaging_control[$y]['rack_number'].'</td>';
				$beastDropDowns .= '<td>';
				$beastDropDowns .= '<select name="po_number_beast_'.$beast_imaging_control[$y]['rack_number'].'"><option></option>';
				foreach ($po_numbers as $po){
					if ($po['po_number'] == $beast_imaging_control[$y]['po_number']){
						$beastDropDowns .= '<option selected>'.$po['po_number'].'</option>';
					}else{
						$beastDropDowns .= '<option>'.$po['po_number'].'</option>';
					}
				}
				$beastDropDowns .= '<input type="hidden" name="hdn_po_number_beast_'.$beast_imaging_control[$y]['rack_number'].'" value="'.$beast_imaging_control[$y]['po_number'].'"/>';
				$beastDropDowns .= '</td>';
			}
			$beastDropDowns .= '</tr>';
		}

		$templateElements = array(
			'DROP_DOWNS_IPAD' => $ipadDropDowns,
			'DROP_DOWNS_BEAST' => $beastDropDowns
		);

		echo $this->parse(TEMPLATE, array('BODY' => $this->parse(IMAGING_CONTROL, $templateElements), "TITLE" => "Imaging Control"));
	}

	function insertSystemProfilerEntry($data) {
		global $adminObj;
		// return "\ntest\n";

		if ($data['os_version'] && strpos($data['os_version'], '(') !== false) {
			$data['os_version'] ="10.".strval(intval(substr($data['os_version'], 1, 2)) - 4);
		}
		$ipAddress = $data['ip'];
		$poNumber = $this->getPoNumberFromIP($ipAddress);
		if ($poNumber) {
			$data['poNumber'] = $poNumber;
		}
		unset($data['ip']);
		$mdm = '';
		if ($data['mdm'] == 'Yes') {
			$mdm = 1;
		} else {
			$mdm = 0;
		}
		unset($data['mdm']);
		$serialNumber = trim($data['serial_number']);
		$imagedStatus = STATUS_REFURB_IMAGED;
		$deleteQuery = "DELETE FROM system_profiler WHERE serial_number = '$serialNumber';";
		$this->db_query($deleteQuery, 'delete', false);
		$deleteOrderQuery = "DELETE FROM ds_orders WHERE serialNumber = '$serialNumber' AND cStatus = '$imagedStatus';";
		$this->db_query($deleteOrderQuery, 'delete', false);

		$time = strtotime("-1 year", time());
		$oneYearAgo = date("Y-m-d", $time);
		$updateOrderQuery = "UPDATE `ds_orders` SET serialNumber = CONCAT(serialNumber, '-OLD') WHERE serialNumber = '$serialNumber' AND cDate < '$oneYearAgo';";
		$this->db_query($updateOrderQuery, 'update', false);

		$fields = implode(', ', array_keys($data));
		$values = "'".implode("', '", array_map("trim", array_values($data)))."'";
		$insertQuery = "INSERT INTO system_profiler ($fields) VALUES ($values);\n";
		// echo $insertQuery;
		$this->db_query($insertQuery, 'insert', false);

		// Generate basic audit data
		$configCode = '';
		if (strlen($data['serial_number']) < 13){
			$configCode = substr($data['serial_number'],8);
		} else {
			$configCode = substr($data['serial_number'],9);
		}
		$machineInfoQuery = "SELECT mon.order_number, ml.machine_description FROM product_model AS pm LEFT JOIN machine_order_number AS mon ON pm.order_number_id = mon.order_number_id LEFT JOIN machine_lookup AS ml ON mon.machine_id = ml.machine_id WHERE pm.configCode = '$configCode' LIMIT 1;";
		$machineInfo = $this->db_query($machineInfoQuery, 'select-single', false);
		$auditData = array(
			'serialNumber' => $data['serial_number'],
			'poNumber' => $data['poNumber'],
			'os_version' => $data['os_version'],
			'ram_1' => $data['memory_bank_1'],
			'ram_2' => $data['memory_bank_2'],
			'ram_3' => $data['memory_bank_3'],
			'ram_4' => $data['memory_bank_4'],
			'hd_1' => $data['hard_drive_size'],
			'battery_mah' => $data['battery_capacity'],
			'battery_cycles' => $data['battery_cycle'],
			'machineType' => $machineInfo['machine_description'],
			'order_number' => $machineInfo['order_number'],
			'identifier' => $configCode,
			'cStatus' => STATUS_REFURB_IMAGED,
			'mdm_lock' => $mdm
		);
		$newOrder = $adminObj->parse_audit_response($auditData, false, true);
		$auditData['newOrder'] = $newOrder;
		$auditData['ip'] = $ipAddress;
		return $auditData;
	}

	function preInstallSystemProfilerEntry($data) {
		global $adminObj;
		// return "\ntest\n";
		$path_to_files = '/var/www/vhosts/macservice.com/logs/systemprofiler/';

		if ($data['os_version'] && strpos($data['os_version'], '(') !== false) {
			$data['os_version'] ="10.".strval(intval(substr($data['os_version'], 1, 2)) - 4);
		}
		$ipAddress = $data['ip'];
		$poNumber = $this->getPoNumberFromIP($ipAddress);
		if ($poNumber) {
			$data['poNumber'] = $poNumber;
		} else {
			$data['poNumber'] = '';
		}
		$serialNumber = trim($data['serial_number']);
		$logData = '';
		foreach($data as $key => $value) {
			$logData .= "$key : $value\n";
		}
		file_put_contents($path_to_files.$serialNumber.'.log', $logData, FILE_APPEND);
		unset($data['ip']);
		$mdm = 0;
		$imagedStatus = STATUS_REFURB_IMAGED;

		$deleteQuery = "DELETE FROM system_profiler WHERE serial_number = '$serialNumber';";
		$this->db_query($deleteQuery, 'delete', false);
		$deleteOrderQuery = "DELETE FROM ds_orders WHERE serialNumber = '$serialNumber' AND cStatus = '$imagedStatus';";
		$this->db_query($deleteOrderQuery, 'delete', false);

		$time = strtotime("-1 year", time());
		$oneYearAgo = date("Y-m-d", $time);
		$updateOrderQuery = "UPDATE `ds_orders` SET serialNumber = CONCAT(serialNumber, '-OLD') WHERE serialNumber = '$serialNumber' AND cDate < '$oneYearAgo';";
		$this->db_query($updateOrderQuery, 'update', false);

		$fields = implode(', ', array_keys($data));
		$values = "'".implode("', '", array_map("trim", array_values($data)))."'";
		$insertQuery = "INSERT INTO system_profiler ($fields) VALUES ($values);\n";
		// echo $insertQuery;
		$this->db_query($insertQuery, 'insert', false);

		// Generate basic audit data
		$configCode = '';
		if (strlen($data['serial_number']) < 13){
			$configCode = substr($data['serial_number'],8);
		} else {
			$configCode = substr($data['serial_number'],9);
		}
		$machineInfoQuery = "SELECT mon.order_number, ml.machine_description FROM product_model AS pm LEFT JOIN machine_order_number AS mon ON pm.order_number_id = mon.order_number_id LEFT JOIN machine_lookup AS ml ON mon.machine_id = ml.machine_id WHERE pm.configCode = '$configCode' LIMIT 1;";
		$machineInfo = $this->db_query($machineInfoQuery, 'select-single', false);
		$auditData = array(
			'serialNumber' => $data['serial_number'],
			'poNumber' => $data['poNumber'],
			'os_version' => $data['os_version'],
			'ram_1' => $data['memory_bank_1'],
			'ram_2' => $data['memory_bank_2'],
			'ram_3' => $data['memory_bank_3'],
			'ram_4' => $data['memory_bank_4'],
			'hd_1' => $data['hard_drive_size'],
			'battery_mah' => $data['battery_capacity'],
			'battery_cycles' => $data['battery_cycle'],
			'machineType' => $machineInfo['machine_description'],
			'order_number' => $machineInfo['order_number'],
			'identifier' => $configCode,
			'cStatus' => STATUS_REFURB_IMAGED,
			'mdm_lock' => $mdm
		);
		$newOrder = $adminObj->parse_audit_response($auditData, false, true);
		$auditData['newOrder'] = $newOrder;
		$auditData['ip'] = $ipAddress;
		return $auditData;
	}

	function postInstallSystemProfilerUpdate($data) {
		$path_to_files = '/var/www/vhosts/macservice.com/logs/systemprofiler/';
		$serialNumber = $data['serial_number'];
		// echo $data;
		$logData = '';
		foreach($data as $key => $value) {
			$logData .= "$key : $value\n";
		}
		// echo print_r($data);
		// echo "\n";
		echo $logData;
		file_put_contents($path_to_files.$serialNumber.'.log', $logData, FILE_APPEND);
		if ($data['os_version'] && strpos($data['os_version'], '(') !== false) {
			$osVersion = "10.".strval(intval(substr($data['os_version'], 1, 2)) - 4);
		}
		$mdm = '';
		if ($data['mdm'] == 'Yes' || $data['mdm'] == 1 || $data['mdm'] == '1') {
			$mdm = 1;
			$mdmData = array(
				'serialNumber' => $serialNumber,
				'orgAddress' => $data['orgAddress'],
				'orgEmail' => $data['orgEmail'],
				'orgName' => $data['orgName'],
				'orgPhone' => $data['orgPhone'],
			);
			$mdmDataResult = $this->addMDMData($mdmData);
		} else {
			$mdm = 0;
		}
		$status = STATUS_REFURB_IMAGED;
		$sql = "UPDATE ds_orders SET os_version = '$osVersion', mdm_lock = $mdm WHERE serialNumber = '$serialNumber' AND cStatus = '$status';";
		$res1 = $this->db_query($sql, 'update', true);
		$sql = "UPDATE system_profiler SET os_version = '$osVersion' WHERE serial_number = '$serialNumber';";
		$res2 = $this->db_query($sql, 'update', true);
		return array(
			'ds_order_update_result' => $res1,
			'system_profiler_update_result' => $res2,
			'mdm_data_result' => $mdmDataResult
		);
	}

	function addMDMData($data) {
		$serialNumber = $data['serialNumber'];
		$orgAddress = $data['orgAddress'] ? "'{$data['orgAddress']}'" : 'NULL' ;
		$orgEmail = $data['orgEmail'] ? "'{$data['orgEmail']}'" : 'NULL' ;
		$orgName = $data['orgName'] ? "'{$data['orgName']}'" : 'NULL' ;
		$orgPhone = $data['orgPhone'] ? "'{$data['orgPhone']}'" : 'NULL' ;
		$sql = "INSERT INTO ds_order_mdm_details VALUES ((SELECT `oID` FROM ds_orders WHERE serialNumber = '$serialNumber' ORDER BY `oID` DESC LIMIT 1), $orgAddress, $orgEmail, $orgName, $orgPhone) ON DUPLICATE KEY UPDATE `organization_address`=$orgAddress, `organization_email`=$orgEmail, `organization_name`=$orgName, `organization_phone`=$orgPhone;";
		$result = $this->db_query($sql, 'insert', true);
		return array(
			'query' => $sql,
			'result' => $result
		);
	}

	function getPoNumberFromIP($ip) {
		$beasts = $this->db_select_multiple('beast_imaging_control', '*', array(), 'ORDER BY rack_number');
		foreach ($beasts as $beast) {
			$ipScope = $beast['ip_scope'];
			$poNumber = $beast['po_number'];
			if ($this->startsWith($ip, $ipScope)) {
				return $poNumber;
			}
		}
		return '';
	}

}
