<?php

class Executive extends Database {
	public function editShippingBoxesPage() {
		$boxes = $this->getShippingBoxes();
		$typeCodes = $this->getUpsTypeCodes();
		foreach ($boxes as $box) {
			$shippingBoxes .= $this->generateShippingBoxRow($box, $typeCodes);
		}
		$templateElements = array(
			"SHIPPING_BOXES" => $shippingBoxes,
			"TYPE_CODE_SELECT" => $this->generateUpsTypeCodeSelect($typeCodes)
		);
		echo $this->parse(TEMPLATE, array('BODY' => $this->parse(SHIPPING_BOX_EDIT, $templateElements), "TITLE" => "Shipping Boxes"));
	}

	private function generateShippingBoxRow($data, &$typeCodes) {
		$id = $data['id'];
		$name = $data['name'];
		$weight = (float)$data['weight'];
		$lbs = floor($weight);
		$oz = round(($weight - $lbs) * 16);
		$length = $data['length'];
		$width = $data['width'];
		$height = $data['height'];
		$typeCodeId = $data['ups_type_code_id'];
		$typeCodeSelect = $this->generateUpsTypeCodeSelect($typeCodes, $id, $typeCodeId);
		$returnRow =
			"<div class='box_row' id='box_row_$id'>
				<input disabled class='borderless pseudo_p' name='name_$id' id='name_$id' placeholder='Enter Name' value='$name' />
				<input style='width:100px;' disabled type='number' class='borderless pseudo_p' name='length_$id' id='length_$id' placeholder='Enter length' value='$length' />
				<input style='width:100px;' disabled type='number' class='borderless pseudo_p' name='width_$id' id='width_$id' placeholder='Enter width' value='$width' />
				<input style='width:100px;' disabled type='number' class='borderless pseudo_p' name='height_$id' id='height_$id' placeholder='Enter height' value='$height' />
				<input style='width:30px;' disabled type='number' class='borderless pseudo_p weight_input' name='lbs_$id' id='lbs_$id' box_id='$id' placeholder='lbs' value='$lbs' min='0' />
				<span>lbs</span>
				<input style='width:30px;' disabled type='number' class='borderless pseudo_p weight_input' name='oz_$id' id='oz_$id' box_id='$id' placeholder='oz' value='$oz' oninput='updateWeight($id)' />
				<span>oz</span>
				$typeCodeSelect
				<button type='button' id='edit_$id' onclick='editBox($id)'>Edit</button>
				<button type='button' id='delete_$id' onclick='deleteBox($id)'>Delete</button>
				<button hidden type='button' id='save_$id' onclick='saveBox($id)'>Save Changes</button>
			</div>";
		return $returnRow;

	}

	public function getShippingBoxes() {
		$sql = "SELECT sb.*, uptc.type_code, uptc.description FROM shipping_boxes AS sb LEFT JOIN `ups_package_type_codes` AS uptc ON sb.`ups_type_code_id` = uptc.`id` ORDER BY `name` ASC;";
		$boxes = $this->db_query($sql, 'select-multiple', true);
		return $boxes;
	}

	public function getShippingBox($id) {
		$sql = "SELECT sb.*, uptc.type_code, uptc.description FROM shipping_boxes AS sb LEFT JOIN `ups_package_type_codes` AS uptc ON sb.`ups_type_code_id` = uptc.`id` WHERE sb.id = $id LIMIT 1;";
	}

	public function generateUpsTypeCodeSelect(&$typeCodes, $id='new', $activeType='') {
		$disabled = $id == 'new' ? '' : 'disabled';
		$select = "<select $disabled class='borderless pseudo_p' id='ups_type_code_$id' name='ups_type_code_$id'>";
		foreach ($typeCodes as $typeCode) {
			$id = $typeCode['id'];
			$typeCodeNum = $typeCode['type_code'];
			$description = $typeCode['description'];
			if ($typeCode['id'] == $activeType) {
				$select .= "<option selected value='$id'>$typeCodeNum - $description</option>";
			}
			else {
				$select .= "<option value='$id'>$typeCodeNum - $description</option>";
			}
		}
		$select .= "</select>";
		return $select;
	}

	public function getUpsTypeCodes() {
		$sql = "SELECT * FROM ups_package_type_codes ORDER BY type_code ASC;";
		$typeCodes = $this->db_query($sql, 'select-multiple', true);
		return $typeCodes;
	}

	public function getOrderShippingBoxes($order_number_id) {
		$sql = "SELECT * FROM shipping_boxes AS sb LEFT JOIN machine_order_shipping_boxes AS mosb ON sb.id = mosb.shipping_box_id WHERE mosb.machine_order_id = $order_number_id;";
		$boxes = $this->db_query($sql, 'select-multiple', true);
		return $boxes;
	}

	public function saveNewBox($data) {
		$name = $data['name'];
		$lbs = (int)$data['lbs'];
		$oz = (int)$data['oz'];
		$weight = $lbs + ($oz / 16);
		$length = $data['length'];
		$width = $data['width'];
		$height = $data['height'];
		$typeCode = $data['type_code'];
		$sql = "INSERT INTO shipping_boxes(`name`, `length`, `width`, `height`, `weight`, `ups_type_code_id`) VALUES ('$name', $length, $width, $height, $weight, $typeCode);";
		$result = $this->db_query($sql, 'insert', false);
		return $result;
	}

	public function saveBoxEdits($data) {
		$id = $data['id'];
		$name = $data['name'];
		$lbs = (int)$data['lbs'];
		$oz = (int)$data['oz'];
		$weight = $lbs + ($oz / 16);
		$length = $data['length'];
		$width = $data['width'];
		$height = $data['height'];
		$typeCode = $data['type_code'];
		$sql = "UPDATE shipping_boxes SET `name`='$name', `length`=$length, `width`=$width, `height`=$height, `weight`=$weight, `ups_type_code_id`=$typeCode WHERE id=$id;";
		$result = $this->db_query($sql, 'update', true);
		return $result;
	}

	public function deleteBox($id) {
		$sql = "DELETE FROM shipping_boxes WHERE id=$id;";
		$result = $this->db_query($sql, 'delete', true);
		return $result;
	}
}

?>
