<?php

class SalesRegionsController {
	public static function salesRegionsDashboard() {
		$adminObj = new Admin;
		$title="Sales Region Management";
		$templateElements = array(
			"SCRIPTS" => 	IMPORT_JQUERY . IMPORT_JQUERY_UI .
							'<script src="__CDN_JAVASCRIPT__javascript/salesRegionManagement/datasets/State.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/salesRegionManagement/datasets/Salesperson.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/salesRegionManagement/datasets/Region.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/salesRegionManagement/salesRegionDash.js" type="text/javascript"></script>'
		);

		echo $adminObj->parse(TEMPLATE, array('BODY' => $adminObj->parse(SALES_REGION_DASH, $templateElements), "TITLE" => $title));
	}


	public static function getRegions() {
		$regions = SalesRegionsService::getRegions();
	}

	public static function getStates() {
		$states = SalesRegionsService::getStates();
	}

	public static function saveRegions($carriersData) {
		$results = array();
		foreach($carriersData as $data) {
			$result = self::saveRegion($data);
			array_push($results, $result);
		}
		return $results;
	}

	public static function saveRegion($data) {
		return SalesRegionsService::saveRegion($data);
	}

	public static function saveStates($carriersData) {
		$results = array();
		foreach($carriersData as $data) {
			$result = self::saveState($data);
			array_push($results, $result);
		}
		return $results;
	}

	public static function saveState($data) {
		return SalesRegionsService::saveState($data);
	}
}

?>
