<?php

require_once("RMAManager.php");
require_once("DisplayOrder.php");

class RMAService {
	public static function serveOpenServiceRequestsPage() {
		$framework = new Framework;
		$scripts = '
			<script src="__CDN_JAVASCRIPT__javascript/column_definition/column_definition.js" type="text/javascript"></script>
			<script src="__CDN_JAVASCRIPT__javascript/servicerequests/WarrantyType.js" type="text/javascript"></script>
			<script src="__CDN_JAVASCRIPT__javascript/Salesperson/Salesperson.js" type="text/javascript"></script>
			<script src="__CDN_JAVASCRIPT__javascript/servicerequests/ServiceRequest.js" type="text/javascript"></script>
			<script src="__CDN_JAVASCRIPT__javascript/servicerequests/serviceRequests.js" type="text/javascript"></script>
			';
		$templateElements = array(
			'SCRIPTS' => $scripts
		);
		echo $framework->parse(TEMPLATE, array('BODY' => $framework->parse(OPEN_SERVICE_REQUESTS_PAGE, $templateElements), "TITLE" => "Service Orders"));
	}

	public static function serveCompletedServiceRequestsPage() {
		$framework = new Framework;
		$scripts = '
			<script src="__CDN_JAVASCRIPT__javascript/column_definition/column_definition.js" type="text/javascript"></script>
			<script src="__CDN_JAVASCRIPT__javascript/servicerequests/WarrantyType.js" type="text/javascript"></script>
			<script src="__CDN_JAVASCRIPT__javascript/Salesperson/Salesperson.js" type="text/javascript"></script>
			<script src="__CDN_JAVASCRIPT__javascript/servicerequests/ServiceRequest.js" type="text/javascript"></script>
			<script src="__CDN_JAVASCRIPT__javascript/servicerequests/completed/CompletedRequestService.js" type="text/javascript"></script>
			';
		$templateElements = array(
			'SCRIPTS' => $scripts
		);
		echo $framework->parse(TEMPLATE, array('BODY' => $framework->parse(COMPLETED_SERVICE_REQUESTS_PAGE, $templateElements), "TITLE" => "Completed Service Orders"));
	}

	public static function getOpenServiceRequests($type='all') {
		$serviceRequests = self::parseServiceRequests(self::fetchServiceRequestsFromDatabase($type));
		$warrantyTypes = self::getWarrantyTypes();
		$salespeople = self::getSalespeople();
		$returnData = array(
			'serviceRequests' => $serviceRequests,
			'warrantyTypes' => $warrantyTypes,
			'salespeople' => $salespeople
		);
		return $returnData;
	}

	public static function saveServiceRequestChanges($postedData) {
		$encodedData = str_replace('\"', '"', str_replace(PHP_EOL, '\n', $postedData['changes']));
		$data = json_decode(str_replace(PHP_EOL, '\n', $encodedData));
		foreach ($data->body as $entry) {
			self::performServiceRequestUpdates($entry);
		}
	}

	private static function performServiceRequestUpdates($requestData) {
		$db = new Database;
		$orderId = substr($requestData->oNum, 2);
		if ($requestData->status) {
			$requestData->cStatus = $requestData->status;
			unset($requestData->status);
		}

		// Handle ds_orders fields
		if ($requestData->cStatus || $requestData->problem || $requestData->oACAdapter !== null) {
			$clauses = array();
			if ($requestData->cStatus) {
				$cStatus = mysql_real_escape_string($requestData->cStatus);
				$cStatusClause = "`cStatus`='$cStatus'";
				array_push($clauses, $cStatusClause);
			}
			if ($requestData->problem) {
				$problem = mysql_real_escape_string(trim($requestData->problem));
				$problemClause = "`problem`='$problem'";
				array_push($clauses, $problemClause);
			}
			if ($requestData->oACAdapter !== null) {
				$oACAdapter = $requestData->oACAdapter == '1' ? 'Y' : 'N';
				$oACAdapterClause = "`oACAdapter`='$oACAdapter'";
				array_push($clauses, $oACAdapterClause);
			}
			// if ($requestData->notes) {
			// 	$notes = mysql_real_escape_string(trim($requestData->notes));
			// 	$notesClause = "`cShipInstruct`='$notes'";
			// 	array_push($clauses, $notesClause);
			// }
			if (count($clauses) > 0) {
				$combinedClauses = implode(", ", $clauses);
				$dsOrdersQuery = "UPDATE ds_orders SET $combinedClauses WHERE `oID`='$orderId';";
				$db->db_query($dsOrdersQuery, 'update', true);
			}
		}
		if ($requestData->warrantyId || $requestData->salesRepId || isset($requestData->notes)) {
			$updatedFields = array();
			if ($requestData->warrantyId) {
				$warrantyId = $requestData->warrantyId;
				$updatedFields['warrantyId'] = "'$warrantyId'";
			}
			if ($requestData->salesRepId) {
				$salesRepId = $requestData->salesRepId;
				$updatedFields['salesRepId'] = "'$salesRepId'";
				$updatedFields['salesRepName'] = "(SELECT `name` FROM `order_salespersons` WHERE `id`='$salesRepId')";
			}
			if (isset($requestData->notes)) {
				$notes = mysql_real_escape_string(trim($requestData->notes));
				$updatedFields['internalNotes'] = "'$notes'";
			}
			if (count($updatedFields) > 0) {
				$columnsClause = "`orderId`";
				$valuesClause = "'$orderId'";
				$updateClause = "";
				$i = 0;
				foreach($updatedFields as $key => $value) {
					$columnsClause .= ", `$key`";
					$valuesClause .= ", $value";
					if ($i) {
						$updateClause .= ", ";
					}
					$updateClause .= "`$key`=$value";
					$i++;
				}

				$dsOrderServiceDetailsQuery = "INSERT INTO ds_order_service_details($columnsClause) VALUES ($valuesClause) ON DUPLICATE KEY UPDATE $updateClause;";
				$db->db_query($dsOrderServiceDetailsQuery, 'insert', true);
			}
		}
	}

	private static function parseServiceRequests($rawRequests='') {
		if (!$rawRequests) {
			$rawRequests = self::fetchServiceRequestsFromDatabase();
		}
		$serviceRequests = array(
			'newOrder' => array(),
			'labelSent' => array(),
			'boxSent' => array(),
			'received' => array(),
			'diagnosticComplete' => array(),
			'approvedDeclined' => array(),
			'readyToShip' => array(),
			'replacement' => array(),
			// 'all' => array()
		);
		foreach ($rawRequests as $request) {
			$parsedRequest = new DisplayOrder($request);
			if ($parsedRequest->getStatus() == STATUS_SERVICE_NEW) {
				array_push($serviceRequests['newOrder'], $parsedRequest->getOpenOrderData());
			}
			elseif ($parsedRequest->getStatus() == STATUS_SERVICE_LABEL_SENT) {
				array_push($serviceRequests['labelSent'], $parsedRequest->getOpenOrderData());
			}
			elseif ($parsedRequest->getStatus() == STATUS_SERVICE_BOX_SENT) {
				array_push($serviceRequests['boxSent'], $parsedRequest->getOpenOrderData());
			}
			elseif ($parsedRequest->getStatus() == STATUS_SERVICE_RECEIVED) {
				array_push($serviceRequests['received'], $parsedRequest->getOpenOrderData());
			}
			elseif ($parsedRequest->getStatus() == STATUS_SERVICE_DIAGNOSTIC_COMPLETE) {
				array_push($serviceRequests['diagnosticComplete'], $parsedRequest->getOpenOrderData());
			}
			elseif ($parsedRequest->getStatus() == STATUS_SERVICE_APPROVED_DECLINED) {
				array_push($serviceRequests['approvedDeclined'], $parsedRequest->getOpenOrderData());
			}
			elseif ($parsedRequest->getStatus() == STATUS_SERVICE_READY_TO_SHIP) {
				array_push($serviceRequests['readyToShip'], $parsedRequest->getOpenOrderData());
			}
			elseif ($parsedRequest->getStatus() == STATUS_SERVICE_REPLACEMENT) {
				array_push($serviceRequests['replacement'], $parsedRequest->getOpenOrderData());
			}
			// array_push($serviceRequests['all'], $parsedRequest->getOpenOrderData());
		}
		return $serviceRequests;
	}

	private static function fetchServiceRequestsFromDatabase($type='all') {
		$db = new Database;
		$types = array(
			'open' => array(
				STATUS_SERVICE_NEW,
				STATUS_SERVICE_LABEL_SENT,
				STATUS_SERVICE_BOX_SENT,
				STATUS_SERVICE_RECEIVED,
				STATUS_SERVICE_DIAGNOSTIC_COMPLETE,
				STATUS_SERVICE_APPROVED_DECLINED,
				STATUS_SERVICE_READY_TO_SHIP,
				STATUS_SERVICE_REPLACEMENT
			),
			'complete' => array(
				STATUS_SERVICE_COMPLETE
			),
			'all' => array(
				STATUS_SERVICE_NEW,
				STATUS_SERVICE_LABEL_SENT,
				STATUS_SERVICE_BOX_SENT,
				STATUS_SERVICE_RECEIVED,
				STATUS_SERVICE_DIAGNOSTIC_COMPLETE,
				STATUS_SERVICE_APPROVED_DECLINED,
				STATUS_SERVICE_READY_TO_SHIP,
				STATUS_SERVICE_REPLACEMENT,
				STATUS_SERVICE_COMPLETE
			)
		);
		$statusString = implode("', '", $types[$type]);
		$sql = "SELECT dso.oNum, dso.problem, dso.cStatus, dso.cShipCompany, dso.cShipInstruct, dsod.internalNotes, dso.oWarranty, dso.cDate, dso.dateCompleted, dso.ship_tracking_id3 AS trackingOut, dso.customer_id, dsod.salesRepId, dsod.salesRepName, os.zoho_id AS salesRepZohoId, dsod.warrantyId, dso.oACAdapter FROM ds_orders AS dso LEFT JOIN ds_order_service_details AS dsod ON dso.oID = dsod.orderId LEFT JOIN order_salespersons AS os ON dsod.salesRepId = os.id WHERE `cStatus` IN ('$statusString');";
		return $db->db_query($sql, 'select-multiple', true);
	}

	public static function getCompletedServiceRequests($startDate='', $endDate='') {
		$fetchedRequests = self::fetchCompletedServiceRequests($startDate, $endDate);
		$parsedRequests = self::parseCompletedServiceRequests($fetchedRequests);
		return $parsedRequests;
	}

	private static function parseCompletedServiceRequests($rawRequests) {
		$serviceRequests = array();
		foreach ($rawRequests as $rawRequest) {
			$parsedRequest = new DisplayOrder($rawRequest);
			array_push($serviceRequests, $parsedRequest->getOpenOrderData());
		}
		return $serviceRequests;
	}

	private static function fetchCompletedServiceRequests($startDate='', $endDate='') {
		$db = new Database;
		$status = STATUS_SERVICE_COMPLETE;
		$sql = "SELECT dso.oNum, dso.problem, dso.cStatus, dso.cShipCompany, dso.cShipInstruct, dsod.internalNotes, dso.oWarranty, dso.cDate, dso.dateCompleted, dso.ship_tracking_id3 AS trackingOut, dso.customer_id, dsod.salesRepId, dsod.salesRepName, os.zoho_id AS salesRepZohoId, dsod.warrantyId FROM ds_orders AS dso LEFT JOIN ds_order_service_details AS dsod ON dso.oID = dsod.orderId LEFT JOIN order_salespersons AS os ON dsod.salesRepId = os.id WHERE `cStatus`='$status'";
		if ($startDate && $endDate) {
			$sql .= " AND dso.cDate BETWEEN '$startDate' AND '$endDate 23:59:59';";
		}
		elseif ($startDate) {
			$sql .= " AND dso.cDate >= '$startDate';";
		}
		elseif ($endDate) {
			$sql .= " AND dso.cDate <= '$endDate 23:59:59';";
		}
		else {
			$sql .= ";";
		}
		return $db->db_query($sql, 'select-multiple', true);
	}

	private static function getWarrantyTypes() {
		$db = new Database;

		$sql = "SELECT `id`, `warrantyType` FROM `ds_warranty_types` WHERE `active`='1';";
		$results = $db->db_query($sql, 'select-multiple', true);
		$warrantyTypes = array();
		foreach ($results as $result) {
			$warrantyType = new stdClass;
			$warrantyType->id = $result['id'];
			$warrantyType->warrantyType = $result['warrantyType'];
			array_push($warrantyTypes, $warrantyType);
		}
		return $warrantyTypes;
	}

	private static function getSalespeople() {
		global $activeSalespeople;
		$db = new Database;

		$salespeopleString = implode("', '", $activeSalespeople);
		$sql = "SELECT `id`, `name` FROM `order_salespersons` WHERE `name` IN ('$salespeopleString');";
		$results = $db->db_query($sql, 'select-multiple');
		$salespeople = array();
		foreach ($results as $result) {
			$salesperson = new stdClass;
			$salesperson->id = $result['id'];
			$salesperson->name = $result['name'];
			array_push($salespeople, $salesperson);
		}
		return $salespeople;
	}
}
?>
