<?php

class RMAOrder {
	/**
	 * @var string
	 */
	private $orderNumber;
	/**
	 * @var string
	 */
	private $purchaseDate;
	/**
	 * @var boolean Does customer have shipping box
	 */
	private $hasShippingBox;
	/**
	 * @var string
	 */
	private $desiredService;
	/**
	 * @var string
	 */
	private $deviceTypesAndSerials;
	/**
	 * @var string
	 */
	private $problemDescription;
	/**
	 * @var DateTime
	 */
	private $creationDate;
	/**
	 * @var RMAShippingAddress
	 */
	private $shippingData;
	private $salesRep;

	public function __construct($orderData) {
		$this->shippingData = new RMAShippingAddress($orderData);

		$this->orderNumber = $orderData->Field15;
		$this->purchaseDate = $orderData->Field35;
		$this->deviceTypesAndSerials = $orderData->Field8;
		$this->problemDescription = $orderData->Field10;
		$this->creationDate = DateTime::createFromFormat("Y-m-d H:i:s", $orderData->DateCreated, new DateTimeZone('America/Los_Angeles'));

		$this->hasShippingBox = self::parseShippingBoxEntry($orderData->Field138);
		$this->desiredService = self::parseDesiredServiceEntry($orderData->Field143);

		$this->salesRep = $this->getSalesRep();
	}

	private static function parseShippingBoxEntry($shippingBoxString) {
		return (substr($shippingBoxString, 0, 3) == 'Yes');
	}

	private static function parseDesiredServiceEntry($desiredServiceString) {
		if ($desiredServiceString == 'Repaired.') {
			return 'repair';
		}
		else {
			return 'replace';
		}
	}

	public function getDesiredService() {
		return $this->desiredService;
	}

	public function getDeviceTypesAndSerials() {
		return $this->deviceTypesAndSerials;
	}

	public function getProblemDescription() {
		return $this->problemDescription;
	}

	public function getShippingData() {
		return $this->shippingData;
	}

	public static function fromCsvEntry($data) {
		$data = (array)$data;
		$orderData = new stdClass;
		$orderData->Field1 = $data['First Name'];
		$orderData->Field2 = $data['Last Name'];
		$orderData->Field3 = $data['Email'];
		$orderData->Field33 = $data['Phone Number'];
		$orderData->Field14 = $data['School/Organization Name'];
		$orderData->Field139 = $data['School/Organization Name'];
		$orderData->Field140 = $data['Attention:'];
		$orderData->Field24 = $data['Street Address'];
		$orderData->Field25 = $data['City'];
		$orderData->Field27 = $data['State'];
		$orderData->Field29 = $data['ZIP'];

		$orderData->Field15 = $data['Order Number (MTS123456)'];
		$orderData->Field35 = $data['Date of Purchase'];
		$orderData->Field8 = $data['Device type(s) and serial number(s):'];
		$orderData->Field10 = $data['Describe the problem or issues:'];
		$orderData->DateCreated = date_format(DateTime::createFromFormat("Y-m-d H:i:s O", $data['Date Created']), "Y-m-d H:i:s");
		$orderData->Field138 = $data['Do you have a shipping box to send in your device?'];
		$orderData->Field143 = $data['Are you looking to get your device repaired or replaced?'];

		return new RMAOrder($orderData);
	}

	public function createNewRefurbOrder($cString) {
		global $orderObj;
		$sql = "SELECT * FROM `ds_customers` WHERE `cString`='$cString' ORDER BY `cID` DESC LIMIT 1;";
		$data = $orderObj->db_query($sql, 'select-single', true);
		$note = $this->createNote();
		$oNum = $orderObj->create_from_cust($data, $cString, SHIP_ROUND_GROUND, 'MS', $note);
		$serviceNewStatus = STATUS_SERVICE_NEW;
		$sql = "UPDATE `ds_orders` SET `cStatus`='$serviceNewStatus' WHERE `oNum`='$oNum';";
		self::insertServiceRequestDetails($oNum);
		$orderObj->db_query($sql, 'update', true);
		$orderUrl = "admin_controller.php?m=order_detail&oNum=$oNum";
		return $oNum;
	}

	private function insertServiceRequestDetails($oNum) {
		$salesRep = $this->getSalesRep();
		$salesRepId = $this->getSalesRepId($salesRep);

		if ($salesRep && $salesRepId) {
			$db = new Database;
			$oId = substr($oNum, 2);
			$sql = "INSERT INTO `ds_order_service_details`(`orderId`, `salesRepName`, `salesRepId`) VALUES ('$oId', '$salesRep', '$salesRepId') ON DUPLICATE KEY UPDATE `salesRepName`='$salesRep', `salesRepId`='$salesRepId';";
			$db->db_query($sql, 'insert', true);
		}
	}

	private function createNote() {
		$note = "Desired service: " . ucwords(trim($this->getDesiredService())) . "\n";
		if ($this->orderNumber) {
			$note .= "MTS#: $this->orderNumber\n";
		}
		$note .= "Device(s): " . trim($this->getDeviceTypesAndSerials()) . "\n";
		$note .= "Problem description: " . trim($this->getProblemDescription()) . "\n";
		return trim($note);
	}

	private function overwriteShippingAddress(&$data) {
		$shippingData = $this->getShippingData();
		$data['cShipCompany'] = $shippingData->getOrgName();
		$data['cShipAddress1'] = $shippingData->getStreet();
		$data['cShipCity'] = $shippingData->getCity();
		$data['cShipState'] = $shippingData->getState();
		$data['cShipZip'] = $shippingData->getZip();
	}

	private function getSalesRepId($salesRepName='') {
		if (!$salesRepName) {
			$salesRepName = $this->getSalesRep();
		}
		$sql = "SELECT `id` FROM `order_salespersons` WHERE `name`='$salesRepName' LIMIT 1;";
		$db = new Database;
		$result = $db->db_query($sql, 'select-single', true);
		return $result['id'];
	}

	private function getSalesRep($stateNameOrAbbrev='') {
		if (!$stateNameOrAbbrev) {
			$stateNameOrAbbrev = $this->getShippingData()->getState();
		}
		$regions = Region::getAllRegions(true, true);
		$states = State::getAllStates();
		foreach ($states as $state) {
			if ($state->getName() == $stateNameOrAbbrev || $state->getAbbreviation() == $stateNameOrAbbrev) {
				$regionId = $state->getRegionId();
				foreach ($regions as $region) {
					if ($region->getId() == $regionId) {
						$salesperson = $region->getSalespersons()[0];
						return $salesperson->getName();
					}
				}
			}
		}
	}
}

?>
