<?php
// Make sure the associated classes are loaded
require_once('RMAOrder.php');
require_once('RMACustomer.php');
require_once('RMAShippingAddress.php');

class RMAManager {
	private static $handshakeKey = 'E3B4AEF6B8AADE53BC1EADCA183D7';
	private static $logPath = HTML_FOLDER . "wufoo_logs/log.txt";

	public static function validateHandshake($key) {
		if ($key == self::$handshakeKey) {
			return true;
		}
		return false;
	}

	public static function handleNewOrder($orderData, $fromCsv=false) {
		if ($fromCsv) {
			$customer = RMACustomer::fromCsvEntry($orderData); // Parse customer data
			$order = RMAOrder::fromCsvEntry($orderData); // Parse order data
		}
		else {
			$customer = new RMACustomer($orderData); // Parse customer data
			$order = new RMAOrder($orderData); // Parse order data
		}
		$cString = $customer->getCustomerString(); // Get the cString for a given customer. Creates a new customer if one does not already exist.
		$newOrderNumber = $order->createNewRefurbOrder($cString); // Create a new order.
		self::insertLogEntry(self::createNewOrderLogString($newOrderNumber, $cString));
		return $newOrderNumber;
	}

	public static function insertLogEntry($logString) {
		$path = self::getLogPath();
		file_put_contents($path, $logString, FILE_APPEND);
	}

	private static function createNewOrderLogString($orderNumber, $cString) {
		$date = date_format(new DateTime('now', new DateTimeZone('America/Los_Angeles')), "Y-m-d H:i:sO");
		$entryString = "Created new order - $orderNumber - for customer with cString $cString at $date\n";
		return $entryString;
	}

	private static function getLogPath() {
		return self::$logPath;
	}
}

?>
