<?php

require_once('RMAShippingAddress.php');
require_once(HTML_FOLDER . "class_customer.php");

class RMACustomer {
	/**
	 * @var string
	 */
	private $firstName;
	/**
	 * @var string
	 */
	private $lastName;
	/**
	 * @var string
	 */
	private $email;
	/**
	 * @var string
	 */
	private $phone;
	/**
	 * @var string
	 */
	private $orgName;
	/**
	 * @var string
	 */
	private $orderNumber;
	/**
	 * @var string
	 */
	private $purchaseDate;
	/**
	 * @var RMAShippingAddress
	 */
	private $shippingData;

	public function __construct($customerData) {
		$this->shippingData = new RMAShippingAddress($customerData);

		$this->firstName = $customerData->Field1;
		$this->lastName = $customerData->Field2;
		$this->email = $customerData->Field3;
		$this->phone = $customerData->Field33;
		$this->orgName = $customerData->Field14;
	}

	public static function fromCsvEntry($data) {
		$data = (array)$data;
		$customerData = new stdClass;
		$customerData->Field1 = $data['First Name'];
		$customerData->Field2 = $data['Last Name'];
		$customerData->Field3 = $data['Email'];
		$customerData->Field33 = $data['Phone Number'];
		$customerData->Field14 = $data['School/Organization Name'];
		$customerData->Field139 = $data['School/Organization Name'];
		$customerData->Field140 = $data['Attention:'];
		$customerData->Field24 = $data['Street Address'];
		$customerData->Field25 = $data['City'];
		$customerData->Field27 = $data['State'];
		$customerData->Field29 = $data['ZIP'];

		return new RMACustomer($customerData);
	}

	public function getFirstName() {
		return $this->firstName;
	}

	public function getLastName() {
		return $this->lastName;
	}

	public function getEmail() {
		return $this->email;
	}

	public function getPhone() {
		return $this->phone;
	}

	public function getShippingData() {
		return $this->shippingData;
	}

	public function getOrgName() {
		return $this->orgName;
	}

	public function getExistingCustomerString() {
		$db = new Database;
		$email = $this->getEmail();
		$sql = "SELECT `cString` FROM `ds_customers` WHERE `cEmail`='$email' ORDER BY `cID` DESC LIMIT 1;";
		$result = $db->db_query($sql, 'select-single', true);
		if ($result['cString']) {
			return $result['cString'];
		}
		else {
			return 'NEW-CUSTOMER';
		}
	}

	public function getCustomerString() {
		global $custObj;
		$cString = $this->getExistingCustomerString();
		if ($cString == 'NEW-CUSTOMER') {
			$cString = $custObj->createUniqueKey();
			$data = $this->getCustomerDataAsDbArray();
			$custObj->insert($cString, $data);
		}
		return $cString;
	}

	private function getCustomerDataAsDbArray() {
		$shippingData = $this->getShippingData();
		$data = array(
			'cPhone' => $this->getPhone(),
			'cEmail' => $this->getEmail(),
			'cShipCompany' => $this->getOrgName(),
			'cShipFname' => $this->getFirstName(),
			'cShipLname' => $this->getLastName(),
			'cShipAddress1' => $shippingData->getStreet(),
			'cShipCity' => $shippingData->getCity(),
			'cShipState' => $shippingData->getState(),
			'cShipZip' => $shippingData->getZip(),
			'cShipCountry' => 'US',
			'cShipEmail' => $this->getEmail(),
			'cPass' => 'password'
		);
		return $data;
	}
}

?>
