<?php

/**
 * Represents the data returned after the AJAX request for a service order
 */
class DisplayOrder {
	private $oNum;
	private $problem;
	private $status;
	private $organization;
	private $warranty;
	private $dateCreation = "1970-01-01";
	private $dateCompleted = "1970-01-01";
	private $customerId;
	private $salesRepId;
	private $salesRepName;
	private $salesRepZohoId;
	private $warrantyId;
	private $servicesPerformed;
	private $notes;
	private $trackingOut;
	private $shipService;
	private $oACAdapter;

	private $shipAddress;

	public function __construct($data) {
		$data = (object)$data;
		$this->oNum = $data->oNum;
		$this->problem = $data->problem;
		$this->status = $data->cStatus;
		$this->organization = $data->cShipCompany;
		$this->warranty = $data->oWarranty == 'Y' ? true : false;
		$this->warrantyId = $data->warrantyId;
		$this->dateCreation = $data->cDate;
		$this->dateCompleted = $data->dateCompleted;
		$this->customerId = $data->customer_id;
		$this->salesRepId = $data->salesRepId;
		$this->salesRepName = $data->salesRepName;
		$this->salesRepZohoId = $data->salesRepZohoId;
		$this->servicesPerformed = $data->cShipInstruct;
		$this->notes = $data->internalNotes;
		$this->trackingOut = $data->trackingOut;
		$this->oACAdapter = $data->oACAdapter == "Y" ? true : false;

		$this->shipService = $data->cShipService;

		if ($data->cShipAddress1) {
			$this->shipAddress = new stdClass;
			$this->shipAddress->organization = $data->cShipCompany;
			$this->shipAddress->name = $data->cShipFname . " " . $data->cShipLname;
			$this->shipAddress->address1 = $data->cShipAddress1;
			$this->shipAddress->address2 = $data->cShipAddress2;
			$this->shipAddress->city = $data->cShipCity;
			$this->shipAddress->state = $data->cShipState;
			$this->shipAddress->zip = $data->cShipZip;
			$this->shipAddress->country = $data->cShipCountry;
		}
	}

	public function getStatus() {
		return $this->status;
	}

	public function getONum() {
		return $this->oNum;
	}

	public function getOpenOrderData() {
		$returnData = new stdClass;
		$returnData->oNum = $this->oNum;
		$returnData->problem = $this->problem;
		$returnData->status = $this->status;
		$returnData->organization = $this->organization;
		$returnData->warranty = $this->warranty;
		$returnData->dateCreation = $this->dateCreation;
		$returnData->dateCompleted = $this->dateCompleted;
		$returnData->customerId = $this->customerId;
		$returnData->salesRepId = $this->salesRepId;
		$returnData->salesRepName = $this->salesRepName;
		$returnData->salesRepZohoId = $this->salesRepZohoId;
		$returnData->warrantyId = $this->warrantyId;
		$returnData->servicesPerformed = $this->servicesPerformed;
		$returnData->notes = $this->notes;
		$returnData->trackingOut = $this->trackingOut;
		$returnData->oACAdapter = $this->oACAdapter;
		return $returnData;
	}

	public function getPdfData() {
		$returnData = new stdClass;
		$returnData->oNum = $this->oNum;
		$returnData->problem = $this->problem;
		$returnData->shipAddress = $this->shipAddress;
		$returnData->dateCreation = $this->dateCreation;
		$returnData->dateCompleted = $this->dateCompleted;
		$returnData->shipService = $this->shipService;
		$returnData->servicesPerformed = $this->servicesPerformed;
		return $returnData;
	}

	public function getShippingAddress() {
		return $this->shipAddress;
	}
}

?>
