<?php

require_once(HTML_FOLDER . "class_database.php");
require_once(HTML_FOLDER . "classes/PurchaseOrders/Datasets/PurchaseOrderLineItem.php");
require_once(HTML_FOLDER . "classes/PurchaseOrders/Datasets/PurchaseOrderVendor.php");
require_once(HTML_FOLDER . "classes/PurchaseOrders/Datasets/PurchaseOrder.php");
class PurchaseOrdersService {
	public static function getRawRecordsFromZoho() {
		global $zohoObj;

		$rawRecords = $zohoObj->getCreatedPurchaseOrders();

		// $processedRecords = self::processOrders($rawRecords);
		// print_r($rawRecords);
		// print_r($processedRecords);
		return $rawRecords;
	}

	public static function getVendorsFromRecords($records) {
		$vendors = array();
		foreach ($records as $record) {
			$vendorData = $record->vendor;
			$vendor = new PurchaseOrderVendor($vendorData);
			array_push($vendors, $vendor);
		}
		return $vendors;
	}

	public static function performVendorDatabaseEntries($vendorList) {
		$db = new Database;
		$dbTable = PurchaseOrderLineItem::getDbTable();
		$db->resetAutoIncrement($dbTable);
		foreach ($vendorList as $vendor) {
			$sql = $vendor->generateInsertQuery();
			$db->db_query($sql, 'insert', true);
			$db->resetAutoIncrement($dbTable);
		}
	}

	public static function getLineItemsFromRecords($records) {
		$lineItems = array();
		foreach ($records as $record) {
			$lineItemsData = $record->lineItems;
			foreach ($lineItemsData as $lineItemData) {
				$lineItem = new PurchaseOrderLineItem($lineItemData);
				array_push($lineItems, $lineItem);
			}
		}
		return $lineItems;
	}

	public static function performLineItemDatabaseEntries($lineItemList) {
		$db = new Database;
		$dbTable = PurchaseOrderLineItem::getDbTable();
		$db->resetAutoIncrement($dbTable);
		foreach ($lineItemList as $lineItem) {
			$sql = $lineItem->generateLineItemTableInsertQuery();
			$db->db_query($sql, 'insert', true);
			$db->resetAutoIncrement($dbTable);
		}
	}

	public static function performPurchaseOrderDatabaseEntries($purchaseOrderList, $deactivateAll = true) {
		$db = new Database;
		$dbTable = PurchaseOrder::getDbTable();
		$db->resetAutoIncrement($dbTable);

		// Set all existing POs inactive. Insertion will reactivate old.
		if($deactivateAll) {
			$sql = PurchaseOrder::generateSetAllInactiveQuery();
			$db->db_query($sql, 'update', true);
		}

		$purchaseOrders = array();
		foreach ($purchaseOrderList as $purchaseOrder) {
			$sql = $purchaseOrder->generateInsertQuery();
			$db->db_query($sql, 'insert', true);
			$db->resetAutoIncrement($dbTable);
			$purchaseOrder->setId(PurchaseOrder::getIdFromDb($purchaseOrder->getZohoId()));

			array_push($purchaseOrders, $purchaseOrder);
		}
		return $purchaseOrders;
	}

	public static function performJoinTableDatabaseEntries($purchaseOrders) {
		$db = new Database;

		foreach ($purchaseOrders as $purchaseOrder) {
			$lineItems = $purchaseOrder->getLineItems();
			$orderId = $purchaseOrder->getId();
			$sql = PurchaseOrderLineItem::generateJoinTableDeleteAllLineItemsWithOrderIdQuery($orderId);
			$db->db_query($sql, 'delete', true);
			foreach ($lineItems as $lineItem) {
				$sql = $lineItem->generateJoinTableInsertQuery($orderId);
				$db->db_query($sql, 'insert', true);
			}
		}
	}

	public static function processOrders($records) {
		$orders = array();
		foreach ($records as $record) {
			$orderData = $record->order;
			$vendorData = $record->vendor;
			$lineItemsData = $record->lineItems;

			$lineItems = array();
			foreach ($lineItemsData as $lineItemData) {
				$lineItem = new PurchaseOrderLineItem($lineItemData, true);
				array_push($lineItems, $lineItem);
			}
			$orderData->lineItems = $lineItems;

			$vendor = new PurchaseOrderVendor($vendorData, true);

			$orderData->vendor = $vendor;

			$order = new PurchaseOrder($orderData);

			array_push($orders, $order);
		}

		return $orders;
	}

	public static function getActivePurchaseOrderRecords($poNumber = null) {
		$db = new Database;
		$poTable = PurchaseOrder::getDbTable();
		$vendorTable = PurchaseOrderVendor::getDbTable();
		$lineItemTable = PurchaseOrderLineItem::getDbTable();
		$poLineItemJoinTable = PurchaseOrderLineItem::getJoinTable();

		$filter = ($poNumber) ? ' and poNumber="'.$poNumber.'"' : '';

		$sql = "SELECT * FROM `$poTable` WHERE `active`='1' ".$filter." ORDER BY `poDate` DESC;";
		$poResults = $db->db_query($sql, 'select-multiple', true);

		$purchaseOrders = array();
		foreach ($poResults as $poResult) {
			$poResultObj = (object)$poResult;
			$orderId = $poResultObj->id;
			$vendorId = $poResultObj->vendorId;
			$sql = "SELECT li.`id`, li.`name`, li.`zoho_id` AS zohoId, li.`code`, jt.`description`, jt.`quantity`, jt.`total`
					FROM `$lineItemTable` AS li
					LEFT JOIN `$poLineItemJoinTable` AS jt ON li.`id` = jt.`lineItemId`
					WHERE jt.`purchaseOrderId`='$orderId';";
			$lineItemResults = $db->db_query($sql, 'select-multiple', true);

			$lineItems = array();

			foreach ($lineItemResults as $lineItemResult) {
				$lineItemResultObj = (object)$lineItemResult;
				$lineItem = new PurchaseOrderLineItem($lineItemResultObj);
				$lineItem->populateOrderNumberId();
				array_push($lineItems, $lineItem);
			}

			$poResultObj->lineItems = $lineItems;

			$sql = "SELECT * FROM `$vendorTable` WHERE `id`='$vendorId';";
			$vendorResult = (object)$db->db_query($sql, 'select-single', true);
			$vendor = new PurchaseOrderVendor($vendorResult);
			$poResultObj->vendor = $vendor;


			$purchaseOrder = new PurchaseOrder($poResultObj);

			$logs = $db->db_query('select * from purchase_orders_logs where purchase_order_id = '.$orderId, 'select-multiple');
			$purchaseOrder->logs = $logs;
			array_push($purchaseOrders, $purchaseOrder);
		}

		return $purchaseOrders;
	}

	public static function saveChanges($purchaseOrderData) {
		$db = new Database;

		$dbTable = PurchaseOrder::getDbTable();

		$zohoId = $purchaseOrderData->zohoId;
		$dbId = $purchaseOrderData->dbId;
		$fields = $purchaseOrderData->fields;


		$notes = mysql_real_escape_string($purchaseOrderData->fields->notes);

		$sql = "UPDATE `$dbTable` SET `notes`='$notes' WHERE `id`='$dbId';";
		$db->db_query($sql, 'update',true);
	}

	public static function getPermissions() {
		$viewAllDataUsers = array(
			'justin',
			'robert',
			'm.kemper'
		);

		$adminString = $_SESSION['xdigiSHOPadmin'];
		$db = new Database;

		$sql = "SELECT `aUser` FROM `ds_admins` WHERE `aString`='$adminString';";
		$result = $db->db_query($sql, 'select-single', true);
		$username = $result['aUser'];
		if (in_array($username, $viewAllDataUsers)) {
			return 'true';
		}
		else {
			return 'false';
		}
	}

	public static function getInboundLineItems() {
		$db = new Database;
		$poTable = PurchaseOrder::getDbTable();
		$lineItemTable = PurchaseOrderLineItem::getDbTable();
		$poLineItemJoinTable = PurchaseOrderLineItem::getJoinTable();

		$sql = "SELECT li.`id`, li.`name`, li.`zoho_id` AS zohoId, li.`code`, jt.`description`, SUM(jt.`quantity`) AS quantity, jt.`total`
				FROM `$lineItemTable` AS li
				JOIN `$poLineItemJoinTable` AS jt ON li.`id` = jt.`lineItemId`
				JOIN `$poTable` AS `po` ON po.`id`=jt.`purchaseOrderId`
				WHERE po.`active`='1'
				GROUP BY li.`id`;";

		$results = $db->db_query($sql, 'select-multiple', true);
		$lineItems = array();
		foreach ($results as $result) {
			$resultObj = (object)$result;
			$lineItem = new PurchaseOrderLineItem($resultObj);
			array_push($lineItems, $lineItem);
		}
		return $lineItems;
	}
	
	public static function getInboundPurchaseOrderRecords($query) {
		global $zohoObj;
		$inboundOrders = $zohoObj->getPurchaseOrdersByQuery($query);
		return $inboundOrders;
	}
}

?>
