<?php

require_once(HTML_FOLDER . "classes/PurchaseOrders/PurchaseOrdersService.php");
class PurchaseOrdersController {

	public static function dashboard() {
		$admin = new Admin;
		$title="Purchase Orders";
		$templateElements = array(
			"SCRIPTS" => 	IMPORT_JQUERY . IMPORT_JQUERY_UI . '<script src="__CDN_JAVASCRIPT__javascript/column_definition/column_definition.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/purchaseOrders/dashboard.js" type="text/javascript"></script>'
		);

		echo $admin->parse(TEMPLATE, array('BODY' => $admin->parse(PURCHASE_ORDERS_DASHBOARD, $templateElements), "TITLE" => $title));
	}

	public static function getInboundPurchaseOrderRecords($searchText) {
		$query = "(Status:equals:In Transit) OR (Status:equals:Wire/Payment Sent) OR (Status:equals:Created)";
		if($searchText && $searchText != 'false') {
			$query = '('.$query.') AND ((Tracking_Number:equals:'.$searchText.') OR (MTS_Number:equals:'.$searchText.') OR (Purchase_Order_Number:equals:'.$searchText.'))';
		}
		$records = PurchaseOrdersService::getInboundPurchaseOrderRecords($query);
		// print_r($records);exit;
		// $vendorList = PurchaseOrdersService::getVendorsFromRecords($records);
		// $lineItemList = PurchaseOrdersService::getLineItemsFromRecords($records);
		// PurchaseOrdersService::performVendorDatabaseEntries($vendorList);
		// PurchaseOrdersService::performLineItemDatabaseEntries($lineItemList);
		// $processedRecords = PurchaseOrdersService::processOrders($records);
		// $finalizedRecords = PurchaseOrdersService::performPurchaseOrderDatabaseEntries($processedRecords);
		// PurchaseOrdersService::performJoinTableDatabaseEntries($finalizedRecords);

		return $records;
	}

	public static function checkIn($poNumber) {
		// Generate Purchase Order
		$query = "(Purchase_Order_Number:equals:".$poNumber.")";
		$rawRecords = PurchaseOrdersService::getInboundPurchaseOrderRecords($query);

		$vendorList = PurchaseOrdersService::getVendorsFromRecords($rawRecords);
		$lineItemList = PurchaseOrdersService::getLineItemsFromRecords($rawRecords);
		PurchaseOrdersService::performVendorDatabaseEntries($vendorList);
		PurchaseOrdersService::performLineItemDatabaseEntries($lineItemList);
		$processedRecords = PurchaseOrdersService::processOrders($rawRecords);
		$finalizedRecords = PurchaseOrdersService::performPurchaseOrderDatabaseEntries($processedRecords, false);
		PurchaseOrdersService::performJoinTableDatabaseEntries($finalizedRecords);
		
		if(is_array($rawRecords)) {
			$purchaseOrderData = $rawRecords[0];
			$adminObj = new Admin();
			$purchaseOrder = $adminObj->db_select_single('purchase_orders', '*', array('poNumber' => $purchaseOrderData->order->poNumber));
			if($purchaseOrder) {
				$purchaseOrderLog = $adminObj->db_select_single('purchase_orders_logs', '*', array('purchase_order_id' => $purchaseOrder['id']));
				if(! $purchaseOrderLog) {
					$zohoCreatedTime = \DateTime::createFromFormat('Y-m-d\TH:i:sT', $purchaseOrderData->order->createdTime)->format('Y-m-d H:i:s');
					$text = 'PO Created ['.$zohoCreatedTime.']';
					$adminObj->db_insert('purchase_orders_logs', array("purchase_order_id" => $purchaseOrder['id'], 'text' => $text, "created_at" => date('Y-m-d H:i:s'), "updated_at" => date('Y-m-d H:i:s')));
				}
			}
		}

		$admin = new Admin;
		$title="Purchase Orders Receving";
		$templateElements = array(
			"SCRIPTS" => 	IMPORT_JQUERY . IMPORT_JQUERY_UI . '<script src="__CDN_JAVASCRIPT__javascript/column_definition/column_definition.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/purchaseOrders/checkin.js" type="text/javascript"></script>'
		);

		echo $admin->parse(TEMPLATE, array('BODY' => $admin->parse(PURCHASE_ORDERS_CHECKIN, $templateElements), "TITLE" => $title));
	}
	
	public static function checkInFetch($poNumber) {
		$records = PurchaseOrdersService::getActivePurchaseOrderRecords($poNumber);

		$adminObj = new Admin();
		foreach($records as &$record) {
			$receivedItems = self::getReceivedItems($poNumber);
			$record->receivedItems = $receivedItems;
		}

		return $records;
	}

	public static function getReceivedItems($poNumber) {
		$adminObj = new Admin();
		$receivedItems = $adminObj->db_query('select * from ds_orders where poNumber = "'.$poNumber.'"', 'select-multiple');
		return $receivedItems;
	}
	
	public static function receving($poNumber, $data) {
		$serialNumbers = $data->serial_numbers;
		$skipped = 0;
		foreach ($serialNumbers as $serialNumber) {
			if (strlen($serialNumber) < 13){
				$configCode = substr($serialNumber,8);
			}else{
				$configCode = substr($serialNumber,9);
			}

			$adminObj = new Admin();
			
			$machineInfoQuery = "SELECT mon.order_number, ml.machine_description FROM product_model AS pm LEFT JOIN machine_order_number AS mon ON pm.order_number_id = mon.order_number_id LEFT JOIN machine_lookup AS ml ON mon.machine_id = ml.machine_id WHERE pm.configCode = '$configCode' LIMIT 1;";
			$machineInfo = $adminObj->db_query($machineInfoQuery, 'select-single', false);
			if(! $machineInfo) {
				$skipped++;
				continue;
			}

			$ram = '';
			$ssd = '';

			$system_profiler = $adminObj->db_select_single('system_profiler', '*', array('serial_number' => $serialNumber));
			if($system_profiler) {
				$data['ram_1'] = $system_profiler['memory_bank_1'];
				$data['ram_2'] = $system_profiler['memory_bank_2'];
				$data['ram_3'] = $system_profiler['memory_bank_3'];
				$data['ram_4'] = $system_profiler['memory_bank_4'];

				$ram = intval($system_profiler['memory_bank_1']) + intval($system_profiler['memory_bank_2']) + intval($system_profiler['memory_bank_3']) + intval($system_profiler['memory_bank_4']);

				$ram = (string)$ram.'GB';
				$ssd = $system_profiler['hard_drive_size'];
			}

			$auditData = array(
				'serialNumber' => $serialNumber,
				'poNumber' => $poNumber,
				'os_version' => 'Other',
				'ram_1' => $ram,
				'hd_1' => $ssd,
				'machineType' => $machineInfo['machine_description'],
				'order_number' => $machineInfo['order_number'],
				'identifier' => $configCode,
				'cStatus' => STATUS_REFURB_AUDITED,
				'grade' => 'A'
			);
			// print_r($auditData);
			$adminObj->parse_audit_response($auditData);
		}
		
		$received = count($serialNumbers) - $skipped;

		$purchaseOrder = $adminObj->db_query('select * from purchase_orders where poNumber = "'.$poNumber.'"', 'select-single');
		if($purchaseOrder) {
			$text = ($received + 2).' Items received by '.$_SESSION['aUser'];
			$adminObj->db_insert('purchase_orders_logs', array("purchase_order_id" => $purchaseOrder['id'], 'text' => $text, "created_at" => date('Y-m-d H:i:s'), "updated_at" => date('Y-m-d H:i:s')));
		}


		echo json_encode(['success' => 1, 'message' => $received.' items are received. '.$skipped.' serial numbers are invalid.']);
		exit;
	}
	
	public static function received($poNumber, $data) {
		$serialNumbers = $data->serial_numbers;
		foreach ($serialNumbers as $serialNumber) {
			if (strlen($serialNumber) < 13){
				$configCode = substr($serialNumber,8);
			}else{
				$configCode = substr($serialNumber,9);
			}

			$adminObj = new Admin();
			$sql = 'select mon.order_number
					from machine_order_number mon
					left join product_model pm on pm.order_number_id = mon.order_number_id
					where pm.configCode = "'.$configCode.'"';

			$machineInfo = $adminObj->db_query($sql, 'select-single');

			$ram = '';
			$ssd = '';

			$system_profiler = $adminObj->db_select_single('system_profiler', '*', array('serial_number' => $serialNumber));
			if($system_profiler) {
				$data['ram_1'] = $system_profiler['memory_bank_1'];
				$data['ram_2'] = $system_profiler['memory_bank_2'];
				$data['ram_3'] = $system_profiler['memory_bank_3'];
				$data['ram_4'] = $system_profiler['memory_bank_4'];

				$ram = intval($system_profiler['memory_bank_1']) + intval($system_profiler['memory_bank_2']) + intval($system_profiler['memory_bank_3']) + intval($system_profiler['memory_bank_4']);

				$ram = (string)$ram.'GB';
				$ssd = $system_profiler['hard_drive_size'];
			}

			$auditData = array(
				'serialNumber' => $serialNumber,
				'poNumber' => $poNumber,
				'os_version' => 'Other',
				'ram_1' => $ram,
				'hd_1' => $ssd,
				'machineType' => $machineInfo['machine_description'],
				'order_number' => $machineInfo['order_number'],
				'identifier' => $configCode,
				'cStatus' => STATUS_REFURB_AUDITED,
				'grade' => 'A'
			);
			// print_r($auditData);
			$oNum = $adminObj->parse_audit_response($auditData);
			if($oNum) {
				echo json_encode(['success' => 1, 'message' => 'Order created!']);
				exit;
			}
		}

		echo json_encode(['success' => 0, 'message' => 'Error']);
		exit;
	}

	public static function inboundInventoryPage() {
		$admin = new Admin;
		$title="Inbound Inventory";
		$templateElements = array(
			"SCRIPTS" => 	IMPORT_JQUERY . IMPORT_JQUERY_UI . '<script src="__CDN_JAVASCRIPT__javascript/column_definition/column_definition.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/purchaseOrders/datasets/LineItem.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/purchaseOrders/datasets/Vendor.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/purchaseOrders/datasets/PurchaseOrder.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/purchaseOrders/purchaseOrdersController.js" type="text/javascript"></script>'
		);

		echo $admin->parse(TEMPLATE, array('BODY' => $admin->parse(INBOUND_INVENTORY, $templateElements), "TITLE" => $title));
	}

	public static function refreshPurchaseOrdersFromZoho() {
		$rawRecords = PurchaseOrdersService::getRawRecordsFromZoho();

		$vendorList = PurchaseOrdersService::getVendorsFromRecords($rawRecords);
		$lineItemList = PurchaseOrdersService::getLineItemsFromRecords($rawRecords);

		PurchaseOrdersService::performVendorDatabaseEntries($vendorList);
		PurchaseOrdersService::performLineItemDatabaseEntries($lineItemList);

		$processedRecords = PurchaseOrdersService::processOrders($rawRecords);

		$finalizedRecords = PurchaseOrdersService::performPurchaseOrderDatabaseEntries($processedRecords);

		PurchaseOrdersService::performJoinTableDatabaseEntries($finalizedRecords);
	}

	public static function getPurchaseOrderRecords() {
		$records = PurchaseOrdersService::getActivePurchaseOrderRecords();
		return $records;
	}

	public static function saveChanges($purchaseOrderData) {
		try {
			PurchaseOrdersService::saveChanges($purchaseOrderData);
			return true;
		}
		catch (Exception $e) {
			return false;
		}
	}

	public static function getPermissions() {
		return PurchaseOrdersService::getPermissions();
	}

	public static function getInboundLineItems() {
		return PurchaseOrdersService::getInboundLineItems();
	}
}

?>
