<?php

class PurchaseOrderLineItem {
	public static $dbTable = 'order_line_items';
	public static $joinTable = 'purchase_order_line_items';

	public $id;
	public $zohoId;
	public $name;
	public $code;
	public $description;
	public $quantity;
	public $total;
	public $orderNumberId;

	public function __construct($data, $queryDbForId = true) {
		if (is_array($data)) {
			$data = (object)$data;
		}
		if ($data->id) {
			$this->id = $data->id;
		}
		if ($data->zohoId) {
			$this->zohoId = $data->zohoId;
		}
		if ($data->name) {
			$this->name = $data->name;
		}
		if ($data->code) {
			$this->code = $data->code;
		}
		if ($data->description) {
			$this->description = $data->description;
		}
		if ($data->quantity) {
			$this->quantity = (int)$data->quantity;
		}
		else {
			$this->quantity = 0;
		}
		if ($data->total) {
			$this->total = (float)$data->total;
		}
		else {
			$this->total = 0.0;
		}

		if (!$data->id && $queryDbForId) {
			$this->setId(self::getIdFromDb($this->getZohoId()));
		}
	}

	public function getId() {
		return $this->id;
	}

	public function setId($id) {
		$this->id = $id;
	}

	public function getZohoId() {
		return $this->zohoId;
	}

	public function setZohoId($zohoId) {
		$this->zohoId = $zohoId;
	}

	public function getName() {
		return $this->name;
	}

	public function setName($name) {
		$this->name = $name;
	}

	public function getCode() {
		return $this->code;
	}

	public function setCode($code) {
		$this->code = $code;
	}

	public function getDescription() {
		return $this->description;
	}

	public function setDescription($description) {
		$this->description = $description;
	}

	public function getQuantity() {
		return $this->quantity;
	}

	public function setQuantity($quantity) {
		$this->quantity = (int)$quantity;
	}

	public function getTotal() {
		return $this->total;
	}

	public function setTotal($total) {
		$this->total = (float)$total;
	}

	public static function getDbTable() {
		return self::$dbTable;
	}

	public static function getJoinTable() {
		return self::$joinTable;
	}

	public function getOrderNumberId() {
		return $this->orderNumberId;
	}

	public function setOrderNumberId($orderNumberId) {
		$this->orderNumberId = $orderNumberId;
	}

	public function populateOrderNumberId() {
		$db = new Database;
		$zohoId = $this->getZohoId();
		$sql = "SELECT mon.order_number, mon.order_number_id
				FROM machine_order_number AS mon
				LEFT JOIN machine_zoho_ids AS mzi ON mzi.machine_order_number_id = mon.order_number_id
				WHERE mzi.first_stock_zoho_id_individual = '$zohoId'
				OR mzi.second_stock_zoho_id_individual = '$zohoId'
				OR mzi.first_stock_zoho_id_tenpack = '$zohoId'
				OR mzi.second_stock_zoho_id_tenpack = '$zohoId'
				LIMIT 1;";
		$result = $db->db_query($sql, 'select-single', true);
		$orderNumberId = $result['order_number_id'];
		if ($orderNumberId) {
			$this->setOrderNumberId($orderNumberId);
			return $orderNumberId;
		}
		else {
			return false;
		}
	}

	public function generateLineItemTableInsertQuery() {
		$name = mysql_real_escape_string($this->getName());
		$code = mysql_real_escape_string($this->getCode());
		$zohoId = $this->getZohoId();
		$dbTable = self::getDbTable();
		$sql = "INSERT INTO `$dbTable`(`name`, `code`, `zoho_id`) VALUES ('$name', '$code', '$zohoId') ON DUPLICATE KEY UPDATE `name`='$name', `code`='$code';";
		return $sql;
	}

	public function generateJoinTableInsertQuery($orderId) {
		$id = $this->getId();
		$zohoId = $this->getZohoId();
		$description = mysql_real_escape_string($this->getDescription());
		$quantity = $this->getQuantity();
		$total = $this->getTotal();
		$dbTable = self::getDbTable();
		$joinTable = self::getJoinTable();
		if ($id) {
			$sql = "INSERT INTO `$joinTable`(`purchaseOrderId`, `lineItemId`, `description`, `quantity`, `total`) VALUES ('$orderId', '$id', '$description', '$quantity', '$total') ON DUPLICATE KEY UPDATE `description`='$description', `quantity`='$quantity', `total`='$total';";
		}
		else {
			$sql = "INSERT INTO `$joinTable`(`purchaseOrderId`, `lineItemId`, `description`, `quantity`, `total`) VALUES ('$orderId', (SELECT `id` FROM `$dbTable` WHERE `zoho_id`='$zohoId' LIMIT 1), '$description', '$quantity', '$total') ON DUPLICATE KEY UPDATE `description`='$description', `quantity`='$quantity', `total`='$total';";
		}
		return $sql;
	}

	public function generateJoinTableDeleteQuery($orderId) {
		$id = $this->getId();
		$zohoId = $this->getZohoId();
		$dbTable = self::getDbTable();
		$joinTable = self::getJoinTable();
		if ($id) {
			$sql = "DELETE FROM `$joinTable` WHERE `lineItemId`='$id' AND `purchaseOrderId`='$orderId';";
		}
		else {
			$sql = "DELETE FROM `$joinTable` WHERE `lineItemId`=(SELECT `id` FROM `$dbTable` WHERE `zoho_id`='$zohoId') AND `purchaseOrderId`='$orderId';";
		}
		return $sql;
	}

	public static function generateJoinTableDeleteAllLineItemsWithOrderIdQuery($orderId) {
		$joinTable = self::getJoinTable();

		$sql = "DELETE FROM `$joinTable` WHERE `purchaseOrderId`='$orderId';";

		return $sql;
	}

	public static function getIdFromDb($zohoId) {
		$db = new Database;
		$dbTable = self::getDbTable();
		$sql = "SELECT `id` FROM `$dbTable` WHERE `zoho_id`='$zohoId';";
		$result = $db->db_query($sql, 'select-single', true);
		$id = $result['id'];
		return $id;
	}
}

?>
