<?php

require_once(HTML_FOLDER . "classes/PurchaseOrders/Datasets/PurchaseOrderLineItem.php");
require_once(HTML_FOLDER . "classes/PurchaseOrders/Datasets/PurchaseOrderVendor.php");
class PurchaseOrder {
	public static $dbTable = 'purchase_orders';

	public $id;
	public $zohoId;
	public $subject;
	public $poNumber;
	public $subtotal;
	public $date;
	public $vendor;
	public $lineItems;
	public $notes;
	public $vendorOrderNumber;
	public $mtsNumber;
	public $trackingNumber;
	public $status;

	public function __construct($data) {
		if ($data->id) {
			$this->id = $data->id;
		}
		if ($data->zohoId) {
			$this->zohoId = $data->zohoId;
		}
		if ($data->subject) {
			$this->subject = $data->subject;
		}
		if ($data->poNumber) {
			$this->poNumber = $data->poNumber;
		}
		if ($data->subtotal) {
			$this->subtotal = (float)$data->subtotal;
		}
		else {
			$this->subtotal = 0.0;
		}
		if ($data->date) {
			$this->date = $data->date;
		}
		elseif ($data->poDate) {
			$this->date = $data->poDate;
		}
		if ($data->vendor) {
			$this->vendor = $data->vendor;
		}
		if ($data->lineItems) {
			$this->lineItems = $data->lineItems;
		}
		else {
			$this->lineItems = array();
		}
		if ($data->notes) {
			$this->notes = $data->notes;
		}
		if ($data->vendorOrderNumber) {
			$this->vendorOrderNumber = $data->vendorOrderNumber;
		}
		if ($data->mtsNumber) {
			$this->mtsNumber = $data->mtsNumber;
		}
		if ($data->trackingNumber) {
			$this->trackingNumber = $data->trackingNumber;
		}
		if ($data->status) {
			$this->status = $data->status;
		}
	}

	public function getId() {
		return $this->id;
	}

	public function setId($id) {
		$this->id = $id;
	}

	public function getZohoId() {
		return $this->zohoId;
	}

	public function setZohoId($zohoId) {
		$this->zohoId = $zohoId;
	}

	public function getSubject() {
		return $this->subject;
	}

	public function setSubject($subject) {
		$this->subject = $subject;
	}

	public function getPoNumber() {
		return $this->poNumber;
	}

	public function setPoNumber($poNumber) {
		$this->poNumber = $poNumber;
	}

	public function getSubtotal() {
		return $this->subtotal;
	}

	public function setSubtotal($subtotal) {
		$this->subtotal = $subtotal;
	}

	public function getDate() {
		return $this->date;
	}

	public function setDate($date) {
		$this->date = $date;
	}

	public function getNotes() {
		return $this->notes;
	}

	public function setNotes($notes) {
		$this->notes = $notes;
	}

	public function getVendor() {
		return $this->vendor;
	}

	public function setVendor($vendor) {
		$this->vendor = $vendor;
	}

	public function getLineItems() {
		return $this->lineItems;
	}

	public function setLineItems($lineItems) {
		$this->lineItems = $lineItems;
	}

	public function getVendorOrderNumber() {
		return $this->vendorOrderNumber;
	}

	public function setVendorOrderNumber($vendorOrderNumber) {
		$this->vendorOrderNumber = $vendorOrderNumber;
	}

	public function getMtsNumber() {
		return $this->mtsNumber;
	}

	public function setMtsNumber($mtsNumber) {
		$this->mtsNumber = $mtsNumber;
	}
	
	public function getTrackingNumber() {
		return $this->trackingNumber;
	}

	public function setTrackingNumber($trackingNumber) {
		$this->trackingNumber = $trackingNumber;
	}

	public function getStatus() {
		return $this->status;
	}

	public function setStatus($status) {
		$this->status = $status;
	}

	public function generateInsertQuery() {
		$zohoId = $this->getZohoId();
		$subject = str_replace("'", "\'", $this->getSubject());
		$poNumber = $this->getPoNumber();
		$poDate = $this->getDate() . " 12:00:00";
		$subtotal = $this->getSubtotal();
		$vendorId = $this->getVendor()->getId();

		$vendorOrderNumber = $this->getVendorOrderNumber();
		$mtsNumber = $this->getMtsNumber();
		$trackingNumber = $this->getTrackingNumber();
		$status = $this->getStatus();

		$dbTable = self::getDbTable();
		$sql = "INSERT INTO `$dbTable`(`zohoId`, `subject`, `poNumber`, `poDate`, `subtotal`, `vendorId`, `vendorOrderNumber`, `mtsNumber`, `trackingNumber`, `status`) VALUES ('$zohoId', '$subject', '$poNumber', '$poDate', '$subtotal', '$vendorId', '$vendorOrderNumber', '$mtsNumber', '$trackingNumber', '$status') ON DUPLICATE KEY UPDATE `subject`='$subject', `poNumber`='$poNumber', `poDate`='$poDate', `subtotal`='$subtotal', `vendorId`='$vendorId', `active`='1', `vendorOrderNumber`='$vendorOrderNumber', `mtsNumber`='$mtsNumber', `trackingNumber`='$trackingNumber', `status`='$status';";

		return $sql;
	}

	public function generateSetInactiveQuery() {
		$zohoId = $this->getZohoId();

		$dbTable = self::getDbTable();

		$sql = "UPDATE `$dbTable` SET `active`='0' WHERE `zohoId`='$zohoId';";

		return $sql;
	}

	public static function generateSetAllInactiveQuery() {
		$dbTable = self::getDbTable();

		$sql = "UPDATE `$dbTable` SET `active`='0';";

		return $sql;
	}

	public static function generateSetInactiveWhereNotInZohoIdsQuery($zohoIds) {
		if (is_array($zohoIds)) {
			$zohoIds = implode("', '", $zohoIds);
		}

		$dbTable = self::getDbTable();

		$sql = "UPDATE `$dbTab` SET `active`='0' WHERE `zohoId` NOT IN ('$zohoIds');";

		return $sql;
	}

	public static function getDbTable() {
		return self::$dbTable;
	}

	public static function getIdFromDb($zohoId) {
		$db = new Database;
		$dbTable = self::getDbTable();
		$sql = "SELECT `id` FROM `$dbTable` WHERE `zohoId`='$zohoId';";
		$result = $db->db_query($sql, 'select-single', true);
		$id = $result['id'];
		return $id;
	}
}

?>
