<?php

class NeweggOrder extends EcommOrder {
	private static $channel = 'newegg';

	public function __construct($order) {
		$orderId = $order->OrderNumber;
		$orderData = new stdClass;
		$orderData->orderId = $orderId;
		$orderData->channel = 'newegg';
		$orderData->status = $order->OrderStatus;
		$date = DateTime::createFromFormat('m/d/Y H:i:s', $order->OrderDate, new DateTimeZone('America/Los_Angeles'));
		$date->setTimezone(new DateTimeZone('UTC'));
		$orderData->datePlaced = date_format($date, 'Y-m-d H:i:s');
		$orderData->subtotal = $order->OrderTotalAmount;

		$orderItems = $order->ItemInfoList;

		$orderItemData = array();

		foreach ($orderItems as $orderItem) {
			$itemInfo = new stdClass;
			$itemData->itemId = $orderItem->NeweggItemNumber;
			$itemData->sku = $orderItem->SellerPartNumber;
			$itemData->title = $orderItem->Description;
			$itemData->quantity = $orderItem->OrderedQty;
			$itemData->price = $orderItem->ItemPrice->UnitPrice;
			$orderItemData[$itemData->OrderItemId] = $itemData;

		}
		$orderData->orderItems = $orderItemData;


		// $this->insertIntoEcommOpenOrderDetails($orderData);
		$orderData->shippingData->recipientName = "$order->ShipToFirstName $order->ShipToLastName";
		$orderData->shippingData->addressLine1 = $order->ShipToAddress1;
		$orderData->shippingData->addressLine2 = $order->ShipToAddress2;
		$orderData->shippingData->addressLine3 = $order->ShipToAddress3;
		$orderData->shippingData->city = $order->ShipToCityName;
		$orderData->shippingData->state = $order->ShipToStateCode;
		$orderData->shippingData->postalCode = $order->ShipToZipCode;
		$orderData->shippingData->countryCode = $order->ShipToCountryCode;
		$orderData->shippingData->phone = $order->CustomerPhoneNumber;
		$orderData->shippingData->email = $order->CustomerEmailAddress;
		$orderData->shippingData->shipService = $order->ShipService;
		parent::__construct($orderData);
	}
}
