<?php

class EcommOrder extends Database {

	private $orderId;
	private $channel;
	private $subtotal;
	private $datePlaced;
	private $shippingData;
	private $orderItems;
	private $status;

	protected function __construct($orderData) {
		$this->orderId = $orderData->orderId;
		$this->channel = $orderData->channel;
		$this->status = $orderData->status;
		$this->datePlaced = $orderData->datePlaced;
		$this->subtotal = $orderData->subtotal;
		$this->shippingData = $orderData->shippingData;
		$this->orderItems = $orderData->orderItems;
	}

	public function performDatabaseInserts() {
		$this->channelId = $this->getChannelId();
		$openOrderId = $this->insertIntoEcommOpenOrders();
		$this->insertIntoEcommOpenOrderDetails($openOrderId);
		foreach ($this->orderItems as $orderItem) {
			$this->insertIntoEcommOpenOrderLineItems($openOrderId, $orderItem);
		}
		if ($this->shippingData && $this->shippingData->addressLine1 && $this->shippingData->recipientName) {
			$this->insertIntoEcommOpenOrderShippingDetails($openOrderId);
		}
	}

	public function getOrderId() {
		return $this->orderId;
	}

	public function getStatus() {
		return $this->status;
	}

	public function closeOrder() {
		$orderId = $this->orderId;
		$channelId = $this->channelId;
		$sql = "UPDATE `ecomm_open_orders` SET `open`='0' WHERE `order_id`='$orderId' AND `channel_id`='$channelId';";
		return $this->db_query($sql, 'update', true);
	}

	public function deleteFromDatabase() {
		$orderId = $this->orderId;
		$channelId = (is_int($this->channelId)) ? $this->channelId : $this->getChannelId();
		$sql = "DELETE FROM `ecomm_open_orders` WHERE `order_id`='$orderId' AND `channel_id`='$channelId';";
		return $this->db_query($sql, 'delete', true);
	}

	private function getChannelId() {
		$channel = $this->channel;
		$sql = "SELECT `id` FROM `ecomm_sales_channels` WHERE `identifier`='$channel' LIMIT 1";
		$result = $this->db_query($sql, 'select-single', true);
		if (!$result['id']) {
			$channel = str_replace('_', '', $channel);
			$sql = "SELECT `id` FROM `ecomm_sales_channels` WHERE `identifier`='$channel' LIMIT 1";
			$result = $this->db_query($sql, 'select-single', true);
		}
		return $result['id'];
	}

	private function insertIntoEcommOpenOrders() {
		$orderId = $this->orderId;
		$channel = $this->channel;
		$channelId = $this->channelId;
		$sql = "INSERT IGNORE INTO `ecomm_open_orders`(`order_id`, `channel_id`) VALUES ('$orderId', '$channelId') ON DUPLICATE KEY UPDATE `open`='1';";
		$this->db_query($sql, 'insert', true);
		$sql = "SELECT `id` FROM `ecomm_open_orders` WHERE `order_id`='$orderId';";
		$result = $this->db_query($sql, 'select-single', true);
		$this->resetAutoIncrement('ecomm_open_orders');
		return $result['id'];
	}

	private function insertIntoEcommOpenOrderLineItems($openOrderId, $itemData) {
		$channel = $this->channel;
		$itemId = $itemData->itemId;
		$sku = $itemData->sku;
		$title = mysql_real_escape_string($itemData->title);
		$quantity = $itemData->quantity;
		$machineData = $this->getMachineData($itemId);
		$orderNumberId = $machineData->orderNumberId ? $machineData->orderNumberId : 'NULL';
		$conditionId = $machineData->conditionId ? $machineData->conditionId : 'NULL';
		$sql = "INSERT IGNORE INTO `ecomm_open_order_line_items`(`open_order_id`, `sku`, `title`, `quantity`, `line_item_id`, `machine_order_id`, `condition_id`) VALUES ('$openOrderId', '$sku', '$title', '$quantity', '$itemId', $orderNumberId, $conditionId);";
		return $this->db_query($sql, 'insert', true);
	}

	private function getMachineData($itemId) {
		$sql = "SELECT `order_number_id`, `condition_id` FROM `machine_ecomm_ids` WHERE `listing_id`='$itemId' ORDER BY `order_number_id`, `condition_id` DESC LIMIT 1;";
		$result = $this->db_query($sql, 'select-single', true);
		$machineData = new stdClass;
		$machineData->orderNumberId = $result['order_number_id'];
		$machineData->conditionId = $result['condition_id'];
		return $machineData;
	}

	private function insertIntoEcommOpenOrderDetails($openOrderId) {
		$subtotal = $this->subtotal;
		$status = $this->status;
		$datePlaced = $this->datePlaced;
		$sql = "INSERT INTO `ecomm_open_order_details`(`open_order_id`, `subtotal`, `status`, `date_placed`) VALUES ('$openOrderId', '$subtotal', '$status', '$datePlaced') ON DUPLICATE KEY UPDATE `status`='$status', `subtotal`='$subtotal';";
		return $this->db_query($sql, 'insert', true);
	}

	private function insertIntoEcommOpenOrderShippingDetails($openOrderId) {
		$recipientName = mysql_real_escape_string($this->shippingData->recipientName);
		$addressLine1 = mysql_real_escape_string($this->shippingData->addressLine1);
		$addressLine2 = mysql_real_escape_string($this->shippingData->addressLine2);
		$addressLine3 = mysql_real_escape_string($this->shippingData->addressLine3);
		$city = mysql_real_escape_string($this->shippingData->city);
		$state = mysql_real_escape_string($this->shippingData->state);
		$postalCode = mysql_real_escape_string($this->shippingData->postalCode);
		$countryCode = mysql_real_escape_string($this->shippingData->countryCode);
		$phone = mysql_real_escape_string($this->shippingData->phone);
		$email = mysql_real_escape_string($this->shippingData->email);
		$service = mysql_real_escape_string($this->shippingData->shipService);
		$sql = "INSERT IGNORE INTO `ecomm_open_order_shipping_details`(`open_order_id`, `recipient_name`, `address_line_1`, `address_line_2`, `address_line_3`, `city`, `state`, `postal_code`, `country_code`, `phone`, `email`, `service`)
				VALUES ('$openOrderId', '$recipientName', '$addressLine1', '$addressLine2', '$addressLine3', '$city', '$state', '$postalCode', '$countryCode', '$phone', '$email', '$service');";
		return $this->db_query($sql, 'insert', true);
	}
}
