<?php

class EbayOrder extends EcommOrder {
	public function __construct($order) {
		$orderId = $order->orderId;
		$orderData = new stdClass;
		$orderData->orderId = $orderId;
		$orderData->channel = 'ebay';
		$orderData->status = $order->orderFulfillmentStatus;
		$orderData->datePlaced = $order->creationDate;
		$orderData->subtotal = $order->pricingSummary->priceSubtotal->value;

		$orderItems = $order->lineItems;
		if ($orderItems[0]->soldFormat) {
			$orderData->channel .= $orderItems[0]->soldFormat == "FIXED_PRICE" ? '_others' : '_auctions';
		}

		$orderItemData = array();

		foreach ($orderItems as $orderItem) {
			$itemInfo = new stdClass;
			$itemData->itemId = $orderItem->legacyItemId;
			$itemData->sku = $orderItem->sku;
			$itemData->title = $orderItem->title;
			$itemData->quantity = $orderItem->quantity;
			$itemData->price = $orderItem->lineItemCost->value;
			$orderItemData[$itemData->OrderItemId] = $itemData;

		}
		$orderData->orderItems = $orderItemData;


		// $this->insertIntoEcommOpenOrderDetails($orderData);
		$shippingData = $order->fulfillmentStartInstructions[0]->shippingStep->shipTo;
		$orderData->shippingData->recipientName = $shippingData->fullName;
		$orderData->shippingData->addressLine1 = $shippingData->contactAddress->addressLine1;
		$orderData->shippingData->addressLine2 = $shippingData->contactAddress->addressLine2;
		$orderData->shippingData->addressLine3 = $shippingData->contactAddress->addressLine3;
		$orderData->shippingData->city = $shippingData->contactAddress->city;
		$orderData->shippingData->state = $shippingData->contactAddress->stateOrProvince;
		$orderData->shippingData->postalCode = $shippingData->contactAddress->postalCode;
		$orderData->shippingData->countryCode = $shippingData->contactAddress->countryCode;
		$orderData->shippingData->phone = $shippingData->primaryPhone->phoneNumber;
		// $orderData->shippingData->email = $order->CustomerEmailAddress;
		$orderData->shippingData->shipService = $order->fulfillmentStartInstructions[0]->shippingStep->shippingServiceCode;
		parent::__construct($orderData);
	}
}
