<?php

require_once(HTML_FOLDER . "classes/OrderTypes/EcommOrder.php");

class BackmarketOrder extends EcommOrder {

	public function __construct($order) {
		$orderId = $order->order_id;
		$orderData = new stdClass;
		$orderData->orderId = $orderId;
		$orderData->channel = 'back_market';
		$orderData->status = $order->state;
		$date = DateTime::createFromFormat(DATE_ATOM, $order->date_creation);
		$date->setTimezone(new DateTimeZone('UTC'));
		$orderData->datePlaced = $date->format('Y-m-d H:i:s');
		$orderData->subtotal = $order->price;

		$orderItems = $order->orderlines;

		$orderItemData = array();

		foreach ($orderItems as $orderItem) {
			$itemInfo = new stdClass;
			$itemData->itemId = $orderItem->listing_id;
			$itemData->sku = $orderItem->listing;
			$itemData->title = $orderItem->title;
			$itemData->quantity = $orderItem->quantity;
			$itemData->price = $orderItem->price;
			$orderItemData[$itemData->OrderItemId] = $itemData;

		}
		$orderData->orderItems = $orderItemData;


		// $this->insertIntoEcommOpenOrderDetails($orderData);
		$shippingData = $order->shipping_address;
		$orderData->shippingData->recipientName = "$shippingData->first_name $shippingData->last_name";
		$orderData->shippingData->addressLine1 = $shippingData->street;
		$orderData->shippingData->addressLine2 = $shippingData->street2;
		$orderData->shippingData->addressLine3 = $shippingData->street3;
		$orderData->shippingData->city = $shippingData->city;
		$orderData->shippingData->state = $shippingData->state_or_province;
		$orderData->shippingData->postalCode = $shippingData->postal_code;
		$orderData->shippingData->countryCode = $shippingData->country;
		$orderData->shippingData->phone = $shippingData->phone;
		$orderData->shippingData->email = $shippingData->email;
		$orderData->shippingData->shipService = $order->shipper;
		parent::__construct($orderData);
	}

}

?>
