<?php

require_once(HTML_FOLDER . "apis/amazon/AmazonMWS.php");
require_once(HTML_FOLDER . "apis/amazon/class_amazon_api.php");
require_once(HTML_FOLDER . "classes/OrderTypes/EcommOrder.php");

class AmazonOrder extends EcommOrder {

	public function __construct($order) {

		$orderId = $order->AmazonOrderId;
		$orderData = new stdClass;
		$orderData->orderId = $orderId;
		$orderData->channel = 'amazon';
		$orderData->status = $order->OrderStatus;
		$orderData->datePlaced = $order->PurchaseDate;
		$orderData->subtotal = 0;

		$orderItems = self::getOrderItems($orderId);

		$orderData->orderItems = $orderItems;

		foreach ($orderItems as $orderItem) {
			$orderData->subtotal += $orderItem->price;
		}
		// $this->insertIntoEcommOpenOrderDetails($orderData);
		if ($order->DefaultShipFromLocationAddress && $order->DefaultShipFromLocationAddress->AddressLine1) {
			$orderData->shippingData->recipientName = $order->DefaultShipFromLocationAddress->Name;
			$orderData->shippingData->addressLine1 = $order->DefaultShipFromLocationAddress->AddressLine1;
			$orderData->shippingData->addressLine2 = $order->DefaultShipFromLocationAddress->AddressLine2;
			$orderData->shippingData->addressLine3 = $order->DefaultShipFromLocationAddress->AddressLine3;
			$orderData->shippingData->city = $order->DefaultShipFromLocationAddress->City;
			$orderData->shippingData->state = $order->DefaultShipFromLocationAddress->StateOrRegion;
			$orderData->shippingData->postalCode = $order->DefaultShipFromLocationAddress->PostalCode;
			$orderData->shippingData->countryCode = $order->DefaultShipFromLocationAddress->CountryCode;
			$orderData->shippingData->phone = $order->DefaultShipFromLocationAddress->Phone;
			$orderData->shippingData->email = $order->BuyerEmail;
			$orderData->shippingData->shipService = $order->ShipServiceLevel;
		}
		parent::__construct($orderData);
	}

	private static function getOrderItems($orderId) {
		//return AmazonMWS::getOrderItems($orderId);
		$amazonSP = new AmazonAPI;
		return $amazonSP->getOrderItemsSP($orderId);
	}

	public static function getShippedAmazonOrders() {
		$db = new Database;
		$sql = "SELECT `order_id` FROM `ecomm_ship_log` WHERE `channel_id`=(SELECT `id` FROM `ecomm_sales_channels` WHERE `identifier`='amazon');";
		$results = $db->db_query($sql, 'select-multiple', true);
		$orderIds = array();
		foreach($results as $result) {
			$orderId = $result['order_id'];
			array_push($orderIds, $orderId);
		}
		return $orderIds;
	}
}
