<?php

require_once(HTML_FOLDER . "class_database.php");

class OrderDetailsService extends Database {
	public function orderDetailNew($oNum) {
		echo $this->parse(TEMPLATE, array(
				'BODY' => $this->parse(ADMIN_SEARCH_BODY, array('PAYFLOW_TOTAL' => '')) . $this->parseOrderDetailNew($oNum)
			)
		);
	}

	public function orderDetailSubmit($oNum, $data) {
		self::performDatabaseInsertions($oNum, $data);
		header('Location:'.CONTROLLER.'?m=ms_order_detail&oNum='.$oNum);
	}

	public function parseOrderDetailNew($oNum) {
		global $cartObj, $searchObj, $orderObj;
		$template = file_get_contents('templates/order_details/detailForm.html');
		$sql = "SELECT dso.*, dsod.salesRepName, dsod.internalNotes, dsw.warrantyType, dsw.id AS warrantyTypeId FROM ds_orders AS dso LEFT JOIN ds_order_service_details AS dsod ON dso.oID = dsod.orderId LEFT JOIN ds_warranty_types AS dsw ON dsod.warrantyId = dsw.id WHERE oNum='$oNum' LIMIT 1;";
		$data = $this->db_query($sql, 'select-single', true);

		$order_logs = '';
		if ($logs = $orderObj->get_history($oNum)) {
			foreach ($logs as $log) {
				$order_logs .= '<tr><td class="small" nowrap="nowrap">' . $this->format_date('templ_full', $log['time'])
					. '&nbsp;&nbsp;</td><td class="small">' . $log['details']
					. '&nbsp;&nbsp;</td><td class="small">' . $log['userName'] . '</td></tr>';
			}
		}

		$parse = array(
			'ONUM' => $oNum,
			'CART_ITEMS' => $cartObj->show_admin($oNum, 0, DISABLE_MULTIPLE_ITEMS),
			// 'ORDER_NOTES' => $searchObj->display_notes($searchObj->search_records('ds_order_notes', $oNum, 'oNumber', 'nID'), false),
			'ORDER_LOGS' => $order_logs,
			'STATII' => self::getOrderStatiiOptions($data['cStatus']),
			'SHIPMETHODS' => self::getShipMethodOptions($data['cShipService']),
			'MACHINETYPES' => self::getMachineTypeOptions($data['machineType']),
			'SALESPEOPLE' => self::getSalespersonOptions(),
			'WARRANTY_TYPES' => self::getWarrantyTypes($data['warrantyTypeId'])
		);
		$checkboxKeys = array(
			"oACAdapter", "oRMA"
		);
		foreach ($data as $key => $value) {
			if (in_array($key, $checkboxKeys)) {
				$parse[strtoupper($key)] = $value == "Y" ? "checked" : "";
			}
			else {
				$parse[strtoupper($key)] = $value;
			}
		}

		return $this->parse($template, $parse);
	}

	private static function performDatabaseInsertions($oNum, $submitted) {
		global $cartObj, $orderObj;
		$db = new Database;
		if ($submitted['submit_action'] == ORDER_SAVE_BUTTON) {
			if ($submitted['cStatus'] == STATUS_REFURB_COMPLETE || $submitted['cStatus'] == STATUS_SERVICE_COMPLETE) {
				$submitted['dateCompleted'] = $db->format_date('db_date');
			}
		}
		else if ($action2 == ORDER_RETURN_BUTTON) {
			$orderObj->create_from_cust(
				$submitted, $data['customer_id'], SHIP_RMA_ROUND_GROUND
				, substr($data['oNum'], 0, 2), 'This is an RMA order for #' . $oNum, 'Y'
			);

		# SUB2: PROCESS RETURN STEP 2
		}
		else if ($action2 == ORDER_RETURN2_BUTTON) {

			# SEND RMA ORDER CONFIRMATION EMAIL
			if ($pricing = $cartObj->get_pricing($oNum, $data['customer_id'], $submitted)) {
				if ($cart = $cartObj->get_data($oNum, $pricing)) {
					if ($orderObj->receipt(
							array($cart), array($submitted), array($oNum)
							, ($data['customer_id'] == SQUARETRADE_CUST_ID), false
						)
					) {
						$output .= '<p>' . EMAIL_SENT;
					}
				}
			}

			# PROCESS CUSTOMER RETURN MAILING, ONLY IF NEW BOX NOT CHOSEN
			if ($submitted['new_box'] != 'Y' && $submitted['imac_box'] != 'Y') {
				list($from, $method) = $orderObj->get_ship_address(
					$data, ($data['customer_id'] == SQUARETRADE_CUST_ID)
				);
				$ship_data = array_merge($data, array('oNum' => $oNum));
				list($to, $retval) = $orderObj->get_ship_address(
					$warehouse_info, ($data['customer_id'] == SQUARETRADE_CUST_ID)
				);
				if ($tracking = $upsObj->ship(
						$ship_data, $from, $to, $method, 'weight_full', 'ship_tracking_id2', 'RZ', false, false, false, ($data['customer_id'] == SQUARETRADE_CUST_ID)
					)
				) {
					if (is_array($tracking)) {
						$output .= '<p class="error">' . implode('<br />', $tracking);
					} else {
						$data['ship_tracking_id2'] = $tracking;
						$output .= '<p>' . SUCCESS_RETURN;
						if ($upsObj->email_label($data, $submitted['cShipEmail'], $tracking)) {
							$output .= '<p>' . EMAIL_SENT;
						}
					}
				}
			}
		}

		# SAVE CART CHANGES
		$cartObj->check_changes(
			$oNum, $submitted['pID'][0], $submitted['pQty'][0], $submitted['pPrice'][0], $oNum
		);

		# RE-CALCULATE PRICING - DUE TO COUPON OR CART CHANGES
		if ($pricing = $cartObj->get_pricing($oNum, $data['customer_id'], $submitted)) {
			$submitted['cSubTotal']	= $pricing['cSubTotal'];
			$submitted['cTax']		= $pricing['cTax'];
			$submitted['cTotal']	= $pricing['cTotal'];
			$submitted['cDiscount']	= $pricing['cDiscount'];
			$submitted['cShipping']	= $pricing['cShipping'];
		}


		$tableFields = $db->getTableFields('ds_orders');
		$unusedFields = array();
		$i = 0;
		$sql = "UPDATE `ds_orders` SET ";
		foreach ($submitted as $key => $value) {
			if (in_array($key, $tableFields)) {
				if ($i) {
					$sql .= ', ';
				}
				if (!$value || $value == '') {
					$value = "NULL";
				}
				else {
					if ($key == 'machineType') {
						$value = "(SELECT machine_description FROM machine_lookup WHERE machine_id='$value')";
					}
					else {
						$value = mysql_real_escape_string(trim($value));
						$value = "'$value'";
					}
				}
				$sql .= "`$key`=$value";
				$i++;
			}
			else {
				array_push($unusedFields, $key);
			}
		}
		$sql .= " WHERE `oNum`='$oNum';";
		$db->db_query($sql, 'update', true);


		// Details insertion
		$orderId = substr($oNum, 2);
		$warrantyId = $submitted['warrantyType'];
		$salesRepName = $submitted['salesperson'];
		$internalNotes = mysql_real_escape_string($submitted['internalNotes']);
		if ($salesRepName) {
			$sql = "REPLACE INTO `ds_order_service_details`(`orderId`, `warrantyId`, `salesRepName`, `salesRepId`, `internalNotes`) VALUES ('$orderId', '$warrantyId', '$salesRepName', IFNULL((SELECT `id` FROM `order_salespersons` WHERE `name` LIKE '$salesRepName%' LIMIT 1), NULL), '$internalNotes');";
		}
		else {
			$sql = "REPLACE INTO `ds_order_service_details`(`orderId`, `warrantyId`, `salesRepName`, `salesRepId`, `internalNotes`) VALUES ('$orderId', '$warrantyId', NULL, NULL, '$internalNotes');";
		}
		$db->db_query($sql, 'insert', true);

		// Note insertion
		if ($submitted['nNote']) {
			$sent = 'N';
			if ($submitted['nStatus'] == 'external') {
				$sent = 'Y';
			}
			$orderObj->insert_note($oNum, $submitted, $sent, $_SESSION['aUser'], ($data['customer_id'] == SQUARETRADE_CUST_ID), ($submitted['physical_damage'] == 'Y'));
		}

		// sleep(10);
		// header('Location:'.CONTROLLER.'?m=order_detail_new&oNum='.$oNum);
	}


	private static function getOrderStatiiOptions($cStatus) {
		global $order_statii;
		$optionString = '';
		foreach (array_keys($order_statii) as $status) {
			if ($status == $cStatus) {
				$selected = 'selected';
			}
			else {
				$selected = '';
			}
			$optionString .= "<option $selected value='$status'>$status</option>";
		}
		return $optionString;
	}

	private static function getShipMethodOptions($shipMethod) {
		global $ship_methods;
		$optionString = '';
		foreach (array_keys($ship_methods) as $method) {
			if ($method == $shipMethod) {
				$selected = 'selected';
			}
			else {
				$selected = '';
			}
			$optionString .= "<option $selected value='$method'>$method</option>";
		}
		return $optionString;
	}

	private static function getMachineTypeOptions($machineType) {
		$db = new Database;
		$sql = "SELECT machine_id AS `id`, machine_description AS `description` FROM machine_lookup WHERE `enabled`='1' ORDER BY `description` ASC;";
		$machines = $db->db_query($sql, 'select-multiple', true);
		// echo "<pre>";
		// print_r($machines);
		// echo "</pre>";
		$optionString = '';
		foreach ($machines as $machine) {
			// if ($machine['id'] == '465') {
			// 	echo "<pre>";
			// 	print_r($machine);
			// 	echo "</pre>";
			// }
			$machineId = $machine['id'];
			$machineDescription = $machine['description'];
			$selected = '';
			if ($machineDescription == $machineType) {
				$selected = 'selected';
			}
			// echo "<p>$machineId $machineDescription $selected</p>";
			$optionString .= "<option $selected value='$machineId'>$machineDescription</option>";
			// if ($machine['id'] == '465') {
			// 	echo "<pre>";
			// 	echo "$machineId $machineDescription $selected\n";
			// 	echo "$optionString\n";
			// 	echo "</pre>";
			// }
		}
		return $optionString;
	}

	private static function getSalespersonOptions() {
		$activeSalespersons = array(
			'Amber Leimbrock Baker',
			'Bonny Hoza'
		);
		foreach ($activeSalespersons as $person) {
			$optionString .= "<option value='$person'>";
		}
		return $optionString;
	}

	private static function getWarrantyTypes($warrantyTypeId) {
		$db = new Database;
		$sql = "SELECT `id`, `warrantyType` FROM `ds_warranty_types` WHERE `active`='1';";
		$results = $db->db_query($sql, 'select-multiple', true);
		$optionString = '';
		foreach ($results as $result) {
			$warrantyId = $result['id'];
			$warrantyType = $result['warrantyType'];
			$selected = '';
			if ($warrantyId == $warrantyTypeId) {
				$selected = 'selected';
			}
			$optionString .= "<option $selected value='$warrantyId'>$warrantyType</option>";
		}
		return $optionString;
	}
}
