<?php

class OpenQuotesService {

	public static function getOpenQuotesFromZoho() {
		global $zohoObj;
		$openQuotes = $zohoObj->getOpenQuotes();
		return $openQuotes;
	}

	public static function getOpenQuotes() {
		$db = new Database;
		$sql = "SELECT oq.zoho_id AS quoteZohoId, oq.mts_number AS quoteMtsNumber, oq.subject AS quoteSubject, oq.notes AS quoteNotes, oq.date_created AS quoteDateCreated, oq.price_date AS quotePriceDate, oq.ship_date AS quoteShipDate, oq.request_for_bid AS quoteRfb, oqs.status AS quoteStatus, oq.status_id AS quoteStatusId, oa.zoho_id AS accountZohoId, oa.`name` AS accountName, oll.zoho_id AS productZohoId, oll.`name` AS productName, oll.code AS productCode, oqll.description AS productDescription, oqll.quantity AS productQuantity, oqll.aGradePrice, oqll.bGradePrice, oqll.cGradePrice, oqll.dGradePrice, os.zoho_id AS salespersonZohoId, os.name AS salespersonName, IFNULL(states.abbreviation, 'UK') AS stateAbbreviation, IFNULL(states.name, 'Unknown') AS stateName
				FROM `open_quotes` AS oq
				LEFT JOIN open_quote_line_items AS oqll ON oqll.open_quote_id = oq.id
				LEFT JOIN order_line_items AS oll ON oqll.line_item_id = oll.id
				LEFT JOIN order_accounts AS oa ON oa.id = oq.account_id
				LEFT JOIN order_salespersons AS os ON os.id = oq.salesperson_id
				LEFT JOIN states ON states.id = oq.state_id
				LEFT JOIN open_quote_statuses AS oqs ON oq.status_id = oqs.id
				WHERE oq.active = '1'
				ORDER BY oq.date_created DESC;";

		$results = $db->db_query($sql, 'select-multiple', true);

		$openQuotes = array();
		foreach ($results as $result) {
			$quoteZohoId = $result['quoteZohoId'];
			if (!$openQuotes[$quoteZohoId]) {
				$openQuotes[$quoteZohoId] = new OpenQuote($result);
			}
			else {
				$openQuotes[$quoteZohoId]->addLineItem($result);
			}
		}
		// echo "<pre>";
		// print_r($openQuotes);
		// echo "</pre>";
		return array_values($openQuotes);
	}

	public static function getOpenQuoteStatuses() {
		$db = new Database;
		$sql = "SELECT * FROM `open_quote_statuses` ORDER BY `id` ASC;";
		$results = $db->db_query($sql, 'select-multiple', true);
		$statuses = array();
		foreach ($results as $result) {
			$status = new stdClass;
			$status->id = $result['id'];
			$status->status = $result['status'];
			array_push($statuses, $status);
		}
		return $statuses;
	}

	public static function getDistinctSalespersonsFromRecords($records) {
		$salespersons = array();
		foreach ($records as $record) {
			$recordSalesperson = (object)$record['salesperson'];
			$salespersonZohoId = $recordSalesperson->Owner_Id;
			if (!$salespersons[$salespersonZohoId]) {
				$salesperson = new stdClass;
				$salesperson->zoho_id = $recordSalesperson->Owner_Id;
				$salesperson->name = $recordSalesperson->Owner;
				$salespersons[$salespersonZohoId] = $salesperson;
			}
		}
		return $salespersons;
	}

	public static function getExistingSalespersonsFromZohoIdList($zohoIds) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$zohoIdString = implode("', '", $zohoIds);

		$sql = "SELECT `zoho_id`, `name` FROM `order_salespersons` WHERE `zoho_id` IN ('$zohoIdString');";
		$results = $db->db_query($sql, 'select-multiple', true);
		$salespersons = array();
		foreach ($results as $result) {
			$salesperson = new stdClass;
			$salesperson->zoho_id = $result['zoho_id'];
			$salesperson->name = $result['name'];

			$salespersons[$salesperson->zoho_id] = $salesperson;
		}
		return $salespersons;
	}

	public static function getNewOrModifiedSalespersons($passedSalespersons) {
		$existingSalespersons = self::getExistingSalespersonsFromZohoIdList(array_keys($passedSalespersons));

		$newOrModifiedSalespersons = array();

		foreach ($passedSalespersons as $passedSalesperson) {
			$zohoId = $passedSalesperson->zoho_id;
			$name = $passedSalesperson->name;

			if (!$existingSalespersons[$zohoId]) {
				$newOrModifiedSalespersons[$zohoId] = $passedSalesperson;
			}
			else {
				$existingSalesperson = $existingSalespersons[$zohoId];
				if ($name != $existingSalesperson->name) {
					$newOrModifiedSalespersons[$zohoId] = $passedSalesperson;
				}
			}
		}

		return $newOrModifiedSalespersons;
	}

	public static function insertSalespersonsIntoDatabase($salespersons) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;
		foreach ($salespersons as $salesperson) {
			$zohoId = $salesperson->zoho_id;
			$name = mysql_real_escape_string($salesperson->name);
			$sql = "INSERT INTO `order_salespersons`(`name`, `zoho_id`) VALUES ('$name', '$zohoId') ON DUPLICATE KEY UPDATE `name`='$name';";
			$db->db_query($sql, 'insert', true);
			$db->resetAutoIncrement('order_salespersons');
		}
	}

	public static function getDistinctAccountsFromRecords($records) {
		$accounts = array();
		foreach ($records as $record) {
			$recordAccount = (object)$record['account'];
			$accountZohoId = $recordAccount->Account_Id;
			if (!$accounts[$accountZohoId]) {
				$account = new stdClass;
				$account->zoho_id = $recordAccount->Account_Id;
				$account->name = $recordAccount->Account_Name;
				$accounts[$accountZohoId] = $account;
			}
		}
		return $accounts;
	}

	public static function getExistingAccountsFromZohoIdList($zohoIds) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$zohoIdString = implode("', '", $zohoIds);

		$sql = "SELECT `zoho_id`, `name` FROM `order_accounts` WHERE `zoho_id` IN ('$zohoIdString');";
		$results = $db->db_query($sql, 'select-multiple', true);
		$accounts = array();
		foreach ($results as $result) {
			$account = new stdClass;
			$account->zoho_id = $result['zoho_id'];
			$account->name = $result['name'];

			$accounts[$account->zoho_id] = $account;
		}
		return $accounts;
	}

	public static function getNewOrModifiedAccounts($passedAccounts) {
		$existingAccounts = self::getExistingAccountsFromZohoIdList(array_keys($passedAccounts));

		$newOrModifiedAccounts = array();

		foreach ($passedAccounts as $passedAccount) {
			$zohoId = $passedAccount->zoho_id;
			$name = $passedAccount->name;

			if (!$existingAccounts[$zohoId]) {
				$newOrModifiedAccounts[$zohoId] = $passedAccount;
			}
			else {
				$existingAccount = $existingAccounts[$zohoId];
				if ($name != $existingAccount->name) {
					$newOrModifiedAccounts[$zohoId] = $passedAccount;
				}
			}
		}

		return $newOrModifiedAccounts;
	}

	public static function insertAccountsIntoDatabase($accounts) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;
		foreach ($accounts as $account) {
			$zohoId = $account->zoho_id;
			$name = mysql_real_escape_string($account->name);
			$sql = "INSERT INTO `order_accounts`(`name`, `zoho_id`) VALUES ('$name', '$zohoId') ON DUPLICATE KEY UPDATE `name`='$name';";
			$db->db_query($sql, 'insert', true);
			$db->resetAutoIncrement('order_accounts');
		}
	}

	public static function getDistinctLineItemsFromRecords($records) {
		$lineItems = array();
		foreach ($records as $record) {
			$recordLineItems = $record['lineItems'];
			foreach ($recordLineItems as $lineItem) {
				$lineItem = (object)$lineItem;
				$itemZohoId = $lineItem->id;
				if (!$lineItems[$itemZohoId]) {
					$item = new stdClass;
					$item->zoho_id = $lineItem->id;
					$item->code = $lineItem->code;
					$item->name = $lineItem->name;
					$lineItems[$itemZohoId] = $item;
				}
			}
		}
		return $lineItems;
	}

	public static function getExistingLineItemsFromZohoIdList($zohoIds) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$zohoIdString = implode("', '", $zohoIds);

		$sql = "SELECT `zoho_id`, `name`, `code` FROM `order_line_items` WHERE `zoho_id` IN ('$zohoIdString');";
		$results = $db->db_query($sql, 'select-multiple', true);
		$lineItems = array();
		foreach ($results as $result) {
			$lineItem = new stdClass;
			$lineItem->zoho_id = $result['zoho_id'];
			$lineItem->name = $result['name'];
			$lineItem->code = $result['code'];

			$lineItems[$lineItem->zoho_id] = $lineItem;
		}
		return $lineItems;
	}

	public static function getNewOrModifiedLineItems($passedLineItems) {
		$debug = false;
		if ($_GET['debug'] == 'yes') {
			$debug = true;
		}


		if ($debug) {
			// echo "<pre>";
			// print_r($passedLineItems);
			// echo "</pre>";
		}

		$existingLineItems = self::getExistingLineItemsFromZohoIdList(array_keys($passedLineItems));


		if ($debug) {
			// echo "<pre>";
			// print_r($existingLineItems);
			// echo "</pre>";
		}

		$newOrModifiedLineItems = array();

		foreach ($passedLineItems as $passedLineItem) {
			$zohoId = $passedLineItem->zoho_id;
			$name = $passedLineItem->name;
			$code = $passedLineItem->code;

			if (!$existingLineItems[$zohoId]) {
				$newOrModifiedLineItems[$zohoId] = $passedLineItem;
			}
			else {
				$existingLineItem = $existingLineItems[$zohoId];
				if ($name != $existingLineItem->name || $code != $existingLineItem->code) {
					$newOrModifiedLineItems[$zohoId] = $passedLineItem;
				}
			}
		}
		if ($debug) {
			// echo "<pre>";
			// print_r($newOrModifiedLineItems);
			// echo "</pre>";
		}

		return $newOrModifiedLineItems;
	}

	public static function insertLineItemsIntoDatabase($lineItems) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;
		foreach ($lineItems as $lineItem) {
			$zohoId = $lineItem->zoho_id;
			$code = mysql_real_escape_string($lineItem->code);
			$name = mysql_real_escape_string($lineItem->name);
			$sql = "INSERT INTO `order_line_items`(`name`, `code`, `zoho_id`) VALUES ('$name', '$code', '$zohoId') ON DUPLICATE KEY UPDATE `name`='$name', `code`='$code';";
			$db->db_query($sql, 'insert', true);
			$db->resetAutoIncrement('order_line_items');
		}
	}

	public static function parseOpenQuotes($openQuotes) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$openquotes = array();
		foreach ($openQuotes as $quote) {
			array_push($openquotes, new OpenQuote($quote['invoice']));
		}

		return $openquotes;
	}

	public static function markOldOpenQuotesInactive($openquotes) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$zohoIds = array();
		foreach ($openquotes as $openquote) {
			$zohoId = $openquote->getQuoteZohoId();
			array_push($zohoIds, $zohoId);
		}
		$zohoIdString = implode("', '", $zohoIds);
		$sql = "UPDATE `open_quotes` SET `active`='0' WHERE `zoho_id` NOT IN ('$zohoIdString');";
		$db->db_query($sql, 'update', true);
	}

	public static function performOpenQuoteInsertions($openquotes) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;
		$db->resetAutoIncrement('open_quotes');

		foreach ($openquotes as $openquote) {
			$zohoId = $openquote->getQuoteZohoId();
			$subject = $openquote->getQuoteSubject();
			$mtsNumber = $openquote->getQuoteMtsNumber();
			$createdTime = $openquote->getQuoteDateCreated();
			$ownerId = $openquote->getOwnerId();
			$accountId = $openquote->getAccountId();
			$products = $openquote->getLineItems();


			self::insertIntoOpenQuotesTable($openquote);
			self::deleteOpenQuoteLineItems($openquote);
			self::insertIntoOpenQuoteLineItemsTable($openquote);
			$db->resetAutoIncrement('open_quotes');
		}
	}

	private static function insertIntoOpenQuotesTable($openquote) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;
		$openquotesTableInsertQuery = $openquote->generateOpenQuotesTableInsertQuery();
		echo "<pre>";
		echo "$openquotesTableInsertQuery\n";
		echo "</pre>";
		$db->db_query($openquotesTableInsertQuery, "insert", true);

	}

	private static function deleteOpenQuoteLineItems($openquote) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;
		$openquotesLineItemsDeleteQuery = $openquote->generateOpenQuotesLineItemsDeleteQuery();
		echo "<pre>";
		echo "$openquotesLineItemsDeleteQuery\n";
		echo "</pre>";
		$db->db_query($openquotesLineItemsDeleteQuery, "delete", true);
	}

	private static function insertIntoOpenQuoteLineItemsTable($openquote) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;
		$openquotesLineItemsInsertQueries = $openquote->generateOpenQuoteLineItemsInsertQueries();
		foreach ($openquotesLineItemsInsertQueries as $openquotesLineItemsInsertQuery) {
			$db->db_query($openquotesLineItemsInsertQuery, "insert", true);
			echo "<pre>";
			echo "$openquotesLineItemsInsertQuery\n";
			echo "</pre>";
		}
	}

	public static function getOpenQuoteDatabaseId($zohoId) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$sql = "SELECT `id` FROM `open_quotes` WHERE `zoho_id`='$zohoId';";
		$result = $db->db_query($sql, 'select-single', true);
		$id = $result['id'];
		return $id;
	}

	public static function saveOpenQuoteChanges($openquoteData) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;
		$quoteZohoId = $openquoteData->zohoId;
		$quoteDbId = self::getOpenQuoteDatabaseId($quoteZohoId);
		$lineItems = $openquoteData->lineItems;
		$fields = $openquoteData->fields;
		$statusId = $openquoteData->fields->statusId;
		$notes = mysql_real_escape_string($openquoteData->fields->notes);

		$sql = "UPDATE `open_quotes` SET `notes`='$notes', `status_id`='$statusId' WHERE `id`='$quoteDbId';";
		echo $sql . "\n";
		$db->db_query($sql, 'update',true);

		foreach ($lineItems as $lineItem) {
			$lineItemZohoId = $lineItem->zohoId;
			$fields = $lineItem->fields;
			$valueString = '';
			$i = 0;
			foreach ($fields as $field => $value) {
				if ($i) {
					$valueString .= ', ';
				}
				$valueString .= "`$field`='$value'";
				$i++;
			}
			$sql = "UPDATE `open_quote_line_items` SET $valueString WHERE `open_quote_id`='$quoteDbId' AND `line_item_id`=(SELECT `id` FROM `order_line_items` WHERE `zoho_id`='$lineItemZohoId' LIMIT 1);";
			echo $sql . "\n";
			$db->db_query($sql, 'update',true);
		}
	}
}

?>
