<?php

require_once(HTML_FOLDER . 'classes/OpenQuotes/Datasets/OpenQuoteLineItem.php');
require_once(HTML_FOLDER . 'classes/OpenQuotes/Datasets/OpenQuote.php');
require_once(HTML_FOLDER . 'classes/OpenQuotes/OpenQuotesService.php');
class OpenQuotesController {

	public static function openQuotesDashboard() {
		$admin = new Admin;
		$title="Open Quotes";
		$templateElements = array(
			"SCRIPTS" => 	IMPORT_JQUERY . IMPORT_JQUERY_UI . '<script src="__CDN_JAVASCRIPT__javascript/column_definition/column_definition.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/openQuotes/datasets/LineItem.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/openQuotes/datasets/Status.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/openQuotes/datasets/OpenQuote.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/openQuotes/openQuotesDashboardController.js" type="text/javascript"></script>'
		);

		echo $admin->parse(TEMPLATE, array('BODY' => $admin->parse(OPEN_QUOTES_DASHBOARD, $templateElements), "TITLE" => $title));
	}

	public static function getOpenQuotes() {
		$openQuotes = OpenQuotesService::getOpenQuotes();
		$openQuoteStatuses = OpenQuotesService::getOpenQuoteStatuses();
		$returnData = new stdClass;
		$returnData->openQuotes = $openQuotes;
		$returnData->statuses = $openQuoteStatuses;
		return $returnData;
	}

	public static function getOpenQuotesFromZoho() {
		$openQuotes = OpenQuotesService::getOpenQuotesFromZoho();
	}

	public static function refreshOpenQuotes() {
		$debug = false;
		if ($_GET['debug'] == 'yes') {
			$debug = true;
		}

		$openQuotes = OpenQuotesService::getOpenQuotesFromZoho();
		if ($debug) {
			// echo "<pre>";
			// print_r($openQuotes);
			// echo "</pre>";
		}
		$newOrModifiedLineItems = OpenQuotesService::getNewOrModifiedLineItems(OpenQuotesService::getDistinctLineItemsFromRecords($openQuotes));
		if ($debug) {
			echo "<pre>";
			print_r($newOrModifiedLineItems);
			echo "</pre>";
		}
		$accounts = OpenQuotesService::getNewOrModifiedAccounts(OpenQuotesService::getDistinctAccountsFromRecords($openQuotes));
		if ($debug) {
			echo "<pre>";
			print_r($accounts);
			echo "</pre>";
		}
		$salespersons = OpenQuotesService::getNewOrModifiedSalespersons(OpenQuotesService::getDistinctSalespersonsFromRecords($openQuotes));
		if ($debug) {
			echo "<pre>";
			print_r($salespersons);
			echo "</pre>";
		}
		$openQuotes = OpenQuotesService::parseOpenQuotes($openQuotes);
		if ($debug) {
			echo "<pre>";
			print_r($openQuotes);
			echo "</pre>";
		}
		if ($newOrModifiedLineItems && count($newOrModifiedLineItems) > 0) {
			OpenQuotesService::insertLineItemsIntoDatabase($newOrModifiedLineItems);
		}
		if ($accounts && count($accounts) > 0) {
			OpenQuotesService::insertAccountsIntoDatabase($accounts);
		}
		if ($salespersons && count($salespersons) > 0) {
			OpenQuotesService::insertSalespersonsIntoDatabase($salespersons);
		}
		OpenQuotesService::performOpenQuoteInsertions($openQuotes);
		OpenQuotesService::markOldOpenQuotesInactive($openQuotes);
	}

	public static function saveOpenQuoteChanges($openQuoteData) {
		try {
			OpenQuotesService::saveOpenQuoteChanges($openQuoteData);
			return true;
		}
		catch (Exception $e) {
			return false;
		}
	}
}

?>
