<?php

class OpenQuoteLineItem {
	public $productZohoId;
	public $productName;
	public $productCode;
	public $productDescription;
	public $productQuantity;
	public $productTotal;
	public $aGradePrice;
	public $bGradePrice;
	public $cGradePrice;
	public $dGradePrice;

	public function __construct($data) {
		if (is_array($data) && $data['id']) {
			$this->productZohoId = $data['id'];
			$this->productName = $data['name'];
			$this->productCode = $data['code'];
			$this->productDescription = $data['description'];
			$this->productQuantity = (int)$data['quantity'];
			$this->productTotal = (float)$data['total'];
		}
		elseif (!is_array($data) && $data->id) {
			$this->productZohoId = $data->id;
			$this->productName = $data->name;
			$this->productCode = $data->code;
			$this->productDescription = $data->description;
			$this->productQuantity = (int)$data->quantity;
			$this->productTotal = (float)$data->total;
		}
		else {
			if (is_array($data)) {
				$data = (object)$data;
			}
			$this->productZohoId = $data->productZohoId;
			$this->productName = $data->productName;
			$this->productCode = $data->productCode;
			$this->productDescription = $data->productName;
			$this->productQuantity = $data->productQuantity;
			$this->aGradePrice = $data->aGradePrice;
			$this->bGradePrice = $data->bGradePrice;
			$this->cGradePrice = $data->cGradePrice;
			$this->dGradePrice = $data->dGradePrice;
		}
	}

	public function getProductZohoId() {
		return $this->productZohoId;
	}

	public function getProductQuantity() {
		return $this->productQuantity;
	}

	public function getProductDescription() {
		return $this->productDescription;
	}
}

?>
