<?php

/*
[0] => 835703000096941180
[quoteZohoId] => 835703000096941180
[1] => MTS97734
[quoteMtsNumber] => MTS97734
[2] => Buyback - 213 Mixed iPads
[quoteSubject] => Buyback - 213 Mixed iPads
[3] => 2021-02-09 08:07:33
[quoteDateCreated] => 2021-02-09 08:07:33
[4] => 0
[quoteRfb] => 0
[5] => 835703000083400415
[accountZohoId] => 835703000083400415
[6] => Annie Sims Elementary School
[accountName] => Annie Sims Elementary School
[7] => 1
[productQuantity] => 1
[8] => iPad Air 2, 16GB (Wi-Fi Only)
[productName] => iPad Air 2, 16GB (Wi-Fi Only)
[9] => MGL12LL/A
[productCode] => MGL12LL/A
[10] =>
[productDescription] =>
[11] => 835703000006898001
[salespersonZohoId] => 835703000006898001
[12] => Jason Melero
[salespersonName] => Jason Melero
*/

class OpenQuote {
	public $quoteZohoId;
	public $quoteMtsNumber;
	public $quoteSubject;
	public $quoteDateCreated;
	public $quoteRfb;
	public $accountZohoId;
	public $accountName;
	public $salespersonZohoId;
	public $salespersonName;
	public $lineItems;
	public $stateName;
	public $stateAbbreviation;

	public function __construct($data) {

		if (is_array($data) && $data['Invoice_Id']) {
			$this->quoteZohoId = $data['Invoice_Id'];
			$this->salespersonZohoId = $data['Owner_Id'];
			$this->accountZohoId = $data['Account_Id'];
			$this->quoteMtsNumber = $data['MTS_Quote_Number'];
			$this->quoteSubject = $data['Subject'];
			$this->stateAbbreviation = $data['State'];
			$this->quoteRfb = strpos($data['Quote_Stage'], 'RFB') !== false ? 1 : 0;
			$this->quoteDateCreated = DateTime::createFromFormat(DATE_ATOM, $data['Created_Time'])->format('Y-m-d H:i:s');
			$this->lineItems = array();
			foreach ($data['Products'] as $product) {
				$productObject = (object)$product;
				$lineItem = new OpenQuoteLineItem($productObject);
				array_push($this->lineItems, $lineItem);
			}
		}
		else {
			if (is_array($data)) {
				$data = (object)$data;
			}
			$this->quoteZohoId = $data->quoteZohoId;
			$this->quoteMtsNumber = $data->quoteMtsNumber;
			$this->quoteSubject = $data->quoteSubject;
			$this->quoteDateCreated = $data->quoteDateCreated;
			$this->quotePriceDate = $data->quotePriceDate;
			$this->quoteShipDate = $data->quoteShipDate;
			$this->quoteRfb = $data->quoteRfb;
			$this->quoteStatus = $data->quoteStatus;
			$this->quoteNotes = $data->quoteNotes;
			$this->quoteStatusId = $data->quoteStatusId;
			$this->accountZohoId = $data->accountZohoId;
			$this->accountName = $data->accountName;
			$this->salespersonZohoId = $data->salespersonZohoId;
			$this->salespersonName = $data->salespersonName;
			$this->stateName = $data->stateName;
			$this->stateAbbreviation = $data->stateAbbreviation;
			$this->lineItems = array();
			$firstLineItem = new OpenQuoteLineItem($data);
			array_push($this->lineItems, $firstLineItem);
		}
	}

	public function getQuoteZohoId() {
		return $this->quoteZohoId;
	}

	public function getQuoteMtsNumber() {
		return $this->quoteMtsNumber;
	}

	public function getQuoteSubject() {
		return $this->quoteSubject;
	}

	public function getQuoteDateCreated() {
		return $this->quoteDateCreated;
	}

	public function getOwnerId() {
		return $this->salespersonZohoId;
	}

	public function getAccountId() {
		return $this->accountZohoId;
	}

	public function getLineItems() {
		return $this->lineItems;
	}

	public function getRequestForBid() {
		return $this->quoteRfb;
	}

	public function getStateAbbreviation() {
		return $this->stateAbbreviation;
	}

	public function addLineItem($data) {
		array_push($this->lineItems, new OpenQuoteLineItem($data));
	}

	public function generateOpenQuotesTableInsertQuery() {
		$zohoId = $this->getQuoteZohoId();
		$mtsNumber = $this->getQuoteMtsNumber();
		$subject = mysql_real_escape_string($this->getQuoteSubject());
		$rfb = $this->getRequestForBid();
		$dateCreated = $this->getQuoteDateCreated();
		$ownerId = $this->getOwnerId();
		$accountId = $this->getAccountId();
		$state = $this->getStateAbbreviation();

		$query = "INSERT INTO `open_quotes`(`zoho_id`, `mts_number`, `subject`, `request_for_bid`, `date_created`, `account_id`, `salesperson_id`, `state_id`) VALUES ('$zohoId', '$mtsNumber', '$subject', '$rfb', '$dateCreated', (SELECT `id` FROM `order_accounts` WHERE `zoho_id`='$accountId'), (SELECT `id` FROM `order_salespersons` WHERE `zoho_id`='$ownerId'), (SELECT `id` FROM `states` WHERE `abbreviation`='$state')) ON DUPLICATE KEY UPDATE `subject`='$subject', `request_for_bid`='$rfb', `state_id`=(SELECT `id` FROM `states` WHERE `abbreviation`='$state'), `active`='1';";

		return $query;
	}

	public function generateOpenQuotesLineItemsDeleteQuery() {
		$zohoId = $this->getQuoteZohoId();

		$lineItemZohoIds = array();
		$lineItems = $this->getLineItems();
		foreach ($lineItems as $lineItem) {
			array_push($lineItemZohoIds, $lineItem->getProductZohoId());
		}

		$lineItemZohoIdString = implode("', '", $lineItemZohoIds);

		$query = "DELETE FROM `open_quote_line_items` WHERE `open_quote_id` = (SELECT `id` FROM `open_quotes` WHERE `zoho_id`='$zohoId') AND `line_item_id` NOT IN (SELECT * FROM (SELECT `id` FROM order_line_items AS oll WHERE oll.zoho_id IN ('$lineItemZohoIdString')) AS subquery);";

		return $query;
	}

	public function generateOpenQuoteLineItemsInsertQueries() {
		$openQuoteId = OpenQuotesService::getOpenQuoteDatabaseId($this->getQuoteZohoId());

		$products = $this->getLineItems();

		$queries = array();

		foreach($products as $product) {
			$productZohoId = $product->getProductZohoId();
			$quantity = $product->getProductQuantity();
			$description = mysql_real_escape_string($product->getProductDescription());

			$query = "INSERT INTO `open_quote_line_items`(`open_quote_id`, `line_item_id`, `quantity`, `description`) VALUES ('$openQuoteId', (SELECT `id` FROM `order_line_items` WHERE `zoho_id`='$productZohoId'), '$quantity', '$description') ON DUPLICATE KEY UPDATE `quantity`='$quantity', `description`='$description';";
			array_push($queries, $query);
		}

		return $queries;
	}

}

?>
