<?php

class OpenOrdersService {
	public static function getStatuses() {
		return OpenOrderStatus::getAll();
	}

	public static function getActiveOpenOrders() {
		$openOrders = OpenOrder::getAllActive();
		return $openOrders;
	}

	public static function updateOpenOrdersFromZoho() {
		global $zohoObj;
		$debug = false;
		if ($_GET['debug'] == 'yes' || $_GET['debug'] == '1') {
			$debug = true;
		}

		$records = $zohoObj->getSearchRecordsProducts();

		$accounts = array();
		$salespersons = array();
		$lineItems = array();
		$openOrders = array();

		$openOrderIds = array();

		foreach ($records as $record) {
			$salespersonData = array(
				'zohoId' => $record['Owner_Id'],
				'name' => $record['Owner']
			);
			$salesperson = new Salesperson($salespersonData);
			$salesperson->save();
			$salesperson->populateDbId();

			$accountData = array(
				'zohoId' => $record['Account_Id'],
				'name' => $record['Account_Name']
			);
			$account = new Account($accountData);
			$account->save();
			$account->populateDbId();
			$account->populateIsNewCustomer();

			$isNewCustomer = $account->getIsNewCustomer() ? '1' : '0';
			$notes = '';
			if ($isNewCustomer == '1') {
				$notes = '***NEW CUSTOMER - VERIFY CUSTOMER/AP BEFORE SHIPMENT***';
			}

			$openOrderData = array(
				'apDataPresent' => $record['AP_Data_Present'],
				'zohoId' => $record['Invoice_Id'],
				'mtsNumber' => $record['MTS_Quote_Number'],
				'subject' => $record['Subject'],
				'account' => $account,
				'salesperson' => $salesperson,
				'invoiceDate' => $record['Created_Time'],
				'total' => $record['Total'],
				'notes' => $notes,
				'newCustomerOrder' => $isNewCustomer
			);

			$openOrder = new OpenOrder($openOrderData);
			$openOrder->setDebug($debug);
			$openOrder->save();
			$openOrder->populateDbId();
			$openOrderId = $openOrder->getDbId();

			foreach ($record['Products'] as $product) {
				$productData = array(
					'zohoId' => $product['id'],
					'openOrderId' => $openOrderId,
					'code' => $product['code'],
					'name' => $product['name'],
					'quantity' => $product['quantity'],
					'total' => $product['total'],
					'deducted' => self::getIsDeductedFromTtsOpenOrders($product['id']),
				);
				$lineItem = new OpenOrderLineItem($productData);
				$lineItem->save();
				$lineItem->populateDbId();
				$openOrder->addLineItem($lineItem);
			}
			$openOrder->saveLineItemJoins();
			array_push($openOrders, $openOrder);
			array_push($openOrderIds, $openOrderId);
		}

		OpenOrder::setInactiveExcept($openOrderIds);

		if ($debug) {
			echo "<pre>";
			echo json_encode($openOrders, JSON_PRETTY_PRINT);
			echo "</pre>";
		}

		return $openOrders;
	}

	private static function getIsDeductedFromTtsOpenOrders($zohoId) {
		$db = new Database;

		$sql = "SELECT `deducted_on_open_orders` AS deducted FROM `order_line_items` WHERE `zoho_id`='$zohoId';";
		$result = $db->db_query($sql, 'select-single', true);
		$deducted = $result['deducted'] == '1' ? true : false;
		return $deducted;
	}

	public static function saveOpenOrderChanges($data) {
		$saveResults = OpenOrder::performSaveChanges($data);
		return $saveResults;
	}
}

?>
