<?php

class OpenOrderStatus {
	private static $dbTable = "open_order_statuses";

	public $dbId;
	public $status;
	public $identifier;
	public $displayOrder;

	public function __construct($data) {
		if (is_array($data)) {
			$data = (object)$data;
		}
		if ($data->dbId) {
			$this->dbId = $data->dbId;
		}
		elseif($data->id) {
			$this->dbId = $data->id;
		}
		if ($data->status) {
			$this->status = $data->status;
		}
		elseif ($data->statusName) {
			$this->status = $data->statusName;
		}
		else {
			$this->status = 'invalidstatus';
		}
		if ($data->identifier) {
			$this->identifier = $data->identifier;
		}
		elseif ($data->statusIdentifier) {
			$this->identifier = $data->statusIdentifier;
		}
		if ($data->displayOrder) {
			$this->displayOrder = $data->displayOrder;
		}
		elseif ($data->display_order) {
			$this->displayOrder = $data->display_order;
		}
	}

	public function getDbId() {
		return $this->dbId;
	}

	public function getStatusName() {
		return $this->status;
	}

	public function getIdentifier() {
		return $this->identifier;
	}

	public function getDisplayOrder() {
		return $this->displayOrder;
	}

	public static function getAll() {
		$db = new Database;
		$dbTable = self::getDbTable();
		$statusArray = array();

		$sql = "SELECT `id`, `status` AS statusName, `identifier`, `display_order` AS displayOrder FROM `$dbTable` ORDER BY displayOrder ASC;";
		$results = $db->db_query($sql, 'select-multiple', true);
		foreach ($results as $result) {
			$status = new OpenOrderStatus($result);
			array_push($statusArray, $status);
		}
		return $statusArray;
	}

	public static function getDbTable() {
		return self::$dbTable;
	}
}

?>
