<?php

class OpenOrderLineItem extends LineItem {
	private static $joinTable = "open_order_line_items";

	public $quantity;
	public $total;
	public $deducted;
	public $openOrderId;

	public function __construct($data) {
		if (is_array($data)) {
			$data = (object)$data;
		}

		parent::__construct($data);
		$this->quantity = (int)$data->quantity;
		$this->total = (float)$data->total;
		$this->deducted = $data->deducted;
		if ($data->openOrderId) {
			$this->openOrderId = $data->openOrderId;
		}
		elseif ($data->open_order_id) {
			$this->openOrderId = $data->open_order_id;
		}
	}

	public function getQuantity() {
		return $this->quantity;
	}
	public function setQuantity($quantity) {
		$this->quantity = $quantity;
	}

	public function getTotal() {
		return $this->total;
	}
	public function setTotal($total) {
		$this->total = $total;
	}

	public function getDeducted() {
		return $this->deducted;
	}
	public function setDeducted($deducted) {
		$this->deducted = $deducted;
	}

	public function getOpenOrderId() {
		return $this->openOrderId;
	}
	public function setOpenOrderId($openOrderId) {
		$this->openOrderId = $openOrderId;
	}

	public function isOpenOrderIdSet() {
		if ($this->getOpenOrderId()) {
			return true;
		}
		else {
			return false;
		}
	}

	public function populateData() {
		if (!$this->isDbIdSet()) {
			return false;
		}
		parent::populateData();
		$this->setDeducted($this->getDeductedOnOpenOrders());
		if (!$this->isOpenOrderIdSet()) {
			return false;
		}
		$db = new Database;

		$joinTable = self::getJoinTable();

		$lineItemId = $this->getDbId();
		$openOrderId = $this->getOpenOrderId();

		$sql = "SELECT * FROM `$joinTable` WHERE `line_item_id`='$lineItemId' AND `open_order_id`='$openOrderId';";
		$result = $db->db_query($sql, 'select-single', true);

		if ($result['quantity']) {
			$quantity = (int)$result['quantity'];
			$this->setQuantity($quantity);
		}
		if ($result['total']) {
			$total = (float)$result['total'];
		}
		return true;
	}

	public function saveJoin() {
		if (!$this->getOpenOrderId()) {
			return false;
		}
		if (!$this->populateDbId()) {
			$this->save();
			if (!$this->populateDbId()) {
				return false;
			}
		}

		$db = new Database;
		$joinTable = self::getJoinTable();

		$lineItemId = $this->getDbId();
		$openOrderId = $this->getOpenOrderId();
		$quantity = $this->getQuantity();
		$total = $this->getTotal();

		$sql = "INSERT INTO `$joinTable`(`line_item_id`, `open_order_id`, `quantity`, `total`) VALUES ('$lineItemId', '$openOrderId', '$quantity', '$total') ON DUPLICATE KEY UPDATE `quantity`='$quantity', `total`='$total';";
		$db->db_query($sql, 'insert', true);
		return true;
	}

	public static function getAllFromOrderId($orderId) {
		$db = new Database;
		$lineItemTable = self::getLineItemDbTable();
		$joinTable = self::getJoinTable();

		$sql = "SELECT lit.*, jt.* FROM `$lineItemTable` AS lit LEFT JOIN `$joinTable` AS jt ON jt.line_item_id = lit.id WHERE jt.open_order_id = '$orderId';";

		$results = $db->db_query($sql, 'select-multiple', true);

		$lineItems = array();
		foreach ($results as $result) {
			$lineItem = new OpenOrderLineItem($result);
			$lineItem->setDeducted($lineItem->getDeductedOnOpenOrders());
			array_push($lineItems, $lineItem);
		}
		return $lineItems;
	}

	public static function deleteExistingJoins($openOrderId) {
		$db = new Database;
		$joinTable = self::getJoinTable();

		$sql = "DELETE FROM `$joinTable` WHERE `open_order_id`='$openOrderId';";
		$db->db_query($sql, 'delete', true);
	}

	public static function getJoinTable() {
		return self::$joinTable;
	}
}

?>
