<?php

class OpenOrder extends ZohoOrder {
	public static $dbTable = "open_orders";
	public static $zohoIdFieldName = 'zoho_id';
	public static $newCustomerNoteString = '***NEW CUSTOMER - VERIFY CUSTOMER/AP BEFORE SHIPMENT***';

	public $statusId;
	public $assetTags;
	public $apDataPresent;
	public $newCustomerOrder;

	public function __construct($data, $options=0) {
		if (is_array($data)) {
			$data = (object)$data;
		}

		parent::__construct($data);

		if ($data->statusId) {
			$this->statusId = $data->statusId;
		}
		elseif ($data->status_id) {
			$this->statusId = $data->status_id;
		}

		if ($data->assetTags !== null) {
			$this->assetTags = boolval($data->assetTags);
		}
		elseif ($data->asset_tags !== null) {
			$this->assetTags = boolval($data->asset_tags);
		}

		if ($data->apDataPresent !== null) {
			$this->apDataPresent = boolval($data->apDataPresent);
		}
		elseif ($data->ap_data_present !== null) {
			$this->apDataPresent = boolval($data->ap_data_present);
		}
		elseif ($data->AP_Data_Present !== null) {
			$this->apDataPresent = boolval($data->AP_Data_Present);
		}

		if ($data->newCustomerOrder !== null) {
			$this->newCustomerOrder = boolval($data->newCustomerOrder);
		}
		elseif ($data->new_customer_order !== null) {
			$this->newCustomerOrder = boolval($data->new_customer_order);
		}

		if ($data->fields) {
			$this->notes = $data->fields->notes;
			$this->assetTags = (bool)$data->fields->assetTags;
			$this->statusId = $data->fields->statusId;
		}

		$this->populate($options);
	}

	public function getStatusId() {
		return $this->statusId;
	}
	public function setStatusId($statusId) {
		$this->statusId = $statusId;
	}

	public function getAssetTags() {
		return $this->assetTags;
	}
	public function setAssetTags($assetTags) {
		$this->assetTags = $assetTags;
	}

	public function getApDataPresent() {
		return $this->apDataPresent;
	}
	public function setApDataPresent($apDataPresent) {
		$this->apDataPresent = $apDataPresent;
	}

	public function getIsNewCustomerOrder() {
		return $this->newCustomerOrder;
	}
	public function setIsNewCustomerOrder($newCustomerOrder) {
		$this->newCustomerOrder = $newCustomerOrder;
	}

	public function getSubtotal() {
		return $this->getTotal();
	}
	public function setSubtotal($subtotal) {
		$this->setTotal($subtotal);
	}

	public function addLineItem($lineItem) {
		if (is_a($lineItem, 'OpenOrderLineItem')) {
			if ($this->isDbIdSet()) {
				$lineItem->setOpenOrderId($this->getDbId());
			}
			array_push($this->lineItems, $lineItem);
		}
		else {
			if ($this->isDbIdSet()) {
				if (is_array($lineItem)) {
					$lineItem = (object)$lineItem;
				}
				$lineItem->openOrderId = $this->getDbId();
			}
			array_push($this->lineItems, new OpenOrderLineItem($lineItem));
		}
	}

	public function populateDbId() {
		if ($this->isDbIdSet()) {
			return true;
		}
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$dbTable = self::getDbTable();
		$zohoIdField = self::getZohoIdFieldName();
		$zohoId = $this->getZohoId();

		$sql = "SELECT `id` FROM `$dbTable` WHERE `$zohoIdField`='$zohoId';";
		$result = $db->db_query($sql, 'select-single', true);
		$id = $result['id'];
		if ($id) {
			$this->setDbId($id);
			return true;
		}
		else {
			return false;
		}
	}

	public function populateData() {
		if (!$this->isDbIdSet()) {
			return false;
		}
		$db = new Database;

		$dbTable = self::getDbTable();
		$zohoIdField = self::getZohoIdFieldName();

		$id = $this->getDbId();

		$sql = "SELECT * FROM `$dbTable` WHERE `id`='$id';";
		$result = $db->db_query($sql, 'select-single', true);

		foreach ($result as $key => $value) {
			if ($key == '0' || intval($key) > 0) {
				continue;
			}
			$this->setKeyValue($key, $value);
		}
	}

	public function setKeyValue($key, $value) {
		if ($value === null) {
			return false;
		}
		$zohoIdAliases = array(
			'zohoId',
			'zoho_id',
			'Owner_Id'
		);
		$mtsNumberAliases = array(
			'mtsNumber',
			'mts_number'
		);
		$invoiceDateAliases = array(
			'invoiceDate',
			'invoice_date',
			'Created_Time'
		);
		$notesAliases = array(
			'notes',
		);
		$assetTagsAliases = array(
			'assetTags',
			'asset_tags',
		);
		$subtotalAliases = array(
			'subtotal',
			'total',
			'Total'
		);
		$newCustomerOrderAliases = array(
			'newCustomerOrder',
			'new_customer_order'
		);
		$statusIdAliases = array(
			'statusId',
			'status_id'
		);
		$apDataPresentAliases = array(
			'apDataPresent',
			'ap_data_present'
		);

		if (in_array($key, $zohoIdAliases)) {
			$this->setZohoId($value);
			return true;
		}
		elseif(in_array($key, $mtsNumberAliases)) {
			$this->setMtsNumber($value);
			return true;
		}
		elseif(in_array($key, $invoiceDateAliases)) {
			$this->setInvoiceDate($value);
			return true;
		}
		elseif (in_array($key, $notesAliases)) {
			$this->setNotes($value);
			return true;
		}
		elseif (in_array($key, $assetTagsAliases)) {
			$this->setAssetTags((bool)$value);
			return true;
		}
		elseif (in_array($key, $apDataPresentAliases)) {
			$this->setApDataPresent((bool)$value);
			return true;
		}
		elseif (in_array($key, $subtotalAliases)) {
			$this->setSubtotal((float)$value);
			return true;
		}
		elseif (in_array($key, $newCustomerOrderAliases)) {
			$this->setIsNewCustomerOrder((bool)$value);
			return true;
		}
		elseif (in_array($key, $statusIdAliases)) {
			$this->setStatusId($value);
			return true;
		}
		else {
			return false;
		}
	}

	public function generateInsertQuery() {
		$dbTable = self::getDbTable();
		$zohoIdField = self::getZohoIdFieldName();

		$zohoId = $this->getZohoId();

		$mtsNumber = $this->getMtsNumber();
		$invoiceDate = $this->getInvoiceDate();
		$invoiceDate = DateTime::createFromFormat(DATE_ATOM, $invoiceDate);
		$invoiceDate = $invoiceDate->format('Y-m-d H:i:s');
		$subtotal = $this->getTotal();
		$accountId = $this->getAccount()->getDbId();
		$salespersonId = $this->getSalesperson()->getDbId();
		$newCustomerOrder = $this->getIsNewCustomerOrder() ? '1' : '0';
		$notes = mysql_real_escape_string($this->getNotes());

		$sql = "INSERT INTO `$dbTable`
					(`$zohoIdField`, `mts_number`, `invoice_date`, `subtotal`, `account_id`, `salesperson_id`, `new_customer_order`, `notes`)
				VALUES
					('$zohoId', '$mtsNumber', '$invoiceDate', '$subtotal', '$accountId', '$salespersonId', '$newCustomerOrder', '$notes') ON DUPLICATE KEY UPDATE `subtotal`='$subtotal';";

		return $sql;
	}

	public function generateUpdateQuery() {
		$dbTable = self::getDbTable();

		$id = $this->getDbId();
		$total = $this->getTotal();

		$num = 0;
		$setClauses = array();
		if ($this->getStatusId()) {
			$statusId = $this->getStatusId();
			$clause = "`status_id`='$statusId'";
			array_push($setClauses, $clause);
			$num++;
		}
		if ($this->getNotes() != self::$newCustomerNoteString && $this->getNotes() !== null) {
			$existingNotes = $this->getExistingNotes();
			$notes = mysql_real_escape_string($this->getNotes());
			if ($notes != $existingNotes) {
				$clause = "`notes`='$notes'";
				array_push($setClauses, $clause);
				$num++;
			}
		}
		if ($this->getMtsNumber()) {
			$mtsNumber = $this->getMtsNumber();
			$clause = "`mts_number`='$mtsNumber'";
			array_push($setClauses, $clause);
			$num++;
		}
		if ($this->getTotal() !== null) {
			$total = $this->getTotal();
			$clause = "`subtotal`='$total'";
			array_push($setClauses, $clause);
			$num++;
		}
		if ($this->getAssetTags() !== null) {
			$assetTags = $this->getAssetTags() ? '1' : '0';
			$clause = "`asset_tags`='$assetTags'";
			array_push($setClauses, $clause);
			$num++;
		}
		if ($this->getInvoiceDate() !== null) {
			$invoiceDate = $this->getInvoiceDate();
			$invoiceDate = DateTime::createFromFormat(DATE_ATOM, $invoiceDate);
			$invoiceDate = $invoiceDate->format('Y-m-d H:i:s');
			$clause = "`invoice_date`='$invoiceDate'";
			array_push($setClauses, $clause);
			$num++;
		}
		if ($this->getAccount() !== null) {
			$accountId = $this->getAccount()->getDbId();
			$clause = "`account_id`='$accountId'";
			array_push($setClauses, $clause);
			$num++;
		}
		if ($this->getSalesperson() !== null) {
			$salespersonId = $this->getSalesperson()->getDbId();
			$clause = "`salesperson_id`='$salespersonId'";
			array_push($setClauses, $clause);
			$num++;
		}
		if ($this->getApDataPresent() !== null) {
			$apDataPresent = $this->getApDataPresent() ? '1' : '0';
			$clause = "`ap_data_present`='$apDataPresent'";
			array_push($setClauses, $clause);
			$num++;
		}

		if ($num > 0) {
			$setClauseString = implode(", ", $setClauses);
			$sql = "UPDATE `$dbTable` SET $setClauseString WHERE `id`='$id';";

			return $sql;
		}
		else {
			return false;
		}
	}

	public function save() {
		$db = new Database;
		$dbTable = self::getDbTable();
		$zohoIdField = self::getZohoIdFieldName();

		$this->populateDbId();
		$sql = '';

		if (!$this->isDbIdSet()) {
			$sql = $this->generateInsertQuery();
			$db->db_query($sql, 'insert', true);
			$db->resetAutoIncrement($dbTable);
		}
		else {
			$sql = $this->generateUpdateQuery();
			if ($sql) {
				$db->db_query($sql, 'update', true);
			}
		}
		return true;
	}

	public function saveLineItemJoins() {
		if (!$this->populateDbId()) {
			return false;
		}
		OpenOrderLineItem::deleteExistingJoins($this->getDbId());
		$lineItems = $this->getLineItems();
		foreach ($lineItems as $lineItem) {
			$lineItem->setOpenOrderId($this->getDbId());
			$lineItem->saveJoin();
		}
		return true;
	}

	public function getExistingNotes() {
		$db = new Database;
		$dbTable = self::getDbTable();

		$notes = '';
		if ($this->populateDbId()) {
			$id = $this->getDbId();
			$sql = "SELECT `notes` FROM `$dbTable` WHERE `id`='$id';";
			$result = $db->db_query($sql, 'select-single');
			$notes = $result['notes'];
		}
		return $notes;
	}

	public function populate($options) {
		if (is_string($options)) {
			$optionVal = 0;
			if ($options == 'all') {
				$optionVal = 15;
			}
			$options = $optionVal;
		}
		// If >= 8, populate salesperson
		if ($options >= 8) {
			if ($this->getSalesperson() != null) {
				$this->getSalesperson()->populateData();
			}
			$options -= 8;
		}
		// if >= 4, populate account
		if ($options >= 4) {
			if ($this->getAccount() != null) {
				$this->getAccount()->populateData();
			}
			$options -= 4;
		}
		if ($options >= 2) {
			$this->setLineItems(OpenOrderLineItem::getAllFromOrderId($this->getDbId()));
			$options -= 2;
		}
		if ($options >= 1) {
			$this->populateData();
			$options -= 1;
		}
	}

	public static function setInactiveExcept($orderIds) {
		$db = new Database;
		$dbTable = self::getDbTable();
		$sql = "UPDATE `$dbTable` SET `active` = '0';";
		$db->db_query($sql, 'update', true);

		if (count($orderIds) > 0) {
			$orderIdStr = implode("', '", $orderIds);
			$sql = "UPDATE `$dbTable` SET `active` = '1' WHERE `id` IN ('$orderIdStr');";
			$db->db_query($sql, 'update', true);
		}
	}

	public static function performSaveChanges($data) {
		$db = new Database;
		$dbTable = self::getDbTable();

		$dbId = $data->dbId;
		$notes = mysql_real_escape_string($data->fields->notes);
		$assetTags = $data->fields->assetTags == '1' ? '1' : '0';
		$statusId = $data->fields->statusId;

		$sql = "UPDATE `$dbTable` SET `active`= '1', `notes`='$notes', `asset_tags`='$assetTags', `status_id`='$statusId' WHERE `id`='$dbId';";
		$result = $db->db_query($sql, 'update', true);
		return $result;
	}

	public static function getAllActive() {
		$db = new Database;

		$dbTable = self::getDbTable();

		$sql = "SELECT `id`, `account_id`, `salesperson_id` FROM `$dbTable` WHERE `active`='1';";
		$results = $db->db_query($sql, 'select-multiple', true);

		$openOrders = array();
		foreach ($results as $result) {
			$openOrder = new OpenOrder($result, 15);
			array_push($openOrders, $openOrder);
		}

		return $openOrders;
	}

	public static function getDbTable() {
		return self::$dbTable;
	}

	public static function getZohoIdFieldName() {
		return self::$zohoIdFieldName;
	}
}

?>
