<?php

class StateMonthData {
	private $state;
	private $month;
	private $year;
	private $subtotal;

	public function __construct($data) {
		$this->year = (string)$data->year;
		$this->month = new stdClass;
		$this->month->name = (string)$data->monthName;
		$this->month->number = (string)$data->monthNum;
		$this->state = new stdClass;
		$this->state->name = (string)$data->stateName;
		$this->state->abbreviation = (string)$data->stateAbbreviation;
		$this->subtotal = (float)$data->total;
		$this->deductions = (float)$data->deductions;
		$this->total = (float)$data->total;
		$this->metadata = $data->metadata;
		if ($data->returns) {
			$this->subtotal -= (float)$data->returns;
		}
		if ($data->deductions) {
			$this->subtotal -= (float)$data->deductions;
		}
	}

	public function getMonthData() {
		$data = new stdClass;
		$data->state = $this->state;
		$data->month = $this->month;
		$data->year = $this->year;
		$data->subtotal = $this->subtotal;
		$data->returns = $this->returns;
		$data->total = $this->total;
		$data->metadata = $this->metadata;
		return $data;
	}

	public function getYear() {
		return $this->year;
	}

	public function getMonth() {
		return $this->month;
	}

	public function getType() {
		return $this->type;
	}

	public function getState() {
		return $this->state;
	}

	public function getSubtotal() {
		return $this->subtotal;
	}
}

?>
