<?php

require_once(HTML_FOLDER . "classes/Metrics/Datasets/MetricsState.php");

class MetricsService {
	private static $monthNums = array(
		'January' => '01',
		'February' => '02',
		'March' =>'03',
		'April' => '04',
		'May' =>'05',
		'June' => '06',
		'July' => '07',
		'August' => '08',
		'September' => '09',
		'October' => '10',
		'November' => '11',
		'December' => '12'

	);
	public static function getRegionCurrentAndPreviousYearData($region, $currentYear) {
		$debug = false;
		if ($_GET['debug'] == 'yes' || $_GET['debug'] == 1) {
			$debug = true;
			echo "<pre>";
			echo "Debug logging active\n";
		}
		$previousYear = (int)$currentYear - 1;
		$currentYearData = self::getRegionYearDataByState($region, $currentYear);
		$previousYearData = self::getRegionYearDataByState($region, $previousYear);

		if ($debug) {
			// print_r($currentYearData);
			// print_r($previousYearData);
		}

		$data = new stdClass;
		$years = array((string)$currentYear, (string)$previousYear);
		$data->states = self::generateNewStateArray($region, $years);
		// if ($debug) {
		// 	print_r($data->states);
		// }

		if ($debug) {
			print_r($currentYearData->elements);
		}

		for ($i=0; $i < count($currentYearData->elements); $i++) {
			$element = $currentYearData->elements[$i];

			$stateName = $element->stateName;
			$stateAbbreviation = $element->stateAbbreviation;
			$monthName = $element->monthName;
			$monthNum = $element->monthNum;
			$subtotal = $element->total - $element->deductions;
			$total = $element->total;
			$deductions = $element->deductions;

			if (!$data->states[$stateAbbreviation]) {
				$stateAbbreviation = 'UK';
				$stateName = 'Unknown';
			}
			if ($debug) {
				echo "$stateAbbreviation\n";
				print_r($data->states[$stateAbbreviation]);
			}

			$data->states[$stateAbbreviation]->getYear($currentYear)->getMonthByNum($monthNum)->setTotal($total);
			$data->states[$stateAbbreviation]->getYear($currentYear)->getMonthByNum($monthNum)->setDeductions($deductions);
		}
		for ($i=0; $i < count($previousYearData->elements); $i++) {
			$element = $previousYearData->elements[$i];

			$stateName = $element->stateName;
			$stateAbbreviation = $element->stateAbbreviation;
			$monthName = $element->monthName;
			$monthNum = $element->monthNum;
			$subtotal = $element->total - $element->deductions;
			$total = $element->total;
			$deductions = $element->deductions;

			if (!$data->states[$stateAbbreviation]) {
				$stateAbbreviation = 'UK';
				$stateName = 'Unknown';
			}
			if ($debug) {
				echo "$stateAbbreviation\n";
				print_r($data->states[$stateAbbreviation]);
			}

			$data->states[$stateAbbreviation]->getYear($previousYear)->getMonthByNum($monthNum)->setTotal($total);
			$data->states[$stateAbbreviation]->getYear($previousYear)->getMonthByNum($monthNum)->setDeductions($deductions);
		}
		if ($debug) {
			echo "</pre>";
		}
		return $data;
	}

	public static function getRegionYearDataByState($region, $year) {
		$regionIdentifier = $region->getIdentifier();

		$data = new stdClass;
		$data->months = array();
		$data->objects = array();
		$data->elements = array();
		foreach (self::$monthNums as $monthName => $monthNum) {
			$monthData = self::getRegionMonthDataByState($region, $year, $monthNum, $monthName);
			$monthData->monthName = $monthName;
			$monthData->monthNum = $monthNum;
			array_push($data->months, $monthData);
			foreach ($monthData as $element) {
				array_push($data->elements, $element);
			}
		}
		$data->success = true;
		return $data;
	}

	public static function getMonthToDateComparisonData($year, $month, $day, $otherYear) {
		$db = new Database;
		$legacyStartYear = 2015; // First year with legacy data.
		$legacyEndYear = 2019; // Last year with legacy data.

		$otherYearAsInt = (int)$otherYear;
		$returnData = new stdClass;

		if ($otherYearAsInt >= $legacyStartYear && $otherYearAsInt <= $legacyEndYear) { // If legacy data range
			$legacyYearData = self::getLegacyDataYearAndMonthToDate($otherYear, $month, $day);

			$returnData->otherYearMTDTtsTotal = $legacyYearData->ttsMtdTotal;
			$returnData->otherYearMTDSpTotal = $legacyYearData->spMtdTotal;
			$returnData->otherYearYTDTtsTotal = $legacyYearData->ttsYtdTotal;
			$returnData->otherYearYTDSpTotal = $legacyYearData->spYtdTotal;

			$sql = "SELECT (SELECT IFNULL(ROUND(SUM(osl.`total`), 2), 0) FROM `order_ship_log` AS osl LEFT JOIN `order_shipping_details` AS osd ON osd.`order_id` = osl.`id` WHERE osd.`ship_date` BETWEEN '$year-$month-01 00:00:00' AND '$year-$month-$day 23:59:59') - (SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions FROM `order_shipped_line_items` AS osli LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id WHERE oli.deducted_on_ship_log = '1' AND osd.ship_date BETWEEN '$year-$month-01 00:00:00' AND '$year-$month-$day 23:59:59') AS thisYearMTDTtsTotal,
					(SELECT IFNULL(ROUND(SUM(osl.`total`), 2), 0) FROM `order_ship_log` AS osl LEFT JOIN `order_shipping_details` AS osd ON osd.`order_id` = osl.`id` WHERE osd.`ship_date` BETWEEN '$year-01-01 00:00:00' AND '$year-$month-$day 23:59:59') - (SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions FROM `order_shipped_line_items` AS osli LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id WHERE oli.deducted_on_ship_log = '1' AND osd.ship_date BETWEEN '$year-01-01 00:00:00' AND '$year-$month-$day 23:59:59') AS thisYearYTDTtsTotal,
					(SELECT IFNULL(ROUND(SUM(esl.`subtotal`), 2), 0) AS total FROM `ecomm_ship_log` AS esl LEFT JOIN `ecomm_shipping_details` AS esd ON esl.`id` = esd.`ecomm_id` WHERE esd.`ship_date` BETWEEN '$year-$month-01 00:00:00' AND '$year-$month-$day 23:59:59') - (SELECT IFNULL(ROUND(SUM(erl.`return_amount`), 2), 0) AS spReturns FROM `ecomm_return_log` AS erl WHERE erl.`return_date` BETWEEN '$year-$month-01 00:00:00' AND '$year-$month-$day 23:59:59') AS thisYearMTDSpTotal,
					(SELECT IFNULL(ROUND(SUM(esl.`subtotal`), 2), 0) AS total FROM `ecomm_ship_log` AS esl LEFT JOIN `ecomm_shipping_details` AS esd ON esl.`id` = esd.`ecomm_id` WHERE esd.`ship_date` BETWEEN '$year-01-01 00:00:00' AND '$year-$month-$day 23:59:59') - (SELECT IFNULL(ROUND(SUM(erl.`return_amount`), 2), 0) AS spReturns FROM `ecomm_return_log` AS erl WHERE erl.`return_date` BETWEEN '$year-01-01 00:00:00' AND '$year-$month-$day 23:59:59') AS thisYearYTDSpTotal;";


			$results = $db->db_query($sql, 'select-single', true);

			$returnData->thisYearMTDTtsTotal = $results['thisYearMTDTtsTotal'];
			$returnData->thisYearMTDSpTotal = $results['thisYearMTDSpTotal'];
			$returnData->thisYearYTDTtsTotal = $results['thisYearYTDTtsTotal'];
			$returnData->thisYearYTDSpTotal = $results['thisYearYTDSpTotal'];
		}
		else {
			$sql = "SELECT (SELECT IFNULL(ROUND(SUM(osl.`total`), 2), 0) FROM `order_ship_log` AS osl LEFT JOIN `order_shipping_details` AS osd ON osd.`order_id` = osl.`id` WHERE osd.`ship_date` BETWEEN '$otherYear-$month-01 00:00:00' AND '$otherYear-$month-$day 23:59:59') - (SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions FROM `order_shipped_line_items` AS osli LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id WHERE oli.deducted_on_ship_log = '1' AND osd.ship_date BETWEEN '$otherYear-$month-01 00:00:00' AND '$otherYear-$month-$day 23:59:59') AS otherYearMTDTtsTotal,
					(SELECT IFNULL(ROUND(SUM(osl.`total`), 2), 0) FROM `order_ship_log` AS osl LEFT JOIN `order_shipping_details` AS osd ON osd.`order_id` = osl.`id` WHERE osd.`ship_date` BETWEEN '$otherYear-01-01 00:00:00' AND '$otherYear-$month-$day 23:59:59') - (SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions FROM `order_shipped_line_items` AS osli LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id WHERE oli.deducted_on_ship_log = '1' AND osd.ship_date BETWEEN '$otherYear-01-01 00:00:00' AND '$otherYear-$month-$day 23:59:59') AS otherYearYTDTtsTotal,
					(SELECT IFNULL(ROUND(SUM(osl.`total`), 2), 0) FROM `order_ship_log` AS osl LEFT JOIN `order_shipping_details` AS osd ON osd.`order_id` = osl.`id` WHERE osd.`ship_date` BETWEEN '$year-$month-01 00:00:00' AND '$year-$month-$day 23:59:59') - (SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions FROM `order_shipped_line_items` AS osli LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id WHERE oli.deducted_on_ship_log = '1' AND osd.ship_date BETWEEN '$year-$month-01 00:00:00' AND '$year-$month-$day 23:59:59') AS thisYearMTDTtsTotal,
					(SELECT IFNULL(ROUND(SUM(osl.`total`), 2), 0) FROM `order_ship_log` AS osl LEFT JOIN `order_shipping_details` AS osd ON osd.`order_id` = osl.`id` WHERE osd.`ship_date` BETWEEN '$year-01-01 00:00:00' AND '$year-$month-$day 23:59:59') - (SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions FROM `order_shipped_line_items` AS osli LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id WHERE oli.deducted_on_ship_log = '1' AND osd.ship_date BETWEEN '$year-01-01 00:00:00' AND '$year-$month-$day 23:59:59') AS thisYearYTDTtsTotal,
					(SELECT IFNULL(ROUND(SUM(esl.`subtotal`), 2), 0) AS total FROM `ecomm_ship_log` AS esl LEFT JOIN `ecomm_shipping_details` AS esd ON esl.`id` = esd.`ecomm_id` WHERE esd.`ship_date` BETWEEN '$otherYear-$month-01 00:00:00' AND '$otherYear-$month-$day 23:59:59') - (SELECT IFNULL(ROUND(SUM(erl.`return_amount`), 2), 0) AS spReturns FROM `ecomm_return_log` AS erl WHERE erl.`return_date` BETWEEN '$otherYear-$month-01 00:00:00' AND '$otherYear-$month-$day 23:59:59') AS otherYearMTDSpTotal,
					(SELECT IFNULL(ROUND(SUM(esl.`subtotal`), 2), 0) AS total FROM `ecomm_ship_log` AS esl LEFT JOIN `ecomm_shipping_details` AS esd ON esl.`id` = esd.`ecomm_id` WHERE esd.`ship_date` BETWEEN '$otherYear-01-01 00:00:00' AND '$otherYear-$month-$day 23:59:59') - (SELECT IFNULL(ROUND(SUM(erl.`return_amount`), 2), 0) AS spReturns FROM `ecomm_return_log` AS erl WHERE erl.`return_date` BETWEEN '$otherYear-01-01 00:00:00' AND '$otherYear-$month-$day 23:59:59') AS otherYearYTDSpTotal,
					(SELECT IFNULL(ROUND(SUM(esl.`subtotal`), 2), 0) AS total FROM `ecomm_ship_log` AS esl LEFT JOIN `ecomm_shipping_details` AS esd ON esl.`id` = esd.`ecomm_id` WHERE esd.`ship_date` BETWEEN '$year-$month-01 00:00:00' AND '$year-$month-$day 23:59:59') - (SELECT IFNULL(ROUND(SUM(erl.`return_amount`), 2), 0) AS spReturns FROM `ecomm_return_log` AS erl WHERE erl.`return_date` BETWEEN '$year-$month-01 00:00:00' AND '$year-$month-$day 23:59:59') AS thisYearMTDSpTotal,
					(SELECT IFNULL(ROUND(SUM(esl.`subtotal`), 2), 0) AS total FROM `ecomm_ship_log` AS esl LEFT JOIN `ecomm_shipping_details` AS esd ON esl.`id` = esd.`ecomm_id` WHERE esd.`ship_date` BETWEEN '$year-01-01 00:00:00' AND '$year-$month-$day 23:59:59') - (SELECT IFNULL(ROUND(SUM(erl.`return_amount`), 2), 0) AS spReturns FROM `ecomm_return_log` AS erl WHERE erl.`return_date` BETWEEN '$year-01-01 00:00:00' AND '$year-$month-$day 23:59:59') AS thisYearYTDSpTotal;";

			$results = $db->db_query($sql, 'select-single', true);
			$returnData->otherYearMTDTtsTotal = $results['otherYearMTDTtsTotal'];
			$returnData->thisYearMTDTtsTotal = $results['thisYearMTDTtsTotal'];
			$returnData->otherYearMTDSpTotal = $results['otherYearMTDSpTotal'];
			$returnData->thisYearMTDSpTotal = $results['thisYearMTDSpTotal'];
			$returnData->otherYearYTDTtsTotal = $results['otherYearYTDTtsTotal'];
			$returnData->thisYearYTDTtsTotal = $results['thisYearYTDTtsTotal'];
			$returnData->otherYearYTDSpTotal = $results['otherYearYTDSpTotal'];
			$returnData->thisYearYTDSpTotal = $results['thisYearYTDSpTotal'];

		}
		return $returnData;
	}

	private static function getLegacyDataYearAndMonthToDate($year, $month, $day) {
		// Year, month, day passed as numbers eg. 2019, 12, 25 for 25 December 2019.
		// Should return other year TTS and SP totals, for month and year
		$monthDayNums = array(
			31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
		);

		$yearString = (string)$year; // Get year as string
		$monthIndex = (int)$month - 1; // Get month as index
		$dayInt = (int)$day; // Get day as integer for elapsed month percentage calculation

		$daysInMonth = $monthDayNums[$monthIndex];
		if ($monthIndex == 1 && (int)$year == 2016) {
			$daysInMonth = 29; // Handler for leap year
		}

		$percentOfMonthPassed = $dayInt / $daysInMonth; // Get how much of the month has passed. eg 15 / 30 = 0.5 = half of month elapsed. Used to calculate MTD average value

		$staticData = json_decode(file_get_contents(HTML_FOLDER . "classes/Metrics/staticData.json")); // Parse static data

		$yearData = $staticData->$yearString; // Get year data

		// Calculate TTS and SP month totals based on how much of month has passed
		$currentMonthTtsTotal = $yearData->tts[$monthIndex] * $percentOfMonthPassed;
		$currentMonthSpTotal = $yearData->sp[$monthIndex] * $percentOfMonthPassed;

		// Initiate YTD data with current month data
		$yearToDateTtsTotal = $currentMonthTtsTotal;
		$yearToDateSpTotal = $currentMonthSpTotal;

		for ($i = 0; $i < $monthIndex; $i++) { // Iterate over months prior to current month
			$yearToDateTtsTotal += $yearData->tts[$i];
			$yearToDateSpTotal += $yearData->sp[$i];
		}

		$returnData = new stdClass;
		$returnData->ttsMtdTotal = $currentMonthTtsTotal;
		$returnData->ttsYtdTotal = $yearToDateTtsTotal;
		$returnData->spMtdTotal = $currentMonthSpTotal;
		$returnData->spYtdTotal = $yearToDateSpTotal;

		return $returnData;
	}

	public static function getRegionYearComparison($region, $year, $otherYear, $month, $day) {
		$debug = false;
		if ($_GET['debug'] == 'yes' || $_GET['debug'] == 1) {
			$debug = true;
			echo "<pre>";
		}

		$db = new Database;

		$regionSalesIds = self::getRegionSalespersonIdArray($region);
		$regionSalesString = implode("' ,'", $regionSalesIds);

		if ($debug) {
			print_r($regionSalesIds);
			echo "$regionSalesString\n";
		}

		$sql = "SELECT (SELECT IFNULL(ROUND(SUM(osl.`total`), 2), 0) FROM `order_ship_log` AS osl LEFT JOIN `order_shipping_details` AS osd ON osd.`order_id` = osl.`id` WHERE osl.`salesperson_id` IN ('$regionSalesString') AND osd.`ship_date` BETWEEN '$otherYear-$month-01 00:00:00' AND '$otherYear-$month-$day 23:59:59') - (SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions FROM `order_shipped_line_items` AS osli LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id WHERE osl.`salesperson_id` IN ('$regionSalesString') AND oli.deducted_on_ship_log = '1' AND osd.ship_date BETWEEN '$otherYear-$month-01 00:00:00' AND '$otherYear-$month-$day 23:59:59') AS otherYearMTDTtsTotal,
				(SELECT IFNULL(ROUND(SUM(osl.`total`), 2), 0) FROM `order_ship_log` AS osl LEFT JOIN `order_shipping_details` AS osd ON osd.`order_id` = osl.`id` WHERE osl.`salesperson_id` IN ('$regionSalesString') AND osd.`ship_date` BETWEEN '$otherYear-01-01 00:00:00' AND '$otherYear-$month-$day 23:59:59') - (SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions FROM `order_shipped_line_items` AS osli LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id WHERE osl.`salesperson_id` IN ('$regionSalesString') AND oli.deducted_on_ship_log = '1' AND osd.ship_date BETWEEN '$otherYear-01-01 00:00:00' AND '$otherYear-$month-$day 23:59:59') AS otherYearYTDTtsTotal,
				(SELECT IFNULL(ROUND(SUM(osl.`total`), 2), 0) FROM `order_ship_log` AS osl LEFT JOIN `order_shipping_details` AS osd ON osd.`order_id` = osl.`id` WHERE osl.`salesperson_id` IN ('$regionSalesString') AND osd.`ship_date` BETWEEN '$year-$month-01 00:00:00' AND '$year-$month-$day 23:59:59') - (SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions FROM `order_shipped_line_items` AS osli LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id WHERE osl.`salesperson_id` IN ('$regionSalesString') AND oli.deducted_on_ship_log = '1' AND osd.ship_date BETWEEN '$year-$month-01 00:00:00' AND '$year-$month-$day 23:59:59') AS thisYearMTDTtsTotal,
				(SELECT IFNULL(ROUND(SUM(osl.`total`), 2), 0) FROM `order_ship_log` AS osl LEFT JOIN `order_shipping_details` AS osd ON osd.`order_id` = osl.`id` WHERE osl.`salesperson_id` IN ('$regionSalesString') AND osd.`ship_date` BETWEEN '$year-01-01 00:00:00' AND '$year-$month-$day 23:59:59') - (SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions FROM `order_shipped_line_items` AS osli LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id WHERE osl.`salesperson_id` IN ('$regionSalesString') AND oli.deducted_on_ship_log = '1' AND osd.ship_date BETWEEN '$year-01-01 00:00:00' AND '$year-$month-$day 23:59:59') AS thisYearYTDTtsTotal;";
		if ($debug) {
			echo "$sql\n";
		}
		$results = $db->db_query($sql, 'select-single');
		$returnData = new stdClass;
		$returnData->otherYearMTDTtsTotal = $results['otherYearMTDTtsTotal'];
		$returnData->thisYearMTDTtsTotal = $results['thisYearMTDTtsTotal'];
		$returnData->otherYearYTDTtsTotal = $results['otherYearYTDTtsTotal'];
		$returnData->thisYearYTDTtsTotal = $results['thisYearYTDTtsTotal'];

		if ($debug) {
			echo "</pre>";
		}
		return $returnData;
	}

	private static function getRegionMonthDataByState($region, $year, $monthNum, $monthName) {
		$regionIdentifier = $region->getIdentifier();
		$regionId = $region->getId();
		$stateIds = $region->getStateIds();
		$stateIdString = implode("', '", $stateIds);
		$db = new Database;


		$sql = "SELECT IFNULL(ROUND(SUM(osl.`total`), 2), 0) AS total, IFNULL(states.abbreviation, 'UK') AS 'abbreviation', IFNULL(states.name, 'Unknown') AS 'name'
				FROM `order_ship_log` AS osl
				LEFT JOIN `order_shipping_details` AS osd ON osd.`order_id` = osl.`id`
				LEFT JOIN `states` ON osl.`state_id` = states.`id`
				WHERE osd.`ship_date` LIKE '$year-$monthNum%'
				AND osl.`state_id` IN ('$stateIdString')
				GROUP BY states.`abbreviation`
				ORDER BY abbreviation;";


		// $sql = "SELECT IFNULL(ROUND(SUM(osl.`total`), 2), 0) AS total, IFNULL(states.abbreviation, 'UK') AS 'abbreviation', IFNULL(states.name, 'Unknown') AS 'name'
		// 		FROM `order_ship_log` AS osl
		// 		LEFT JOIN `order_shipping_details` AS osd ON osd.`order_id` = osl.`id`
		// 		LEFT JOIN states ON osl.`state_id` = states.`id`
		// 		LEFT JOIN regions ON states.`region_id` = `regions`.id
		// 		LEFT JOIN `regions_salespersons` ON regions.`id` = `regions_salespersons`.`region_id`
		// 		LEFT JOIN `order_salespersons` ON `regions_salespersons`.`salesperson_id` = `order_salespersons`.`id`
		// 		WHERE osd.`ship_date` LIKE '$year-$monthNum%'
		// 		AND osl.`salesperson_id` IN (
		// 			SELECT * FROM
		// 			(
		// 				SELECT `id`
		// 				FROM `order_salespersons`
		// 				LEFT JOIN `regions_salespersons` ON `order_salespersons`.`id` = `regions_salespersons`.`salesperson_id`
		// 				WHERE `regions_salespersons`.`region_id` = '$regionId'
		// 			) AS subquery
		// 		)
		// 		GROUP BY states.`abbreviation`
		// 		ORDER BY abbreviation;";

		$results = $db->db_query($sql, 'select-multiple', true);

		$returnArray = array();

		foreach ($results as $result) {
			$stateAbbreviation = $result['abbreviation'];
			$deductionResult = self::getRegionStateDeductions($stateAbbreviation, $region, $year, $monthNum);

			$stateMonthData = new stdClass;
			$stateMonthData->total = (float)$result['total'];
			$stateMonthData->deductions = $deductionResult['deductions'] ? (float)$deductionResult['deductions'] : 0.0;
			$stateMonthData->stateName = $result['name'];
			$stateMonthData->stateAbbreviation = $result['abbreviation'];
			$stateMonthData->monthName = $monthName;
			$stateMonthData->monthNum = $monthNum;

			array_push($returnArray, $stateMonthData);
		}

		return $returnArray;
	}

	private static function getRegionStateDeductions($stateAbbreviation, $region, $year, $monthNum) {
		$regionIdentifier = $region->getIdentifier();
		$regionId = $region->getId();
		$stateIds = $region->getStateIds();
		$stateIdString = implode("', '", $stateIds);

		$db = new Database;
		if ($stateAbbreviation == 'UK') { // handling unknown
			$sql = "SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions
					FROM `order_shipped_line_items` AS osli
					LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id
					LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id
					LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id
					LEFT JOIN states ON states.id = osl.state_id
					WHERE states.abbreviation IS NULL
					AND osl.salesperson_id IN (
						SELECT * FROM
							(
								SELECT `id`
								FROM `order_salespersons`
								LEFT JOIN `regions_salespersons` ON `order_salespersons`.`id` = `regions_salespersons`.`salesperson_id`
								WHERE `regions_salespersons`.`region_id` = '$regionId'
							) AS subquery
						)
					AND oli.deducted_on_ship_log = '1' AND osd.ship_date LIKE '$year-$monthNum%';";
			// $sql = "SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions
			// 		FROM `order_shipped_line_items` AS osli
			// 		LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id
			// 		LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id
			// 		LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id
			// 		LEFT JOIN states ON states.id = osl.state_id
			// 		WHERE states.abbreviation IS NULL
			// 		AND osl.salesperson_id IN (
			// 			SELECT * FROM
			// 				(
			// 					SELECT `id`
			// 					FROM `order_salespersons`
			// 					LEFT JOIN `regions_salespersons` ON `order_salespersons`.`id` = `regions_salespersons`.`salesperson_id`
			// 					WHERE `regions_salespersons`.`region_id` = (SELECT `id` FROM `regions` WHERE `identifier`='$regionIdentifier')
			// 				) AS subquery
			// 			)
			// 		AND oli.deducted_on_ship_log = '1' AND osd.ship_date LIKE '$year-$monthNum%';";
		}
		else {
			$sql = "SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions
					FROM `order_shipped_line_items` AS osli
					LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id
					LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id
					LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id
					LEFT JOIN states ON states.id = osl.state_id
					WHERE states.abbreviation = '$stateAbbreviation'
					AND osl.`state_id` IN ('$stateIdString')
					AND oli.deducted_on_ship_log = '1' AND osd.ship_date LIKE '$year-$monthNum%';";
			// $sql = "SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions
			// 		FROM `order_shipped_line_items` AS osli
			// 		LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id
			// 		LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id
			// 		LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id
			// 		LEFT JOIN states ON states.id = osl.state_id
			// 		WHERE states.abbreviation = '$stateAbbreviation'
			// 		AND osl.salesperson_id IN (
			// 			SELECT * FROM
			// 				(
			// 					SELECT `id`
			// 					FROM `order_salespersons`
			// 					LEFT JOIN `regions_salespersons` ON `order_salespersons`.`id` = `regions_salespersons`.`salesperson_id`
			// 					WHERE `regions_salespersons`.`region_id` = (SELECT `id` FROM `regions` WHERE `identifier`='$regionIdentifier')
			// 				) AS subquery
			// 			)
			// 		AND oli.deducted_on_ship_log = '1' AND osd.ship_date LIKE '$year-$monthNum%';";
		}
		$result = $db->db_query($sql, 'select-single', true);
		$result['query'] = $sql;
		return $result;
	}

	private static function getRegionStates($regionIdentifier) {
		$db = new Database;

		$sql = "SELECT `name`, `abbreviation` FROM `states` WHERE `region_id`=(SELECT `id` FROM `regions` WHERE `identifier`='$regionIdentifier') ORDER BY `name` ASC;";

		$results = $db->db_query($sql, 'select-multiple', true);

		$states = array();
		foreach ($results as $result) {
			$state = new stdClass;
			$state->name = $result['name'];
			$state->abbreviation = $result['abbreviation'];
			array_push($states, $state);
		}
		array_push($states, self::generateUnknownStateHolder());
		return $states;
	}

	private static function generateNewStateArray($region, $years) {
		$regionStates = $region->getStates();
		// $regionStates = self::getRegionStates($regionIdentifier);
		$states = array();
		foreach($regionStates as $state) {
			$stateAbbreviation = $state->getAbbreviation();
			$stateName = $state->getName();
			$states[$stateAbbreviation] = new MetricsState($stateName, $stateAbbreviation, $years);
		}
		$states['UK'] = new MetricsState("Unknown", "UK", $years);
		return $states;
	}

	private static function generateUnknownStateHolder() {
		$state = new stdClass;
		$state->name = "Unknown";
		$state->abbreviation = "UK";
		return $state;
	}

	private static function getRegionSalespersonIdArray($region) {
		$db = new Database;

		$sql = "SELECT `id`
				FROM `order_salespersons`
				LEFT JOIN `regions_salespersons` ON `order_salespersons`.`id` = `regions_salespersons`.`salesperson_id`
				WHERE `regions_salespersons`.`region_id` = (SELECT `id` FROM `regions` WHERE `identifier`='$region');";
		$results = $db->db_query($sql, 'select-multiple', true);
		$returnArray = array();
		foreach($results as $result) {
			$id = $result['id'];
			array_push($returnArray, $id);
		}
		return $returnArray;
	}
}

?>
