<?php

require_once(HTML_FOLDER . "class_database.php");
require_once(HTML_FOLDER . "classes/Metrics/MonthData.php");
require_once(HTML_FOLDER . "classes/Metrics/MetricsService.php");
class MetricsController {
	public static function metricsPage() {
		$adminObj = new Admin;
		$title="Metrics";
		$templateElements = array(
			"SCRIPTS" => 	'<script src="__CDN_JAVASCRIPT__javascript/metrics/datasets/MonthSummary.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/metrics/datasets/YearSummary.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/metrics/datasets/Channel.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/metrics/yearSummaryController.js" type="text/javascript"></script>'
		);

		echo $adminObj->parse(TEMPLATE, array('BODY' => $adminObj->parse(METRICS_PAGE, $templateElements), "TITLE" => $title));
	}

	public static function regionalMetricsPage($region) {
		$adminObj = new Admin;
		$title = "Region Metrics";
		$templateElements = array(
			"SCRIPTS" => 	'<script src="__CDN_JAVASCRIPT__javascript/metrics/datasets/MonthSummary.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/metrics/datasets/YearSummary.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/metrics/datasets/State.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/metrics/regionSummaryController.js" type="text/javascript"></script>'
		);

		echo $adminObj->parse(TEMPLATE, array('BODY' => $adminObj->parse(METRICS_PAGE, $templateElements), "TITLE" => $title));
	}

	public static function getRegionPermissions() {
		$adminString = $_SESSION['xdigiSHOPadmin'];
		$admin = new Admin;

		$sql = "SELECT `salesRegionPermissions` FROM `ds_admins` WHERE `aString`='$adminString';";
		$result = $admin->db_query($sql, 'select-single', true);
		$regionPermissions = explode(',', $result['salesRegionPermissions']);
		return $regionPermissions;
	}

	public static function getHasMetricsDashboardPermission() {
		$adminString = $_SESSION['xdigiSHOPadmin'];
		$admin = new Admin;
		$hasPermission = $admin->checkAdminHasPagePermission('metrics_dashboard', $adminString);
		return $hasPermission;
	}

	public static function getMonthToDateComparisonData($year, $month, $day, $otherYear=null) {
		$lastYear = (int)$year - 1;
		if (!$otherYear) {
			$otherYear = $lastYear;
		}

		return MetricsService::getMonthToDateComparisonData($year, $month, $day, $otherYear);
	}

	public static function getRegionalYearData($year, $regionIdentifier) {
		$regionPermissions = self::getRegionPermissions();
		$hasDashboardPermission = self::getHasMetricsDashboardPermission();
		if ($_GET['debug'] == "yes") {
			echo "<pre>Permissions:\nRegion permissions:\n";
			print_r($regionPermissions);
			echo "\nDashboard permissions: $hasDashboardPermission\n</pre>";
		}
		if (in_array($regionIdentifier, $regionPermissions)) {
			if ($_GET['debug'] == "yes") {
				echo "<pre>Preparing to get region data</pre>";
			}
			$region = Region::fetchByIdentifier($regionIdentifier, true, true);
			$yearData = MetricsService::getRegionCurrentAndPreviousYearData($region, $year);
			$yearData->region = $regionIdentifier;
			$yearData->regionPermissions = $regionPermissions;
			$yearData->hasDashboardPermission = $hasDashboardPermission;
			return $yearData;
		}
		else {
			return false;
		}
	}

	public static function getRegionMonthToDateComparisonData($region, $year, $month, $day, $otherYear=null) {
		$lastYear = (int)$year-1;
		if (!$otherYear) {
			$otherYear = $lastYear;
		}

		return MetricsService::getRegionYearComparison($region, $year, $otherYear, $month, $day);
	}

	public static function getYearData($year) {
		$returnData = new stdClass;

		$hasDashboardPermission = self::getHasMetricsDashboardPermission();
		$returnData->hasDashboardPermission = $hasDashboardPermission;
		if (!$hasDashboardPermission) {
			return $returnData;
		}
		$ecommData = self::getEcommYearData($year);
		$ttsData = self::getTtsYearData($year);
		$regionPermissions = self::getRegionPermissions();
		$returnData->channels = $ecommData;
		$returnData->channels->tts = $ttsData->tts;
		$returnData->channels->regions = $ttsData->regions;
		$returnData->channels->wholesale = $ttsData->wholesale;
		$returnData->channels->localWholesale = $ttsData->localWholesale;
		$returnData->regionPermissions = $regionPermissions;
		return $returnData;
	}

	public static function getTtsYearData($year) {
		$regions = Region::getAllRegions();

		$regionData = array();
		foreach ($regions as $region) {
			$regionData[$region->getIdentifier()] = self::getTtsRegionYearData($year, $region);
		}

		$wholesaleData = self::getWholesaleYearData($year, "wholesale");
		$localWholesaleData = self::getWholesaleYearData($year, "localwholesale");
		$totalData = self::getTtsRegionYearData($year, '');

		$ttsData = new stdClass;
		$ttsData->regions = $regionData;
		$ttsData->wholesale = $wholesaleData;
		$ttsData->localWholesale = $localWholesaleData;
		$ttsData->tts = $totalData;

		return $ttsData;
	}

	public static function getEcommYearData($year) {
		$backmarketData = self::getEcommChannelYearData('back_market', $year);
		$neweggData = self::getEcommChannelYearData('newegg', $year);
		$ebayMarketData = self::getEcommChannelYearData('ebay_others', $year);
		$ebayAuctionData = self::getEcommChannelYearData('ebay_auctions', $year);
		$amazonData = self::getEcommChannelYearData('amazon', $year);
		$othersData = self::getOthersEcommChannelYearData($year);
		$spData = self::getEcommChannelYearData('', $year);

		$ecommData = new stdClass;
		$ecommData->backmarket = $backmarketData;
		$ecommData->newegg = $neweggData;
		$ecommData->ebayMarket = $ebayMarketData;
		$ecommData->ebayAuction = $ebayAuctionData;
		$ecommData->amazon = $amazonData;
		$ecommData->others = $othersData;
		$ecommData->sp = $spData;
		// $ecommData->metadata = new stdClass;
		// $ecommData->metadata->year = $year;



		return $ecommData;
	}

	public static function getRegionProjectedSales($region) {
		$db = new Database;

		// First get region id
		$sql = "SELECT `id` FROM `regions` WHERE `identifier`='$region' OR `id`='$region';"; // search by identifier or id to be safe to pass either
		$result = $db->db_query($sql, 'select-single');
		$regionId = $result['id'];
		if (!$regionId) {
			return 0;
		}


		$sql = "SELECT IFNULL(ROUND(SUM(oo.`subtotal`),2),0) AS ttsSubtotal
				FROM `open_orders` AS oo
				LEFT JOIN `order_salespersons` AS os ON oo.`salesperson_id` = os.`id`
				WHERE `active`='1' AND oo.`status_id` != '2' AND os.`id` IN
				(
					SELECT * FROM (
						SELECT oss.`id` FROM `order_salespersons` AS oss LEFT JOIN `regions_salespersons` AS rs ON oss.`id` = rs.`salesperson_id` WHERE rs.`region_id`='1'
					) AS subquery
				);";
		$result = $db->db_query($sql, 'select-single', true);
		$ttsSubtotal = (float)$result['ttsSubtotal'];

		$sql = "SELECT IFNULL(ROUND(SUM(ooli.`total`), 2), 0) AS deductions
				FROM `open_orders` AS oo
				LEFT JOIN `order_salespersons` AS os ON oo.`salesperson_id` = os.`id`
				LEFT JOIN `open_order_line_items` AS ooli ON oo.id = ooli.open_order_id
				LEFT JOIN `order_line_items` AS oli ON ooli.line_item_id = oli.id
				WHERE oli.`deducted_on_open_orders`='1' AND oo.`active`='1' AND oo.`status_id` != '2' AND os.`id` IN
				(
					SELECT * FROM (
						SELECT oss.`id` FROM `order_salespersons` AS oss LEFT JOIN `regions_salespersons` AS rs ON oss.`id` = rs.`salesperson_id` WHERE rs.`region_id`='1'
					) AS subquery
				);";
		$result = $db->db_query($sql, 'select-single', true);
		$deductions = (float)$result['deductions'];

		$total = $ttsSubtotal - $deductions;
		$returnData = new stdClass;
		$returnData->projectedSales = $total;
		return $returnData;
	}

	public static function getProjectedSales() {
		$db = new Database;
		$sql = "SELECT IFNULL(ROUND(SUM(oo.`subtotal`),2),0) AS ttsSubtotal FROM `open_orders` AS oo WHERE `active`='1' AND oo.`status_id` != '2';";
		$result = $db->db_query($sql, 'select-single', true);
		$ttsSubtotal = $result['ttsSubtotal'];

		$sql = "SELECT IFNULL(ROUND(SUM(ooli.`total`), 2), 0) AS deductions FROM `open_orders` AS oo LEFT JOIN `open_order_line_items` AS ooli ON oo.id = ooli.open_order_id LEFT JOIN `order_line_items` AS oli ON ooli.line_item_id = oli.id WHERE oli.`deducted_on_open_orders`='1' AND oo.`active`='1' AND oo.`status_id` != '2';";
		$result = $db->db_query($sql, 'select-single', true);
		$deductions = (float)$result['deductions'];

		$sql = "SELECT IFNULL(ROUND(SUM(eood.`subtotal`),2),0) AS spSubtotal FROM `ecomm_open_order_details` AS eood LEFT JOIN `ecomm_open_orders` AS eoo ON eood.`open_order_id` = eoo.`id` WHERE eoo.`open` = '1';";
		$result = $db->db_query($sql, 'select-single', true);
		$spSubtotal = $result['spSubtotal'];
		$projectedSales = (float)$ttsSubtotal + (float)$spSubtotal - (float)$deductions;
		$returnData = new stdClass;
		$returnData->projectedSales = $projectedSales;
		return $returnData;
	}

	private static function getTtsRegionYearData($year, $region=null) {
		if ($region) {
			$regionId = $region->getId();
			$salespersonId = $region->getSalespersonId();
		}
		else {
			$regionName = 'TTS';
		}


		$monthNames = array(
			'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'
		);
		$months = array();
		foreach ($monthNames as $monthName) {
			// $months[$monthName] = self::getEcommChannelMonthSales($channelData, $year, $monthName);
			if ($region) {
				$monthData = self::getTtsMonthSales($year, $monthName, $region);
			}
			else {
				$monthData = self::getTtsMonthSales($year, $monthName);
			}
			array_push($months, $monthData->getMonthData());
		}
		$returnData = new stdClass;
		if ($region) {
			$returnData->name = $region->getName();
			$returnData->identifier = $region->getIdentifier();
			$returnData->id = $region->getId();
		}
		else {
			$returnData->name = $regionName;
			$returnData->identifier = strtolower($regionName);
		}
		$returnData->type = 'tts';
		$returnData->years = array();
		$yearData = new stdClass;
		$yearData->year = $year;
		$yearData->months = $months;
		$returnData->years[(string)$year] = $yearData;
		return $returnData;
	}

	private static function getWholesaleMonthSales($year, $month, $wholesaleData) {
		$metadata = new stdClass;
		$monthNums = array(
			'jan' => '01',
			'feb' => '02',
			'mar' => '03',
			'apr' => '04',
			'may' => '05',
			'jun' => '06',
			'jul' => '07',
			'aug' => '08',
			'sep' => '09',
			'oct' => '10',
			'nov' => '11',
			'dec' => '12',
		);
		if (in_array(substr(strtolower($month), 0, 3), array_keys($monthNums))) {
			$monthNum = $monthNums[substr(strtolower($month), 0, 3)];
		}
		$db = new Database;
		$deductions = 0.0;
		$salespersonId = $wholesaleData->salespersonId;
		$deductions = self::getWholesaleMonthDeductions($year, $monthNum, $salespersonId);
		$sql = "SELECT IFNULL(ROUND(SUM(osl.`total`), 2), 0) AS total FROM `order_ship_log` AS osl LEFT JOIN `order_shipping_details` AS osd ON osd.`order_id` = osl.`id` WHERE osl.`salesperson_id`='$salespersonId' AND osd.`ship_date` LIKE '$year-$monthNum%';";
		$wholesaleIdentifier = $wholesaleData->identifier;
		$wholesaleName = $wholesaleData->name;
		$metadata->getSalesQuery = $sql;
		$result = $db->db_query($sql, 'select-single');

		$result['type'] = 'tts';
		$result['deductions'] = $deductions;
		$result['channelIdentifier'] = $wholesaleIdentifier;
		$result['channelName'] = $wholesaleName;
		$result['monthName'] = $month;
		$result['monthNum'] = $monthNum;
		$result['year'] = $year;
		$result['metadata'] = $metadata;
		$monthData = new MonthData($result);
		return $monthData;
	}

	private static function getWholesaleMonthDeductions($year, $month, $salespersonId) {
		$db = new Database;
		$deductions = 0.0;
		$sql = "SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions FROM `order_shipped_line_items` AS osli LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id WHERE osl.salesperson_id='$salespersonId' AND oli.deducted_on_ship_log = '1' AND osd.ship_date LIKE '$year-$month%';";
		$result = $db->db_query($sql, 'select-single', true);
		$deductions = $result['deductions'];
		return $deductions;
	}

	private static function getWholesaleYearData($year, $wholesaleIdentifier="wholesale") {
		if ($wholesaleIdentifier == "wholesale") {
			$wholesaleName = "Wholesale";
		}
		elseif ($wholesaleIdentifier == "localwholesale") {
			$wholesaleName = "Local Wholesale";
		}
		$salesRegions = array(
			'wholesale' => '835703000013773251',
			'localwholesale' => '835703000010382001'
		);

		$zohoId = $salesRegions[$wholesaleIdentifier];

		$db = new Database;
		$sql = "SELECT `id` FROM `order_salespersons` WHERE `zoho_id`='$zohoId';";
		$result = $db->db_query($sql, 'select-single');
		$wholesaleData = new stdClass;
		$wholesaleData->salespersonId = $result['id'];
		$wholesaleData->identifier = $wholesaleIdentifier;
		$wholesaleData->name = $wholesaleName;

		$monthNames = array(
			'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'
		);
		$months = array();
		foreach ($monthNames as $monthName) {
			// $months[$monthName] = self::getEcommChannelMonthSales($channelData, $year, $monthName);
			$monthData = self::getWholesaleMonthSales($year, $monthName, $wholesaleData);
			array_push($months, $monthData->getMonthData());
		}
		$returnData = new stdClass;
		$returnData->name = $wholesaleName;
		$returnData->identifier = $wholesaleIdentifier;
		$returnData->type = 'tts';
		$returnData->years = array();
		$yearData = new stdClass;
		$yearData->year = $year;
		$yearData->months = $months;
		$returnData->years[(string)$year] = $yearData;
		return $returnData;
	}

	private static function getTtsMonthSales($year, $month, $region) {
		$metadata = new stdClass;
		$monthNums = array(
			'jan' => '01',
			'feb' => '02',
			'mar' => '03',
			'apr' => '04',
			'may' => '05',
			'jun' => '06',
			'jul' => '07',
			'aug' => '08',
			'sep' => '09',
			'oct' => '10',
			'nov' => '11',
			'dec' => '12',
		);
		if (in_array(substr(strtolower($month), 0, 3), array_keys($monthNums))) {
			$monthNum = $monthNums[substr(strtolower($month), 0, 3)];
		}
		$db = new Database;
		$deductions = 0.0;
		if ($region) {
			$regionId = $region->getId();
			$stateIds = $region->getStateIds();
			$stateIdString = implode("', '", $stateIds);
			// $states = $region->getStates();
			$deductions = self::getTtsMonthDeductions($year, $monthNum, $region);
			$sql = "SELECT IFNULL(ROUND(SUM(osl.`total`), 2), 0) AS total FROM `order_ship_log` AS osl LEFT JOIN `order_shipping_details` AS osd ON osd.`order_id` = osl.`id` WHERE osl.`state_id` IN ('$stateIdString') AND osd.`ship_date` LIKE '$year-$monthNum%';";
			$regionIdentifier = $region->getIdentifier();
			$regionName = $region->getName();
			$metadata->getSalesQuery = $sql;
		}
		else {
			$deductions = self::getTtsMonthDeductions($year, $monthNum);
			$sql = "SELECT IFNULL(ROUND(SUM(osl.`total`), 2), 0) AS total FROM `order_ship_log` AS osl LEFT JOIN `order_shipping_details` AS osd ON osd.`order_id` = osl.`id` WHERE osd.`ship_date` LIKE '$year-$monthNum%';";
			$regionIdentifier = 'tts';
			$regionName = 'TTS';
			$metadata->getSalesQuery = $sql;
		}
		$result = $db->db_query($sql, 'select-single');

		$result['type'] = 'tts';
		$result['deductions'] = $deductions;
		$result['channelIdentifier'] = $regionIdentifier;
		$result['channelName'] = $regionName;
		$result['monthName'] = $month;
		$result['monthNum'] = $monthNum;
		$result['year'] = $year;
		$result['metadata'] = $metadata;
		$monthData = new MonthData($result);
		return $monthData;
	}

	private static function getTtsMonthDeductions($year, $month, $region) {
		$db = new Database;
		$deductions = 0.0;
		if ($region) {
			$stateIds = $region->getStateIds();
			$stateIdString = implode("', '", $stateIds);
			$sql = "SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions FROM `order_shipped_line_items` AS osli LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id WHERE osl.`state_id` IN ('$stateIdString') AND oli.deducted_on_ship_log = '1' AND osd.ship_date LIKE '$year-$month%';";
			// $sql = "SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions FROM `order_shipped_line_items` AS osli LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id WHERE osl.salesperson_id='$regionId' AND oli.deducted_on_ship_log = '1' AND osd.ship_date LIKE '$year-$month%';";
		}
		else {
			$sql = "SELECT IFNULL(ROUND(SUM(osli.`total`), 2), 0) AS deductions FROM `order_shipped_line_items` AS osli LEFT JOIN order_line_items AS oli ON oli.id = osli.line_item_id LEFT JOIN order_ship_log AS osl ON osl.id = osli.ship_log_id LEFT JOIN order_shipping_details AS osd ON osd.order_id = osl.id WHERE oli.deducted_on_ship_log = '1' AND osd.ship_date LIKE '$year-$month%';";
		}
		$result = $db->db_query($sql, 'select-single', true);
		$deductions = $result['deductions'];
		return $deductions;
	}

	private static function getRegionData($regionName) {
		$regionIdentifier = str_replace(' ', '', strtolower($regionName));
		$salesRegions = array(
			'west' => '835703000000061001',
			'south' => '835703000010136075',
			'north' => '835703000007379001',
			'wholesale' => '835703000013773251',
			'localwholesale' => '835703000010382001'
		);

		$zohoId = $salesRegions[$regionIdentifier];

		$db = new Database;
		$sql = "SELECT `id` FROM `order_salespersons` WHERE `zoho_id`='$zohoId';";
		$result = $db->db_query($sql, 'select-single');
		$regionData = new stdClass;
		$regionData->id = $result['id'];
		$regionData->identifier = $regionIdentifier;
		$regionData->name = $regionName;

		return $regionData;
	}

	private static function getOthersEcommChannelYearData($year) {
		$monthNames = array(
			'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'
		);
		$months = array();
		foreach ($monthNames as $monthName) {
			// $months[$monthName] = self::getEcommChannelMonthSales($channelData, $year, $monthName);
			$monthData = self::getOtherEcommChannelMonthSales($year, $monthName);
			array_push($months, $monthData->getMonthData());
		}
		$returnData = new stdClass;
		$returnData->name = 'Other';
		$returnData->identifier = 'others';
		$returnData->type = 'ecomm';
		$returnData->years = array();
		$yearData = new stdClass;
		$yearData->year = $year;
		$yearData->months = $months;
		$returnData->years[(string)$year] = $yearData;
		return $returnData;
	}

	private static function getOtherEcommChannelMonthSales($year, $month) {
		$metadata = new stdClass;
		$othersIdentifiers = "('chanx', 'facebook', 'weeklycloseouts')";
		$monthNums = array(
			'jan' => '01',
			'feb' => '02',
			'mar' => '03',
			'apr' => '04',
			'may' => '05',
			'jun' => '06',
			'jul' => '07',
			'aug' => '08',
			'sep' => '09',
			'oct' => '10',
			'nov' => '11',
			'dec' => '12',
		);
		if (in_array(substr(strtolower($month), 0, 3), array_keys($monthNums))) {
			$monthNum = $monthNums[substr(strtolower($month), 0, 3)];
		}
		$db = new Database;


		$sql = "SELECT IFNULL(ROUND(SUM(osl.`total`), 2), 0) AS total FROM `order_ship_log` AS osl LEFT JOIN `order_shipping_details` AS osd ON osd.`order_id` = osl.`id` WHERE osl.`salesperson_id`=(SELECT `id` FROM `order_salespersons` WHERE `zoho_id`='835703000014702050') AND osd.`ship_date` LIKE '$year-$monthNum%';";
		$result = $db->db_query($sql, 'select-single');
		$ttsOtherTotal = (float)$result['total'];

		$sql = "SELECT IFNULL(ROUND(SUM(erl.`return_amount`), 2), 0) AS spReturns FROM `ecomm_return_log` AS erl LEFT JOIN `ecomm_ship_log` AS esl ON erl.`ecomm_id` = esl.`id` LEFT JOIN `ecomm_sales_channels` AS esc ON esl.`channel_id` = esc.`id` WHERE esc.`identifier` IN $othersIdentifiers AND erl.`return_date` LIKE '$year-$monthNum%';";
		$metadata->getReturnsQuery = $sql;
		$result = $db->db_query($sql, 'select-single');
		$returns = $result['spReturns'];

		$sql = "SELECT IFNULL(ROUND(SUM(esl.`subtotal`), 2), 0) AS total FROM `ecomm_ship_log` AS esl LEFT JOIN `ecomm_shipping_details` AS esd ON esl.`id` = esd.`ecomm_id` LEFT JOIN `ecomm_sales_channels` AS esc ON esl.`channel_id` = esc.`id` WHERE esc.`identifier` IN $othersIdentifiers AND esd.`ship_date` LIKE '$year-$monthNum%';";
		$metadata->getSalesQuery = $sql;
		$result = $db->db_query($sql, 'select-single');

		$result['returns'] = $returns;
		$result['total'] = (float)$result['total'] + $ttsOtherTotal;
		$result['type'] = 'ecomm';
		$result['channelIdentifier'] = 'others';
		$result['channelName'] = 'Other';
		$result['monthName'] = $month;
		$result['monthNum'] = $monthNum;
		$result['year'] = $year;
		$result['metadata'] = $metadata;
		$monthData = new MonthData($result);
		return $monthData;
	}

	private static function getEcommChannelYearData($channelIdentifier, $year) {
		if ($channelIdentifier != '') {
			$channelData = self::getEcommChannelData($channelIdentifier);
			$channelName = $channelData->name;
		}
		else {
			$channelData = null;
			$channelName = "SP";
			$channelIdentifier = 'sp';
		}

		$monthNames = array(
			'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'
		);
		$months = array();
		foreach ($monthNames as $monthName) {
			// $months[$monthName] = self::getEcommChannelMonthSales($channelData, $year, $monthName);
			$monthData = self::getEcommChannelMonthSales($channelData, $year, $monthName);
			array_push($months, $monthData->getMonthData());
		}
		$returnData = new stdClass;
		$returnData->name = $channelName;
		$returnData->identifier = $channelIdentifier;
		$returnData->type = 'ecomm';
		$returnData->years = array();
		$yearData = new stdClass;
		$yearData->year = $year;
		$yearData->months = $months;
		$returnData->years[(string)$year] = $yearData;
		return $returnData;
	}

	private static function getEcommChannelMonthSales($channelData, $year, $month) {
		$metadata = new stdClass;
		$monthNums = array(
			'jan' => '01',
			'feb' => '02',
			'mar' => '03',
			'apr' => '04',
			'may' => '05',
			'jun' => '06',
			'jul' => '07',
			'aug' => '08',
			'sep' => '09',
			'oct' => '10',
			'nov' => '11',
			'dec' => '12',
		);
		if (in_array(substr(strtolower($month), 0, 3), array_keys($monthNums))) {
			$monthNum = $monthNums[substr(strtolower($month), 0, 3)];
		}
		$db = new Database;
		if ($channelData) {
			$channelId = $channelData->id;
			$channelIdentifier=$channelData->identifier;
			$channelName=$channelData->name;
			$sql = "SELECT IFNULL(ROUND(SUM(erl.`return_amount`), 2), 0) AS spReturns FROM `ecomm_return_log` AS erl LEFT JOIN `ecomm_ship_log` AS esl ON erl.`ecomm_id` = esl.`id` WHERE esl.`channel_id`='$channelId' AND erl.`return_date` LIKE '$year-$monthNum%';";
			$metadata->getReturnsQuery = $sql;
			$result = $db->db_query($sql, 'select-single');
			$returns = $result['spReturns'];
			$sql = "SELECT IFNULL(ROUND(SUM(esl.`subtotal`), 2), 0) AS total FROM `ecomm_ship_log` AS esl LEFT JOIN `ecomm_shipping_details` AS esd ON esl.`id` = esd.`ecomm_id` WHERE esl.`channel_id`='$channelId' AND esd.`ship_date` LIKE '$year-$monthNum%';";

		}
		else {
			$channelIdentifier = 'sp';
			$channelName = 'SP';
			$sql = "SELECT IFNULL(ROUND(SUM(erl.`return_amount`), 2), 0) AS spReturns FROM `ecomm_return_log` AS erl WHERE erl.`return_date` LIKE '$year-$monthNum%';";
			$metadata->getReturnsQuery = $sql;
			$result = $db->db_query($sql, 'select-single');
			$returns = $result['spReturns'];
			$sql = "SELECT IFNULL(ROUND(SUM(esl.`subtotal`), 2), 0) AS total FROM `ecomm_ship_log` AS esl LEFT JOIN `ecomm_shipping_details` AS esd ON esl.`id` = esd.`ecomm_id` WHERE esd.`ship_date` LIKE '$year-$monthNum%';";

		}
		$metadata->getSalesQuery = $sql;

		$result = $db->db_query($sql, 'select-single');

		$result['returns'] = $returns;
		$result['type'] = 'ecomm';
		$result['channelIdentifier'] = $channelIdentifier;
		$result['channelName'] = $channelName;
		$result['monthName'] = $month;
		$result['monthNum'] = $monthNum;
		$result['year'] = $year;
		$result['metadata'] = $metadata;
		$monthData = new MonthData($result);
		return $monthData;
	}

	private static function getEcommChannelData($channelIdentifier) {
		$db = new Database;
		$sql = "SELECT `id`, `name` FROM `ecomm_sales_channels` WHERE `identifier`='$channelIdentifier';";
		$result = $db->db_query($sql, 'select-single');
		$channelData = new stdClass;
		$channelData->id = $result['id'];
		$channelData->identifier = $channelIdentifier;
		$channelData->name = $result['name'];

		return $channelData;
	}

	private static function getEcommChannelId($channelIdentifier) {
		$db = new Database;
		$sql = "SELECT `id` FROM `ecomm_sales_channels` WHERE `identifier`='$channelIdentifier';";
		$result = $db->db_query($sql, 'select-single');
		return $result['id'];
	}

	private static function getEcommChannelName($channelIdentifier) {
		$db = new Database;
		$sql = "SELECT `name` FROM `ecomm_sales_channels` WHERE `identifier`='$channelIdentifier';";
		$result = $db->db_query($sql, 'select-single');
		return $result['name'];
	}
}
