<?php

class Month {
	public $name;
	public $number;
	public $subtotal;
	public $total;
	public $deductions;

	public static $monthNames = array(
		'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'
	);

	public static $monthNums = array(
		'01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12'
	);

	public function __construct($monthName, $monthNum) {
		$this->name = $monthName;
		$this->number = $monthNum;
		$this->subtotal = 0.0;
		$this->total = 0.0;
		$this->deductions = 0.0;
	}

	public function setSubtotal($subtotal) {
		$this->subtotal = (float)$subtotal;
	}

	public function setTotal($total) {
		$this->total = (float)$total;
		$this->recalculateSubtotal();
	}

	public function setDeductions($deductions) {
		$this->deductions = (float)$deductions;
		$this->recalculateSubtotal();
	}

	private function recalculateSubtotal() {
		$this->subtotal = $this->total - $this->deductions;
	}

	public function getSubtotal() {
		return $this->subtotal;
	}

	public function getName() {
		return $this->name;
	}

	public function getNumber() {
		return $this->number;
	}

	public static function getArrayOfMonths() {
		$monthArray = array();
		for ($i=0; $i < count(self::getMonthNames()); $i++) {
			array_push($monthArray, new Month(self::getMonthNameAtIndex($i), self::getMonthNumAtIndex($i)));
		}
		return $monthArray;
	}

	public static function getMonthNameAtIndex($index) {
		return self::getMonthNames()[$index];
	}

	public static function getMonthNumAtIndex($index) {
		return self::getMonthNums()[$index];
	}

	public static function getMonthNames() {
		return self::$monthNames;
	}

	public static function getMonthNums() {
		return self::$monthNums;
	}

}

?>
