<?php

require_once(HTML_FOLDER . "classes/Metrics/Datasets/Month.php");
class MetricsYear {
	public $year;
	public $months;
	public function __construct($year) {
		$this->year = $year;
		$this->months = Month::getArrayOfMonths();
	}

	public function getMonthByName($monthName) {
		foreach ($this->getMonths() as $month) {
			if ($month->getName() == $monthName) {
				return $month;
			}
		}
		return $false;
	}

	public function getMonthByNum($monthNum) {
		foreach ($this->getMonths() as $month) {
			if ($month->getNumber() == $monthNum) {
				return $month;
			}
		}
		return $false;
	}

	public function getMonthByIndex($monthIndex) {
		$months = $this->getMonths();
		if ($monthIndex >= 0 && $monthIndex < count($months)) {
			return $months[$monthIndex];
		}
		else {
			return false;
		}
	}

	public function getMonths() {
		return $this->months;
	}
}

?>
