<?php

require_once(HTML_FOLDER . "classes/Metrics/Datasets/MetricsYear.php");

class MetricsState {
	public $name;
	public $abbreviation;
	public $years;

	public function __construct($stateName, $stateAbbreviation, $years=null) {
		$this->name = $stateName;
		$this->abbreviation = $stateAbbreviation;
		$this->metadata->passedYears = $years;
		if ($years && is_array($years)) {
			$this->years = array();
			foreach ($years as $year) {
				$yearString = (string)$year;
				$this->years[$yearString] = new MetricsYear($yearString);
			}
		}
	}

	public function getYear($year) {
		return $this->getYears()[$year];
	}

	public function getYears() {
		return $this->years;
	}
}

?>
