<?php

class InventoryService {
	public static function getInventoryCount() {
		$db = new Database;
		$sql = "SELECT
				mon.order_number,
				mon.order_number_id,
				mon.ram,
				mon.storage,
				mon.first_stock_pricing,
				mon.second_stock_pricing,
				mon.first_stock_ten_pack_pricing,
				mon.second_stock_ten_pack_pricing,
				mon.limited_to_inventory,
				mon.color,
				mon.active AS tts_active,
				mon.special_order,
				ml.machine_id,
				ml.machine_description,
				ml.processor AS ml_processor,
				ml.processor_speed AS ml_processor_speed,
				mon.processor AS mon_processor,
				mon.processor_speed AS mon_processor_speed,
				mon.device_condition AS device_condition,
				mon.touchscreen AS touchscreen,
				mon.auto_update_expiration,
				ml.upgradeable,
				ml.latest_os,
				mzi.first_stock_zoho_id_individual,
				mzi.second_stock_zoho_id_individual,
				mzi.first_stock_zoho_id_tenpack,
				mzi.second_stock_zoho_id_tenpack,
				msi.first_stock_inventory_item_id,
				msi.second_stock_inventory_item_id
				FROM machine_order_number AS mon
				LEFT JOIN machine_lookup AS ml ON ml.machine_id = mon.machine_id
				LEFT JOIN machine_zoho_ids AS mzi ON mzi.machine_order_number_id = mon.order_number_id
				LEFT JOIN machine_shopify_ids AS msi ON msi.machine_order_number_id = mon.order_number_id
				WHERE mon.order_number IS NOT NULL
				AND mon.order_number != ''
				GROUP BY mon.order_number_id
				ORDER BY mon.order_number_id ASC;";
		$results = $db->db_query($sql, 'select-multiple', true);

		$assets = array();
		$counts = self::getAllOrderNumbersCurrentStock();
		// print_r($counts);
		$inbounds = self::getAllOrderNumberIdsInbound();
		if ($_GET['debug'] == 'yes') {
			echo "<pre>";
			print_r($inbounds);
			echo "</pre>";
		}
		// print_r($inbounds);
		$demands = self::getAllOrderNumberIdsDemand();
		// print_r($demands);
		foreach ($results as $result) {
			$asset = new Asset($result);
			$orderNumberId = $asset->getMachineOrderNumberId();
			if ($counts[$orderNumberId]) {
				$asset->setCounts($counts[$orderNumberId]);
			}
			if ($inbounds[$orderNumberId]) {
				$asset->setInbound($inbounds[$orderNumberId]);
			}
			if ($demands[$orderNumberId]) {
				$asset->setDemands($demands[$orderNumberId]);
			}
			array_push($assets, $asset);
		}
		return $assets;
	}

	public static function getAllOrderNumbersCurrentStock() {
		$db = new Database;
		$sql = "SELECT
				mon.order_number_id,
				COUNT(CASE WHEN dso.cStatus = 'Refurb - In Process' AND dso.grade != 'F' AND dso.grade NOT LIKE '%D%' AND (dso.activation_lock = 0 OR dso.activation_lock IS NULL) AND (dso.mdm_lock = 0 OR dso.mdm_lock IS NULL) THEN 1 END) AS itemCount,
				COUNT(CASE WHEN dso.cStatus = 'Refurb - In Process' AND dso.grade = 'A' AND (dso.activation_lock = 0 OR dso.activation_lock IS NULL) AND (dso.mdm_lock = 0 OR dso.mdm_lock IS NULL) THEN 1 END) AS aGradeCount,
				COUNT(CASE WHEN dso.cStatus = 'Refurb - In Process' AND dso.grade = 'B' AND (dso.activation_lock = 0 OR dso.activation_lock IS NULL) AND (dso.mdm_lock = 0 OR dso.mdm_lock IS NULL) THEN 1 END) AS bGradeCount,
				COUNT(CASE WHEN dso.cStatus = 'Refurb - In Process' AND dso.grade = 'C' AND (dso.activation_lock = 0 OR dso.activation_lock IS NULL) AND (dso.mdm_lock = 0 OR dso.mdm_lock IS NULL) THEN 1 END) AS cGradeCount,
				COUNT(CASE WHEN dso.cStatus = 'Refurb - In Process' AND dso.grade LIKE '%D%' AND (dso.activation_lock = 0 OR dso.activation_lock IS NULL) AND (dso.mdm_lock = 0 OR dso.mdm_lock IS NULL) THEN 1 END) AS dGradeCount,
				COUNT(CASE WHEN dso.cStatus = 'Refurb - In Process' AND dso.grade = 'F' AND (dso.activation_lock = 0 OR dso.activation_lock IS NULL) AND (dso.mdm_lock = 0 OR dso.mdm_lock IS NULL) THEN 1 END) AS fGradeCount,
				COUNT(CASE WHEN dso.cStatus = 'Refurb - In Process' AND dso.marking = 1 AND (dso.activation_lock = 0 OR dso.activation_lock IS NULL) AND (dso.mdm_lock = 0 OR dso.mdm_lock IS NULL) AND dso.grade IN ('A', 'B', 'C') THEN 1 END) AS engravedCount
				FROM ds_orders AS dso
				LEFT JOIN machine_order_number AS mon ON dso.asset = mon.order_number
				WHERE dso.dateMachineReceived >= '2020-05-01'
				AND dso.asset IN
				(
					SELECT * FROM (
						SELECT DISTINCT order_number FROM machine_order_number ORDER BY order_number_id ASC
					) AS subquery
				)
				GROUP BY mon.order_number_id
				HAVING itemCount > 0
				ORDER BY order_number_id ASC;";
		$results = $db->db_query($sql, 'select-multiple', true);

		$counts = array();
		foreach ($results as $result) {
			$resultObj = (object)$result;
			$orderNumberId = $resultObj->order_number_id;
			$itemCount = (int)$resultObj->itemCount;
			$aGradeCount = (int)$resultObj->aGradeCount;
			$bGradeCount = (int)$resultObj->bGradeCount;
			$cGradeCount = (int)$resultObj->cGradeCount;
			$dGradeCount = (int)$resultObj->dGradeCount;
			$fGradeCount = (int)$resultObj->fGradeCount;
			$engravedCount = (int)$resultObj->engravedCount;

			$count = new stdClass;
			$count->itemCount = (int)$itemCount;
			$count->aGradeCount = (int)$aGradeCount;
			$count->bGradeCount = (int)$bGradeCount;
			$count->cGradeCount = (int)$cGradeCount;
			$count->dGradeCount = (int)$dGradeCount;
			$count->fGradeCount = (int)$fGradeCount;
			$count->engravedCount = (int)$engravedCount;

			$counts[$orderNumberId] = $count;
		}
		return $counts;
	}

	public static function getAllOrderNumberIdsInbound() {
		$db = new Database;
		$sql = "SELECT
				mon.order_number_id,
				IFNULL((SELECT SUM(poli.quantity) FROM purchase_order_line_items AS poli LEFT JOIN purchase_orders AS po ON po.id = poli.purchaseOrderId WHERE lineItemId = (SELECT id FROM order_line_items WHERE zoho_id = mzi.first_stock_zoho_id_individual) AND po.active='1' GROUP BY poli.lineItemId),0) + (IFNULL((SELECT SUM(poli.quantity) FROM purchase_order_line_items AS poli LEFT JOIN purchase_orders AS po ON po.id = poli.purchaseOrderId WHERE lineItemId = (SELECT id FROM order_line_items WHERE zoho_id = mzi.first_stock_zoho_id_tenpack) AND po.active='1' GROUP BY poli.lineItemId), 0) * 10) AS inbound
				FROM machine_order_number AS mon
				LEFT JOIN machine_zoho_ids AS mzi ON mzi.`machine_order_number_id` = mon.order_number_id
				WHERE mon.order_number IN
				(
					SELECT * FROM (
						SELECT DISTINCT order_number FROM machine_order_number ORDER BY order_number_id ASC
					) AS subquery
				)
				HAVING inbound > 0
				ORDER BY order_number_id ASC;";
		$results = $db->db_query($sql, 'select-multiple', true);

		if ($_GET['debug'] == 'yes') {
			echo "<pre>";
			echo $sql;
			print_r($results);
			echo "</pre>";
		}

		$inbounds = array();
		foreach ($results as $result) {
			$resultObj = (object)$result;
			$orderNumberId = $resultObj->order_number_id;


			$inbounds[$orderNumberId] = (int)$resultObj->inbound;
		}
		return $inbounds;
	}

	public static function getAllOrderNumberIdsDemand() {
		$db = new Database;
		$sql = "SELECT
				mon.order_number_id,
				IFNULL((SELECT SUM(ooli.quantity) FROM open_order_line_items AS ooli WHERE line_item_id = (SELECT id FROM order_line_items WHERE zoho_id = mzi.first_stock_zoho_id_individual) GROUP BY ooli.line_item_id),0) + (IFNULL((SELECT SUM(ooli.quantity) FROM open_order_line_items AS ooli WHERE line_item_id = (SELECT id FROM order_line_items WHERE zoho_id = mzi.first_stock_zoho_id_tenpack) GROUP BY ooli.line_item_id), 0) * 10) AS first_stock_demand,
				IFNULL((SELECT SUM(ooli.quantity) FROM open_order_line_items AS ooli WHERE line_item_id = (SELECT id FROM order_line_items WHERE zoho_id = mzi.second_stock_zoho_id_individual) GROUP BY ooli.line_item_id),0) + (IFNULL((SELECT SUM(ooli.quantity) FROM open_order_line_items AS ooli WHERE line_item_id = (SELECT id FROM order_line_items WHERE zoho_id = mzi.second_stock_zoho_id_tenpack) GROUP BY ooli.line_item_id), 0) * 10) AS second_stock_demand
				FROM machine_order_number AS mon
				LEFT JOIN machine_zoho_ids AS mzi ON mzi.`machine_order_number_id` = mon.order_number_id
				WHERE mon.order_number IN
				(
					SELECT * FROM (
						SELECT DISTINCT order_number FROM machine_order_number ORDER BY order_number_id ASC
					) AS subquery
				)
				HAVING first_stock_demand > 0 OR second_stock_demand > 0
				ORDER BY order_number_id ASC;";
		$results = $db->db_query($sql, 'select-multiple', true);

		$demands = array();
		foreach ($results as $result) {
			$resultObj = (object)$result;
			$orderNumberId = $resultObj->order_number_id;
			$firstStockDemand = (int)$resultObj->first_stock_demand;
			$secondStockDemand = (int)$resultObj->second_stock_demand;

			$demand = new stdClass;
			$demand->firstStock = (int)$firstStockDemand;
			$demand->secondStock = (int)$secondStockDemand;
			$demands[$orderNumberId] = $demand;
		}
		return $demands;
	}

	public static function getAllStatuses() {
		global $order_statii;
		return array_keys($order_statii);
	}
}

?>
