<?php

require_once(HTML_FOLDER . 'classes/Inventory/InventoryService.php');
require_once(HTML_FOLDER . 'classes/Inventory/Datasets/Asset.php');
class InventoryController {
	public static function inventoryPage() {
		$admin = new Admin;
		$title = "TTS Inventory";
		$page_heading = "Tech to School Inventory";
		$asset_modal = file_get_contents('templates/inventory/asset_modal.html');
		$template = TTS_INVENTORY;
		$scripts = '<script src="__CDN_JAVASCRIPT__javascript/column_definition/column_definition.js" type="text/javascript"></script>
					<script src="__CDN_JAVASCRIPT__javascript/inventory/asset_modal.js" type="text/javascript"></script>
					<script src="__CDN_JAVASCRIPT__javascript/inventory/datasets/Asset.js" type="text/javascript"></script>
					<script src="__CDN_JAVASCRIPT__javascript/inventory/inventoryController.js" type="text/javascript"></script>';
		$templateElements = array(
			'MODAL' => $asset_modal,
			'PAGE_HEADING' => $page_heading,
			'CURRENT_PAGE' => $page,
			'SCRIPTS' => $scripts
		);
		echo $admin->parse(TEMPLATE, array('BODY' => $admin->parse($template, $templateElements), "TITLE" => $title));
	}

	public static function getInventoryCount($status) {
		$assets = InventoryService::getInventoryCount();
		return $assets;
	}

	public static function getStatuses() {
		$statuses = InventoryService::getAllStatuses();
		return $statuses;
	}
}

?>
