<?php

/**
 * Class to handle generic utility functions
 */
class Utility {
	public static function startsWith($string, $startString) {
		$len = strlen($startString);
		return (substr($string, 0, $len) === $startString);
	}

	public static function endsWith($string, $endString) {
		$len = strlen($endString);
		if ($len == 0) {
			return true;
		}
		return (substr($string, -$len) === $endString);
	}

	public static function getCurrentTimestamp() {
		$currentTime = new DateTime('now', new DateTimeZone('UTC'));
		$currentTimeFormatted = $currentTime->format(DATE_ISO8601);
		return $currentTimeFormatted;
	}
}

?>
