<?php

abstract class ZohoOrder {
	public $dbId;
	public $zohoId;
	public $mtsNumber;
	public $subject;
	public $invoiceDate;
	public $notes;
	public $total;

	public $account;
	public $salesperson;

	public $lineItems;

	public $debug = false;

	protected function __construct($data) {
		if (is_array($data)) {
			$data = (object)$data;
		}
		if ($data->dbId) {
			$this->dbId = $data->dbId;
		}
		elseif ($data->id) {
			$this->dbId = $data->id;
		}

		// Zoho ID variants - multiple variants to catch multiple implementations in the code.
		if ($data->zohoId) {
			$this->zohoId = $data->zohoId;
		}
		elseif ($data->zoho_id) {
			$this->zohoId = $data->zoho_id;
		}
		elseif ($data->Invoice_Id) {
			$this->zohoId = $data->Account_Id;
		}

		if ($data->mtsNumber) {
			$this->mtsNumber = $data->mtsNumber;
		}
		elseif ($data->mts_number) {
			$this->mtsNumber = $data->mts_number;
		}
		elseif ($data->MTS_Quote_Number) {
			$this->mtsNumber = $data->MTS_Quote_Number;
		}

		if ($data->subject) {
			$this->subject = $data->subject;
		}
		elseif ($data->Subject) {
			$this->subject = $data->subject;
		}

		if ($data->invoiceDate) {
			$this->invoiceDate = $data->invoiceDate;
		}
		elseif ($data->Created_Time) {
			$this->invoiceDate = $data->Created_Time;
		}

		if ($data->notes) {
			$this->notes = $data->notes;
		}

		if ($data->total) {
			$this->total = $data->total;
		}
		elseif ($data->subtotal) {
			$this->total = $data->subtotal;
		}

		if ($data->account) {
			if (is_a($data->account, 'Account')) {
				$this->account = $data->account;
			}
			else {
				$this->account = new Account($data->account);
			}
		}
		elseif ($data->accountData) {
			if (is_a($data->accountData, 'Account')) {
				$this->account = $data->accountData;
			}
			else {
				$this->account = new Account($data->accountData);
			}
		}
		elseif ($data->account_id) {
			$accountData = new stdClass;
			$accountData->id = $data->account_id;
			$this->account = new Account($accountData);
		}

		if ($data->salesperson) {
			if (is_a($data->salesperson, 'Salesperson')) {
				$this->salesperson = $data->salesperson;
			}
			else {
				$this->salesperson = new Salesperson($data->salesperson);
			}
		}
		elseif ($data->salespersonData) {
			if (is_a($data->salespersonData, 'Salesperson')) {
				$this->salesperson = $data->salespersonData;
			}
			else {
				$this->salesperson = new Salesperson($data->salespersonData);
			}
		}
		elseif ($data->salesperson_id) {
			$salespersonData = new stdClass;
			$salespersonData->id = $data->salesperson_id;
			$this->salesperson = new Salesperson($salespersonData);
		}

		$this->lineItems = array();

		if ($data->debug) {
			$this->debug = $data->debug;
		}
	}

	public function getDebug() {
		return $this->debug;
	}
	public function setDebug($debug) {
		$this->debug = $debug;
	}

	public function getDbId() {
		return $this->dbId;
	}

	public function setDbId($id) {
		$this->dbId = $id;
	}

	public function isDbIdSet() {
		if ($this->getDbId()) {
			return true;
		}
		else {
			return false;
		}
	}

	public function getZohoId() {
		return $this->zohoId;
	}

	public function setZohoId($zohoId) {
		$this->zohoId = $zohoId;
	}

	public function getMtsNumber() {
		return $this->mtsNumber;
	}

	public function setMtsNumber($mtsNumber) {
		$this->mtsNumber = $mtsNumber;
	}

	public function getSubject() {
		return $this->subject;
	}

	public function setSubject($subject) {
		$this->subject = $subject;
	}

	public function getInvoiceDate() {
		return $this->invoiceDate;
	}

	public function setInvoiceDate($invoiceDate) {
		$this->invoiceDate = $invoiceDate;
	}

	public function getNotes() {
		return $this->notes;
	}

	public function setNotes($notes) {
		$this->notes = trim($notes);
	}

	public function getTotal() {
		return $this->total;
	}

	public function setTotal($total) {
		$this->total = $total;
	}

	public function getAccount() {
		return $this->account;
	}

	public function setAccount($accountData) {
		if (is_a($accountData, 'Account')) {
			$this->account = $accountData;
		}
		else {
			$this->account = new Account($accountData);
		}
	}

	public function getSalesperson() {
		return $this->salesperson;
	}

	public function setSalesperson($salespersonData) {
		if (is_a($salespersonData, 'Salesperson')) {
			$this->salesperson = $salespersonData;
		}
		else {
			$this->salesperson = new Salesperson($salespersonData);
		}
	}

	public function getLineItems() {
		return $this->lineItems;
	}

	public function setLineItems($lineItems) {
		$this->lineItems = $lineItems;
	}

	public function addLineItem($lineItem) {
		if (is_a($lineItem, 'LineItem')) {
			array_push($this->lineItems, $lineItem);
		}
		else {
			array_push($this->lineItems, new LineItem($lineItem));
		}
	}

	abstract function getExistingNotes();

	abstract function populateDbId();
	abstract function generateInsertQuery();
}

?>
