<?php

class State {
	private static $dbTable = 'states';

	private static $dbFields = array(
		'id' => array('type' => 'primary', 'mutable' => false),
		'name' => array('type' => 'string', 'mutable' => true),
		'abbreviation' => array('type' => 'string', 'mutable' => true),
		'region_id' => array('type' => 'foreignKey', 'mutable' => true, 'class' => 'Region', 'getter' => 'getRegionId', 'setter' => 'setRegionId')
	);

	private $id;
	private $name;
	private $abbreviation;
	private $regionId;

	public function __construct($data) {
		if (is_array($data)) {
			$data = (object)$data;
		}

		if ($data->id) {
			$this->id = $data->id;
		}

		if ($data->name) {
			$this->name = $data->name;
		}

		if ($data->abbreviation) {
			$this->abbreviation = $data->abbreviation;
		}

		if ($data->regionId) {
			$this->regionId = $data->regionId;
		}
		elseif ($data->region_id) {
			$this->regionId = $data->region_id;
		}
	}

	public function getId() {
		return $this->id;
	}

	public function getName() {
		return $this->name;
	}

	public function getAbbreviation() {
		return $this->abbreviation;
	}

	public function getRegionId() {
		return $this->regionId;
	}

	public function getHtmlOption() {
		$id = $this->getId();
		$name = $this->getName();

		$option = "<option value='$id'>$name</option>";
		return $option;
	}

	public function jsonify() {
		$jsonData = new stdClass;
		$jsonData->id = $this->getId();
		$jsonData->name = $this->getName();
		$jsonData->abbreviation = $this->getAbbreviation();
		$jsonData->regionid = $this->getRegionId();
		return $jsonData;
	}

	public function save() {
		$db = new Database;
		$dbTable = self::getDbTable();
		$id = $this->getId();
		$regionId = $this->getRegionId();
		if ($id) {
			$sql = "UPDATE `$dbTable` SET `region_id`='$regionId' WHERE `id`='$id';";
			$result = $db->db_query($sql, "update", true);
			return $result;
		}
		else {
			return false;
		}
	}

	public static function getOptionArrayForAllStates($states=null) {
		if (!$states) {
			$states = self::getAllStates();
		}

		$options = array();
		foreach ($states as $state) {
			$option = $state->getHtmlOption();

			array_push($options, $option);
		}
		return $options;
	}

	public static function fetchById($stateId) {
		$db = new Database;
		$dbTable = self::getDbTable();

		$sql = "SELECT * FROM `$dbTable` WHERE `id`='$stateId';";
		$result = $db->db_query($sql, 'select-single');
		if ($result['id']) {
			$state = new State($result);
			return $state;
		}
		else {
			return null;
		}
	}

	public static function fetchIdByNameOrAbbreviation($nameOrAbbreviation) {
		$db = new Database;
		$dbTable = self::getDbTable();

		$sql = "SELECT `id` FROM `$dbTable` WHERE `name`='$nameOrAbbreviation' OR `abbreviation`='$nameOrAbbreviation' LIMIT 1;";
		$result = $db->db_query($sql, 'select-single');
		if ($result['id']) {
			return $result['id'];
		}
		else {
			return null;
		}
	}

	public static function getAllStates() {
		$db = new Database;
		$dbTable = self::getDbTable();
		$sql = "SELECT * FROM `$dbTable` ORDER BY `id` ASC;";
		$results = $db->db_query($sql, 'select-multiple', true);

		$states = array();
		foreach ($results as $result) {
			$state = new State($result);
			array_push($states, $state);
		}
		return $states;
	}

	public static function getStatesByRegionId($regionId) {
		$db = new Database;
		$dbTable = self::getDbTable();
		$sql = "SELECT * FROM `$dbTable` WHERE `region_id`='$regionId' ORDER BY `id` ASC;";
		$results = $db->db_query($sql, 'select-multiple', true);

		$states = array();
		foreach ($results as $result) {
			$state = new State($result);
			array_push($states, $state);
		}
		return $states;
	}

	public static function getDbTable() {
		return self::$dbTable;
	}
}

?>
