<?php

class Salesperson {
	public static $dbTable = "order_salespersons";
	public static $regionJoinTable = "regions_salespersons";
	public static $zohoIdFieldName = "zoho_id";

	public $dbId;
	public $zohoId;
	public $name;

	public function __construct($data) {
		// Convert from array to object if is array
		if (is_array($data)) {
			$data = (object)$data;
		}
		if ($data->dbId) {
			$this->dbId = $data->dbId;
		}
		elseif ($data->id) {
			$this->dbId = $data->id;
		}

		// Zoho ID variants - multiple variants to catch multiple implementations in the code.
		if ($data->zohoId) {
			$this->zohoId = $data->zohoId;
		}
		elseif ($data->zoho_id) {
			$this->zohoId = $data->zoho_id;
		}
		elseif ($data->Owner_Id) {
			$this->zohoId = $data->Owner_Id;
		}

		if ($data->name) {
			$this->name = $data->name;
		}
		elseif($data->Owner && is_string($data->Owner)) {
			$this->name = $data->Owner;
		}
		elseif($data->Owner_Name) {
			$this->name = $data->Owner_Name;
		}
	}

	public function getDbId() {
		return $this->dbId;
	}

	public function setDbId($id) {
		$this->dbId = $id;
	}

	public function getId() {
		return $this->getDbId();
	}

	public function setId($id) {
		$this->setDbId($id);
	}

	public function isDbIdSet() {
		if ($this->getDbId()) {
			return true;
		}
		else {
			return false;
		}
	}

	public function getZohoId() {
		return $this->zohoId;
	}
	public function setZohoId($zohoId) {
		$this->zohoId = $zohoId;
	}

	public function getName() {
		return $this->name;
	}

	public function setName($name) {
		$this->name = trim($name);
	}

	public function populateDbId() {
		if ($this->isDbIdSet()) {
			return true;
		}
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$dbTable = self::getDbTable();
		$zohoIdField = self::getZohoIdFieldName();
		$zohoId = $this->getZohoId();

		$sql = "SELECT `id` FROM `$dbTable` WHERE `$zohoIdField`='$zohoId';";
		$result = $db->db_query($sql, 'select-single', true);
		$id = $result['id'];
		if ($id) {
			$this->setDbId($id);
			return true;
		}
		else {
			return false;
		}
	}

	public function populateData() {
		if (!$this->isDbIdSet()) {
			return false;
		}
		$db = new Database;

		$dbTable = self::getDbTable();
		$zohoIdField = self::getZohoIdFieldName();

		$id = $this->getDbId();

		$sql = "SELECT * FROM `$dbTable` WHERE `id`='$id';";
		$result = $db->db_query($sql, 'select-single', true);

		foreach ($result as $key => $value) {
			$this->setKeyValue($key, $value);
		}
	}

	public function setKeyValue($key, $value) {
		$zohoIdAliases = array(
			'zohoId',
			'zoho_id',
			'Owner_Id'
		);
		$nameAliases = array(
			'name',
			'Owner',
			'Owner_Name'
		);
		if (in_array($key, $zohoIdAliases)) {
			$this->setZohoId($value);
			return true;
		}
		elseif(in_array($key, $nameAliases)) {
			$this->setName($value);
			return true;
		}
		else {
			return false;
		}
	}

	public function save() {
		$db = new Database;
		$dbTable = self::getDbTable();
		$zohoIdField = self::getZohoIdFieldName();

		$this->populateDbId();

		if (!$this->isDbIdSet()) {
			$sql = $this->generateInsertQuery();
			$db->db_query($sql, 'insert', true);
			$db->resetAutoIncrement($dbTable);
		}
		else {
			$sql = $this->generateUpdateQuery();
			$db->db_query($sql, 'update', true);
		}
		return true;
	}

	public function generateInsertQuery() {
		$dbTable = self::getDbTable();
		$zohoIdField = self::getZohoIdFieldName();

		$zohoId = $this->getZohoId();
		$name = mysql_real_escape_string($this->getName());

		$sql = "INSERT INTO `$dbTable`(`$zohoIdField`, `name`) VALUES ('$zohoId', '$name') ON DUPLICATE KEY UPDATE `name`='$name';";

		return $sql;
	}

	public function generateUpdateQuery() {
		$dbTable = self::getDbTable();

		$dbId = $this->getDbId();
		$name = mysql_real_escape_string($this->getName());

		$sql = "UPDATE `$dbTable` SET `name`='$name' WHERE `id`='$dbId';";

		return $sql;
	}

	public function jsonify() {
		$jsonData = new stdClass;
		$jsonData->id = $this->getId();
		$jsonData->name = $this->getName();
		$jsonData->zohoId = $this->getZohoId();
		return $jsonData;
	}

	public static function getDbTable() {
		return self::$dbTable;
	}

	public static function getRegionJoinTable() {
		return self::$regionJoinTable;
	}

	public static function getZohoIdFieldName() {
		return self::$zohoIdFieldName;
	}

	public static function fetchById($id) {
		$db = new Database;
		$dbTable = self::getDbTable();
		$sql = "SELECT * FROM `$dbTable` WHERE `id`='$id';";
		$result = $db->db_query($sql, 'select-single', true);

		$salesperson = new Salesperson($result);

		return $salesperson;
	}

	public static function getAllSalespersons() {
		$db = new Database;
		$dbTable = self::getDbTable();
		$sql = "SELECT * FROM `$dbTable` ORDER BY `id` ASC;";
		$results = $db->db_query($sql, 'select-multiple', true);

		$salespersons = array();
		foreach ($results as $result) {
			$salesperson = new Salesperson($result);
			array_push($salespersons, $salesperson);
		}
		return $salespersons;
	}

	public static function getSalespersonsByRegionId($regionId) {
		$db = new Database;
		$dbTable = self::getDbTable();
		$joinTable = self::getRegionJoinTable();
		$sql = "SELECT os.* FROM `$dbTable` AS os LEFT JOIN `$joinTable` AS rs ON rs.`salesperson_id` = os.`id` WHERE `region_id`='$regionId';";
		$results = $db->db_query($sql, 'select-multiple', true);

		$salespersons = array();
		foreach ($results as $result) {
			$salesperson = new Salesperson($result);
			array_push($salespersons, $salesperson);
		}
		return $salespersons;
	}
}

?>
