<?php

class Region {
	private static $dbTable = 'regions';
	private static $salesJoinTable = 'regions_salespersons';
	private static $salesJoinSchema = array(
		'regions' => 'region_id',
		'salespersons' => 'salesperson_id'
	);

	private static $dbFields = array(
		'id' => array('type' => 'primary', 'mutable' => false),
		'name' => array('type' => 'string', 'mutable' => true),
		'identifier' => array('type' => 'string', 'mutable' => true),
	);

	private $id;
	private $name;
	private $identifier;
	private $states;
	private $salespersons;

	public function __construct($data, $getStates=true, $getSalespersons=true) {
		if (is_array($data)) {
			$data = (object)$data;
		}

		if ($data->id) {
			$this->id = $data->id;
		}

		if ($data->name) {
			$this->name = $data->name;
		}

		if ($data->identifier) {
			$this->identifier = $data->identifier;
		}

		if ($this->id && $getStates) {
			$this->states = State::getStatesByRegionId($this->id);
		}

		if ($this->id && $getSalespersons) {
			$this->salespersons = Salesperson::getSalespersonsByRegionId($this->id);
		}

		if ($data->salespersonId) {
			$this->salespersons = array();
			array_push($this->salespersons, Salesperson::fetchById($data->salespersonId));
			print_r($this->salespersons);
		}
	}

	public function getId() {
		return $this->id;
	}

	public function populateId() {
		if ($this->getId()) {
			return true;
		}
		$db = new Database;
		$dbTable = self::getDbTable();
		$identifier = $this->getIdentifier();
		$sql = "SELECT `id` FROM `$dbTable` WHERE `identifier`='$identifier';";
		$result = $db->db_query($sql, "select-single", true);
		if ($result['id']) {
			$id = $result['id'];
			$this->id = $id;
			return true;
		}
		else {
			return false;
		}
	}

	public function getName() {
		return $this->name;
	}

	public function getIdentifier() {
		return $this->identifier;
	}

	public function getStates() {
		return $this->states;
	}

	public function getStateIds() {
		$ids = array();
		foreach ($this->states as $state) {
			array_push($ids, $state->getId());
		}
		return $ids;
	}

	public function getSalespersons() {
		return $this->salespersons;
	}

	public function getSalesperson() {
		return $this->salespersons[0];
	}

	public function getSalespersonId() {
		$salesperson = $this->salespersons[0];
		if ($salesperson) {
			return $salesperson->getId();
		}
		else {
			return null;
		}
	}

	public function getHtmlOption() {
		$id = $this->getId();
		$name = $this->getName();

		$option = "<option value='$id'>$name</option>";
		return $option;
	}

	public function jsonify() {
		$jsonData = new stdClass;
		$jsonData->id = $this->getId();
		$jsonData->name = $this->getName();
		$jsonData->identifier = $this->getIdentifier();
		$jsonData->states = array();
		foreach ($this->getStates() as $state) {
			array_push($jsonData->states, $state->jsonify());
		}
		$jsonData->salespersons = array();
		foreach ($this->getSalespersons() as $salesperson) {
			array_push($jsonData->salespersons, $salesperson->jsonify());
		}
		return $jsonData;
	}

	public function save() {
		$db = new Database;
		$dbTable = self::getDbTable();
		$name = self::getName();
		$identifier = self::getIdentifier();
		if ($this->getId()) {
			// perform update
			$id = self::getId();
			$sql = "UPDATE `$dbTable` SET `name`='$name', `identifier`='$identifier' WHERE `id`='$id';";
			$queryType = "update";
		}
		else {
			// insert
			$sql = "INSERT INTO `$dbTable`(`name`, `identifier`) VALUES ('$name', '$identifier');";
			$queryType = "insert";
		}
		$result = $db->db_query($sql, $queryType, true);
		if (count($this->salespersons) > 0) {
			$this->saveSalespersons();
		}
		return $result;
	}

	public function saveSalespersons() {
		$db = new Database;

		$joinTable = self::$salesJoinTable;
		$joinTableSchema = (object)self::$salesJoinSchema;
		if ($this->populateId()) {
			$id = $this->getId();
			$deleteQuery = "DELETE FROM `$joinTable` WHERE `$joinTableSchema->regions`='$id';";
			$db->db_query($deleteQuery, "delete", true);
			foreach ($this->salespersons as $salesperson) {
				$salespersonId = $salesperson->getId();
				$regionId = $this->getId();
				$insertQuery = "INSERT INTO `$joinTable`(`$joinTableSchema->regions`, `$joinTableSchema->salespersons`) VALUES ('$regionId', '$salespersonId');";
				$db->db_query($insertQuery, "insert", true);
			}
		}
	}

	public static function getOptionArrayForAllRegions($regions=null) {
		if (!$regions) {
			$regions = self::getAllRegions(false);
		}

		$options = array();
		foreach ($regions as $region) {
			$option = $region->getHtmlOption();

			array_push($options, $option);
		}
		return $options;
	}

	public static function fetchByIdentifier($identifier, $getStates=true, $getSalespersons=true) {
		$db = new Database;
		$dbTable = self::getDbTable();
		$sql = "SELECT * FROM `$dbTable` WHERE `identifier`='$identifier';";
		$result = $db->db_query($sql, "select-single", true);

		$region = new Region($result, $getStates, $getSalespersons);

		return $region;
	}

	public static function getAllRegions($getStates=true, $getSalespersons=true) {
		$db = new Database;
		$dbTable = self::getDbTable();
		$sql = "SELECT * FROM `$dbTable` ORDER BY `id` ASC;";
		$results = $db->db_query($sql, 'select-multiple', true);

		$regions = array();
		foreach ($results as $result) {
			$region = new Region($result, $getStates, $getSalespersons);
			array_push($regions, $region);
		}
		return $regions;
	}


	public static function getDbTable() {
		return self::$dbTable;
	}
}

?>
